/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.message;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class MessageFormatter {
    private static final String MESSAGES = "Messages";

    private MessageFormatter() {
    }

    public static String getMessage(String messageCode, Object[] args) {
        if (messageCode == null) {
            messageCode = "";
        }
        return "[" + messageCode + "]" + MessageFormatter.getSimpleMessage(messageCode, args);
    }

    public static String getSimpleMessage(String messageCode, Object[] arguments) {
        try {
            String pattern = MessageFormatter.getPattern(messageCode);
            if (pattern != null) {
                return MessageFormat.format(pattern, arguments);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return MessageFormatter.getNoPatternMessage(arguments);
    }

    private static String getPattern(String messageCode) {
        ResourceBundle resourceBundle = MessageFormatter.getMessages(MessageFormatter.getSystemName(messageCode));
        if (resourceBundle != null) {
            return resourceBundle.getString(messageCode);
        }
        return null;
    }

    private static String getSystemName(String messageCode) {
        return messageCode.substring(1, Math.min(4, messageCode.length()));
    }

    private static ResourceBundle getMessages(String systemName) {
        return ResourceBundle.getBundle(String.valueOf(systemName) + MESSAGES);
    }

    private static String getNoPatternMessage(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            buffer.append(args[i] + ", ");
            ++i;
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }
}

