package org.seasar.framework.aop.impl;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.exception.EmptyRuntimeException;

/**
 * @author higa
 *
 */
public class AspectImpl implements Aspect {

	private AroundAdvice aroundAdvice_;
	private Pointcut pointcut_;

	public AspectImpl(AroundAdvice aroundAdvice)
			throws EmptyRuntimeException {
				
		this(aroundAdvice, null);
	}
	
	public AspectImpl(AroundAdvice aroundAdvice, Pointcut pointcut)
		throws EmptyRuntimeException {

		if (aroundAdvice == null) {
			throw new EmptyRuntimeException("aroundAdvice");
		}
		aroundAdvice_ = aroundAdvice;
		pointcut_ = pointcut;
	}
	/**
	 * @see org.seasar.framework.aop.Aspect#getAroundAdvice()
	 */
	public AroundAdvice getAroundAdvice() {
		return aroundAdvice_;
	}

	/**
	 * @see org.seasar.framework.aop.Aspect#getPointcut()
	 */
	public Pointcut getPointcut() {
		return pointcut_;
	}

	/**
	 * @see org.seasar.framework.aop.Aspect#setPointcut(org.seasar.framework.aop.Pointcut)
	 */
	public void setPointcut(Pointcut pointcut) {
		pointcut_ = pointcut;
	}

}
