package test.org.seasar.framework.sel.exps;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.exps.GetArrayExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class GetArrayExpTest extends TestCase {

	public GetArrayExpTest(String name) {
		super(name);
	}

	public void testEvaluateValueForArray() throws Exception {
		String[] strings = new String[] { "bbb" };
		GetArrayExp exp =
			new GetArrayExp(
				new ObjectExp(strings),
				new ObjectExp(new Integer(0)));
		assertEquals("1", "bbb", exp.evaluateValue(null));
	}

	public void testEvaluateValueForList() throws Exception {
		List strings = new ArrayList();
		strings.add("bbb");
		GetArrayExp exp =
			new GetArrayExp(
				new ObjectExp(strings),
				new ObjectExp(new Integer(0)));
		assertEquals("1", "bbb", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GetArrayExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GetArrayExpTest.class.getName()});
	}
}