/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.matrix;

import slothLib.linearAlgebra.matrix.IMatrix;
import slothLib.linearAlgebra.vector.VectorCollection;

public class BasicMatrix {
    private double[][] matrix;

    public BasicMatrix(int row, int column) {
        this.matrix = new double[row][column];
    }

    public BasicMatrix(double[][] matrix) {
        this(matrix.length, matrix[0].length);
        int r = 0;
        while (r < matrix.length) {
            int c = 0;
            while (c < matrix[0].length) {
                this.matrix[r][c] = matrix[r][c];
                ++c;
            }
            ++r;
        }
    }

    public BasicMatrix(IMatrix matrix) {
        this(matrix.rowCount(), matrix.columnCount());
        int r = 0;
        while (r < matrix.rowCount()) {
            int c = 0;
            while (c < matrix.columnCount()) {
                this.matrix[r][c] = matrix.get(r, c);
                ++c;
            }
            ++r;
        }
    }

    public BasicMatrix(VectorCollection vectorCollection) {
        this(vectorCollection.count(), vectorCollection.dimension());
        int r = 0;
        while (r < vectorCollection.count()) {
            int c = 0;
            while (c < vectorCollection.dimension()) {
                this.matrix[r][c] = vectorCollection.get(r).get(c);
                ++c;
            }
            ++r;
        }
    }

    public double[][] getPlainMatrix() {
        return (double[][])this.matrix.clone();
    }

    public double get(int row, int column) {
        if (this.isIndexInRange(row, column)) {
            return this.matrix[row][column];
        }
        return 0.0;
    }

    public void set(int row, int column, double value) {
        if (this.isIndexInRange(row, column)) {
            this.matrix[row][column] = value;
        }
    }

    public int rowCount() {
        return this.matrix.length;
    }

    public int columnCount() {
        return this.matrix[0].length;
    }

    public Object clone() {
        return new BasicMatrix(this.getPlainMatrix());
    }

    public boolean isIndexInRange(int row, int column) {
        boolean result = true;
        result = result && row < this.rowCount();
        result = result && column < this.columnCount();
        return result;
    }
}

