
#
# Copyright (C) 2001-2005 Voluna Software. All rights reserved.
# Portions of this file are based on VA Linux's very old NetAttach's RPM spec file
#

%define of_user openfiler
%define of_passwd password
%define of_group openfiler
%define of_uid 94
%define of_gid 94
%define of_home /opt/%{name}

%define of_guest_user ofguest
%define of_guest_passwd password
%define of_guest_group ofguest
%define of_guest_uid 96
%define of_guest_gid 96
%define of_guest_home /mnt/%{name}

%define modified_files %{_sysconfdir}/samba/smb.conf %{_sysconfdir}/exports

Summary: Openfiler Storage Management Platform
Name: openfiler
Version: 1.1
Release: 1
Vendor: The Openfiler Project
License: GPL
ExclusiveOS: Linux
Group: Applications/System
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
URL: http://www.openfiler.org/
Requires: httpd >= 2.0.46, samba >= 3.0.7, samba-common >= 3.0.7
# Requires: samba-utils >= 3.0.7
Requires: php-openfiler >= 0.1, php-pam-auth >= 4.0, at >= 3.1.8
Requires: quota >= 3.09, lvm >= 1.0.8, acl >= 2.2.3, initscripts >= 7.31.16
Requires: redhat-config-date >= 1.5.22, authconfig >= 4.6.5, php >= 4.3.2
Requires: glibc-common >= 2.3.2, yp-tools >= 2.8, SysVinit >= 2.85, setup >= 2.5.27
Requires: chkconfig >= 1.3.11, coreutils >= 4.5.3, mount >= 2.11y, sudo >= 1.6, nfs-utils >= 1.0.6
Requires: ntp >= 4.1.2, util-linux >= 2.11y, yp-tools >= 2.8, passwd >= 0.68
Requires: mod_auth_pam >= 1.1.1
#Requires: vsftpd >= 1.2.1
#BuildPrereq: pam-devel >= 0.73, newt-devel, glib2-devel, python, python-devel


%description
Openfiler is a powerful, intuitive browser-based network storage management utility.
Openfiler, combined with the underlying Linux-based Operating System, delivers
file-based Network Attached Storage and block-based Storage Area Networking in
a single framework.


%prep
%setup -q


%build
make


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT


%clean
rm -rf $RPM_BUILD_ROOT


%post

# Backup files which may be modified
for i in %{modified_files}
do
	cp -f $i $i.openfiler-orig-backup
done

# Add the admin user account and group to the system
grep "^%{of_group}:" %{_sysconfdir}/group &> /dev/null
if [ $? != 0 ]
then
	groupadd -g %{of_gid} %{of_group}
fi
grep "^%{of_user}:" %{_sysconfdir}/passwd &> /dev/null
if [ $? != 0 ]
then
	useradd -M -u %{of_uid} -g %{of_gid} -d %{of_home} -s "%{of_home}/bin/ofconfig" -c "Openfiler Administrator" %{of_user}
	echo "%{of_user}:%{of_passwd}" | chpasswd
fi

# Add the guest user account and group to the system
grep "^%{of_guest_group}:" %{_sysconfdir}/group &> /dev/null
if [ $? != 0 ]
then
	groupadd -g %{of_guest_gid} %{of_guest_group}
fi
grep "^%{of_guest_user}:" %{_sysconfdir}/passwd &> /dev/null
if [ $? != 0 ]
then
	useradd -M -u %{of_guest_uid} -g %{of_guest_gid} -d %{of_guest_home} -s "/sbin/nologin" -c "Openfiler Guest User" %{of_guest_user}
	echo "%{of_guest_user}:%{of_guest_passwd}" | chpasswd
fi

# Set ownership and permissions on various paths
chown -R %{of_user}:%{of_group} $RPM_INSTALL_ROOT/%{of_home}
chgrp %{of_group} %{_sysconfdir}/shadow
chmod g+r %{_sysconfdir}/shadow

# Append OF account to 'ftpusers' to deny ftp connections
if [ -e %{_sysconfdir}/ftpusers ]
then
	grep -v "^%{of_user}" %{_sysconfdir}/ftpusers > /tmp/ftpusers
	echo "%{of_user}" >> /tmp/ftpusers
	cp -f /tmp/ftpusers %{_sysconfdir}/ftpusers
	rm -f /tmp/ftpusers
else
	echo "%{of_user}" >> %{_sysconfdir}/ftpusers
fi

# Add admin user to /etc/sudoers for root privs
# Using the mods below is pretty lax on the security side.. consider improving
if [ -e %{_sysconfdir}/sudoers ]
then
	grep -v "^%{of_user}" %{_sysconfdir}/sudoers > /tmp/sudoers
	echo "%{of_user}	ALL = NOPASSWD: ALL" >> /tmp/sudoers
	cp -f /tmp/sudoers %{_sysconfdir}/sudoers
	rm -f /tmp/sudoers
else
	echo "%{of_user}	ALL = NOPASSWD: ALL" >> %{_sysconfdir}/sudoers
fi

# Add account's shell to /etc/shells
if [ -e %{_sysconfdir}/shells ]
then
	grep -v "%{of_home}/bin/ofconfig" %{_sysconfdir}/shells > /tmp/shells
	echo "%{of_home}/bin/ofconfig" >> /tmp/shells
	cp /tmp/shells %{_sysconfdir}/shells
	rm /tmp/shells
else
	echo "%{of_home}/bin/ofconfig" >> %{_sysconfdir}/shells
fi

# Add openfiler init.d rc script
chkconfig --add %{name}

# Turn off network filesystem services by default
chkconfig smb off
chkconfig nfs off
chkconfig httpd off
# chkconfig vsftpd off
# chkconfig atalk off

# Turn off iptables
chkconfig iptables off

# Turn off nscd as it doesn't work well with Winbind for a start
chkconfig nscd off

# Turn on the port mapper, nfslock, atd and openfiler
chkconfig portmap on
chkconfig nfslock on
chkconfig atd on
chkconfig openfiler on

# Create default smb.conf
grep -i %{name} %{_sysconfdir}/samba/smb.conf &> /dev/null
if [ $? != 0 ] || [ ! -e %{_sysconfdir}/samba/smb.conf ]
then
    cat > %{_sysconfdir}/samba/smb.conf <<EOF
#
# PLEASE DO NOT MODIFY THIS CONFIGURATION FILE!
#   This configuration file was auto-generated
#   by Openfiler. Please do not modify it.
#

# Global settings

workgroup = SOMEGROUP
guest account = nobody
log file = /var/log/samba/%m.log
max log size = 0
security = domain
hosts deny = all
encrypt passwords = yes
smb passwd file = /etc/samba/smbpasswd
unix password sync = yes
passwd program = /usr/bin/passwd %u
passwd chat = *New*password* %n\n *Retype*new*password* %n\n *passwd:*all*authentication*tokens*updated*successfully*
pam password change = yes
obey pam restrictions = yes
socket options = TCP_NODELAY SO_RCVBUF=8192 SO_SNDBUF=8192
load printers = no

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/networks.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/networks.xml <<EOF
<?xml version="1.0" ?>
<networks>
</networks>

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/smb_settings.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/smb_settings.xml <<EOF
<?xml version="1.0" ?>
<smb>
	<serverstring value="Openfiler NAS" />
	<encryptedpasswords value="on" />
</smb>

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/volumes.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/volumes.xml <<EOF
<?xml version="1.0" ?>
<volumes>
</volumes>

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/snapshots.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/snapshots.xml <<EOF
<?xml version="1.0" ?>
<snapshots>
</snapshots>

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/rsync.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/rsync.xml <<EOF
<?xml version="1.0" ?>
<rsync>
</rsync>

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/cluster.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/cluster.xml <<EOF
<?xml version="1.0" ?>
<cluster>
</cluster>

EOF
fi

if [ ! -e $RPM_INSTALL_ROOT/%{of_home}/etc/specialpaths.xml ]
then
    cat > $RPM_INSTALL_ROOT/%{of_home}/etc/specialpaths.xml <<EOF
<?xml version="1.0" ?>
<specialpaths>
	<directory filename="cdrom" />
	<directory filename="floppy" />
	<directory filename="cluster_metadata" />
</specialpaths>

EOF
fi

# Blank /etc/exports
echo "" > %{_sysconfdir}/exports

# Update NFS exports
exportfs -r

# Blank openfiler-shares.conf
echo "" > %{_sysconfdir}/httpd/conf/openfiler-shares.conf

mkdir %{_sysconfdir}/skel.samba

    cat > %{_sysconfdir}/pam.d/samba <<EOF
#%PAM-1.0
auth       required     pam_nologin.so
auth       required     pam_stack.so service=system-auth
account    required     pam_stack.so service=system-auth
session    required     pam_mkhomedir.so skel=/etc/skel.samba umask=0077
session    required     pam_stack.so service=system-auth
password   required     pam_stack.so service=system-auth
EOF
cd $RPM_INSTALL_ROOT/%{of_home}/etc/httpd
ln -s /etc/httpd/build
mkdir logs
ln -s /etc/httpd/modules
mkdir run
mkdir -p $RPM_INSTALL_ROOT/%{of_home}/var/lock/subsys
mkdir -p $RPM_INSTALL_ROOT/%{of_home}/var/oflocks
mkdir -p $RPM_INSTALL_ROOT/%{of_home}/var/lib/dav

ln -s /usr/sbin/httpd /opt/openfiler/sbin/openfiler

# Set ownership and permissions on various paths
chown -R %{of_user}:%{of_group} $RPM_INSTALL_ROOT/%{of_home}

# Setup cron scheduled stuff
crontab -u openfiler $RPM_INSTALL_ROOT/%{of_home}/share/openfiler/stuff/openfiler.crontab

%preun

if [ $1 -eq 0 ]
then

	service openfiler stop
	service smb stop
	service nfs stop
	service nfslock stop
	service httpd stop

	rm -rf %{of_home}/var/lib/dav
	rm -rf %{of_home}/var/oflocks
	rm -rf %{of_home}/var/lock/subsys
	rm -rf %{of_home}/etc/httpd/logs
	rm -rf %{of_home}/etc/httpd/run
	rm -f %{of_home}/etc/httpd/build
	rm -f %{of_home}/etc/httpd/modules

	rm -rf /etc/skel.samba

	chkconfig smb off
	chkconfig nfs off
#	chkconfig atalk off
	chkconfig portmap off
	chkconfig openfiler off
	
	# Turn off init.d rc script
	chkconfig --del %{name}

	# Remove admin account from ftpusers
	grep -v "^%{of_user}" /etc/ftpusers > /tmp/ftpusers
	cp -f /tmp/ftpusers /etc/ftpusers
	rm -f /tmp/ftpusers

	# Remove of user from /etc/sudoers and cleanup
	grep -v "^%{of_user}" /etc/sudoers > /tmp/sudoers
	cp -f /tmp/sudoers /etc/sudoers
	rm -f /tmp/sudoers
	rm -rf /var/run/sudo/%{of_user}

	# Remove ofconfig from /etc/shells
	grep -v "ofconfig" /etc/shells > /tmp/shells
	cp -f /tmp/shells /etc/shells
	rm -f /tmp/shells
	
	# Remove cron scheduled stuff
	crontab -u openfiler -r

	# Restore orig system files
	for i in %{modified_files}
	do
		mv -f $i.openfiler-orig-backup $i
	done
fi

%postun

if [ $1 -eq 0 ]
then

	# Delete admin user and group accounts
	userdel %{of_user}
	userdel %{of_guest_user}
	# groupdel %{of_group} -- should not be necessary -- userdel should get rid of it
	# groupdel %{of_guest_group} -- should not be necessary -- userdel should get rid of it
	
fi

%files
%{of_home}/*
/etc/rc.d/init.d/openfiler

#----------------------------------------------------------------------------

%changelog
* Fri Jan 09 2004 Mukund Sivaraman <muks@xinitsystems.com>
- Adopted for GPL'd Openfiler

