
/*
 * Applet that displays the statistics meters on the start page
 *
 * Copyright (C) 2001-2005 Voluna Software. All rights reserved.
 *
 */


public class Meters extends javax.swing.JApplet implements java.awt.event.ActionListener
{
	java.net.URL documentbase, statsscript;
	java.net.URLConnection connection;
	java.io.InputStream istream;
	java.io.Reader ireader;
	java.io.StreamTokenizer tokens;
	java.awt.Color topdotcolor, markscolor, boxbgcolor, meanlinecolor, meantextcolor,
		textcolor, bbcolor, mbcolor, bgcolor, m1color, m2color,
		m3color, m4color, m5color;
	javax.swing.Timer timer;
	java.awt.image.BufferedImage bi;
	java.awt.Graphics gr;
	java.awt.Font headerfont;
	java.awt.Font defaultfont;
	java.awt.FontMetrics fm;
	
	int width, height;
	int mwidth, mheight, mspace, mcount, xsize, ysize;
	int mx1, mx2, mx3, mx4, mx5;
	int my1, my2, my3, my4, my5;

	double cpu[] = new double[60];
	double load[] = new double[60];
	double disk[] = new double[60];
	double memory[] = new double[60];
	double net[] = new double[60];
	int counter = 0;
	double marker;
	String hoststring;
	boolean infoready = false;
	
	private java.awt.Color parseColor(String color, int defaultr, int defaultg, int defaultb, int defaulta)
	{
		java.util.StringTokenizer st;
		java.awt.Color tempcolor;
		int r, g, b;
		
		if (color != null)
		{
			st = new java.util.StringTokenizer(color, ",");

			try
			{
				r = Integer.parseInt(st.nextToken());
				g = Integer.parseInt(st.nextToken());
				b = Integer.parseInt(st.nextToken());
			}
			catch (Exception e)
			{
				return (new java.awt.Color(defaultr, defaultg, defaultb, defaulta));
			}
			
			tempcolor = new java.awt.Color(r, g, b, defaulta);
		}
		else
			tempcolor = new java.awt.Color(defaultr, defaultg, defaultb, defaulta);
		
		return tempcolor;
	}
	
	public void init()
	{
		bgcolor = parseColor(getParameter("bgcolor"), 0xff, 0xff, 0xff, 0xff);
		m1color = parseColor(getParameter("m1color"), 0xce, 0xdf, 0xae, 0xc0);
		m2color = parseColor(getParameter("m2color"), 0x75, 0xd0, 0xf4, 0xc0);
		m3color = parseColor(getParameter("m3color"), 0xf9, 0xb8, 0x77, 0xc0);
		m4color = parseColor(getParameter("m4color"), 0xc7, 0xcc, 0xf9, 0xc0);
		m5color = parseColor(getParameter("m5color"), 0xdf, 0xc7, 0xf9, 0xc0);
		topdotcolor = parseColor(getParameter("topdotcolor"), 0x80, 0x80, 0x80, 0xc0);
		meanlinecolor = parseColor(getParameter("meanlinecolor"), 0xea, 0xc3, 0xb2, 0xc0);
		bbcolor = parseColor(getParameter("bbcolor"), 0xd0, 0xd0, 0xd0, 0xff);
		boxbgcolor = parseColor(getParameter("boxbgcolor"), 0xf0, 0xf0, 0xf0, 0xff);
		mbcolor = parseColor(getParameter("mbcolor"), 0x80, 0x80, 0x80, 0xff);
		markscolor = parseColor(getParameter("markscolor"), 0xd8, 0xd8, 0xd8, 0xff);
		meantextcolor = parseColor(getParameter("meantextcolor"), 0xe5, 0x7b, 0x54, 0xff);
		textcolor = parseColor(getParameter("textcolor"), 0x80, 0x80, 0x80, 0xff);

		headerfont = new java.awt.Font("Courier", java.awt.Font.PLAIN, 16);
		
		documentbase = getDocumentBase();

		// Set timer to update every 15 seconds
		
		timer = new javax.swing.Timer(15000, this);
		timer.setInitialDelay(0);
		timer.setCoalesce(true);
		
		try
		{
			statsscript = new java.net.URL("https://" + documentbase.getHost() + ":445/scripts/health.txt");
		}
		catch (java.net.MalformedURLException e)
		{
			System.out.println("Couldn't construct a valid URL from the server name: " + documentbase.getHost());
			return;
		}
		
		width = getWidth();
		height = getHeight();

		bi = new java.awt.image.BufferedImage(width, height, java.awt.image.BufferedImage.TYPE_INT_ARGB);
		gr = bi.createGraphics();

		mwidth = 122;
		mheight = 102;
		mspace = 25;
		mcount = 5;
		
		xsize = ((mcount - 1) * mspace) + (mcount * mwidth);
		ysize = mheight;
	}
	
	public void start()
	{
		if (!timer.isRunning())
			timer.start();
	}
	
	public void stop()
	{
		if (timer.isRunning())
			timer.stop();
	}
	
	private void drawMeter(int count, double values[], java.awt.Color color, String str, String suffix, boolean scale)
	{
		int mx1, mx2, txpos;
		double meanutilization, meanutilizationy;
		String displaystring;
		double correction = 1;
		
		mx1 = ((width - 2) / 2) - (xsize / 2) + (count * (mspace + mwidth));
		my1 = ((height - 2) / 2) - (ysize / 2) + 15;
		
		// Draw bounding box
		
		gr.setColor(mbcolor);
		gr.drawRect(mx1, my1, mwidth - 1, mheight);
		
		// Fill with background color
		
		gr.setColor(boxbgcolor);
		gr.fillRect(mx1 + 1, my1 + 1, mwidth - 2, mheight - 2);

		// Draw markers

		gr.setColor(markscolor);
		gr.drawLine(mx1 + 1 + ((int) marker), my1 + 1, mx1 + 1 + ((int) marker), my1 + (ysize - 1));
		gr.drawLine(mx1 + 21 + ((int) marker), my1 + 1, mx1 + 21 + ((int) marker), my1 + (ysize - 1));
		gr.drawLine(mx1 + 41 + ((int) marker), my1 + 1, mx1 + 41 + ((int) marker), my1 + (ysize - 1));
		gr.drawLine(mx1 + 61 + ((int) marker), my1 + 1, mx1 + 61 + ((int) marker), my1 + (ysize - 1));
		gr.drawLine(mx1 + 81 + ((int) marker), my1 + 1, mx1 + 81 + ((int) marker), my1 + (ysize - 1));
		gr.drawLine(mx1 + 101 + ((int) marker), my1 + 1, mx1 + 101 + ((int) marker), my1 + (ysize - 1));

		// Compute graph correction factor
		
		if (scale)
		{
		
			correction = 0;

			for (int i = 0; i < 60; i++)
				if (correction < values[i])
					correction = values[i];
			correction = 100 / correction;
		}

		// Plot the graph with the dots on it
		
		meanutilization = 0;
		
		for (int i = 0; i < 60; i++)
		{
			gr.setColor(color);
			gr.drawLine(mx1 + 1 + (i * 2), my1 + (ysize - 1), mx1 + 1 + (i * 2), my1 + (ysize - 1) - ((int) (values[i] * correction)) + 1);
			gr.drawLine(mx1 + 1 + (i * 2) + 1, my1 + (ysize - 1), mx1 + 1 + (i * 2) + 1, my1 + (ysize - 1) - ((int) (values[i] * correction)) + 1);
			gr.setColor(topdotcolor);
			gr.drawLine(mx1 + 1 + (i * 2), my1 + (ysize - 1) - ((int) (values[i] * correction)), mx1 + 1 + (i * 2), my1 + (ysize - 1) - ((int) (values[i] * correction)));
			gr.drawLine(mx1 + 1 + (i * 2) + 1, my1 + (ysize - 1) - ((int) (values[i] * correction)), mx1 + 1 + (i * 2) + 1, my1 + (ysize - 1) - ((int) (values[i] * correction)));
			meanutilization += values[i];
		}
		
		// Plot the average value line
		
		meanutilization /= 60;
		meanutilizationy = meanutilization * correction;
		
		gr.setColor(meanlinecolor);
		gr.drawLine(mx1 + 1, my1 + (ysize - 1) - ((int) meanutilizationy), mx1 + mwidth - 1, my1 + (ysize - 1) - ((int) meanutilizationy));
		
		// Display the text below
		
		gr.setColor(textcolor);
		displaystring = str + " - " + ((int) values[59]) + suffix + " [";
		fm = gr.getFontMetrics();
		txpos = mx1 + (mwidth / 2) - (fm.stringWidth(displaystring + ((int) meanutilization) + suffix + "]") / 2);
		gr.drawString(displaystring, txpos, my1 + (ysize - 1) - 10 + 30);

		gr.setColor(meantextcolor);
		txpos += fm.stringWidth(displaystring);
		displaystring = ((int) meanutilization) + suffix;
		fm = gr.getFontMetrics();
		gr.drawString(displaystring, txpos, my1 + (ysize - 1) - 10 + 30);

		gr.setColor(textcolor);
		txpos += fm.stringWidth(displaystring);
		displaystring = "]";
		gr.drawString(displaystring, txpos, my1 + (ysize - 1) - 10 + 30);
	}
	
	public void paint(java.awt.Graphics g)
	{
		// Clear the background
		
		gr.setColor(bgcolor);
		gr.fillRect(0, 0, width, height);
		
		// Draw applet bounding box

		gr.setColor(bbcolor);
		gr.drawRect(0, 0, width - 1, height - 1);
		
		// Draw the meters if information is ready

		if (infoready)
		{
			drawMeter(0, cpu, m1color, "CPU", "%", false);
			drawMeter(1, load, m2color, "Proc", "", true);
			drawMeter(2, disk, m3color, "Disk", "bk", true);
			drawMeter(3, memory, m4color, "Net", "KB", true);
			drawMeter(4, net, m5color, "Mem", "%", false);
		
			// Hostname and date string display
			
			gr.setColor(textcolor);
			defaultfont = gr.getFont();
			gr.setFont(headerfont);
			fm = gr.getFontMetrics();
			gr.drawString(hoststring, (width / 2) - (fm.stringWidth(hoststring) / 2), ((height - 2) / 2) - (ysize / 2) - 10);
			gr.setFont(defaultfont);
		}
		
		g.drawImage(bi, 0, 0, this);
	}
	
	public String getAppletInfo()
	{
		return "Title: System Statistics Meters\n"
			+ "Author: S. Mukund.\n"
			+ "A simple class to display statistic charts.";
	}
	
	public String[][] getParameterInfo()
	{
		String[][] info =
		{
			{"bgcolor", "int,int,int", "the background color of the applet"},
			{"m1color", "int,int,int", "the RGB color of the first meter"},
			{"m2color", "int,int,int", "the RGB color of the second meter"},
			{"m3color", "int,int,int", "the RGB color of the third meter"},
			{"m4color", "int,int,int", "the RGB color of the fourth meter"},
			{"m5color", "int,int,int", "the RGB color of the fifth meter"},
			{"topdotcolor", "int,int,int", "the RGB color of the topping dots"},
			{"meanlinecolor", "int,int,int", "the RGB color of the average value line"},
			{"bbcolor", "int,int,int", "the RGB color of the bounding box of the applet"},
			{"boxbgcolor", "int,int,int", "the RGB color of the background of the box"},
			{"mbcolor", "int,int,int", "the RGB color of the bounding box of a meter"},
			{"markscolor", "int,int,int", "the RGB color of the scale marks"},
			{"meantextcolor", "int,int,int", "the RGB color of text displaying average values"},
			{"textcolor", "int,int,int", "the RGB color of text displayed"}
		};

		return info;
	}
	
	public void actionPerformed(java.awt.event.ActionEvent event)
	{
		int nexttoken;
		int c;
		
		try
		{
			connection = statsscript.openConnection();
			istream = connection.getInputStream();
			
			hoststring = "";
			
			while ((c = istream.read()) != '\n')
				hoststring += (char) c;
			
			ireader = new java.io.InputStreamReader(istream);
			tokens = new java.io.StreamTokenizer(ireader);
			nexttoken = tokens.nextToken();
			
			while ((nexttoken != java.io.StreamTokenizer.TT_EOF) && (tokens.ttype != java.io.StreamTokenizer.TT_NUMBER))
				nexttoken = tokens.nextToken();

			if (nexttoken == java.io.StreamTokenizer.TT_EOF)
			{
				System.out.println("Error! Out of content reading input stream!");
				infoready = false;
				return;
			}
				
			marker = tokens.nval;
			nexttoken = tokens.nextToken();

			for (counter = 0; counter < 60; counter++)
			{
				while ((nexttoken != java.io.StreamTokenizer.TT_EOF) && (tokens.ttype != java.io.StreamTokenizer.TT_NUMBER))
					nexttoken = tokens.nextToken();

				if (nexttoken == java.io.StreamTokenizer.TT_EOF)
				{
					System.out.println("Error! Out of content reading input stream!");
					infoready = false;
					return;
				}
				
				cpu[counter] = tokens.nval;
				nexttoken = tokens.nextToken();
			}
			
			for (counter = 0; counter < 60; counter++)
			{
				while ((nexttoken != java.io.StreamTokenizer.TT_EOF) && (tokens.ttype != java.io.StreamTokenizer.TT_NUMBER))
					nexttoken = tokens.nextToken();

				if (nexttoken == java.io.StreamTokenizer.TT_EOF)
				{
					System.out.println("Error! Out of content reading input stream!");
					infoready = false;
					return;
				}
				
				load[counter] = tokens.nval;
				nexttoken = tokens.nextToken();
			}
			
			for (counter = 0; counter < 60; counter++)
			{
				while ((nexttoken != java.io.StreamTokenizer.TT_EOF) && (tokens.ttype != java.io.StreamTokenizer.TT_NUMBER))
					nexttoken = tokens.nextToken();

				if (nexttoken == java.io.StreamTokenizer.TT_EOF)
				{
					System.out.println("Error! Out of content reading input stream!");
					infoready = false;
					return;
				}
				
				disk[counter] = tokens.nval;
				nexttoken = tokens.nextToken();
			}
			
			for (counter = 0; counter < 60; counter++)
			{
				while ((nexttoken != java.io.StreamTokenizer.TT_EOF) && (tokens.ttype != java.io.StreamTokenizer.TT_NUMBER))
					nexttoken = tokens.nextToken();

				if (nexttoken == java.io.StreamTokenizer.TT_EOF)
				{
					System.out.println("Error! Out of content reading input stream!");
					infoready = false;
					return;
				}
				
				memory[counter] = tokens.nval;
				nexttoken = tokens.nextToken();
			}
			
			for (counter = 0; counter < 60; counter++)
			{
				while ((nexttoken != java.io.StreamTokenizer.TT_EOF) && (tokens.ttype != java.io.StreamTokenizer.TT_NUMBER))
					nexttoken = tokens.nextToken();

				if (nexttoken == java.io.StreamTokenizer.TT_EOF)
				{
					System.out.println("Error! Out of content reading input stream!");
					infoready = false;
					return;
				}
				
				net[counter] = tokens.nval;
				nexttoken = tokens.nextToken();
			}
			
			istream.close();
		}
		catch (java.io.IOException e)
		{
			System.out.println("Error! Unable to open a connection-to/read-from server: " + documentbase.getHost());
			infoready = false;
			return;
		}
		
		infoready = true;
		repaint();
	}
}
	
