
#
# RPM spec for Openfiler (still work in progress)
#

%define admin_user openfiler
%define admin_group openfiler
%define admin_uid 94
%define admin_gid 94
%define passwd password
%define prefix /opt/openfiler
%define volumegroup openfiler

Summary: Openfiler Storage Management Interface.
Name: openfiler
Version: 1.0
Release: 1
Vendor: Xinit Systems Limited
Group: Applications/System
License: GPL
Source: http://www.openfiler.org/downloads/source/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
URL: http://www.openfiler.org/
#Requires: httpd, samba, nfs-utils, netatalk, sudo, php, postgresql
#BuildPrereq: httpd, samba, nfs-utils, netatalk, sudo, php, postgresql

%description
Openfiler provides a convenient easy-to-use web-based storage management
interface, which can be used to manage users and their storage accounts
on a storage appliance.

%prep
%setup -q

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make install INSTALLPREFIX=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%pre

# Nothing here

%post

# Add the admin user account and group to the system
grep "^%{admin_group}:" /etc/group &> /dev/null
if [ $? != 0 ]; then
	groupadd -g %{admin_gid} %{admin_group}
fi
grep "^%{admin_user}:" /etc/passwd &> /dev/null
if [ $? != 0 ]; then
	useradd -u %{admin_uid} -g %{admin_gid} -d %{prefix} -s "%{prefix}/bin/ofsetup" -c "Openfiler Administrator" %{admin_user}
	echo "%{admin_user}:%{passwd}" | /usr/sbin/chpasswd
fi

# Set permissions on %{prefix}
chown -R %{admin_user}:%{admin_group} %{prefix}

# Add account's shell to /etc/shells
grep -v "%{prefix}/bin/ofsetup" /etc/shells > /tmp/shells
echo "%{prefix}/bin/ofsetup" >> /tmp/shells
cp /tmp/shells /etc/shells
rm /tmp/shells

# Add admin user to /etc/sudoers for root privs
grep -v "^%{admin_user}" /etc/sudoers > /tmp/sudoers
echo "%{admin_user}	ALL = NOPASSWD: ALL" >> /tmp/sudoers
cp /tmp/sudoers /etc/sudoers
rm /tmp/sudoers

# Setup services
chkconfig --add %{name}
chkconfig %{name} on
chkconfig portmap on
chkconfig smb off
chkconfig nfs off
chkconfig atalk off

# Create default smb.conf
grep "Openfiler" /etc/samba/smb.conf &> /dev/null
if [ $? != 0 ] || [ ! -e /etc/samba/smb.conf ]
then
	echo "
#
# PLEASE DO NOT MODIFY THIS CONFIGURATION FILE!
#   This configuration file was auto-generated
#   by Openfiler. Please do not modify it.
#

# Global settings

workgroup = SOMEGROUP
guest account = nobody
log file = /var/log/samba/%m.log
max log size = 0
security = user
hosts deny = all
encrypt passwords = yes
smb passwd file = /etc/samba/smbpasswd
unix password sync = yes
passwd program = /usr/bin/passwd %u
passwd chat = *New*password* %n\n *Retype*new*password* %n\n *passwd:*all*authentication*tokens*updated*successfully*
pam password change = yes
obey pam restrictions = yes
socket options = TCP_NODELAY SO_RCVBUF=8192 SO_SNDBUF=8192
load printers = no

" > /etc/samba/smb.conf
fi

# Update NFS exports with existing /etc/exports
exportfs -r

# Make share directory root
mkdir -p /mnt &> /dev/null
chmod 755 /mnt &> /dev/null


%preun
if [ $1 -eq 0 ]
then
	/bin/true
fi

#----------------------------------------------------------------------------

%postun
if [ $1 -eq 0 ]
then
	/bin/true
fi

#----------------------------------------------------------------------------

%files
%defattr(-, root, root)
%dir /etc/rc.d/
/etc/rc.d/rc.sysinit.%{name}
%dir %config /etc/rc.d/init.d/
/etc/rc.d/init.d/%{name}-post
/etc/rc.d/init.d/%{name}-pre
/etc/rc.d/init.d/atalk.%{name}
/etc/rc.d/init.d/httpd.%{name}
%dir %{home}/html/
%{home}/html/Start.pl
%{home}/html/Status.pl
%{home}/html/DiskQuota.pl
%{home}/html/Volume.pl
%dir %{home}/html/Language
%dir %{home}/html/Language/%{language}
%dir %{home}/html/Language/%{language}/Help
%dir %{home}/html/Language/%{language}/Help/Accounts
%{home}/html/Language/English/Help/Accounts/Group.txt
%{home}/html/Language/English/Help/Accounts/Administrator.txt
%{home}/html/Language/English/Help/Accounts/DefaultTemplate.txt
%{home}/html/Language/English/Help/Accounts/DiskQuota.txt
%{home}/html/Language/English/Help/Accounts/User.txt
%dir %{home}/html/Language/%{language}/Help/Shares
%{home}/html/Language/English/Help/Shares/ShareProperties.txt
%{home}/html/Language/English/Help/Volume.txt
%dir %{home}/html/Language/%{language}/Help/Network
%{home}/html/Language/English/Help/Network/NetworkProperties.txt
%{home}/html/Language/English/Help/Network/Hosts.txt
%{home}/html/Language/English/Help/VerifySetup.txt
%dir %{home}/html/Language/%{language}/Help/System
%{home}/html/Language/English/Help/System/Alerts.txt
%{home}/html/Language/English/Help/System/Backup.txt
%{home}/html/Language/English/Help/System/Clock.txt
%{home}/html/Language/English/Help/System/Status.txt
%{home}/html/Language/English/Help/System/SystemUpdate.txt
%{home}/html/Language/English/Help/System/Shutdown.txt
%{home}/html/Language/English/Help/System/Security.txt
%dir %{home}/html/Library/
%{home}/html/Library/Cabinet.pl
%{home}/html/Library/GuiLib.pl
%{home}/html/Library/Status.pl
%{home}/html/Library/Share.pl
%{home}/html/Library/cgi-lib.pl
%{home}/html/Library/Volume.pl
%{home}/html/Library/Login.pl
%{home}/html/Library/Package.pl
%{home}/html/Library/Security.pl
%{home}/html/Library/Tree.pl
%{home}/html/Library/cookie.lib
%{home}/html/Library/Authenticate.lib
%{home}/html/Library/Accounts.pl
%{home}/html/Library/CfgFile.pm
%{home}/html/Library/ServerAdmin.ph
%{home}/html/Library/CfgFile.pl
%{home}/html/Library/Alerts.pl
%{home}/html/Library/Network.pl
%{home}/html/Library/javascript.pl
%{home}/html/Storage.pl
%{home}/html/Login.pl
%{home}/html/Security.pl
%dir %{home}/html/Command/
%{home}/html/Command/Wizard.pl
%{home}/html/Command/Volume.pl
%{home}/html/Command/Accounts.pl
%{home}/html/Command/System.pl
%{home}/html/Command/Shares.pl
%{home}/html/Command/Hosts.pl
%{home}/html/Command/Network.pl
%{home}/html/Accounts.pl
%{home}/html/Backup.pl
%{home}/html/DefaultTemplate.pl
%{home}/html/Clock.pl
%{home}/html/System.pl
%dir %{home}/html/User/
%{home}/html/User/Password.pl
%{home}/html/User/DiskQuota.pl
%{home}/html/User/Login.pl
%{home}/html/User/Logout.pl
%{home}/html/Shares.pl
%{home}/html/ShareProperties.pl
%{home}/html/VerifySetup.pl
%{home}/html/Hosts.pl
%{home}/html/User.pl
%{home}/html/Administrator.pl
%{home}/html/Alerts.pl
%{home}/html/SystemUpdate.pl
%{home}/html/Group.pl
%{home}/html/Shutdown.pl
%{home}/html/Network.pl
%{home}/html/NetworkProperties.pl
%dir %{home}/html/admin
%dir %{home}/html/admin/system/
%{home}/html/admin/system/setup.cgi
%dir %{home}/html/admin/system/images/
%{home}/html/admin/system/images/NewButton.gif
%{home}/html/admin/system/images/ExpandedVolume.gif
%{home}/html/admin/system/images/ButtonDisable.gif
%{home}/html/admin/system/images/FolderNew.gif
%{home}/html/admin/system/images/DeleteButton.gif
%{home}/html/admin/system/images/Volume.gif
%{home}/html/admin/system/images/PlainFolder.gif
%{home}/html/admin/system/images/ButtonRename.gif
%{home}/html/admin/system/images/ExpandedArray.gif
%{home}/html/admin/system/images/FolderRename.gif
%{home}/html/admin/system/images/TreeBranch.gif
%{home}/html/admin/system/images/RenameButton.gif
%dir %{home}/html/admin/system/images/Pie/
%{home}/html/admin/system/images/Pie/pie095.gif
%{home}/html/admin/system/images/Pie/pie_disabled.gif
%{home}/html/admin/system/images/Pie/pie070.gif
%{home}/html/admin/system/images/Pie/pie005.gif
%{home}/html/admin/system/images/Pie/pie050.gif
%{home}/html/admin/system/images/Pie/pie040.gif
%{home}/html/admin/system/images/Pie/pie090.gif
%{home}/html/admin/system/images/Pie/pie010.gif
%{home}/html/admin/system/images/Pie/pie080.gif
%{home}/html/admin/system/images/Pie/pie100.gif
%{home}/html/admin/system/images/Pie/pie060.gif
%{home}/html/admin/system/images/Pie/pie099.gif
%{home}/html/admin/system/images/Pie/pie030.gif
%{home}/html/admin/system/images/Pie/pie020.gif
%{home}/html/admin/system/images/Pie/pie000.gif
%{home}/html/admin/system/images/Pie/pie001.gif
%{home}/html/admin/system/images/legend_used.gif
%{home}/html/admin/system/images/ButtonDelete.gif
%{home}/html/admin/system/images/NetAttachLogo.gif
%{home}/html/admin/system/images/ButtonCreateVolume.gif
%{home}/html/admin/system/images/Folder.gif
%{home}/html/admin/system/images/ExpandedFolder.gif
%{home}/html/admin/system/images/LastOpenFolder.gif
%{home}/html/admin/system/images/LastFolder.gif
%{home}/html/admin/system/images/OpenFolder.gif
%{home}/html/admin/system/images/ExpandableFolder.gif
%{home}/html/admin/system/images/cleardot.gif
%{home}/html/admin/system/images/Warning.gif
%{home}/html/admin/system/images/FolderDelete.gif
%{home}/html/admin/system/images/ButtonEnable.gif
%{home}/html/admin/system/images/legend_unused.gif
%dir %{home}/html/admin/images/
%{home}/html/admin/images/Help.gif
%{home}/html/admin/images/RightTopGray.gif
%{home}/html/admin/images/LeftTop.gif
%{home}/html/admin/images/LeftTopDkGray.gif
%{home}/html/admin/images/RightTopDkGray.gif
%{home}/html/admin/images/RightTopBlue.gif
%{home}/html/admin/images/RightTop.gif
%{home}/html/admin/images/LeftTopBlue.gif
%{home}/html/admin/images/LeftTopGray.gif
%{home}/html/admin/images/header_gsm.jpg
%{home}/html/admin/images/header_my_account.jpg
%{home}/html/admin/images/header_setup_options.jpg
%{home}/html/admin/images/header_system_setup.jpg
%{home}/html/admin/images/opt_my_account_up.jpg
%{home}/html/admin/images/opt_my_account_over.jpg
%{home}/html/admin/images/opt_system_setup_up.jpg
%{home}/html/admin/images/opt_system_setup_over.jpg
%{home}/html/admin/images/opt_support_up.jpg
%{home}/html/admin/images/opt_support_over.jpg
%{home}/html/admin/images/opt_gsm_up.jpg
%{home}/html/admin/images/opt_gsm_over.jpg
%{home}/html/admin/images/link_logout.jpg
%{home}/html/admin/images/link_setup_options.jpg
%{home}/html/admin/images/connectedto.gif
%{home}/html/admin/images/cleardot.gif
%{home}/html/admin/images/pleaselogin.gif
%{home}/html/admin/images/MainArt.jpg
%{home}/html/admin/images/LogoFooter.gif
%dir %{home}/html/admin/images/9000
%{home}/html/admin/images/9000/DriveEMPTY_Wide.gif
%{home}/html/admin/images/9000/DriveUNUSED_Wide.gif
%{home}/html/admin/images/9000/DriveOK_Wide.gif
%{home}/html/admin/images/9000/DriveSPARE_Wide.gif
%{home}/html/admin/images/9000/DriveFAULT_Wide.gif
%{home}/html/admin/images/9000/DriveFAILED_Wide.gif
%{home}/html/admin/images/9000/DriveDEAD_Wide.gif
%{home}/html/admin/images/9000/Floppy.gif
%dir %{home}/html/admin/images/9205SE
%{home}/html/admin/images/9205SE/DriveEMPTY_Wide.gif
%{home}/html/admin/images/9205SE/DriveUNUSED_Wide.gif
%{home}/html/admin/images/9205SE/DriveOK_Wide.gif
%{home}/html/admin/images/9205SE/DriveSPARE_Wide.gif
%{home}/html/admin/images/9205SE/DriveFAULT_Wide.gif
%{home}/html/admin/images/9205SE/DriveFAILED_Wide.gif
%{home}/html/admin/images/9205SE/DriveDEAD_Wide.gif
%dir %{home}/html/admin/images/9205NAS
%{home}/html/admin/images/9205NAS/MainArt.jpg
%{home}/html/admin/images/9205NAS/DriveEMPTY_Wide.gif
%{home}/html/admin/images/9205NAS/DriveUNUSED_Wide.gif
%{home}/html/admin/images/9205NAS/DriveOK_Wide.gif
%{home}/html/admin/images/9205NAS/DriveSPARE_Wide.gif
%{home}/html/admin/images/9205NAS/DriveFAULT_Wide.gif
%{home}/html/admin/images/9205NAS/DriveFAILED_Wide.gif
%{home}/html/admin/images/9205NAS/DriveDEAD_Wide.gif
%{home}/html/admin/images/9205NAS/Floppy.gif
%{home}/html/admin/main.cgi
%{home}/html/admin/footer.cgi
%{home}/html/admin/index.htm
%dir %{home}/html/admin/user
%{home}/html/admin/user/setup.cgi
%dir %{home}/html/admin/user/images
%{home}/html/admin/user/images/cleardot.gif
%dir %{home}/conf
%config %{home}/conf/phone
%config %{home}/conf/ServerAdmin.conf
%config %{home}/conf/httpd.conf
%config %{home}/conf/cabinet.conf
%config %{home}/conf/alert_contact
%config %{home}/conf/package.conf
%config %{home}/conf/config-backup.spec
%dir %{home}/bin/
%{home}/bin/sendmesg
%{home}/bin/notifyd
%{home}/bin/cleanlogd
%{home}/bin/delete_user
%{home}/bin/devicemon
%{home}/bin/naconfig
%{home}/bin/quotad
%{home}/bin/add_user
%{home}/bin/make-config-rpm

%changelog
* Thu Nov 28 2002 Mukund Sivaraman <muks@xinitsystems.com>
- Initial revision
