Summary: Extension functions in PHP for PAM authentication
Name: php-pam-auth
Version: 4.0
Release: 2of
License: GPL
ExclusiveOS: Linux
Group: Development/Languages
BuildRoot: %{_tmppath}/%{name}-root
Source: %{name}-%{version}.tar.gz
Requires: php >= 4.3.4, pam >= 0.77
BuildPrereq: php-devel >= 4.3.4, pam-devel >= 0.77
Vendor: The Openfiler Project

%description 
Extension functions in PHP for PAM authentication

%prep
%setup -q

%build
phpize
%configure
make

%install
rm -rf $RPM_BUILD_ROOT
make install INSTALL_ROOT=$RPM_BUILD_ROOT

install -m 755 -d $RPM_BUILD_ROOT%{_sysconfdir}/php.d
install -m 755 -d $RPM_BUILD_ROOT%{_sysconfdir}/pam.d

# Generate files lists and stub .ini files for pam-auth subpackage
for mod in pam_auth; do
    cat > $RPM_BUILD_ROOT%{_sysconfdir}/php.d/${mod}.ini <<EOF
; Enable ${mod} extension module
extension=${mod}.so
EOF

    cat > $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/php <<EOF
#%PAM-1.0
auth            sufficient      /lib/security/pam_pwdb.so shadow nodelay
account         sufficient      /lib/security/pam_pwdb.so
EOF

    cat > files.${mod} <<EOF
%attr(755,root,root) %{_libdir}/php4/${mod}.so
%config(noreplace) %attr(644,root,root) %{_sysconfdir}/php.d/${mod}.ini
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/pam.d/php
EOF
done

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
rm files.*

%files -f files.pam_auth

%changelog
* Tue Jan 06 2004 Mukund Sivaraman <muks@xinitsystems.com> 4.0-1of
- Initial release

