Name: quota
Summary: System administration tools for monitoring users' disk usage.
Epoch: 1
Version: 3.10
Release: 2.1of
Vendor: The Openfiler Project
License: BSD
Group: System Environment/Base
BuildRoot: %{_tmppath}/%{name}-root
Requires: kernel >= 2.4 initscripts >= 6.38
BuildPreReq: e2fsprogs-devel gettext tcp_wrappers
Source0: http://prdownloads.sourceforge.net/linuxquota/quota-%{version}.tar.gz
Patch0:	quota-3.06-warnquota.patch
Patch1: quota-3.06-no-stripping.patch
Patch2: quota-3.06-man-page.patch
Patch3: quota-3.09-root_sbindir.patch
Patch4: quota-3.06-pie.patch
Patch5: quota-openfiler.patch


%description
The quota package contains system administration tools for monitoring
and limiting user and or group disk usage per filesystem.


%prep
%setup -q -n quota-tools
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%ifnarch ppc ppc64
%patch4 -p1
%endif
%patch5 -p1


%build
%configure \
	--with-ext2direct=no
make


%install
rm -fr %{buildroot}
mkdir -p %{buildroot}/sbin
mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_sbindir}
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_mandir}/{man1,man2,man3,man8}
make install ROOTDIR=%{buildroot}
install -m 644 warnquota.conf %{buildroot}%{_sysconfdir}
#
# we don't support XFS yet
#
rm -f %{buildroot}%{_sbindir}/quot
rm -f %{buildroot}%{_sbindir}/xqmstats
rm -f %{buildroot}%{_mandir}/man8/quot.*

%find_lang %{name}


%clean
rm -rf %{buildroot}


%files -f %{name}.lang
%defattr(-,root,root)
%config(noreplace) %{_sysconfdir}/warnquota.conf
%attr(0644,root,root) %{_sysconfdir}/*
%attr(0755,root,root) /sbin/*
%attr(0755,root,root) %{_bindir}/*
%attr(0755,root,root) %{_sbindir}/*
%{_includedir}/rpcsvc/*
%attr(0644,root,root) %{_mandir}/man1/*
%attr(0644,root,root) %{_mandir}/man2/*
%attr(0644,root,root) %{_mandir}/man3/*
%attr(0644,root,root) %{_mandir}/man8/*


%changelog
* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Jan 27 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- add -pie support
- update to 3.10

* Sat Aug 16 2003  Steve Dickson <SteveD@RedHat.com>
- upgraded to 3.0.9
- added quota-3.09-root_sbindir.patch

* Sun Aug 10 2003 Elliot Lee <sopwith@redhat.com> 3.06-11
- Rebuild

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue May 27 2003 Steve Dickson <SteveD@RedHat.com>
- rebuilt for 7.3 errata

* Tue Feb 25 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sun Feb 23 2003 Tim Powers <timp@redhat.com>
- add buildprereq on tcp_wrappers

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Mon Nov 18 2002 Tim Powers <timp@redhat.com>
- rebuild on all arches


* Fri Sep 6 2002 Philip Copeland <bryce@redhat.com> 3.06-5
- added --with-ext2direct=no to fix #73244
  without this users with UID's > 65535 will not
  be able to exist on a quota enabled FS

* Wed Aug 7 2002 Philip Copeland <bryce@redhat.com> 3.06-4
- Man page change. #60108

* Tue Aug 6 2002 Philip Copeland <bryce@redhat.com> 3.06-3
- Bah, I'd dropped epoch from the spec file but seems
  we need this if you want to upgrade as the epoch
  number has precedence over the version/release
  numbers.

* Wed Jul 17 2002 Philip Copeland <bryce@redhat.com> 3.06-2
- Lets stop the makefile from stripping the
  binaries as thats rpms job (apparently)

* Mon Jul 01 2002 Philip Copeland <bryce@redhat.com> 3.06-1
- Ditched the 3.01-pre9 src base for 3.06
  Rebuilt without any patchs

============================================================

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Feb 25 2002 Elliot Lee <sopwith@redhat.com>
- IfArch the badkernelinclude patch for ppc-only.
- Update to 3.03

* Wed Dec 12 2001 Guy Streeter <streeter@redhat.com>
- Make #include of kernel header file work on non-x86

* Wed Sep  5 2001 Preston Brown <pbrown@redhat.com>
- require new initscripts

* Thu Aug 30 2001 Preston Brown <pbrown@redhat.com>
- fixed bug #52075 (problem with ext2 labels)
- backup data files off by default in quotacheck, optional backup flag added
- fix bug where giving a bad directory or device would cause 
  quotaon/quotacheck to simulate "-a" behaviour
- if a device name (i.e /dev/hda1) is passed, look up the corresponding mount
  point

* Wed Aug 29 2001 Preston Brown <pbrown@redhat.com>
- return an error code in more cases in convertquota

* Tue Aug 28 2001 Preston Brown <pbrown@redhat.com>
- 3.01pre9

* Fri Jul 20 2001 Preston Brown <pbrown@redhat.com>
- more cleanups on 3.01pre8

* Mon Jul  2 2001 Preston Brown <pbrown@redhat.com>
- 3.01 version, everything has changed again. :(

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Fri Mar 30 2001 Preston Brown <pbrown@redhat.com>
- use rpc.rquotad from here again (#33738)

* Thu Mar 15 2001 Preston Brown <pbrown@redhat.com>
- enable ALT_FORMAT for edquota

* Tue Mar 13 2001 Preston Brown <pbrown@redhat.com>
- I broke passing devices on the cmd line.  Fixed.

* Fri Mar 09 2001 Preston Brown <pbrown@redhat.com>
- quota 3.00 is required by recent kernel 2.4 changes
- no warnquota included this time, not yet ported
- quite a bit of work on quotacheck to make is backwards compatible
- we will likely go back to "quota 2.00" as these projects merge...

* Fri Feb 09 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- use "rm -f" instead of only "rm"

* Wed Feb  7 2001 Preston Brown <pbrown@redhat.com>
- fix quotacheck man page for -a option (#26380)

* Thu Feb  1 2001 Preston Brown <pbrown@redhat.com>
- 2.00 final, rolls in pretty much all our patches. :)
- fix reporting of in use dquot entries from quotastats
- change repquota man page to fix documentation of -v (#10330)
- include warnquota.conf

* Mon Nov 20 2000 Bill Nottingham <notting@redhat.com>
- fix ia64 build

* Mon Aug 21 2000 Jeff Johnson <jbj@redhat.com>
- add LABEL=foo support (#16390).

* Thu Jul 27 2000 Jeff Johnson <jbj@redhat.com>
- remote NFS quotas with different blocksize converted incorrectly (#11932).

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Thu Jun 15 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.

* Wed May 10 2000 Jeff Johnson <jbj@redhat.com>
- apply patch5 (H.J. Lu)

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix description
- man pages are compressed

* Tue Jan 18 2000 Preston Brown <pbrown@redhat.com>
- quota 2.00 series
- removed unnecessary patches

* Thu Aug  5 1999 Jeff Johnson <jbj@redhat.com>
- fix man page FUD (#4369).

* Thu May 13 1999 Peter Hanecak <hanecak@megaloman.sk>
- changes to allow non-root users to build too (Makefile patch, %attr)

* Tue Apr 13 1999 Jeff Johnson <jbj@redhat.com>
- fix for sparc64 quotas (#2147)

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 5)

* Mon Dec 28 1998 Cristian Gafton <gafton@redhat.com>
- don't install rpc.rquotad - we will use the one from the knfsd package
  instead

* Thu Dec 17 1998 Jeff Johnson <jbj@redhat.com>
- merge ultrapenguin 1.1.9 changes.

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Apr 30 1998 Cristian Gafton <gafton@redhat.com>
- removed patch for mntent

* Fri Mar 27 1998 Jakub Jelinek <jj@ultra.linux.cz>
- updated to quota 1.66

* Tue Jan 13 1998 Erik Troan <ewt@redhat.com>
- builds rquotad
- installs rpc.rquotad.8 symlink

* Mon Oct 20 1997 Erik Troan <ewt@redhat.com>
- removed /usr/include/rpcsvc/* from filelist
- uses a buildroot and %attr

* Thu Jun 19 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Tue Mar 25 1997 Erik Troan <ewt@redhat.com>
- Moved /usr/sbin/quota to /usr/bin/quota
