<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}

if (!defined('_SB_DIRNAME')) {
    define('_SB_DIRNAME', basename(dirname(dirname(__FILE__))));
}
require_once XOOPS_MODULE_PATH . "/" . _SB_DIRNAME . '/inc/inc.php';
require_once _SB_MODULE_PATH . 'inc/util.php';
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ǿ̰֥å饹
 *
 */
class scorebook_ViewLastRankPitcherBlock extends Legacy_BlockProcedure {

    /**
     * ץꥹ
     *
     * @var Array
     */
    var $options = array();

    /**
     * 󥹥ȥ饯
     *
     * @param object $block
     * @return scorebook_ViewLastRankPitcherBlock
     */
    function scorebook_ViewLastRankPitcherBlock(&$block) {

        parent::Legacy_BlockProcedure($block);
        $this->options = explode('|', $this->_mBlock->get('options'));

        if (empty($this->options[0])) {
            $this->options[0] = 'ERA';
        }
        if (empty($this->options[1])) {
            $this->options[1] = SORT_ASC;
        }
        else {
            if ($this->options[1] == 'ASC') {
                $this->options[1] = SORT_ASC;
            }
            elseif ($this->options[1] == 'DESC') {
                $this->options[1] = SORT_DESC;
            }
        }
        if (empty($this->options[2])) {
            $this->options[2] = '3';
        }
    }

    /**
     * ֥åɽ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $root->mLanguageManager->loadBlockMessageCatalog($this->_mBlock->get('dirname'));

        /* ͼ */
        $year = date('Y');
        $column = $this->options[0];
        $sort = $this->options[1];
        $limit = $this->options[2];

        /* 󥹥󥹤 */
        $playerResultPitcher =& new PlayerResultPitcher();
        $team =& new Team();
        $game =& new Game();

        /* ꥹȤμ */
        $teamList = $team->getAllList();
        /* (Ǥ⥲¿Υ)ȤƼ */
        $maxGameCount = 0;
        foreach ($teamList as $teamItem) {
            $game->setTeamCd($teamItem['team_cd']);
            $gameCount = $game->getGameCount($year);
            if ($gameCount > $maxGameCount) {
                $maxGameCount = $gameCount;
            }
        }
        $baseIP = $maxGameCount;

        /* 󥭥󥰥ꥹȤμ */
        $playerResultPitcher->setYear($year);
        $playerResultPitcher->setBaseIP($baseIP);
        $playerResultPitcher->setRankSortCond($column, $sort);

        /* 󥭥󥰤μ */
        $playerResultPitcher->setResultCd(1);
        $winList = $playerResultPitcher->getResultCdList();
        /* ̿󥭥󥰤μ */
        $playerResultPitcher->setResultCd(2);
        $loseList = $playerResultPitcher->getResultCdList();
        /* SAVE󥭥󥰤μ */
        $playerResultPitcher->setResultCd(3);
        $SVList = $playerResultPitcher->getResultCdList();
        /* HOLD󥭥󥰤μ */
        $playerResultPitcher->setResultCd(4);
        $HLDList = $playerResultPitcher->getResultCdList();
        /* ¾ܥ󥭥󥰤μ */
        $rankList = array_set_key($playerResultPitcher->getRankList(), 'player_cd');

        /* ̤ޡ */
        for ($i = 0; $i < count($rankList); $i++) {
            if (!empty($winList[$i]) && !empty($rankList[$winList[$i]['player_cd']])) {
                $rankList[$winList[$i]['player_cd']]['win'] = $winList[$i]['win'];
            }
            if (!empty($loseList[$i]) && !empty($rankList[$loseList[$i]['player_cd']])) {
                $rankList[$loseList[$i]['player_cd']]['lose'] = $loseList[$i]['lose'];
            }
            if (!empty($SVList[$i]) && !empty($rankList[$SVList[$i]['player_cd']])) {
                $rankList[$SVList[$i]['player_cd']]['SV'] = $SVList[$i]['SV'];
            }
            if (!empty($HLDList[$i]) && !empty($rankList[$HLDList[$i]['player_cd']])) {
                $rankList[$HLDList[$i]['player_cd']]['HLD'] = $HLDList[$i]['HLD'];
            }
        }

        /* Ⱦ */
        $showList =array();
        if (!empty($rankList)) {
            foreach ($rankList as $key => $rank) {
                $firstKeyList[$key] = $rank[$column];
                $secondKeyList[$key] = $rank['win'];
            }

            /* 󥯥ꥹȤΥ */
            
            array_multisort($firstKeyList, $sort, SORT_NUMERIC, $secondKeyList, SORT_DESC, SORT_NUMERIC, $rankList);
            /* ʬΤ߼ */
            for ($i = 0; $i < $limit; $i++) {
                if (!empty($rankList)) {
                    $showList[] = array_shift($rankList);
                }
            }
        }

        $render =& $this->getRenderTarget();
        $render->setTemplateName($this->_mBlock->get('template'));
        $render->setAttribute('mid', $this->_mBlock->get('mid'));
        $render->setAttribute('bid', $this->_mBlock->get('bid'));
        $render->setAttribute('rankList', $showList);
        $render->setAttribute('_TEXT_PLAYER_NAME', _MB_SB_TEXT_PLAYER_NAME);
        $render->setAttribute('_TEXT_ERA', _MB_SB_TEXT_ERA);
        $render->setAttribute('_TEXT_IP', _MB_SB_TEXT_IP);
        $render->setAttribute('_TEXT_R', _MB_SB_TEXT_R);
        $render->setAttribute('_TEXT_ER', _MB_SB_TEXT_ER);
        $render->setAttribute('_TEXT_WIN', _MB_SB_TEXT_WIN);
        $render->setAttribute('_TEXT_LOSE', _MB_SB_TEXT_LOSE);
        $render->setAttribute('_TEXT_SV', _MB_SB_TEXT_SV);
        $render->setAttribute('_TEXT_HLD', _MB_SB_TEXT_HLD);
        $render->setAttribute('sb_url', _SB_MODULE_URL);
        $render->setAttribute('column', $column);
        $renderSystem =& $root->getRenderSystem($this->getRenderSystemName());
        $renderSystem->renderBlock($render);
    }

    /**
     * ֥åԽ᥽å
     *
     * @return String
     */
    function getOptionForm() {
        $options = explode('|', $this->_mBlock->get('options'));
        $options[2] = (int) $options[2];
        $mydirname = $this->_mBlock->get('dirname');

        if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname)) {
            die('Invalid dirname');
        }
        $root =& XCube_Root::getSingleton();
        $root->mLanguageManager->loadBlockMessageCatalog($mydirname);

        $win = "";
        $lose = "";
        $SV = "";
        $HLD = "";
        $ERA = "";
        if ($options[0] == 'win') {
            $win = ' selected';
        }
        elseif ($options[0] == 'lose') {
            $lose = ' selected';
        }
        elseif ($options[0] == 'SV') {
            $SV = ' selected';
        }
        elseif ($options[0] == 'HLD') {
            $HLD = ' selected';
        }
        elseif ($options[0] == 'ERA') {
            $ERA = ' selected';
        }

        $ASC = "";
        $DESC = "";
        if ($options[1] == "ASC") {
            $ASC = " selected";
        }
        elseif ($options[1] == "DESC") {
            $DESC = " selected";
        }

        $selectItem = '<select name="options[]">';
        $selectItem .= '<option value="win"' . $win . '>' . _MB_SB_TEXT_WIN;
        $selectItem .= '<option value="lose"' . $lose . '>' . _MB_SB_TEXT_LOSE;
        $selectItem .= '<option value="SV"' . $SV . '>' . _MB_SB_TEXT_SV;
        $selectItem .= '<option value="HLD"' . $HLD . '>' . _MB_SB_TEXT_HLD;
        $selectItem .= '<option value="ERA"' . $ERA . '>' . _MB_SB_TEXT_ERA;
        $selectItem .= '</select>';
        $selectSort = '<select name="options[]">';
        $selectSort .= '<option value="ASC"' . $ASC . '>' . _MB_SB_TEXT_ASC;
        $selectSort .= '<option value="DESC"' . $DESC . '>' . _MB_SB_TEXT_DESC;
        $selectSort .= '</select>';
        $form = '<table>';
        $form .= '<tr><td>' . _MB_SB_TEXT_LAST_PITCHER_COLUMN . '</td><td>' . $selectItem . '</td></tr>';
        $form .= '<tr><td>' . _MB_SB_TEXT_LAST_PITCHER_SORT . '</td><td>' . $selectSort . '</td></tr>';
        $form .= sprintf('<tr><td>%s:</td><td><input type="text" name="options[]" value="%d" /></td></tr>', _MB_SB_TEXT_LAST_PITCHER_LIMIT, intval($options[2]));
        $form .= '</table>';
        return $form;
    }

}
?>