<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * 饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class deleteGameAction extends ActionAbstract  {

    /**
     * μ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();
        $game =& new Game();

        /* ͼ */
        $gameCd = $root->mContext->mRequest->getRequest('game_cd');

        /*  */
        $game->setGameCd($gameCd);
        $detailGame = $game->getGame();

        /* 桼å */
        $acl->setTeamCd($detailGame['top_team_cd']);
        $topEditFg = $acl->isEditGame();
        $acl->setTeamCd($detailGame['bottom_team_cd']);
        $bottomEditFg = $acl->isEditGame();
        $editFg = false;
        if ($topEditFg || $bottomEditFg) {
            $editFg = true;
        }
        if (!$editFg) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* ͥå */
        $validate =& new validateDeleteGameFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError() || empty($detailGame)) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_BADDATA;
            return;
        }

        /* 򥻥å */
        $game->setDataList($gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);

        /*  */
        if (!$game->delete()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_DELETE;
        }
        else {
            /* ¾ơ֥Υ쥳ɤ */
            $teamResult =& new TeamResult();
            $playerResultHitter =& new PlayerResultHitter();
            $playerResultPitcher =& new PlayerResultPitcher();

            /* ̥ޥåפκ */
            $teamResult->setDataList($gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
            $teamResult->delete();

            /* (Ǽ)κ */
            $playerResultHitter->setDataList($gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
            $playerResultHitter->delete();

            /* ()κ */
            $playerResultPitcher->setDataList($gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
            $playerResultPitcher->delete();
        }
    }

    /**
     * ȥåץڡ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL, _SB_MODULE_REDIRECT_TIME,
            _MD_SB_SUCCESS_DELETE);
    }
}
?>