<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once XOOPS_MODULE_PATH . '/legacy/kernel/Legacy_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * ɲäͥå饹
 *
 * @since 0.0.1
 * @author saitoh-y
 */
class validateInsertTeamFormAction extends Legacy_ActionForm {
    /**
     * 󥹥ȥ饯
     *
     * @return object validateInsertTeamFormAction
     */
    function validateInsertTeamFormAction() {
        parent::Legacy_ActionForm();
    }

    /**
     * ȡ̾
     *
     * @return String
     */
    function getTokenName() {
        return 'modules.' . _SB_DIRNAME . '.insertTeamForm.TOKEN';
    }

    /**
     * ͥå¹ԥ᥽å
     *
     */
    function prepare() {
        /* ǡϥåϿ */
        $this->mFormProperties['team_name'] =& new XCube_StringProperty('team_name');
        $this->mFormProperties['home'] =& new XCube_StringProperty('home');
        $this->mFormProperties['sort_num'] =& new XCube_StringProperty('sort_num');

        /* ̾ */
        $this->mFieldProperties['team_name'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['team_name']->setDependsByArray(array('required', 'maxlength'));
        $this->mFieldProperties['team_name']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['team_name']->addMessage('required', _MD_SB_COLUMN_TEAM_NAME
            . _MD_SB_CHECK_NULL);
        $this->mFieldProperties['team_name']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_TEAM_NAME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* ۡ॰饦 */
        $this->mFieldProperties['home'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['home']->setDependsByArray(array('maxlength'));
        $this->mFieldProperties['home']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['home']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_HOME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* ֹ */
        $this->mFieldProperties['sort_num'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['sort_num']->setDependsByArray(array('required', 'maxlength'));
        $this->mFieldProperties['sort_num']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_SORT_NUM);
        $this->mFieldProperties['sort_num']->addMessage('required', _MD_SB_COLUMN_SORT_NUM
            . _MD_SB_CHECK_NULL);
        $this->mFieldProperties['sort_num']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_SORT_NUM, _SB_MODULE_VALI_MAXLENGTH_SORT_NUM);
    }

    /**
     * ֹΥå
     *
     */
    function validateSort_num() {
        /* ͥå */
        if (!$this->isNumeric_sort_num()) {
            $this->addErrorMessage(_MD_SB_COLUMN_SORT_NUM
                . _MD_SB_CHECK_NUMERIC);
        }
    }

    /**
     * ֹοͥå
     *
     */
    private function isNumeric_sort_num() {
        $data = $this->get('sort_num');
        if (!empty($data) && !is_numeric($data)) {
            return false;
        }
        else {
            return true;
        }
    }
}
?>