<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once XOOPS_MODULE_PATH . '/legacy/kernel/Legacy_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * ƥ󹹿ͥå饹
 *
 * @since 1.0.0
 * @author saitoh-y
 */
class validateUpdateCategoryFormAction extends Legacy_ActionForm {
    /**
     * 󥹥ȥ饯
     *
     * @return object validatepdateCategoryFormAction
     */
    function validateUpdateCategoryFormAction() {
        parent::Legacy_ActionForm();
    }

    /**
     * ȡ̾
     *
     * @return String
     */
    function getTokenName() {
        return 'modules.' . _SB_DIRNAME . '.updateCategoryForm.TOKEN';
    }

    /**
     * ͥå¹ԥ᥽å
     *
     */
    function prepare() {
        /* ǡϥåϿ */
        $this->mFormProperties['category_cd'] =& new XCube_StringProperty('category_cd');
        $this->mFormProperties['category_name'] =& new XCube_StringProperty('category_name');
        $this->mFormProperties['sort_num'] =& new XCube_StringProperty('sort_num');

        /* ƥꥳ */
        $this->mFieldProperties['category_cd'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['category_cd']->setDependsByArray(array('required'));
        $this->mFieldProperties['category_cd']->addMessage('required', _MD_SB_COLUMN_CATEGORY_CD
            . _MD_SB_CHECK_NULL);

        /* ƥ̾ */
        $this->mFieldProperties['category_name'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['category_name']->setDependsByArray(array('required', 'maxlength'));
        $this->mFieldProperties['category_name']->addVar('maxlength',
            _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['category_name']->addMessage('required', _MD_SB_COLUMN_CATEGORY_NAME .
            _MD_SB_CHECK_NULL);
        $this->mFieldProperties['category_name']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_CATEGORY_NAME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* ֹ */
        $this->mFieldProperties['sort_num'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['sort_num']->setDependsByArray(array('required', 'maxlength'));
        $this->mFieldProperties['sort_num']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_SORT_NUM);
        $this->mFieldProperties['sort_num']->addMessage('required', _MD_SB_COLUMN_SORT_NUM .
            _MD_SB_CHECK_NULL);
        $this->mFieldProperties['sort_num']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_SORT_NUM, _SB_MODULE_VALI_MAXLENGTH_SORT_NUM);
    }

    /**
     * ֹΥå
     *
     */
    function validateSort_num() {
        /* ͥå */
        if (!$this->isNumeric_sort_num()) {
            $this->addErrorMessage(_MD_SB_COLUMN_SORT_NUM . _MD_SB_CHECK_NUMERIC);
        }
    }

    /**
     * ֹοͥå
     *
     */
    private function isNumeric_sort_num() {
        $data = $this->get('sort_num');
        if (!empty($data) && !is_numeric($data)) {
            return false;
        }
        else {
            return true;
        }
    }
}
?>