<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/database/DatabaseScoreBookClass.php";

/**
 * sb_playerơ֥륯饹
 *
 * @since 0.0.8
 * @author saitoh-y
 */
class Player extends DatabaseScoreBook {

    /**
     * ꥳ
     *
     * @access private
     * @var Integer
     */
    private $plyerCd = 0;

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * ÿͥե饰
     *
     * @access private
     * @var Integer
     */
    private $helpFg = 0;

    /**
     * OBե饰
     *
     * @access private
     * @var Integer
     */
    private $obFg = 0;

    /**
     * sb_playerơ֥ƤΥ쥳ɤ
     *
     * @return Array
     */
    function getAllList() {
        $sql = "SELECT * FROM " . $this->tableNamePlayer . " ORDER BY team_cd ASC, back_num ASC";
        return $this->getList($sql);
    }

    /**
     * sb_playerơ֥1ʬΥ쥳ɤ
     * 
     * @param Integer $showHelpFg
     * @param Integer $showObFg
     * @return Array
     */
    function getPlayerList() {
        $sql = "SELECT * FROM " . $this->tableNamePlayer;
        $sql .= " WHERE team_cd = " . $this->teamCd;

        $sql .= " ORDER BY boss_fg DESC, cap_fg DESC, ob_fg ASC, help_fg ASC, CAST(if(backnum=0,999,backnum) as SIGNED) ASC, player_name ASC";      
        return $this->getList($sql);
    }

    /**
     * sb_playerơ֥1ʬꥳɥꥹȤ
     *
     * @return Array
     */
    function getPlayerCdList() {
        $list = array();
        foreach ($this->getPlayerList() as $player) {
            $list[] = $player["player_cd"];
        }
        return $list;
    }

    /**
     * sb_playerơ֥1쥳ɤꤷƼ
     *
     * @return Array
     */
    function getPlayer() {
        $sql = "SELECT * FROM " . $this->tableNamePlayer . " WHERE player_cd = " . $this->plyerCd;
        $recordList = $this->getList($sql);
        return (!empty($recordList[0])) ? $recordList[0] : array();
    }

    /**
     * sb_playerơ֥˥쥳ɤɲä
     *
     */
    function insert() {
        return parent::insert($this->tableNamePlayer);
    }

    /**
     * sb_playerơ֥Υ쥳ɤ򹹿
     *
     * @return boolean
     */
    function update() {
        return parent::update($this->tableNamePlayer);
    }

    /**
     * sb_playerơ֥Υ쥳ɤ
     *
     * @return boolean
     */
    function delete() {
        return parent::delete($this->tableNamePlayer);
    }

    /**
     * ꥳɤΥå
     *
     * @param Integer $playerCd
     */
    function setPlayerCd($playerCd) {
        $this->plyerCd = addslashes(intval($playerCd));
    }

    /**
     * ॳɤΥå
     *
     * @param Integer $teamCd
     */
    function setTeamCd($teamCd) {
        $this->teamCd = addslashes(intval($teamCd));
    }
    
    /**
     * ÿͥե饰Υå
     *
     * @param Integer $helpFg
     */
    function setHelpFg($helpFg) {
        $this->helpFg = addslashes(intval($helpFg));
    }
    
    /**
     * OBե饰Υå
     *
     * @param Integer $obFg
     */
    function setObFg($obFg) {
        $this->obFg = addslashes(intval($obFg));
    }
}
?>