<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/database/DatabaseScoreBookClass.php";

/**
 * sb_player_result_hitterơ֥륯饹
 *
 * @since 0.0.8
 * @author saitoh-y
 */
class PlayerResultHitter extends DatabaseScoreBook {
    /**
     * ӥ
     *
     * @access private
     * @var Integer
     */
    private $playerResultCd = 0;

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd = 0;

    /**
     * 蹶ե饰
     *
     * @access private
     * @var boolean
     */
    private $topFg = false;

    /**
     * ꥳ
     *
     * @access private
     * @var Integer
     */
    private $playerCd = 0;

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * SELECTꥹ()
     *
     * @access private
     * @var Array
     */
    private $selectList = array();

    /**
     * Ⱦꥹ
     *
     * @access private
     * @var Array
     */
    private $rankSortCond = array();

    /**
     * ǯ
     *
     * @access private
     * @var Integer
     */
    private $year = 0;

    /**
     * ƥꥳ
     *
     * @access private
     * @var Integer
     */
    private $categoryCd = 0;

    /**
     * ǿ
     *
     * @access private
     * @var Integer
     */
    private $baseAtbats = 0;

    /**
     * ߥå
     *
     * @access private
     * @var Integer
     */
    private $limit = 0;

    function PlayerResultHitter() {
        parent::DatabaseScoreBook();
        $this->selectList[] = ", count(*) as game_count";
        $this->selectList[] = ", sum(hitter.atbat) as atbat";
        $this->selectList[] = ", sum(hitter.atbats) as atbats";
        $this->selectList[] = ", sum(hitter.hits) as hits";
        $this->selectList[] = ", sum(hitter.two_base) as two_base";
        $this->selectList[] = ", sum(hitter.three_base) as three_base";
        $this->selectList[] = ", sum(hitter.HR) as HR";
        $this->selectList[] = ", sum(hitter.BB) as BB";
        $this->selectList[] = ", sum(hitter.HBP) as HBP";
        $this->selectList[] = ", sum(hitter.E) as E";
        $this->selectList[] = ", sum(hitter.sacrifice) as sacrifice";
        $this->selectList[] = ", sum(hitter.RBI) as RBI";
        $this->selectList[] = ", sum(hitter.R) as R";
        $this->selectList[] = ", sum(hitter.SB) as SB";
        $this->selectList[] = ", sum(hitter.K) as K";
        $this->selectList[] = ", sum(hitter.self_E) as self_E";
        $this->selectList[] = ", sum(hitter.hits)/sum(hitter.atbats) as AVG";
        $this->selectList[] =
            ", (sum(hitter.hits)+sum(hitter.BB)+sum(hitter.HBP))
            /(sum(hitter.atbats)+sum(hitter.BB)+sum(hitter.HBP)+sum(hitter.sacrifice)) as OBP";
        $this->selectList[] =
            ", ((sum(hitter.hits)-sum(hitter.two_base)-sum(hitter.three_base)-sum(hitter.HR))
                +(sum(hitter.two_base)*2)+(sum(hitter.three_base)*3)+(sum(hitter.HR)*4))
                /sum(hitter.atbats) as SP";
        $this->selectList[] =
            ", (sum(hitter.hits)+sum(hitter.BB)+sum(hitter.HBP))
            /(sum(hitter.atbats)+sum(hitter.BB)+sum(hitter.HBP)+sum(hitter.sacrifice))
            +((sum(hitter.hits)-sum(hitter.two_base)-sum(hitter.three_base)-sum(hitter.HR))
                +(sum(hitter.two_base)*2)+(sum(hitter.three_base)*3)+(sum(hitter.HR)*4))
                /sum(hitter.atbats) as OPS";
    }

    /**
     * sb_player_result_hitterơ֥ƤΥ쥳ɤ
     *
     * @return Array
     */
    function getAllList() {
        $sql = "SELECT * FROM " . $this->tableNamePlayerResultHitter . " ORDER BY player_cd ASC";
        return $this->getList($sql);
    }

    /**
     * sb_player_result_hitterơ֥1ʬΥ쥳ɤ
     *
     * @param boolean $totalfg ̻ե饰
     * @return Array
     */
    function getPlayerResultHitter($totalFg = false) {
        $sql = "SELECT hitter.player_cd";
        if ($totalFg) {
            $sql .= ", '" . _MD_SB_TEXT_TOTAL . "' as year";
        }
        else {
            $sql .= ", LEFT(game.game_date, 4) as year";
        }
        foreach ($this->selectList as $select) {
            $sql .= $select;
        }
        $sql .= " FROM " . $this->tableNamePlayerResultHitter . " as hitter, " . $this->
            tableNameGame . " as game";
        $sql .= " WHERE hitter.player_cd = " . $this->playerCd;
        $sql .= " AND hitter.game_cd = game.game_cd";
        if ($totalFg) {
            $sql .= " GROUP BY hitter.player_cd";
        }
        else {
            $sql .= " GROUP BY LEFT(game.game_date, 4)";
            $sql .= " ORDER BY year ASC";
        }

        return $this->getList($sql);
    }

    /**
     * sb_player_result_hitterơ֥11ʬΥ쥳ɤ
     *
     * @return Array
     */
    function getPlayerResultHitterList() {
        $sql = "SELECT * FROM " . $this->tableNamePlayerResultHitter . " as result,";
        $sql .= $this->tableNamePlayer . " as player";
        $sql .= " WHERE result.player_cd = player.player_cd";
        $sql .= " AND result.game_cd = " . $this->gameCd;
        $sql .= " AND result.top_fg = " . $this->topFg;
        $sql .= " ORDER BY result.batting_order ASC";
        return $this->getList($sql);
    }

    /**
     * sb_player_result_hitterơ֥1ʬΥ쥳ɤ
     *
     * @param boolean $totalfg ̻ե饰
     * @return Array
     */
    function getPlayerResultHitterTeamList($totalfg = false) {
        $sql = "SELECT hitter.player_cd";
        if ($totalfg) {
            $sql .= ", '" . _MD_SB_TEXT_TOTAL . "' as year";
        }
        else {
            $sql .= ", LEFT(game.game_date, 4) as year";
        }
        foreach ($this->selectList as $select) {
            $sql .= $select;
        }
        $sql .= " FROM " . $this->tableNamePlayerResultHitter . " as hitter, " . $this->
            tableNameGame . " as game, " . $this->tableNamePlayer . " as player";
        $sql .= " WHERE hitter.player_cd = player.player_cd";
        $sql .= " AND hitter.game_cd = game.game_cd";
        $sql .= " AND player.team_cd = " . $this->teamCd;
        if ($totalfg) {
            $sql .= " GROUP BY player.team_cd";
        }
        else {
            $sql .= " GROUP BY LEFT(game.game_date, 4)";
            $sql .= " ORDER BY year ASC";
        }
        return $this->getList($sql);
    }

    /**
     * sb_player_result_hitterơ֥뤫ǯӽ˥쥳ɤ
     *
     * @return Array
     */
    function getRankList() {
        /*  */
        $sql = "SELECT hitter.player_cd, player.player_name, team.team_cd, team.team_name, player.help_fg, player.ob_fg";
        foreach ($this->selectList as $select) {
            $sql .= $select;
        }
        $sql .= " FROM " . $this->tableNamePlayerResultHitter . " as hitter, ";
        $sql .= $this->tableNameTeam . " as team, ";
        $sql .= $this->tableNamePlayer . " as player ";
        if (!empty($this->year) || !empty($this->categoryCd)) {
            $sql .= "," . $this->tableNameGame . " as game";
        }
        $sql .= " WHERE hitter.player_cd = player.player_cd";
        $sql .= " AND team.team_cd = player.team_cd";
        if (!empty($this->year) || !empty($this->categoryCd)) {
        	$sql .= " AND hitter.game_cd = game.game_cd";
            if (!empty($this->year)) {
                $sql .= " AND game.game_date BETWEEN CAST('" . $this->year . "-01-01' as DATE)";
                $sql .= " AND CAST('" . $this->year . "-12-31' as DATE)";
            }
            if (!empty($this->categoryCd)) {
                $sql .= " AND game.category_cd = ".$this->categoryCd;
            }
        }
        $sql .= " GROUP BY hitter.player_cd";
        if(in_array($this->rankSortCond['column'],array('AVG', 'OBP', 'SP', 'OPS'))){
        	$sql .= " HAVING sum(hitter.atbat) >=" . $this->baseAtbats;
        }
        $sql .= " ORDER BY " . $this->rankSortCond['column'] . " " . $this->rankSortCond['sort'] .
            ", player.help_fg ASC, player.ob_fg ASC, hitter.atbats DESC";
        if (!empty($this->limit)) {
            $sql .= " LIMIT " . $this->limit;
        }

        return $this->getList($sql);
    }

    /**
     * sb_player_result_hitterơ֥˥쥳ɤɲä
     *
     * @return boolean
     */
    function insert() {
        return parent::insert($this->tableNamePlayerResultHitter);
    }

    /**
     * sb_player_result_hitterơ֥Υ쥳ɤ򹹿
     *
     * @return boolean
     */
    function update() {
        return parent::update($this->tableNamePlayerResultHitter);
    }

    /**
     * sb_player_result_hitterơ֥Υ쥳ɤ蹶ե饰򹹿
     *
     * @param Array $playerCdList ꥳɥꥹ
     * @return boolean
     */
    function updateTopFg($playerCdList) {
        $sql = "UPDATE " . $this->tableNamePlayerResultHitter . " SET top_fg = " . $this->topFg;
        $sql .= " WHERE game_cd = " . $this->gameCd . " AND player_cd in (" . implode(",",
            $playerCdList) . ")";
        return $this->execute($sql);
    }

    /**
     * sb_player_result_hitterơ֥뤫쥳ɤ
     *
     * @return boolean
     */
    function delete() {
        return parent::delete($this->tableNamePlayerResultHitter);
    }

    /**
     * ӥɤΥå
     *
     * @param Integer $playerResultCd
     */
    function setPlayerResultCd($playerResultCd) {
        $this->playerResultCd = addslashes(intval($playerResultCd));
    }

    /**
     * 祳ɤΥå
     *
     * @param Integer $gameCd
     */
    function setGameCd($gameCd) {
        $this->gameCd = addslashes(intval($gameCd));
    }

    /**
     * 蹶ե饰Υå
     *
     * @param Integer $topFg
     */
    function setTopFg($topFg) {
        $this->topFg = addslashes(intval($topFg));
    }

    /**
     * ꥳɤΥå
     *
     * @param Integer $playerCd
     */
    function setPlayerCd($playerCd) {
        $this->playerCd = addslashes(intval($playerCd));
    }

    /**
     * ॳɤΥå
     *
     * @param Integer $teamCd
     */
    function setTeamCd($teamCd) {
        $this->teamCd = addslashes(intval($teamCd));
    }

    /**
     * ǯ٤Υå
     *
     * @param Integer $year
     */
    function setYear($year) {
        $this->year = addslashes(intval($year));
    }

    /**
     * ƥꥳɤΥå
     *
     * @param Integer $categoryCd
     */
    function setCategoryCd($categoryCd) {
        $this->categoryCd = addslashes(intval($categoryCd));
    }
    
    /**
     * ǿΥå
     *
     * @param Integer $atbats
     */
    function setBaseAtbats($atbats) {
        $this->baseAtbats = addslashes(floatval($atbats));
    }

    /**
     * ߥåȤΥå
     *
     * @param Integer $limit
     */
    function setLimit($limit) {
        $this->limit = addslashes(intval($limit));
    }

    /**
     * 󥯥ȾΥå
     *
     * @param String $column Ⱦˤ륫̾
     * @param String $sort /߽
     */
    function setRankSortCond($column, $sort) {
        $this->rankSortCond = array('column' => addslashes($column), 'sort' => addslashes($sort));
    }
}
?>