/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.internal.Segment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0000\b \u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\u00020\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0004\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0004\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ#\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\u00028\u00008D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0017\u001a\u00028\u00008D@\u0004X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lkotlinx/coroutines/internal/SegmentQueue;", "Lkotlinx/coroutines/internal/Segment;", "S", "<init>", "()V", "startFrom", "", "id", "getSegment", "(Lkotlinx/coroutines/internal/Segment;J)Lkotlinx/coroutines/internal/Segment;", "getSegmentAndMoveHead", "new", "", "moveHeadForward", "(Lkotlinx/coroutines/internal/Segment;)V", "moveTailForward", "prev", "newSegment", "(JLkotlinx/coroutines/internal/Segment;)Lkotlinx/coroutines/internal/Segment;", "getHead", "()Lkotlinx/coroutines/internal/Segment;", "head", "getTail", "tail", "kotlinx-coroutines-core", ""})
public abstract class SegmentQueue<S extends Segment<S>> {
    private volatile Object _head;
    private static final AtomicReferenceFieldUpdater _head$FU = AtomicReferenceFieldUpdater.newUpdater(SegmentQueue.class, Object.class, "_head");
    private volatile Object _tail;
    private static final AtomicReferenceFieldUpdater _tail$FU = AtomicReferenceFieldUpdater.newUpdater(SegmentQueue.class, Object.class, "_tail");

    @NotNull
    protected final S getHead() {
        return (S)((Segment)this._head);
    }

    @NotNull
    protected final S getTail() {
        return (S)((Segment)this._tail);
    }

    @NotNull
    public abstract S newSegment(long var1, @Nullable S var3);

    public static /* synthetic */ Segment newSegment$default(SegmentQueue segmentQueue, long l, Segment segment, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newSegment");
        }
        if ((n & 2) != 0) {
            segment = null;
        }
        return segmentQueue.newSegment(l, segment);
    }

    @Nullable
    protected final S getSegment(@NotNull S startFrom, long id) {
        Intrinsics.checkParameterIsNotNull(startFrom, (String)"startFrom");
        S cur = startFrom;
        while (((Segment)cur).getId() < id) {
            Object curNext = ((Segment)cur).getNext();
            if (curNext == null) {
                Object s;
                S newTail = this.newSegment(((Segment)cur).getId() + 1L, cur);
                if (((Segment)cur).casNext(null, newTail)) {
                    if (((Segment)cur).getRemoved()) {
                        ((Segment)cur).remove();
                    }
                    this.moveTailForward(newTail);
                    s = newTail;
                } else {
                    s = ((Segment)cur).getNext();
                    if (s == null) {
                        Intrinsics.throwNpe();
                    }
                }
                curNext = s;
            }
            cur = curNext;
        }
        if (((Segment)cur).getId() != id) {
            return null;
        }
        return cur;
    }

    @Nullable
    protected final S getSegmentAndMoveHead(@NotNull S startFrom, long id) {
        Intrinsics.checkParameterIsNotNull(startFrom, (String)"startFrom");
        if (((Segment)startFrom).getId() == id) {
            return startFrom;
        }
        S s = this.getSegment(startFrom, id);
        if (s == null) {
            return null;
        }
        S s2 = s;
        this.moveHeadForward(s2);
        return s2;
    }

    private final void moveHeadForward(S s) {
        Segment curHead;
        SegmentQueue $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            curHead = (Segment)$this$loop$iv._head;
            boolean bl = false;
            if (curHead.getId() <= ((Segment)s).getId()) continue;
            return;
        } while (!_head$FU.compareAndSet(this, curHead, s));
        ((Segment)s).prev = null;
    }

    private final void moveTailForward(S s) {
        Segment curTail;
        SegmentQueue $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            curTail = (Segment)$this$loop$iv._tail;
            boolean bl = false;
            if (curTail.getId() <= ((Segment)s).getId()) continue;
            return;
        } while (!_tail$FU.compareAndSet(this, curTail, s));
    }

    public SegmentQueue() {
        Segment initialSegment = SegmentQueue.newSegment$default(this, 0L, null, 2, null);
        this._head = initialSegment;
        this._tail = initialSegment;
    }
}

