--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)

procedure drawroom(
	numport: integer; -- 0, 1, 2
	insideportal: boolean := false;
	avx,avy,avz,angl : float
) is

	dxp,dzp : float := 0.0;
	isel : glint := 0;

	ballsec: float;
	ibsec,ii,kk: integer;
	nslic: constant integer := 1000; --partitions per direction
	xfb1 : constant float := -xmax+fballrad;       -- one end
	xfb2 : constant float := +xmax-fballrad;       -- other end
	xxfb,yyfb,zzfb : float;

	et, extension: float;



procedure getFireBallPos(xxx,yyy,zzz: out float) is
begin
----------------------------------------------------------------------
			ballsec := 0.06*float(sdl_getticks);
			ibsec := integer( ballsec );
			kk:= ibsec/nslic;
			ii:= 1 + ibsec mod nslic; -- 1..nslic = 1..1000
			if (kk mod 2 = 1) then
				null;
			else
				ii:= 1 + nslic - ii; -- 1001-i = 1..1000
			end if;
			xxx := xfb1 + float(ii-1)/float(nslic) * (xfb2-xfb1);
			yyy:= -ymax+fballrad;
			zzz:= 2.0;
-----------------------------------------------------------------------
end getFireBallPos;




begin


	-- 5pgs to end if:
	if level<5 then  -- in-a-dungeon with many textured objects in common


		if thirdPerson then
			drawAvatar(currenttime, avx,avy,avz,angl);
		end if;



		if not insideportal then -- ZPMs mostly invisible if insideportal

			--draw barrels
			glUseProgram(nontexshadid);

			for i in 1..nbarrels loop

				bmvp := mvp;

				if rolling(i) then
					barreltime := float(sdl_getticks)/1000.0;
					tt := float( barreltime - timeofroll ) / secperroll;
					barangle := onepi*tt*rad2deg;

					if( tt<1.0 ) then
						posbar(i)(1):=olbarrl(1)+tt*(nubarrl(1)-olbarrl(1));
						posbar(i)(2):=olbarrl(2)+tt*(nubarrl(2)-olbarrl(2));
						posbar(i)(3):=olbarrl(3)+tt*(nubarrl(3)-olbarrl(3));

						if    (rolldir=-1) then axis:=xaxis; barangle:=-barangle;
						elsif (rolldir=+1) then axis:=xaxis;
						elsif (rolldir=+3) then axis:=zaxis; barangle:=-barangle;
						elsif (rolldir=-3) then axis:=zaxis;
						end if;

						cyl2obj.updcyl2(barrel(i), 
							posbar(i)(1),posbar(i)(2),posbar(i)(3));

						bmm:=identity;
						translate(bmm, -posbar(i)(1), -posbar(i)(2), -posbar(i)(3) );
						degRotate(bmm, barangle, axis(1), axis(2), axis(3) );
						translate(bmm, posbar(i)(1), posbar(i)(2), posbar(i)(3) );

						bmvp := bmm;
						matXmat( bmvp, viewMatrix );
						matXmat( bmvp, projMatrix );

					else
						rolling(i):=false;
						posbar(i):=nubarrl;

						cyl2obj.updcyl2(barrel(i), 
							posbar(i)(1),posbar(i)(2),posbar(i)(3));

					end if; -- tt

				end if; -- rolling

				-- we have to register bmvp for each i AFTER it is redefined:
				gluniformmatrix4fv( ntmatrixid, 1, gl_false, bmvp(1,1)'address );
				cyl2obj.draw(barrel(i),vertbuff,rgbbuff,elembuff, seated(i)); -- 2jul15

			end loop;

		end if; -- not insideportal



	-- begin draw common textured objects-----------------------------------------


		glUseProgram( pgmtexshadid ); --==========================================

		glUniform1i(unifside, glint(numport) );

		if thirdPerson then
			glUniform3f(unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
		else
			glUniform3f(unifme, glfloat(xme),glfloat(yme),glfloat(zme));
		end if;

		--new portal-hole setup: puts hole in roomwall about size of portal,
		--however, "holes" are actually prolate spheroids of transparency;
		--Be careful of size because we risk erasing any nearby objects in 3D

		glUniform3f(unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
		--center p1 (left)

		glUniform3f(unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 
		--center p2 (right)


		if 
			(
				worm_active
				or (lshooting and rport_defined)
				or (rshooting and lport_defined)
			)
		then
			glUniform1f(unifprad, glfloat(0.80) ); --radius (show holes, danger)

			if rport_defined and lport_defined then
				glUniform1i(unifisel, 3 ); -- 0=>none, 3=>both, 1=>1, 2=>2
			elsif rport_defined then
				glUniform1i(unifisel, 2 ); -- 0=>none, 3=>both, 1=>1, 2=>2
			elsif lport_defined then
				glUniform1i(unifisel, 1 ); -- 0=>none, 3=>both, 1=>1, 2=>2
			end if;

		else
			glUniform1f(unifprad, glfloat(0.0) ); --radius (hide holes, no danger)
			glUniform1i(unifisel, 0 ); -- 0=>none, 3=>both, 1=>1, 2=>2
		end if;



		gluniformmatrix4fv( mvid, 1, gl_false, viewMatrix(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, mvp(1,1)'address );
		gluniform1i(uniftex,0);

		-- we now set fog level, color:
		if level=1 then -- adobe
			gluniform1i(uniflev, 1 );
			gluniform1i(unifclr, 1 );
		elsif level=2 then -- wood
			gluniform1i(uniflev, 1 );
			gluniform1i(unifclr, 1 );
		elsif level=3 then -- brick
			gluniform1i(uniflev, 3 );
			gluniform1i(unifclr, 2 );
		elsif level=4 then -- granite
			gluniform1i(uniflev, 1 );
			gluniform1i(unifclr, 3 );
		end if;

		gluniform1i(unifopac, 1); -- 1=>normal opacity

		glbindtexture(gl_texture_2d, room_texid);





		if level=3 then
			gluniform1i(uniflag, 1); -- 1=> lightingEffects;  0=> normal

			if thirdPerson then
				glUniform3f(unifeye, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(unifeye, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;


			--2 light sources within lava pool (?pcen=poolcenter)
			gluniform3f(unifpos1,glfloat(xpcen-xprad/6.0),glfloat(waterlevel+1.1),glfloat(zpcen) );
			gluniform3f(unifpos2,glfloat(xpcen+xprad/6.0),glfloat(waterlevel+1.1),glfloat(zpcen) );

			getFireBallPos(xxfb,yyfb,zzfb);

			--1 light source @ fireball center:
			gluniform3f(unifpos3,glfloat(xxfb),glfloat(yyfb),glfloat(zzfb) );

			-- color of light
			gluniform3f( unifpcol, 254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange


			mroomobj.ldraw(rmo,vertbuff,uvbuff,normbuff,elembuff); 
			--textured room with floor-gap AND LightEffects

		else -- level 1,2,4
			gluniform1i(uniflag, 0); -- 1=> lightingEffects;  0=> normal
			mroomobj.draw(rmo,vertbuff,uvbuff,elembuff); --textured room with floor-gap
		end if;

		glUniform1f(unifprad, glfloat(0.0) ); --radius (disable further holes)
		glUniform1i(unifisel, 0 ); -- 0=>none, 3=>both, 1=>1, 2=>2



		if not insideportal then -- typically invisible if insideportal

			if portalEnabled then
				glbindtexture(gl_texture_2d, barloc1_texid);
			else
				glbindtexture(gl_texture_2d, barloc0_texid);
			end if;

			if level=3 then
			gluniform1i(uniflag, 0 ); -- do NOT apply lighting to receptacles
			end if;
			-- draw receptacles (using pgmtexshadid)
			for row in 1..nrows loop
				for col in 1..ncols loop
					if( rcpt(row,col) = true ) then
						pictobj.draw( sokrcpt(row,col), vertbuff, uvbuff, elembuff );
						-- note:  these are out of range of lighting effects in level 3
					end if;
				end loop;
			end loop;
			if level=3 then
			gluniform1i(uniflag, 1 ); -- restore lighting
			end if;

		end if; -- not insideportal




		if level=2 then
			glbindtexture(gl_texture_2d, grunge_texid);
			pictobj.draw(bloc2, vertbuff,uvbuff,elembuff); --block wall divider

			glbindtexture(gl_texture_2d, wood2_texid);
			cylobj.draw(cyl,vertbuff,uvbuff,elembuff); 
			-- new edge of ceiling (normal shader needed)


		elsif level=3 then
			glbindtexture(gl_texture_2d, woodw_texid);
			pictobj.ldraw(bloc2, vertbuff,uvbuff,normbuff,elembuff); --block wall divider
		elsif level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); --  lev1, dark adobe wall
			rectobj.draw(bloc, vertbuff,uvbuff,elembuff); --block wall divider
		elsif level=4 then
			glbindtexture(gl_texture_2d, bricksw_texid); -- for lev 4
			rectobj.draw(bloc, vertbuff,uvbuff,elembuff); --block wall divider
		end if;

		if level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); -- dark adobe for ledge
		else
			glbindtexture(gl_texture_2d, woodw_texid);
		end if;
		if level=3 then
			rectobj.ldraw(ledge,  vertbuff,uvbuff,normbuff,elembuff); -- high ledge platform
		else
			rectobj.draw(ledge,  vertbuff,uvbuff,elembuff); -- high ledge platform
		end if;

		-- level#3: ceil matches walls;   4: special fragshader
		if level=1 then 
			glbindtexture(gl_texture_2d, ceil_texid);
			rectobj.draw(ceil1,  vertbuff,uvbuff,elembuff); -- ceiling
		elsif level=2 then
			glbindtexture(gl_texture_2d, grunge_texid); -- best 4 reflective water
			pictobj.draw(ceil2,  vertbuff,uvbuff,elembuff); -- ceiling
		end if;


		if (level=1) or (level=4) then
			glbindtexture(gl_texture_2d, pic_texid);
			pictobj.draw(pic,  vertbuff,uvbuff,elembuff); -- wall picture
		end if;


		-- Brick Lining of Pool
		glbindtexture(gl_texture_2d, lining_texid);

		if level=3 then
			rectobj.ldraw(pxp, vertbuff,uvbuff,normbuff,elembuff); --@+X
			rectobj.ldraw(pxm, vertbuff,uvbuff,normbuff,elembuff); --@-X
			rectobj.ldraw(pzp, vertbuff,uvbuff,normbuff,elembuff); --@+Z
			rectobj.ldraw(pzm, vertbuff,uvbuff,normbuff,elembuff); --@-Z
			rectobj.ldraw(pym, vertbuff,uvbuff,normbuff,elembuff); --@bottom
		else
			rectobj.draw(pxp, vertbuff,uvbuff,elembuff); --@+X
			rectobj.draw(pxm, vertbuff,uvbuff,elembuff); --@-X
			rectobj.draw(pzp, vertbuff,uvbuff,elembuff); --@+Z
			rectobj.draw(pzm, vertbuff,uvbuff,elembuff); --@-Z
			rectobj.draw(pym, vertbuff,uvbuff,elembuff); --@bottom
		end if;






		--draw portals
		if lport_located and lport_stable and lport_defined then
			glbindtexture(gl_texture_2d, offportg_texid);
			pict1obj.draw(lportal, vertbuff,uvbuff,elembuff);
		end if;
		if rport_located and rport_stable and rport_defined then
			glbindtexture(gl_texture_2d, offportr_texid);
			pict1obj.draw(rportal, vertbuff,uvbuff,elembuff);
		end if;




		-- draw sokoban walls here
		if level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); --dark adobe
		elsif level=2 then
			glbindtexture(gl_texture_2d, woodt_texid);
		elsif level=3 then
			glbindtexture(gl_texture_2d, brick_texid);
		else
			glbindtexture(gl_texture_2d, granite_texid);
		end if;

		-- draw walls made up of short cubes (still using pgmtexshadid)
		for row in 1..nrows loop
			for col in 1..ncols loop
				-- if post exists here, draw short cube
				if( wall(row,col) = true ) then
					if level=3 then
						--rectobj.ldraw( sokwall(row,col), vertbuff, uvbuff, normbuff, elembuff );
						rectobj.draw( sokwall(row,col), vertbuff, uvbuff, elembuff );
					else
						rectobj.draw( sokwall(row,col), vertbuff, uvbuff, elembuff );
					end if;
				end if;
			end loop;
		end loop;



		-- Window or wall picture frame
		glbindtexture(gl_texture_2d, grunge_texid);
		frameobj.ldraw(nfox,vertbuff,uvbuff,normbuff,elembuff);
		frameobj.ldraw(sfox,vertbuff,uvbuff,normbuff,elembuff);
		-- in case of problem, use ldraw only in level 3





--NOTE:  still using pgmtexshadid to draw




		if not xit or showskulls then --skull descending
			glbindtexture(gl_texture_2d, xbox1_texid);
			twictobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box
		else -- door ascending
			glbindtexture(gl_texture_2d, xbox2_texid);
			twictobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box

			if not exitwait then
				et:=currenttime-exittime-8.0-halfpi; 
				-- -pi/2 @ wormhole activation

				extension:=1.0+fmath.sin(et); -- 0..2..0
				if et>twopi-halfpi then
					extension:=0.0;
				end if;
				xckwh:=glfloat(xboxpos(1));
				yckwh:=glfloat(xboxpos(2));
				zckwh:=glfloat(xboxpos(3));
				xrkwh:=0.7;
				yrkwh:=0.7;
				zrkwh:=0.7;
				if level=4 then
					zrkwh:=0.02+glfloat( extension )*0.7;
				else
					xrkwh:=0.02+glfloat( extension )*0.7;
				end if;

				--CAUTION...this MUST be last since it changes drawing program
				drawKawhoosh(
					xckwh,yckwh,zckwh,
					xrkwh,yrkwh,zrkwh,
					glint(level),
					mvp);
			end if;

		end if;







	end if; -- in-a-dungeon (level < 5) (5pgs up)


---------- end draw textured objects common to all levels ---------------




	--draw pools and other objects that use special shaders (from glsl sandbox)

--########################################################################
		if (level=1) then

---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID); --=================================

		--portal-exterior discard:
			glUniform1i(funifside, glint(numport) );

			if thirdPerson then
				glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;



			glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			gluniform1i(fishunifrot,1); -- 1=>CW,  -1=>CCW (28jan17)
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------


			-- fancy frag shader draws normal water in level 1
			glUseProgram( poolshadid ); --===================================

			glUniform1i(bunifside, glint(numport) );


			if thirdPerson then
				glUniform3f(bunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(bunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(bunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(bunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 



			gluniformmatrix4fv( poolmvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniformmatrix4fv( poolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(timeid, glfloat(currentTime) );
			gluniform3f(pcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(pradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(wlevid, glfloat(waterlevel) );
			rectsurf.draw(rso,vertbuff);



			--PalmTreeWindmill
			glUseProgram( x1picshadid ); --=====================================

			glUniform1i(x1unifside, glint(numport) );

			if thirdPerson then
				glUniform3f(x1unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x1unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x1unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x1unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( x1picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x1pictimeid, glfloat(currentTime) );
			gluniform2f(x1piccenid, glfloat(x1picx), glfloat(x1picy) );
			gluniform2f(x1picradid, glfloat(x1picw/2.0), glfloat(x1pich/2.0) );
			gluniform2f(x1picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);


--########################################################################
		elsif (level=2) then -- reflective water



---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID); --=================================

		--portal-exterior discard:
			glUniform1i(funifside, glint(numport) );


			if thirdPerson then
				glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			gluniform1i(fishunifrot,1); -- 1=>CW,  -1=>CCW (28jan17)
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------








			glUseProgram( rpoolshadid ); --=================================

			glUniform1i(runifside, glint(numport) );

			if thirdPerson then
				glUniform3f(runifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
				gluniform3f(rpeyeid, glfloat(xcam), glfloat(ycam), glfloat(zcam) );
			else
				glUniform3f(runifme, glfloat(xme),glfloat(yme),glfloat(zme));
				gluniform3f(rpeyeid, glfloat(xme), glfloat(yme), glfloat(zme) );
			end if;

			glUniform3f(runifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(runifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			-- define cubemapped textures to reflect:
			glenable(gl_texture_cube_map_seamless);
			glbindtexture(gl_texture_cube_map, cubemap_texid);
			-- note:  this is essentially a "cheat".  I really want
			--        to use the actual environment!
			gluniform1i(envmapid, 0); -- "envMap" in .fs
			gluniformmatrix4fv( rpoolmvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniformmatrix4fv( rpoolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(rtimeid, glfloat(currentTime) );

			gluniform3f(rpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(rpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(rwlevid, glfloat(waterlevel) );

			reflsurf.draw(rfo,vertbuff);





			--WaterWorld
			glUseProgram( x2picshadid ); --===================================

			glUniform1i(x2unifside, glint(numport) );


			if thirdPerson then
				glUniform3f(x2unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x2unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x2unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x2unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( x2picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x2pictimeid, glfloat(currentTime) );
			gluniform2f(x2piccenid, glfloat(x2picx), glfloat(x2picy) );
			gluniform2f(x2picradid, glfloat(x2picwb/2.0), glfloat(x2pichb/2.0) );
			gluniform2f(x2picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);

			--MountainScape
			glUseProgram( x2pic2shadid ); --====================================

			glUniform1i(x22unifside, glint(numport) ); 

			if thirdPerson then
				glUniform3f(x22unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x22unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x22unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x22unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( x2pic2matid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x2pic2timeid, glfloat(currentTime) );
			gluniform2f(x2pic2cenid, glfloat(x2picx), glfloat(x2picy) );
			gluniform2f(x2pic2radid, glfloat(x2picws/2.0), glfloat(x2pichs/2.0) );
			gluniform2f(x2pic2resid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox2,vertbuff,elembuff);


			-- fancy fragshader draws star ceiling
			glUseProgram( star2shadid ); --========================================
			gluniformmatrix4fv( star2matid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(star2timeid, glfloat(currentTime) );
			gluniform2f(star2resid, glfloat(winwidth), glfloat(winheight) );

			--window-discard:
			glUniform1i(sunifside, glint(numport) );
			if thirdPerson then
				glUniform3f(sunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(sunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;
			glUniform3f(sunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(sunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			rectxobj.draw(rox,vertbuff,elembuff);





--########################################################################
		elsif (level=3) then  -- volcano

----------- fireball begin --------------------------------------------

			glUseProgram(fireTexShadID); --====================================
			glUniform1i(funiftex, 0);
			glUniform1f(fopacid, 0.9);

			glUniform1f(fbrad, glfloat(fballrad));

			--window-discard:
			glUniform1i(fbunifside, glint(numport) );

			if thirdPerson then
				glUniform3f(fbunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(fbunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(fbunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(fbunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			glBindTexture(GL_TEXTURE_2D, ball_texid);


-- define trajectory of fireball before the following code to move it
-- want circum = 1.0 = 2piR => R=1/twopi
-- Appx:  z=2,  y=rad,   x in (-8..+8),  @ 2 unit per second => 8 sec per dir
-- make 200 time slices, 100 each way
--

			-- begin fireball roll ------------------------------------------------------------
			BMVP := MVP;

-----------------------------------------------------------------------
			--getFireBallPos(xxfb,yyfb,zzfb);
-----------------------------------------------------------------------

			axis:=zaxis;

			bmm:=identity;
			translate(bmm, -xxfb,-yyfb,-zzfb ); --Xlate to origin
			barangle := -twopi*xxfb/(twopi*fballrad) *rad2deg;
			degRotate(bmm, barangle, axis(1), axis(2), axis(3) ); --rotate
			translate(bmm, xxfb,yyfb,zzfb ); --Xlate back
			bmvp := bmm;
			matXmat( bmvp, viewMatrix );
			matXmat( bmvp, projMatrix );


			-- we have to register bmvp AFTER it is redefined:
			gluniformmatrix4fv( fmatrixid, 1, gl_false, BMVP(1,1)'address );

			glUniform3f(firecenid,  --send current centroid to shaders
				glfloat(xxfb),glfloat(yyfb),glfloat(zzfb) );

			glUniform1f(ftimeid, glfloat(currenttime));

			fireballobj.draw(fireball,vertbuff,elembuff);

			if sqrt( sqr(xxfb-xme)+sqr(yyfb-yme)+sqr(zzfb-zme) ) < fballrad+margin then
				fireballdead:=true;
			end if;

			-- end fireball roll ------------------------------------------------------------






------------------ turtle begin ---------------------------------------

			glUseProgram( tpgmtexshadid ); --======================================

			--portal-exterior-discard uniforms
			glUniform1i(tunifside, glint(numport));


			if thirdPerson then
				glUniform3f(tunifeye, glfloat(xcam),glfloat(ycam),glfloat(zcam));
				glUniform3f(tunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(tunifeye, glfloat(xme),glfloat(yme),glfloat(zme));
				glUniform3f(tunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(tunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(tunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv( tmvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniformmatrix4fv( tmatrixid, 1, gl_false, mvp(1,1)'address );
			gluniform1i(tuniftex,0);

			-- Fog flag
			--gluniform1i(tuniflev, glint(level-1) );
			gluniform1i(tuniflev, 2 );
			gluniform1i(tunifclr, 2 );

			-- Lighting Effects uniforms:

			gluniform1i(tuniflag, 1); -- 1=> lightingEffects;  0=> none


			-- color
			gluniform3f( tunifpcol, 254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange


			--NOTE:  for turtle, we need top of shell well lit from 3 fixed light positions
			-- because we are neglecting the changing ModelMatrix for the turtle as she moves!
			-- Anyway, the ambient is accentuated for looks.
			gluniform3f(tunifpos1,glfloat(xpcen-xprad/2.0),glfloat(2.0),glfloat(zpcen-zprad/2.0) );
			gluniform3f(tunifpos2,glfloat(xpcen+xprad/2.0),glfloat(2.0),glfloat(zpcen+zprad/2.0) );
			gluniform3f(tunifpos3,glfloat(xpcen          ),glfloat(2.0),glfloat(zpcen) );
			--1 light source @ fireball center:
			--gluniform3f(tunifpos3,glfloat(xxfb),glfloat(yyfb),glfloat(zzfb) );

			-- color of light
			gluniform3f( tunifpcol, 254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange




			-- ferry-capable lava turtle
			if not insidePortal then
				updateFerryPos(currentTime,
					xtur,ytur,ztur,angltur, xturh,yturh,zturh,anglturh );
			end if;


			-- body positioning, orientation via uniforms (turtle.vs)
			gluniform3f( tfcenid, glfloat(xtur), glfloat(ytur), glfloat(ztur) );
			glUniform1f( tfangid, glfloat(angltur) );


			glbindtexture(gl_texture_2d, turtle_texid);
			turtleobj.ldraw(turtle,vertbuff,uvbuff,normbuff,elembuff);

			-- head positioning, orientation via uniforms 
			gluniform3f( tfcenid, glfloat(xturh), glfloat(yturh), glfloat(zturh) );
			glUniform1f( tfangid, glfloat(anglturh) );

			glbindtexture(gl_texture_2d, turhead_texid);
			turtleobj.ldraw(turhead,vertbuff,uvbuff,normbuff,elembuff);


------------------ turtle end ---------------------------------------






			-- fancy fragshader draws lava in level 3
			glUseProgram( lpoolshadid ); --=====================================

--need this only with DIY lava pool:
--glbindtexture(gl_texture_2d, lava_texid); -- 16jan17


			glUniform1i(lunifside, glint(numport) );

			if thirdPerson then
				glUniform3f(lunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(lunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(lunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(lunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( lpoolmvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniformmatrix4fv( lpoolmatid, 1, gl_false, mvp(1,1)'address );

			gluniform2f(lresid, glfloat(winwidth), glfloat(winheight) );
			gluniform1f(ltimeid, glfloat(currentTime) );

			gluniform3f(lpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(lpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(lwlevid, glfloat(waterlevel) );

			lavasurf.draw(fso,vertbuff);



			--DaliClock
			glUseProgram( x3picshadid ); --=======================================

			glUniform1i(x3unifside, glint(numport) );

			if thirdPerson then
				glUniform3f(x3unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x3unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x3unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			--center p1 (left)

			glUniform3f(x3unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 
			--center p2 (right)


			gluniformmatrix4fv( x3picmatid, 1, gl_false, mvp(1,1)'address );
			gluniformmatrix4fv( x3picmvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniform1f(x3pictimeid, glfloat(-currentTime) );
			gluniform2f(x3piccenid, glfloat(x3picx), glfloat(x3picy) );
			gluniform2f(x3picradid, glfloat(x3picws/2.0), glfloat(x3pichs/2.0) );
			gluniform2f(x3picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);



			--redPlanet
			glUseProgram( x3pic2shadid ); --=====================================

			glUniform1i(x32unifside, glint(numport) );

			if thirdPerson then
				glUniform3f(x32unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x32unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x32unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x32unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv( x3pic2matid, 1, gl_false, mvp(1,1)'address );
			gluniformmatrix4fv( x3pic2mvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniform1f(x3pic2timeid, glfloat(currentTime) );
			gluniform2f(x3pic2cenid, glfloat(x3picx), glfloat(x3picy) );
			gluniform2f(x3pic2radid, glfloat(x3picwb/2.0), glfloat(x3pichb/2.0) );
			gluniform2f(x3pic2resid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox2,vertbuff,elembuff);






--########################################################################
		elsif (level=4) then



---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID); --===================================

		--portal-exterior discard:
			glUniform1i(funifside, glint(numport) );

			if thirdPerson then
				glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			gluniform1i(fishunifrot,1); -- 1=>CW,  -1=>CCW (28jan17)
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------





			-- fancy fragshader draws dark green water in level 4
			glUseProgram( dpoolshadid ); --=================================

			glUniform1i(dunifside, glint(numport) );

			if thirdPerson then
				glUniform3f(dunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(dunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(dunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(dunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( dpoolmvid, 1, gl_false, viewMatrix(1,1)'address );
			gluniformmatrix4fv( dpoolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(dtimeid, glfloat(currentTime) );
			gluniform3f(dpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(dpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(dwlevid, glfloat(waterlevel) );
			rectsurf.draw(rso,vertbuff);

			-- fancy fragshader draws star ceiling
			glUseProgram( starshadid ); --=======================================
			gluniformmatrix4fv( starmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(startimeid, glfloat(currentTime) );
			gluniform2f(starresid, glfloat(winwidth), glfloat(winheight) );

			-- window-discard:
			glUniform1i(stunifside, glint(numport) );
			if thirdPerson then
				glUniform3f(stunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(stunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;
			glUniform3f(stunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(stunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			rectxobj.draw(rox,vertbuff,elembuff);


			--blueSpiralGalaxy
			glUseProgram( x4picshadid ); --===================================

			glUniform1i(x4unifside, glint(numport) );


			if thirdPerson then
				glUniform3f(x4unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x4unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x4unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x4unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv( x4picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x4pictimeid, glfloat(currentTime) );
			gluniform2f(x4piccenid, glfloat(x4picx), glfloat(x4picy) );
			gluniform2f(x4picradid, glfloat(x4picw/2.0), glfloat(x4pich/2.0) );
			gluniform2f(x4picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);


--########################################################################
		elsif (level=5) then


			-- draw cube-mapped skybox:
			gluseprogram(pidskyb); --======================================
			glenable(gl_texture_cube_map_seamless);
			glbindtexture(gl_texture_cube_map, circubemap_texid);
			gluniform1i(sbmapuid,0);
			gluniformmatrix4fv(sbmvpuid,1,gl_false,mvp(1,1)'address);
			usboxobj.draw(usb5,vertbuff,elembuff);



			-- draw skybox reflections in water:
			gluseprogram(pidskyw); --=======================================
			gluniform1i(cemuid,0);
			gluniformmatrix4fv(cmvpuid,1,gl_false,mvp(1,1)'address);
			gluniform1f(ctimeid, glfloat(currenttime));
			gluniform3f(cpeyeid, 0.0, 0.0, 0.0 );
			gluniform1f(cwlevid, -0.12);
			circsurf.draw(cir, vertbuff); -- using n=200

			solved(5):=true;

		end if;



end drawroom;







