
separate (gameutils)

-- island prologue
--
-- involves a large cubemapped ocean-setting skybox
-- with round body of water and a annular island of sand at center
-- Walking about is done by keeping the eye @ (0,0,0) and moving
-- the sandy island in the opposite direction.  This is done
-- to preserve the proper skybox perspective.  Thus, within
-- this skybox, we maintain 2 distinct view matrices:
-- mviewMatrix [& mmvp] with eyepos @ (0,0,0)
-- iviewMatrix [& imvp] with eyepos @ island-virtual-position
--
function island_ftn( dbkgd: integer:= 0; dbug: boolean := false ) return integer is

	bkg : integer := 0;
	foglev : glint := 0;
	fogclr : glint := 1;

	use gl;
	use matutils;
	use type interfaces.c.c_float;

	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl.binding;
	use gl.pointers;






-- We have to draw trees/bamboo in order from far to near
procedure wsort( 
	f2n: in out wsortarray; 
	nx,px,nz,pz : wlimarray;  
	eyex,eyez : float;  
	avgdist: out float ) is

	n, isave : integer;
	fn, ni,pi,di, nj,pj,dj : float;
begin
	n:=nwrng'last; --nptex
	fn := float(n);

	for i in nwrng loop
		f2n(i):=i; -- initialize permutation
	end loop;
	avgdist:=0.0;

	for i in reverse nwrng loop
		ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
		pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
		di := min( ni, pi );
		avgdist := avgdist + fmath.sqrt(di)/fn;

		for j in 1..i loop

			ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
			pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
			di := min( ni, pi );

			nj := sqr( nx( f2n(j) ) - eyex ) + sqr( nz( f2n(j) ) - eyez );
			pj := sqr( px( f2n(j) ) - eyex ) + sqr( pz( f2n(j) ) - eyez );
			dj := min( nj, pj );

			if( di > dj ) then -- swap i,j
				isave:=f2n(i);
				f2n(i):=f2n(j);
				f2n(j):=isave;
			end if;

		end loop; -- for j

	end loop; -- for i

end wsort;









-- We have to draw trees/bamboo in order from far to near
procedure sort( 
	f2n: in out psortarray; 
	nx,px,nz,pz : plimarray;  
	eyex,eyez : float;  
	avgdist: out float ) is

	n, isave : integer;
	fn, ni,pi,di, nj,pj,dj : float;
begin
	n:=nprng'last; --nptex
	fn := float(n);

	for i in nprng loop
		f2n(i):=i; -- initialize permutation
	end loop;
	avgdist:=0.0;

	for i in reverse nprng loop
		ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
		pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
		di := min( ni, pi );
		avgdist := avgdist + fmath.sqrt(di)/fn;

		for j in 1..i loop

			ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
			pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
			di := min( ni, pi );

			nj := sqr( nx( f2n(j) ) - eyex ) + sqr( nz( f2n(j) ) - eyez );
			pj := sqr( px( f2n(j) ) - eyex ) + sqr( pz( f2n(j) ) - eyez );
			dj := min( nj, pj );

			if( di > dj ) then -- swap i,j
				isave:=f2n(i);
				f2n(i):=f2n(j);
				f2n(j):=isave;
			end if;

		end loop; -- for j

	end loop; -- for i

end sort;




-- keeping it simple...
-- limited only by how far we allow going into ocean:
procedure myst_movebackward( currenttime: float ) is
	dt : float := currenttime-boldtime;
	lagfac : constant float := 1.0;
	nuy, oy, dx,dy,dz, dist2 : float;
	--kxl,kxh,kzl,kzh,okxl,okxh,okzl,okzh : float;
	kxc,kzc, kxr,kzr, kr2,kt2, fac : float;
	mxrad: constant float := fmath.sqrt(radialMax2);
begin


if not mrolling then

	-- avoid large jumps due to inactivity
	if (dt>2.0) then dt:=0.0; end if;

	forwardok := true;

	dx:=dt*0.25*speed*xlook;
	dz:=dt*0.25*speed*zlook;
	direction:=-1;

	boldtime := currenttime;
	oxme:=xme;
	oyme:=yme;
	ozme:=zme;

	xme := xme - dx;
	zme := zme - dz;



	-- limit incursion into ocean...
	-- by tangential deflection:
	rad := fmath.sqrt(xme*xme+zme*zme);
	if( rad >= mxrad ) then
		xme := xme*mxrad/rad;
		zme := zme*mxrad/rad;
	end if;




	-- test for passing thru active stargate:
	dist2 := sqr( xme-gatex ) + sqr( zme-gatez );
	if mseated and (dhdstate>0) and (dist2 < gaterad*gaterad) then
		mystexit := true;
	end if;

	-- further, limit pos to avoid ko zones:
	for i in 1..nko loop

		kxc:=0.5*(koxhi(i)+koxlo(i));
		kzc:=0.5*(kozhi(i)+kozlo(i));

		kxr:=0.5*(koxhi(i)-koxlo(i));
		kzr:=0.5*(kozhi(i)-kozlo(i));
		kr2:=kxr*kxr+kzr*kzr; --square of circular radius

		dx:=xme-kxc;
		dz:=zme-kzc;
		kt2:=dx*dx+dz*dz;

		if kt2<kr2 then --intrusion into KO
			fac:=fmath.sqrt(kr2/kt2);
			xme:=kxc+fac*dx;
			zme:=kzc+fac*dz; --move radially away from KO center
		end if;

	end loop; --for i


	moving:=true;
	nuy :=  sandht(xme,zme,hmax,mwaterlevel,r1,r2);
	inwater := (nuy<mwaterlevel-aheight/7.0);
	oy :=  sandht(oxme,ozme,hmax,mwaterlevel,r1,r2);
	dy := nuy-oy;
	yme := yme + dy;

	if yme>eyeht+nuy then yme:=eyeht+nuy; end if; --find bottom after floating
	if yme<minyme then yme:=minyme; end if; --float if in water too deep


end if;

end myst_movebackward;





-- limited by how far we allow going into ocean,
-- and by rock obstacles,
-- and perhaps someday the trees...
procedure myst_moveforward( currenttime: float ) is
	dt : float := currenttime-foldtime;
	lagfac : constant float := 1.0;
	nuy, oy, dx,dy,dz, dist2, rad : float;
	--kxl,kxh,kzl,kzh,okxl,okxh,okzl,okzh : float;
	kxc,kzc, kxr,kzr, kr2,kt2, fac : float;
	mxrad: constant float := fmath.sqrt(radialMax2);
begin


if not mrolling and forwardOk then

	-- avoid large jumps due to inactivity
	if (dt>2.0) then dt:=0.0; end if;

	dx:=dt*0.25*speed*xlook;
	dz:=dt*0.25*speed*zlook;
	direction:=+1;


	foldtime := currenttime;
	oxme:=xme;
	oyme:=yme;
	ozme:=zme;

	xme := xme + dx;
	zme := zme + dz;

	-- limit incursion into ocean...
	-- by tangential deflection:
	rad := fmath.sqrt(xme*xme+zme*zme);
	if( rad >= mxrad ) then
		xme := xme*mxrad/rad;
		zme := zme*mxrad/rad;
	end if;


	-- test for passing thru active stargate:
	dist2 := sqr( xme-gatex ) + sqr( zme-gatez );
	if mseated and (dhdstate>0) and (dist2 < gaterad*gaterad) then
		mystexit := true;
	end if;


	-- further, limit pos to avoid ko zones:
	for i in 1..nko loop

		kxc:=0.5*(koxhi(i)+koxlo(i));
		kzc:=0.5*(kozhi(i)+kozlo(i));

		kxr:=0.5*(koxhi(i)-koxlo(i));
		kzr:=0.5*(kozhi(i)-kozlo(i));
		kr2:=kxr*kxr+kzr*kzr; --square of circular radius

		dx:=xme-kxc;
		dz:=zme-kzc;
		kt2:=dx*dx+dz*dz;

		if kt2<kr2 then --intrusion into KO
			fac:=fmath.sqrt(kr2/kt2);
			xme:=kxc+fac*dx;
			zme:=kzc+fac*dz; --move radially away from KO center
		end if;

	end loop; --for i


	moving:=true;
	nuy :=  sandht(xme,zme,hmax,mwaterlevel,r1,r2);
	inwater := (nuy<mwaterlevel-aheight/7.0);

	oy :=  sandht(oxme,ozme,hmax,mwaterlevel,r1,r2);
	dy := nuy-oy;
	yme := yme + dy;

	if yme>eyeht+nuy then yme:=eyeht+nuy; end if; --find bottom after floating
	if yme<minyme then yme:=minyme; end if; --float if in water too deep


--------- disable & use alternate strategy 25jan18 (search dhdnear1) ------------
	--if neardhd then -- sudden forced 1st-person view...
	--	xcam:=xme;	 -- improving DHD selection !
	--	ycam:=yme;
	--	zcam:=zme;
	--	slewToAvLook;
	--end if;
--------- disable & use alternate strategy 25jan18 (search dhdnear1) ------------

end if;

end myst_moveforward;









procedure myst_handle_gc_left( gcx,gcy:sdl.sint16 ) is
-- to update look direction using left game controller stick
	ux : float := float(gcx)/float(32768);
	uy : float := float(gcy)/float(32768);
begin


	if abs(ux)<0.15 then 
		ux:=0.0;
	else
		ux:=ux-0.15*signum(ux);
	end if;

	if abs(uy)<0.15 then 
		uy:=0.0; 
	else
		uy:=uy-0.15*signum(uy);
	end if;


	horiAng := horiAng - 0.04 * ux * Lsens;
	vertAng := vertAng + 0.02 * uy * Lsens;



	if thirdperson then -- vertang represents camera
		xlook := fmath.cos(0.0)*fmath.sin(horiAng);
		zlook := fmath.cos(0.0)*fmath.cos(horiAng);
	else
		xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
		zlook := fmath.cos(vertAng)*fmath.cos(horiAng);
	end if;
	cylook := fmath.sin(vertAng);



	--slewToAvLook; --gradually slew choriang toward horiang
	slewToAv; -- 26jan18: gradually slew choriang toward avatar


	if
	( 
	not forwardOk 
	and (abs(badHoriAng-horiAng)>fourthpi) 
	and not pauseAtLevelChange 
	)  then
		forwardOk:=true;
		badHoriAng:=-10.0*twopi;
	end if;

end myst_handle_gc_left;

procedure myst_handle_gc_right( nowtime: float;  gcx,gcy:sdl.sint16 ) is
-- to update move direction using right game controller stick
	ux : float := Rsens*float(gcx)/float(32768);
	uy : float := Rsens*float(gcy)/float(32768);
begin

	if    uy < -0.05 then
		myst_moveforward(nowTime);

	elsif uy > +0.05 then
		myst_movebackward(nowTime);

	end if;

	myst_handle_gc_left(gcx,0); -- turns left/right

end myst_handle_gc_right;






















-- until flyover is false, (oxme,oyme,ozme) holds original position

procedure fly(
currenttime, xme,yme,zme, xlook,cylook,zlook : in out float;
flyover : in out boolean ) is
	tt : constant float := (currenttime - flystart)/flyduration;
	ang0 : constant float := fmath.arctan(ozme,oxme);
	rxz : float;
begin

if tt>1.0 then
	flyover:=false;
else

	yme:=(1.0-tt)*yfly + tt*oyme;
	horiang := tt*onepi*3.0 + ang0;


	-- nice...looking in direction of flight
	--xme := oxme*cos(-horiang+onepi) - ozme*sin(-horiang+onepi);
	--zme := oxme*sin(-horiang+onepi) + ozme*cos(-horiang+onepi);

	-- best...looking between island center and direction of flight
	xme := oxme*fmath.cos(-horiang+1.2*onepi) - ozme*fmath.sin(-horiang+1.2*onepi);
	zme := oxme*fmath.sin(-horiang+1.2*onepi) + ozme*fmath.cos(-horiang+1.2*onepi);

	rxz := fmath.sqrt( xme*xme+zme*zme );
	vertang := -onepi/12.0 - fmath.arctan(yme,rxz);

	xlook := fmath.cos(vertang)*fmath.sin(horiang);
	cylook := fmath.sin(vertang);
	zlook := fmath.cos(vertang)*fmath.cos(horiang);

	slewToAvLook;
	updateCamera;

end if;

end fly;








-- version used for prolog (on beach) where jumping is disallowed...
-- this initiates beach-ZPM rolls
procedure mupdatezpm( currenttime : float ) is

	barrelwasmoved, barrelhitko : boolean := false;
	dist, nbx,nby,nbz : float;

begin

	nbx:=0.0; nby:=0.0; nbz:=0.0;

	---------- begin barrel logic -------------------------------

	-- initiate roll when appropriate:
	if not mrolling then

		barrl := mposbar;
		-- xme,zme are used in this next ftn:
		mtestbarrel( nbx,nby,nbz, barrelwasmoved, barrelhitko);

		if barrelhitko then
			forwardok := false;
			badhoriang := horiang;
		end if;


		if forwardok and barrelwasmoved  then

			nubarrl(1):=nbx;
			nubarrl(2):=nby;
			nubarrl(3):=nbz;
			mrolling:=true;
			mseated:=false;
			if dhdstate/=5 then
				dhdstate:=0;
			end if;
			timeofroll:=currenttime;
			olbarrl:=barrl;
			incbarrl:=olbarrl;

			-- barrel can only roll in 2 directions
			if (nubarrl(3)=olbarrl(3)) then
				rolldir := 3 * integer( signum(nubarrl(1)-olbarrl(1)) );
			elsif (nubarrl(1)=olbarrl(1)) then
				rolldir := 1 * integer( signum(nubarrl(3)-olbarrl(3)) );
			end if;
			snd4ada_hpp.playSnd(kick); --kick

		end if;

	end if;



	-- check whether barrel is on receptacle:
	if  not mrolling  and not mseated then

		dist := fmath.sqrt( 
			sqr(mposbar(1)-barx) +
			sqr(mposbar(3)-barz) );
		if (dist<0.1) then 
			mseated:=true; -- barrel is on receptacle
		end if;

		if mseated then
			snd4ada_hpp.playSnd(qport); --sbQport signals empowerment 11nov14
		end if;

	end if;

	---------- end barrel logic -------------------------------

	lasttime := currenttime;

end mupdatezpm;








-- this assumes mm=ID, (xme,yme,zme)=virtual pos on island
-- [ actual pos is always (0,0,0) ]
procedure myst_update3MVPs( bkgdNum: integer; currentTime, wid,hit : float) is
	pmx,pmy,pmz,madeg,
	mang,
	xlk,ylk,zlk,
	xrt,yrt,zrt,
	xpos,ypos,zpos,
	xup,yup,zup : float;
	degtilt: constant float := -60.0; -- -45.0;
begin

	if thirdPerson and not worming then

		xpos:=xcam; ypos:=ycam; zpos:=zcam;
		-- camera look + choriang are already defined

	else -- firstPerson

		xpos:=xme; ypos:=yme; zpos:=zme;

		choriang:=horiang;
		cxlook := fmath.cos(vertang)*fmath.sin(choriang);
		cylook := fmath.sin(vertang);
		czlook := fmath.cos(vertang)*fmath.cos(choriang);

	end if;


	-- Look Vector
	xlk:=xpos+cxlook;
	ylk:=ypos+cylook;
	zlk:=zpos+czlook;

	-- Right unit-Direction
	xrt:= fmath.sin(choriang-halfpi);
	yrt:= 0.0;
	zrt:= fmath.cos(choriang-halfpi);

	-- calculate UP unit-Direction
	cross( xrt,yrt,zrt, cxlook,cylook,czlook, xup,yup,zup );

	perspective(projMatrix, 45.0, wid/hit,  0.1, 100.0);

	lookat(mviewMatrix, 0.0,0.0,0.0, cxlook,cylook,czlook, xup,yup,zup );
	lookat(iviewMatrix, xpos,ypos,zpos, xlk,ylk,zlk, xup,yup,zup );

	mmvp:=mviewMatrix; --use only for skybox
	imvp:=iviewMatrix;
	imv:=iviewMatrix;

	matXmat(mmvp,projMatrix); -- for skybox only
	matXmat(imvp,projMatrix); -- for all else



---------------------------------------------
	-- orbit pos (myrad,mrad=20)
	if bkgdNum=4 then --night stars
		mang:=currentTime*twopi*0.002; --0.002
		pmx:=8.0*fmath.sin(mang);
		pmz:=8.0*fmath.cos(mang);
		pmy:=15.0;
	elsif bkgdNum=3 then --evening
		--mx:=0.0; mz:=0.0; my:=15.0;
		mang:=currentTime*twopi*0.005; --0.005
		pmx:=2.0*fmath.sin(mang);
		pmz:=2.0*fmath.cos(mang);
		pmy:=15.0;
	elsif bkgdNum=2 then -- icy, foggy
		pmx:=-0.5; pmz:=-0.5; pmy:=15.0;
	elsif bkgdNum=1 then -- clouds, fog
		pmx:=1.0; pmz:=-4.0; pmy:=15.0;
	elsif bkgdNum=0 then -- sunny, clouds
		mang:=currentTime*twopi*0.01; --0.01
		pmx:=5.0*fmath.sin(mang);
		pmz:=5.0*fmath.cos(mang);
		pmy:=15.0;
	else
		raise program_error;
	end if;


	-- spinAngle
	madeg := -currentTime*twopi*rad2deg*0.1; -- 10sec/rev

	mars.setpos( pmx, pmy, pmz );
	ellobj.setpos(jupit,pmx,pmy,pmz);

---------------------------------------------


	satmm:=identity;
	translate(satmm, -pmx,-pmy,-pmz); --first, move to origin

-- begin rotations

	--spin on polar axis:
	degRotate(satmm, madeg, 0.0,1.0,0.0); -- Y=polar-axis (best 4 mars)

	--axis-tilt:
	degRotate(satmm, degtilt, 1.0, 0.0, 0.0);

-- end rotations

	translate(satmm, pmx,pmy,pmz); --now, move back

	satmv:=satmm;
	matXmat(satmv,mviewMatrix);
	satmvp:=satmv;
	matXmat(satmvp,projMatrix);
---------------------------------------------



end myst_update3MVPs;




procedure aimu(x,y,z: out float) is
	x0,y0,z0, x1,y1,z1, tt : float := 0.0;
	yplane : constant float := dhdy+dhdh; -- Y-coord of DHD Face
begin

	x0:=xme;
	y0:=yme;
	z0:=zme;
	x1:=x0;
	y1:=y0;
	z1:=z0;

	while (y1>yplane) loop
		tt:=tt+1.0;
		x1 := x0 + tt*xlook;
		y1 := y0 + tt*cylook;
		z1 := z0 + tt*zlook;
	end loop;
	tt := (yplane-y0)/(y1-y0);
	x := x0 + tt*(x1-x0);
	z := z0 + tt*(z1-z0);
	y := yplane;

end aimu;


dhdtime: float;

-- on beach, decide which button on DHD the user selects:
procedure pickleft is
	x0,y0,z0, x1,y1,z1, tt : float := 0.0;
	dx,dz,xtgt,ztgt : float;
	yplane : constant float := dhdy+dhdh; -- Y-coord of DHD Face
begin

	x0:=xme;
	y0:=yme;
	z0:=zme;
	x1:=x0;
	y1:=y0;
	z1:=z0;

	while (y1>yplane) loop
		tt:=tt+1.0;
		x1 := x0 + tt*xlook;
		y1 := y0 + tt*cylook;
		z1 := z0 + tt*zlook;
	end loop;
	tt := (yplane-y0)/(y1-y0);
	xtgt := x0 + tt*(x1-x0);
	ztgt := z0 + tt*(z1-z0);

	dx := xtgt-dhdx;
	dz := ztgt-dhdz;

	if( (abs(dx)<dhdr) and (abs(dz)<dhdr) and (dhdstate<5) ) then


		if( (dx<0.0) and (dz<0.0) ) then -- SE

			if not solved(3) then 
				dhdstate:=3; --4;
				dhdtime:=currenttime;
				snd4ada_hpp.playSnd(kwush);
						snd4ada_hpp.playLoop(kbub);
			end if;

		elsif( (dx>0.0) and (dz<0.0) ) then -- SW

			if not solved(4) then
				dhdstate:=4; --1;
				dhdtime:=currenttime;
				snd4ada_hpp.playSnd(kwush);
						snd4ada_hpp.playLoop(kbub);
			end if;

		elsif( (dx>0.0) and (dz>0.0) ) then -- NW

			if not solved(1) then
				dhdstate:=1; --2;
				dhdtime:=currenttime;
				snd4ada_hpp.playSnd(kwush);
						snd4ada_hpp.playLoop(kbub);
			end if;

		elsif( (dx<0.0) and (dz>0.0) ) then -- NE

			if not solved(2) then
				dhdstate:=2; --3;
				dhdtime:=currenttime;
				snd4ada_hpp.playSnd(kwush);
						snd4ada_hpp.playLoop(kbub);
			end if;

		end if;


	end if;
	-- else look too far away



end pickleft;









	darkness : interfaces.c.int := 0; -- 0..4

	dt, rr : float;

	detales: boolean := false;

	vmt,vcc: vec4;
	ang2dhd, adiff, dist,xap,yap,zap: float;


	beach_error : exception;

	extension, et: float;
	
	kz: glfloat;

	bubbling: boolean := false;

begin -------------------- begin main island_ftn ------------------------

	bubbling:=false;

	mars.setpos( 0.0, 0.0, 0.0 );
	jupit.setpos( 0.0, 0.0, 0.0 );

		currentTime:=float(sdl_getticks)/1000.0;

	myassert( npt = nprng'last, 113 );

--3apr18 begin
if 
	--solved(1) or solved(2) or solved(3) or solved(4) or
	dbug
then

	-- in this case, we are exitting the stargate:
	xme := gatex+0.0; -- -4.0;
	zme := gatez+0.5; -- -3.5;
	yme := eyeht + sandht(xme,zme,hmax,mwaterlevel,r1,r2);

	vertang:=0.0;
	horiang:=0.0;

else --first arrival @ island

	xme := 4.0;
	zme := 1.0;
	yme := eyeht + sandht(xme,zme,hmax,mwaterlevel,r1,r2);

	vertang:=0.0;
	horiang:=-onepi;

end if;
--3apr18 end


	xlook := fmath.cos(vertang)*fmath.sin(horiang);
	cylook := fmath.sin(vertang);
	zlook := fmath.cos(vertang)*fmath.cos(horiang);

	slewToAvLook;
	updateCamera(true);


	if not flyover then
		toIsland:=true;
		-- note:  as written, tunnel requires horiang be a multiple of halfpi
		prepwormhole( currenttime, 
			xme-40.0*xlook, yme, zme-40.0*zlook, xme,yme,zme, xme,yme,zme);
	end if;

	--hold pos until after flyover
	oxme:=xme; oyme:=yme; ozme:=zme;
	flystart:=float(sdl_getticks)/1000.0;

	if dbug then
		flyover:=false; -- debug only
	end if;


jupit.yseteli(0.5,0.5,0.5); -- +Y=Npole
mars.yseteli(0.4,0.4,0.4); -- +Y=Npole

-- these keepout zones must be
-- reinitialized here at each return to the island since the
-- same ko arrays are also used in the dungeon rooms:
	nko:=0;


	-- rock2 (smaller-higher)
	nko:=nko+1;
	koxlo(nko):=r2cx-r2rx;
	koxhi(nko):=r2cx+r2rx;
	koylo(nko):=r2cy-r2ry;
	koyhi(nko):=r2cy+r2ry;
	kozlo(nko):=r2cz-r2rz;
	kozhi(nko):=r2cz+r2rz;


	-- rock3 (bigger-lower)
	nko:=nko+1;
	koxlo(nko):=r3cx-r3rx;
	koxhi(nko):=r3cx+r3rx;
	koylo(nko):=r3cy-r3ry;
	koyhi(nko):=r3cy+r3ry;
	kozlo(nko):=r3cz-r3rz;
	kozhi(nko):=r3cz+r3rz;





	-- 3rd keepout for cockpit, nose
	nko:=nko+1;
	koxlo(nko):= r4cx-r4rx;
	koxhi(nko):= r4cx+r4rx;
	koylo(nko):= -1.0;
	koyhi(nko):= +1.0;
	kozlo(nko):= r4cz-r4rz;
	kozhi(nko):= r4cz+r4rz;

	-- 4th, 5th keepouts, 2 SG pillars (#1,2):

	nko:=nko+1;
	koxlo(nko):= gatex-gdx-pdr2-pdr2-0.15;
	koxhi(nko):= gatex-gdx+0.15;
	koylo(nko):= -1.0;
	koyhi(nko):= +1.0;
	kozlo(nko):= gatez-pdr2-0.15;
	kozhi(nko):= gatez+pdr2+0.15;

	nko:=nko+1;
	koxlo(nko):= gatex+gdx-0.15;
	koxhi(nko):= gatex+gdx+pdr2+pdr2+0.15;
	koylo(nko):= -1.0;
	koyhi(nko):= +1.0;
	kozlo(nko):= gatez-pdr2-0.15;
	kozhi(nko):= gatez+pdr2+0.15;


	-- 6th KO for lean-to
	nko:=nko+1;
	koxlo(nko):= l2xc-l2xr;
	koxhi(nko):= l2xc+l2xr+0.3; -- needs Xtra margin @ high edge
	koylo(nko):= l2yc-1.0;
	koyhi(nko):= l2yc+1.0;
	kozlo(nko):= l2zc-l2zr;
	kozhi(nko):= l2zc+l2zr;




	-- 8 more KOs for palms, + 3 bamboo
	for ii in 1..11 loop

		-- rr=radius of canopy...need radius of trunk
		rr:=pzr(ii)+pxr(ii);
		if ii>8 then --bamboo
			rr:=0.2*rr; 
		else
			rr:=0.15*rr;
		end if;

		nko:=nko+1;
		koxlo(nko):= pxc(ii)-rr;
		koxhi(nko):= pxc(ii)+rr;
		koylo(nko):= -1.0;
		koyhi(nko):= +1.0;
		kozlo(nko):= pzc(ii)-rr;
		kozhi(nko):= pzc(ii)+rr;

	end loop;
-----------------------------------------
-- spalm => i in [ 1.. 2]		 
-- tpalm => i in [ 3.. 8]		 
-- bamboo=> i in [ 9..11]		
-- grass => i in [12..14]		
-- tgrass=> i in [15..16]		
-----------------------------------------


	--DHD : (MUST be last KO)
	nko:=nko+1;
	koxlo(nko):=dhdx-2.0*dhdr;
	koxhi(nko):=dhdx+2.0*dhdr;
	koylo(nko):=dhdy-2.0*dhdh;
	koyhi(nko):=dhdy+2.0*dhdh+aheight;
	kozlo(nko):=dhdz-2.0*dhdr;
	kozhi(nko):=dhdz+2.0*dhdr;


-------------- end KO zone definition -----------------------------------



	bkg:=0;
	if solved(1) then bkg:=bkg+1; end if;
	if solved(2) then bkg:=bkg+1; end if;
	if solved(3) then bkg:=bkg+1; end if;
	if solved(4) then bkg:=bkg+1; end if;

	if dbug then bkg:=dbkgd; end if;

	if bkg=0 then
		mcubemap_texid := tropical_cubemap_texid; -- sunny day
		foglev:=0;
	elsif bkg=1 then
		mcubemap_texid := blue_cubemap_texid;     -- cloudy day
		foglev:=1;
	elsif bkg=2 then
		mcubemap_texid := sargas_cubemap_texid;   -- icy, colorful
		foglev:=1;
	elsif bkg=3 then
		mcubemap_texid := sunset_cubemap_texid;   -- evening
		foglev:=0;
	elsif bkg=4 then
		mcubemap_texid := moon_cubemap_texid;     -- night
		foglev:=0; -- 13dec17

		nko:=nko-1; --16jan18: remove DHD as KO zone

	end if;
	darkness:=interfaces.c.int(bkg);

	mystexit:=false;
	mrolling:=false;


	updateCamera(true);
	myst_update3MVPs(bkg, currentTime, float(winwidth), float(winheight) );

	snd4ada_hpp.playLoop(beach); -- tradewinds & surf



	dhdstate:=0;
	if( solved(1) and solved(2) and solved(3) and solved(4) ) then
		dhdstate:=5; -- allow going directly to epilogue
	end if;


	----------------------- main event loop begin -----------------------
   while not mystexit loop

		direction:=0; --stop avatar's legs, unless moving

		currentTime:=float(sdl_getticks)/1000.0;
		SDL_PumpEvents;



------- begin response to user inputs /////////////////////////////////////////

		currentTime := float(sdl_getticks)/1000.0;

		SDL_PumpEvents;

		-- these are only 2 keyboard responses needed in level=5 (epilogue)
		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then 
			userexit:=true; 
			mystexit:=true;
		end if;

		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then 
			userexit:=true; 
			mystexit:=true;
		end if;


	if not flyover and not worming then

		moving:=false;
		if
			( key_map( SDL_SCANCODE_UP ) /= 0 )
			or ( key_map( SDL_SCANCODE_W ) /= 0 )
		then 
			myst_moveForward(currentTime);

		elsif
			( key_map( SDL_SCANCODE_DOWN ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_S ) /= 0 )
		then 
			myst_moveBackward(currentTime);

		end if;


		-- debug utility...helps see new viewpoints
		--if( key_map( SDL_SCANCODE_H ) /= 0 ) then 
		--	yme := yme + 0.01;
		--	yme := min(yme, maxyme);
		--elsif( key_map( SDL_SCANCODE_L ) /= 0 ) then 
		--	yme := max(yme-0.01,eyeht+sandht(xme,zme,hmax,mwaterlevel,r1,r2));
		--	yme := max(yme, minyme);
		--end if;
		-- Test Result:  eventually, island disappears below bottom of skybox



		if
			(
				( key_map( SDL_SCANCODE_M )  /= 0 )
				or
				( key_map( SDL_SCANCODE_F1 ) /= 0 )
			)
		then
			dt := currentTime - dBtnTime;
			if( dt > 0.8 ) then
				thirdPerson := not thirdPerson;
				dBtnTime:=currentTime;
			end if;
		end if;



		if( key_map( SDL_SCANCODE_X )  /= 0 ) then 
			dt := currentTime - dBtnTime;
			if( dt > 0.8 ) then
				detales:=not detales;
				dBtnTime:=currentTime;
			end if;
		end if;


		deltaT := currentTime - oldTimeKb;


		if
			( key_map( SDL_SCANCODE_LEFT ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_A ) /= 0 )
		then

			if thirdperson then
				roty := angrate3*deltaT;
			else
				roty := angrate1*deltaT;
			end if;

			horiang := horiang + roty;
			--slewToAvLook;
			slewToAv; --26jan18
			roty:=0.0;


			if thirdperson then -- vertang represents camera
				xlook := fmath.cos(0.0)*fmath.sin(horiAng);
				zlook := fmath.cos(0.0)*fmath.cos(horiAng);
			else
				xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
				zlook := fmath.cos(vertAng)*fmath.cos(horiAng);
			end if;
			cylook := fmath.sin(vertAng);




		elsif
			( key_map( SDL_SCANCODE_RIGHT ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_D ) /= 0 )
		then

			if thirdperson then
				roty := -angrate3*deltaT;
			else
				roty := -angrate1*deltaT;
			end if;

			horiang := horiang + roty;
			--slewToAvLook;
			slewToAv; --26jan18
			roty:=0.0;


			if thirdperson then -- vertang represents camera
				xlook := fmath.cos(0.0)*fmath.sin(horiAng);
				zlook := fmath.cos(0.0)*fmath.cos(horiAng);
			else
				xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
				zlook := fmath.cos(vertAng)*fmath.cos(horiAng);
			end if;
			cylook := fmath.sin(vertAng);




		end if;



--------------------------------------------------------- addendum 19jan18
		if SDL_PollEvent(test_event'access)>0 
		and then test_event.typ = SDL_MouseWheel then

			if test_event.wheel.y<0 then --move eye closer by 1%
				camdist := 0.99*camdist;
				if camdist<0.1 then camdist:=0.1; end if;

			else --move eye away by 1%
				camdist := 1.01*camdist;
				if camdist>10.0 then camdist:=10.0; end if;

			end if;

		end if;
--------------------------------------------------------- addendum 19jan18



------ begin mouse button -----------------------------------------

-- Here, I am assuming dhdy < yme ...
-- so if we are close enough to the DHD
-- and if we are looking down then we test:


		dist:=fmath.sqrt( sqr(xme-dhdx) + sqr(zme-dhdz) );



----------- force 1st person insert 25jan18 -----------------------
		if dist<dhdnear1 and thirdperson then

			restoreThird:=true;
			thirdperson:=false;

		elsif dist>dhdnear1 and restoreThird then

			thirdperson:=true;
			restoreThird:=false;

		end if;
----------- force 1st person insert 25jan18 -----------------------


		if dist>0.001 then

			--difference between DHD and look direction...since we are using sine
			--we must test halfangle so that test fails @ delta=onepi
			--adiff := abs(fmath.sin( 0.5*fmath.arctan(dhdx-xme,dhdz-zme) - 0.5*horiang ));
			ang2dhd:=branchnear(horiang,fmath.arctan(dhdx-xme,dhdz-zme));
			adiff := abs(fmath.sin( 0.5*(ang2dhd-horiang) ));

			if thirdPerson then
				--neardhd:=((dist<dhdnear1)and(cylook<-0.1)and(adiff<fmath.sin(eighthpi)));
				neardhd := ( (dist<dhdnear1) and (adiff<fmath.sin(eighthpi)) );
			else
				-- must be looking down at 30 degrees or more below horizontal
				neardhd:=((dist<dhdnear1) and (cylook<-0.5) and (adiff<fmath.sin(eighthpi)));
			end if;

		else
			neardhd:=false; --too close for calculations
		end if;

		if dhdstate=5 then neardhd:=false; end if; --14jan18 fix


		if mseated and neardhd and (dhdstate<5) then
			MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
			state := integer( MouseState );
			ileft := integer( SDL_BUTTON(1) );
			if    bitmatch(state, ileft)   then 
				pickLeft;
			end if;
		end if;

		handle_mouse_move(currentTime); -- change look direction here


----------- begin game controller ---------------------------------
		if joystik or gamepad then

			-- axis_* values in [-32768...+32767]

			-- JS: 2nd Axis parm:  0..2
			-- GC: 2nd Axis parm:  0..3
			axis_lx := SDL_JoystickGetAxis(jsa, 0);
			axis_ly := SDL_JoystickGetAxis(jsa, 1);
			myst_handle_gc_left(axis_lx,axis_ly);

			currentTime := float(sdl_getticks)/1000.0;
			if gamepad then
				axis_rx := SDL_JoystickGetAxis(jsa, 2);
				axis_ry := SDL_JoystickGetAxis(jsa, 3);
				myst_handle_gc_right(currentTime,axis_rx,axis_ry);
			end if;

-- now handle the buttons:

			-- 1 => pressed,  0 => not pressed
			-- JS: 2nd Btn parm:  0..7
			-- GC: 2nd Btn parm:  0..11

			zeroBtns; -- sets btns 0..8 to zero
			if gamepad then
				btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- pick
				btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- pick
			elsif joystik then
				btn_0 := SDL_JoystickGetButton(jsa,jbak); -- back
				btn_1 := SDL_JoystickGetButton(jsa,jfor); -- forw
				btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- pick
				btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- pick
			end if;


			if btn_4>0 or btn_5>0 or btn_2>0 or btn_3>0 then
				if mseated and neardhd and (dhdstate<5) then
					pickLeft;
				end if;
			end if;

			if joystik then
				if btn_0>0 then -- JS.trigger
					myst_moveBackward(currentTime);
				elsif btn_1>0 then -- JS.thumb
					myst_moveForward(currentTime);
				end if;
			end if;

		end if; --joystik or gamepad


		if not moving and splashing then
			snd4ada_hpp.stopLoop(splash); --Splash;
			splashing:=false;
		elsif not inwater and splashing then
			snd4ada_hpp.stopLoop(splash);
			splashing:=false;
		elsif moving and inwater and not splashing then
			snd4ada_hpp.playLoop(splash);
			splashing:=true;
		end if;



----------- end game controller ---------------------------------




----///////////////////// end response to user inputs /////////////////////////


	else -- flyover or worming is taking place
		if flyover then
			fly(currenttime, xme,yme,zme, xlook,cylook,zlook,flyover);
		elsif worming then
			vertang:=0.0;
			worm(currenttime, xme,yme,zme, worming);
		end if;
	end if; -- not flyover




		updateCamera; -- main call within myst event loop

		myst_update3MVPs(bkg,currentTime, float(winwidth), float(winheight) );


		mupdatezpm(currenttime); -- 6nov15 addition ???
		-- much simpler version of updategamestate for beach


		foldtime:=currenttime;
		boldtime:=currenttime;
		oldTimeKb := currenttime;

		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);









--//////////// draw other textured objects /////////////////////////////////////


		-- draw sandy island:
		glUseProgram(mystpgmTexShadID);
		glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniformMatrix4fv(mmvid, 1, GL_FALSE, imv(1,1)'address);
		--if bkg=1 then
		--	glUniform1i(mgrlevel, 1); -- lagoonFog 0=>none, 1=>show
		--else
		--	glUniform1i(mgrlevel, 0); -- lagoonFog 0=>none, 1=>show
		--end if;
		glUniform1i(mgrlevel, foglev); -- lagoonFog 0=>none, 1=>show
		glUniform1i(mgrcolor, fogclr); -- lagoonFog 0=>none, 1=>show
		glUniform1i(muniftex, 0);
		glUniform1i(munifdark, darkness);
		glBindTexture(GL_TEXTURE_2D, island_texid);
		isandy.Draw(island,vertbuff,uvbuff,elembuff);


	-- draw a planet:
	glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, satmvp(1,1)'address);
	glUniformMatrix4fv(mmvid, 1, GL_FALSE, satmv(1,1)'address);
	glUniform1i(mgrlevel, 0); -- lagoonFog 0=>none, 1=>show
	glUniform1i(munifdark, 0);
	if bkg=4 or bkg=1 then
		glBindTexture( GL_TEXTURE_2D, marstex );
		ellobj.draw(mars,vertbuff,uvbuff,elembuff); --EquiRect
	else
		glBindTexture( GL_TEXTURE_2D, juptex );
		ellobj.draw(jupit,vertbuff,uvbuff,elembuff); --EquiRect
	end if;





-- nose:
		glUseProgram(noseTexShadID);
		glUniformMatrix4fv(noseMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(noseuniftex, 0);
		glUniform1i(noseunifdark, darkness);

		glUniform3f(ncenID, glfloat(r4cxn),glfloat(r4cyn),glfloat(r4czn) );
		glUniform3f(nradID, glfloat(r4rxn),glfloat(r4ryn),glfloat(r4rzn) );
		glBindTexture(GL_TEXTURE_2D, nose_texid);
		ntexsurf.Draw(nose,vertbuff,uvbuff,elembuff);


-- cockpit:
		glUseProgram(cpitTexShadID);
		glUniformMatrix4fv(cpitMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cpituniftex, 0);
		glUniform1i(cpitunifdark, darkness);
		glUniform3f(cpcenID, glfloat(r4cx),glfloat(r4cy),glfloat(r4cz) );
		glUniform3f(cpradID, glfloat(r4rx),glfloat(r4ry),glfloat(r4rz) );
		glBindTexture(GL_TEXTURE_2D, cpit_texid);
		ctexsurf.Draw(cpit,vertbuff,uvbuff,elembuff);






		glUseProgram(logTexShadID);
		glUniformMatrix4fv(logMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(loguniftex, 0);
		glUniform1i(logunifdark, darkness);
		-- burnt log
		glBindTexture(GL_TEXTURE_2D, log_texid);
		glUniform3f(logcenID, glfloat(blcx),glfloat(blcy),glfloat(blcz) );
		glUniform3f(logradID, glfloat(blrx),glfloat(blry),glfloat(blrz) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);

		glUniform3f(logradID, glfloat(blrz),glfloat(blry),glfloat(blrx) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);










-- draw crab/star here

		glUseProgram(crabTexShadID);
		glUniformMatrix4fv(crabMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(crabuniftex, 0);
		glUniform1i(crabunifdark, darkness);


		-- fish bones
		glBindTexture(GL_TEXTURE_2D, fishbones_texid);
		glUniform3f(ccenID, glfloat(fbcx),glfloat(fbcy),glfloat(fbcz) );
		glUniform3f(cradID, glfloat(fbrx),glfloat(fbry),glfloat(fbrz) );
		glUniform1f(crabangl, glfloat(0.7*onepi) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);

		glUniform1f(crabangl, glfloat(0.0*onepi) );

		glUniform3f(cradID, glfloat(fbrx),glfloat(fbry),glfloat(fbrz+0.03) );
		glUniform3f(ccenID, glfloat(fbcx+0.05),glfloat(fbcy),glfloat(fbcz-0.05) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);


		-- human arm bone
		glBindTexture(GL_TEXTURE_2D, arm_texid);
		glUniform3f(ccenID, glfloat(lgcx),glfloat(lgcy),glfloat(lgcz) );
		glUniform3f(cradID, glfloat(lgrx),glfloat(lgry),glfloat(lgrz) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);

		-- human skull.  Is it Amelia?
		glBindTexture(GL_TEXTURE_2D, skull_texid);
		glUniform3f(ccenID, glfloat(skcx),glfloat(skcy),glfloat(skcz) );
		glUniform3f(cradID, glfloat(skrx),glfloat(skry),glfloat(skrz) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);

		-- draw bottle of freckle cream nearby
		glBindTexture(GL_TEXTURE_2D, frek_texid);
		glUniform3f(ccenID, glfloat(fxc),glfloat(fyc),glfloat(fzc) );
		glUniform3f(cradID, glfloat(fxr),glfloat(fyr),glfloat(fzr) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);



		--//////// starfish, crab begin //////////////////////
		glBindTexture(GL_TEXTURE_2D, star_texid);
		glUniform3f(ccenID, glfloat(s1cx),glfloat(s1cy),glfloat(s1cz) );
		glUniform3f(cradID, glfloat(s1rx),glfloat(s1ry),glfloat(s1rz) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);

		glBindTexture(GL_TEXTURE_2D, crab_texid);
		glUniform3f(ccenID, glfloat(c1cx),glfloat(c1cy),glfloat(c1cz) );
		glUniform3f(cradID, glfloat(c1rx),glfloat(c1ry),glfloat(c1rz) );
		stexsurf.Draw(item,vertbuff,uvbuff,elembuff);
		--//////// starfish, crab end //////////////////////




-- draw primitive lean-to here

		glUseProgram(lean2TexShadID);
		glUniform1i(lean2lev, foglev); --14dec17
		glUniform1i(lean2clr, fogclr); --14dec17
		glUniformMatrix4fv(lean2MVID, 1, GL_FALSE, imv(1,1)'address);
		glUniformMatrix4fv(lean2MatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(lean2uniftex, 0);
		glUniform1i(lean2unifdark, darkness);

		glUniform3f(lean2cenID, glfloat(l2xc),glfloat(l2yc),glfloat(l2zc) );
		glUniform3f(lean2radID, glfloat(l2xr),glfloat(l2yr),glfloat(l2zr) );
		glBindTexture(GL_TEXTURE_2D, lean2_texid);
		mylean2obj.Draw(lean2, vertbuff,uvbuff,elembuff);


--////// draw double cylinder ZPM begin ///////////
		glUseProgram(mystnonTexShadID);

-------------------------------------------------------------------------
			bmvp := imvp;
			if mrolling then

				barreltime := float(sdl_getticks)/1000.0;
				tt := float( barreltime - timeofroll ) / secperroll;
				barangle := onepi*tt*rad2deg;

				if( tt<1.0 ) then
					mposbar(1):=olbarrl(1)+tt*(nubarrl(1)-olbarrl(1));
					mposbar(2):=olbarrl(2)+tt*(nubarrl(2)-olbarrl(2));
					mposbar(3):=olbarrl(3)+tt*(nubarrl(3)-olbarrl(3));

					if    (rolldir=-1) then axis:=xaxis; barangle:=-barangle;
					elsif (rolldir=+1) then axis:=xaxis;
					elsif (rolldir=+3) then axis:=zaxis; barangle:=-barangle;
					elsif (rolldir=-3) then axis:=zaxis;
					end if;

					cyl2obj.updcyl2(mbarrel, mposbar(1),mposbar(2),mposbar(3));
					bmm:=identity;
					translate(bmm, -mposbar(1), -mposbar(2), -mposbar(3) );
					degRotate(bmm, barangle, axis(1), axis(2), axis(3) );
					translate(bmm, mposbar(1), mposbar(2), mposbar(3) );
					bmvp := bmm;
					matXmat( bmvp, iviewmatrix ); --vm ); -- check vm
					matXmat( bmvp, projMatrix ); -- check pm
				else
					mrolling:=false;
					mposbar:=nubarrl;
					cyl2obj.updcyl2(mbarrel, mposbar(1),mposbar(2),mposbar(3));
				end if; -- tt
			end if; -- mrolling
			gluniformmatrix4fv( nmatrixid, 1, gl_false, bmvp(1,1)'address );
-------------------------------------------------------------------------

		if  not mseated  then
			cyl2obj.Draw(mbarrel,vertbuff,rgbbuff,elembuff, false);
		else
			cyl2obj.Draw(mbarrel,vertbuff,rgbbuff,elembuff, true);
		end if;

--////// draw double cylinder ZPM end ///////////











--////////////// draw cube-mapped skybox ///////////////////////////////////////
		glUseProgram(mpidSkyB);
		glUniform1i(sblevel, foglev);
		glUniform1i(sbcolor, fogclr);
		glUniform1i(sbmapUID, 0);
		glUniformMatrix4fv(sbmvpUID, 1, GL_FALSE, mmvp(1,1)'address);
		glEnable(GL_TEXTURE_CUBE_MAP_SEAMLESS); --seems Ok
		glBindTexture(GL_TEXTURE_CUBE_MAP, mcubemap_texid);
		cubemapobj.Draw(skybox, vertbuff,elembuff);



-------- draw fish here begin ----------------------------------------

		-- orbit center:
		fishx:= -7.0;  fishy:= mwaterlevel-0.04;  fishz:= -7.0;

		gluseprogram(fishTexShadID);
		glUniform1i(fishunifrot, 1 ); --RotSense(1=>CW, -1=>CCW)
		gluniformmatrix4fv(fishMatrixID, 1, gl_false, imvp(1,1)'address );
		gluniform1i(fishuniftex,0);

		-- setup for 2 types of small tropical fish
		glUniform1f(fishunifrad, 1.0 ); --swim circle radius
		glUniform1f(fishunifsvel, 1.0 ); --swim speed
		glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
		glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
		glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );


	--portal-exterior discard (unused):
		glUniform1i(funifside, 0 ); -- -1=>min, +1=>max, 0=>no-discard

		if thirdperson then
			glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
		else
			glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
		end if;

		glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
		glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


		glbindtexture(gl_texture_2d, mfish_texid); -- 3 multi-colored

		glUniform1f(fishuniftime, glfloat(currentTime) );
		myfish.draw( mfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+3.0) );
		myfish.draw( mfish, vertbuff,uvbuff,elembuff ); 

		glUniform1f(fishuniftime, glfloat(currentTime+9.0) );
		myfish.draw( mfish, vertbuff,uvbuff,elembuff );




		glbindtexture(gl_texture_2d, bfish_texid); -- 2 blue-tropicals
		glUniform3f(fcenID, 
			glfloat(fishx+0.4), glfloat(fishy), glfloat(fishz-0.4) );

		glUniform1f(fishuniftime, glfloat(currentTime) ); 
		myfish.draw( bfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+8.0) ); 
		myfish.draw( bfish, vertbuff,uvbuff,elembuff );



		glbindtexture(gl_texture_2d, rfish_texid); -- 2 stingrays
		glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
		glUniform3f(fcenID, 
			glfloat(fishx+0.8), glfloat(fishy), glfloat(fishz-0.8) );

		glUniform1f(fishuniftime, glfloat(currentTime+25.0) ); 
		myfish.draw( rfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+45.0) ); 
		myfish.draw( rfish, vertbuff,uvbuff,elembuff );




		-- school of piranha
		glUniform1i(fishunifrot, -1 ); --RotSense(1=>CW, -1=>CCW)
		glbindtexture(gl_texture_2d, pfish_texid); -- piranha (?salt water?)
		glUniform3f(fcenID, 0.0,glfloat(fishy-0.01),0.0 );
		glUniform1f(fishunifrad, 2.0 ); --swim circle radius
		glUniform1f(fishunifsvel, 1.0 ); --swim speed
		glUniform1f(fishunifwvel, 2.0 ); --wiggle speed
		glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude

		glUniform1f(fishuniftime, glfloat(currentTime) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+3.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+10.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+20.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+21.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );

		glUniform1f(fishuniftime, glfloat(currentTime+32.0) ); 
		myfish.draw( pfish, vertbuff,uvbuff,elembuff );




		--shark
		glUniform1i(fishunifrot, +1 ); --RotSense(1=>CW, -1=>CCW)
		glbindtexture(gl_texture_2d, sfish_texid); -- 3 sharks
		glUniform3f(fcenID, 0.0, glfloat(sharky), 0.0 );
		glUniform1f(fishunifrad, 11.0 ); --swim circle radius
		glUniform1f(fishunifsvel, 0.2 ); --swim speed
		glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
		glUniform1f(fishunifwamp, 1.5 ); --wiggle amplitude

		glUniform1f(fishuniftime, glfloat(currentTime+0.0) ); 
		myfish.draw( sfish, vertbuff,uvbuff,elembuff ); 

		glUniform1f(fishuniftime, glfloat(currentTime+45.0) ); 
		myfish.draw( sfish, vertbuff,uvbuff,elembuff ); 

		glUniform1f(fishuniftime, glfloat(currentTime+90.0) ); 
		myfish.draw( sfish, vertbuff,uvbuff,elembuff ); 



		-- 1 serpents
		glbindtexture(gl_texture_2d, serpent_texid);
		glUniform3f(fcenID, 0.0, glfloat(sharky), 0.0 );
		glUniform1f(fishunifrad, 10.0 ); --swim circle radius
		glUniform1f(fishunifsvel, 0.2 ); --swim speed
		glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
		glUniform1f(fishunifwamp, 1.5 ); --wiggle amplitude

		glUniform1f(fishuniftime, glfloat(currentTime+135.0) ); 
		longfish.draw( serpent, vertbuff,uvbuff,elembuff );



		-- 1 snake
		glbindtexture(gl_texture_2d, snake_texid);
		glUniform1i(fishunifrot, -1 ); --RotSense(1=>CW, -1=>CCW)
		glUniform3f(fcenID, 0.0, glfloat(sharky), 0.0 );
		glUniform1f(fishunifrad, 9.5 ); --swim circle radius
		glUniform1f(fishunifsvel, 0.1 ); --swim speed
		glUniform1f(fishunifwvel, 2.0 ); --wiggle speed
		glUniform1f(fishunifwamp, 2.0 ); --wiggle amplitude

		glUniform1f(fishuniftime, glfloat(currentTime+0.0) ); 
		longtube.draw( snake, vertbuff,uvbuff,elembuff );



-------- draw fish here end ----------------------------------------






------dhd begin -------------------------------------------------------

			glUseProgram(gateTexShadID);
			glUniformMatrix4fv(gateMatrixID, 1, GL_FALSE, imvp(1,1)'address);
			glUniform1i(gateuniftex,0);
			glUniform1i(gateunifdark, darkness);


			if not solved(1) then
				glBindTexture(GL_TEXTURE_2D, adobe2_texid);
				pictobj.Draw(dhdp1, vertbuff,uvbuff,elembuff);
			end if;

			if not solved(2) then
				glBindTexture(GL_TEXTURE_2D, wood_texid);
				pictobj.Draw(dhdp2, vertbuff,uvbuff,elembuff);
			end if;

			if not solved(3) then
				glBindTexture(GL_TEXTURE_2D, brick_texid);
				pictobj.Draw(dhdp3, vertbuff,uvbuff,elembuff);
			end if;

			if not solved(4) then
				glBindTexture(GL_TEXTURE_2D, granite_texid);
				pictobj.Draw(dhdp4, vertbuff,uvbuff,elembuff);
			end if;



			if (dhdstate=0) or (dhdstate=5) then
				if mseated then
					glBindTexture(GL_TEXTURE_2D, dhdo_texid);
				else
					glBindTexture(GL_TEXTURE_2D, dhd0_texid);
				end if;
			elsif dhdstate=1 then
				glBindTexture(GL_TEXTURE_2D, dhd1_texid);
			elsif dhdstate=2 then
				glBindTexture(GL_TEXTURE_2D, dhd2_texid);
			elsif dhdstate=3 then
				glBindTexture(GL_TEXTURE_2D, dhd3_texid);
			elsif dhdstate=4 then
				glBindTexture(GL_TEXTURE_2D, dhd4_texid);
			end if;
			if (dhdstate<5) then
				pictobj.Draw(dhdface, vertbuff,uvbuff,elembuff);
			end if;

------dhd end ---------------------------------------------------------



		if thirdPerson then

			if neardhd and mseated  then --translucent
				fadeAvatar:=true;
			else
				fadeAvatar:=false;
			end if;

			drawAvatar(currenttime, xme,yme,zme,horiang); --draw after DHD
		end if;




-- draw seaweed begin ------------------------------------------------

		if thirdperson then
			wsort(wfar2near, nwx,pwx,nwz,pwz, xcam,zcam, avgdist);
		else
			wsort(wfar2near, nwx,pwx,nwz,pwz, xme,zme, avgdist);
		end if;

		glUseProgram(palmTexShadID);
		glUniformMatrix4fv(palmMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniformMatrix4fv(palmMVID, 1, GL_FALSE, imv(1,1)'address); --14dec17
		glUniform1i(palmlev, foglev); --14dec17
		glUniform1i(palmclr, fogclr); --14dec17
		glUniform1i(palmuniftex, 0);
		glUniform1i(palmunifdark, darkness);
		glUniform1f(palmuniftime, glfloat(currentTime) ); 
		--shader makes them sway

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

		glBindTexture(GL_TEXTURE_2D, tgrass_texid);

		-- note that the depthmask trick used for trees
		-- seems unnecessary here.
			for i in nwrng loop

				j:=wfar2near(i);
				pid := j + npalms;

				glUniform3f(palmcenid, 
					0.5*glfloat(pwx(j)+nwx(j)), 
					0.5*glfloat(pwy(j)+nwy(j)), 
					0.5*glfloat(pwz(j)+nwz(j)) );

				glUniform3f(palmradid,
					0.5*glfloat(pwx(j)-nwx(j)), 
					0.5*glfloat(pwy(j)-nwy(j)), 
					0.5*glfloat(pwz(j)-nwz(j)) );

				glUniform1f(palmbaseid, weedbase(j) );

				glUniform1i(palmunifid, glint(pid) );
				xtreeobj.Draw( seaweed, vertbuff,uvbuff,elembuff);

			end loop; --i

-- draw seaweed end ------------------------------------------------



-- draw some fixed textured objects using stargate shaders/program -------------
		-- draw old wooden sign in sand:
		glUseProgram(gateTexShadID);
		glUniformMatrix4fv(gateMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(gateuniftex,0);
		glUniform1i(gateunifdark, darkness);
		glBindTexture(GL_TEXTURE_2D, gard_texid);
		pictobj.Draw(sign, vertbuff,uvbuff,elembuff);

		-- draw SOS at waters edge:
		glBindTexture(GL_TEXTURE_2D, sos_texid);
		pictobj.Draw(sos, vertbuff,uvbuff,elembuff);

-- begin draw receptacle beneath ZPM:
		if  not mseated  then -- unlit receptacle
			glbindtexture(gl_texture_2d, gate0_texid);
		else -- lit receptacle
			glbindtexture(gl_texture_2d, gate_texid);
		end if;
		pictobj.draw( msokrcpt, vertbuff, uvbuff, elembuff );
-- end draw receptacle beneath ZPM:







--/////////////// draw skybox reflections in ocean water begin /////////////////

		-- surrounding sea:
		glUseProgram(mpidSkyW);
		glUniform1i(mwlevel, foglev);
		glUniform1i(mwcolor, fogclr);
		glEnable(GL_TEXTURE_CUBE_MAP_SEAMLESS); --seems Ok
		glBindTexture(GL_TEXTURE_CUBE_MAP, mcubemap_texid);
		glUniform1i(emUID, 0);
		glUniformMatrix4fv(mvpUID, 1, GL_FALSE, imvp(1,1)'address); --30nov14
		glUniformMatrix4fv(mvUID, 1, GL_FALSE, imv(1,1)'address); --13dec17
		glUniform1f(mtimeID, glfloat(currentTime) );

		if thirdperson then
			glUniform3f(mpeyeID, glfloat(xcam),glfloat(ycam), glfloat(zcam) );
		else
			glUniform3f(mpeyeID, glfloat(xme),glfloat(yme), glfloat(zme) );
		end if;

		glUniform3f(mpcenID, glfloat(mxpcen), 0.0, glfloat(mzpcen) );
		glUniform3f(mpradID, glfloat(mrad), glfloat(mrad), glfloat(mrad) );
		glUniform1f(mwlevID, glfloat(mwaterlevel));
		glUniform1f(hmaxuid, glfloat(hmax) );
		glUniform1f(r1uid, glfloat(r1) );
		glUniform1f(r2uid, glfloat(r2) );

		sea.Draw(ocean,vertbuff);

--/////////////// draw skybox reflections in ocean water end ///////////////////









--/////// now use rock vertex shader : ////////////////////////
		glUseProgram(rockTexShadID);
		glUniform1i(rocklev, foglev); --14dec17
		glUniform1i(rockclr, fogclr); --14dec17
		glUniform1i(rockuniftex, 0);
		glUniform1i(rockunifdark, darkness);


		glUniformMatrix4fv(rockMVID, 1, GL_FALSE, imv(1,1)'address);
		glUniformMatrix4fv(rockMatrixID, 1, GL_FALSE, imvp(1,1)'address);

		glBindTexture(GL_TEXTURE_2D, coco_texid); -- coconuts
		glUniform3f(rradID, glfloat(r1rx),glfloat(r1ry),glfloat(r1rz) );

		glUniform3f(rcenID, glfloat(r1cx),glfloat(r1cy),glfloat(r1cz) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);


		glUniform3f(rcenID, glfloat(ccx(1)),glfloat(ccy(1)),glfloat(ccz(1)) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);

		glUniform3f(rcenID, glfloat(ccx(2)),glfloat(ccy(2)),glfloat(ccz(2)) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);

		glUniform3f(rcenID, glfloat(ccx(3)),glfloat(ccy(3)),glfloat(ccz(3)) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);

		glUniform3f(rcenID, glfloat(ccx(4)),glfloat(ccy(4)),glfloat(ccz(4)) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);

		glUniform3f(rcenID, glfloat(ccx(5)),glfloat(ccy(5)),glfloat(ccz(5)) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);



		-- 2 granite rocks:
		glBindTexture(GL_TEXTURE_2D, rock_texid);

		glUniform3f(rcenID, glfloat(r2cx),glfloat(r2cy),glfloat(r2cz) );
		glUniform3f(rradID, glfloat(r2rx),glfloat(r2ry),glfloat(r2rz) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);


		glUniform3f(rcenID, glfloat(r3cx),glfloat(r3cy),glfloat(r3cz) );
		glUniform3f(rradID, glfloat(r3rx),glfloat(r3ry),glfloat(r3rz) );
		myrockobj.Draw(rococo,vertbuff,uvbuff,elembuff);



--////////////// decide order of drawing palm trees, stargate //////////////////

		if thirdperson then
			d2gate := ( fmath.sqrt(sqr(gatex-xcam) + sqr(gatez-zcam)) );
			sort(far2near,nx,px,nz,pz, xcam,zcam, avgdist);
		else
			d2gate := ( fmath.sqrt(sqr(gatex-xme) + sqr(gatez-zme)) );
			sort(far2near,nx,px,nz,pz, xme,zme, avgdist);
		end if;


		if( avgdist < d2gate ) then --//draw stargate here (first)

			glUseProgram(gateTexShadID);
			glUniformMatrix4fv(gateMatrixID, 1, GL_FALSE, imvp(1,1)'address);
			glUniform1i(gateuniftex,0);
			glUniform1i(gateunifdark, darkness); --14nov15

			glBindTexture(GL_TEXTURE_2D, pillar1_texid);
			pictobj.Draw(pillar1, vertbuff,uvbuff,elembuff);
			pictobj.Draw(pillar2, vertbuff,uvbuff,elembuff);

			glBindTexture(GL_TEXTURE_2D, pillar2_texid);
			pictobj.Draw(pillar3, vertbuff,uvbuff,elembuff);
			pictobj.Draw(pillar4, vertbuff,uvbuff,elembuff);
			pictobj.Draw(pillar5, vertbuff,uvbuff,elembuff);



			glBindTexture(GL_TEXTURE_2D, gate0_texid);
			pictobj.Draw(gate, vertbuff,uvbuff,elembuff);

			if dhdstate>0 and mseated then
				et:=currenttime-dhdtime-halfpi;
				extension:=1.0+fmath.sin(et);
				if et>twopi-halfpi then
					extension:=0.0;
				end if;
				kz := 0.02 + kwradz*glfloat( extension );
				drawKawhoosh(xxkwh,yykwh,zzkwh,kwradx,kwrady,kz,0,imvp);
			end if;


		end if; -- draw stargate



---------- now draw palms/grasses in order from far to near, 
---------- each using 2 textures intersecting in an "X"

		glUseProgram(palmTexShadID);
		glUniformMatrix4fv(palmMVID, 1, GL_FALSE, imv(1,1)'address); --14dec17
		glUniform1i(palmlev, foglev); --14dec17
		glUniform1i(palmclr, fogclr); --14dec17
		glUniformMatrix4fv(palmMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(palmuniftex, 0);
		glUniform1i(palmunifdark, darkness);
		glUniform1f(palmuniftime, glfloat(currentTime) ); 
		--shader makes them sway

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);


-- palms & grasses:  current drawing strategy:
-- using 2 [double-sided] texture planes arranged in an X;  
-- then sort, draw far to near.  But now I am drawing twice:
-- draw once with depthmask off so that all foliage branches
-- are drawn;  then draw again with usual depthmask on
-- so that overlapping branches look fairly correct.
--
-- Note: the ideal preferred way to do this is either:
-- a) use 3 texture planes arranged in a triangle, draw far to near;
-- b) use 4 texture half-planes arranged in an X, draw far to near.

		for k in 1..2 loop
			if k=1 then
				gldepthmask(gl_false);
			end if;

			for i in nprng loop

				j:=far2near(i);  -- draw this one now
				pid := j;

				glUniform3f(palmcenid, 
					glfloat(pxc(j)),glfloat(pyc(j)),glfloat(pzc(j)));
				glUniform3f(palmradid, 
					glfloat(pxr(j)),glfloat(pyr(j)),glfloat(pzr(j)));

				glUniform1f( palmbaseid, palmbase(j) );

				if( plant(j)=tgrass ) then
					glBindTexture(GL_TEXTURE_2D, tgrass_texid);
				elsif( plant(j)=cgrass ) then
					glBindTexture(GL_TEXTURE_2D, cgrass_texid);
				elsif( plant(j)=bamboo ) then
					glBindTexture(GL_TEXTURE_2D, bamb_texid);
				elsif( plant(j)=tpalm ) then
					glBindTexture(GL_TEXTURE_2D, tpalm_texid);
				elsif( plant(j)=spalm ) then
					glBindTexture(GL_TEXTURE_2D, palm_texid);
				else
					raise program_error;
				end if;

				glUniform1i(palmunifid, glint(pid) );
				xtreeobj.Draw( palm, vertbuff,uvbuff,elembuff);

			end loop; --i

			if k=1 then
				gldepthmask(gl_true);
			end if;
		end loop; --k
----------------------- end draw palms -------------------------------



		if avgdist >= d2gate then -- draw stargate now

			gluseprogram(gateTexShadID);
			gluniformmatrix4fv(gateMatrixID, 1, gl_false, imvp(1,1)'address );
			gluniform1i(gateuniftex,0);
			glUniform1i(gateunifdark, darkness); --14nov15

			glBindTexture(GL_TEXTURE_2D, pillar1_texid);
			pictobj.Draw(pillar1, vertbuff,uvbuff,elembuff);
			pictobj.Draw(pillar2, vertbuff,uvbuff,elembuff);

			glBindTexture(GL_TEXTURE_2D, pillar2_texid);
			pictobj.Draw(pillar3, vertbuff,uvbuff,elembuff);
			pictobj.Draw(pillar4, vertbuff,uvbuff,elembuff);
			pictobj.Draw(pillar5, vertbuff,uvbuff,elembuff);


			glBindTexture(GL_TEXTURE_2D, gate0_texid);
			pictobj.draw( gate, vertbuff,uvbuff,elembuff );
			if dhdstate>0 and mseated then
				et:=currenttime-dhdtime-halfpi;
				extension:=1.0+fmath.sin(et);
				if et>twopi-halfpi then
					extension:=0.0;
				end if;
				kz := 0.02 + kwradz*glfloat( extension );
				drawKawhoosh(xxkwh,yykwh,zzkwh,kwradx,kwrady,kz,0,imvp);
			end if;


		end if; -- draw stargate now






		if neardhd and mseated  then -- show hand-cursor

			-- "`" => rightPalm in my alphabet
			aimu(xap,yap,zap);
			vmt:=(xap,yap,zap,1.0);
			matXvec(imvp,vmt,vcc);
			utex.print3d("`",vcc(1),vcc(2),vcc(3),vcc(4), 40, 1.0);

		end if;




		if worming then -- draw passage thru wormhole
				drawWormHole( currentTime, imvp );


		elsif detales then

			utex.print2d(" bkg="& integer'image(bkg), 0.02, 0.8, 25);
			utex.print2d(" hdpi: " &
				interfaces.c.int'image(Fwid)&" X "
				& interfaces.c.int'image(Fhit), 0.02, 0.7, 25 );

--------- begin OGL queries -----------------------------------------

			glGetIntegerv(GL_CONTEXT_PROFILE_MASK, profile'address);
			if( profile = GL_CONTEXT_CORE_PROFILE_BIT ) then
				utex.print2d("ogl-query:  Core Profile", 0.02, 0.6, 20);
			end if;

			-- Note that OSX currently requires the forward_compatible flag!
			glGetIntegerv(GL_CONTEXT_FLAGS, flags'address);
			if( flags = GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT ) then
				utex.print2d("ogl-query:  Forward-Compatible bit is set", 0.02, 0.55, 10);
			end if;

			glgetintegerv(gl_major_version, major'address);
			glgetintegerv(gl_minor_version, minor'address);
			utex.print2d( "ogl-query: OGL-major: "&glint'image(major), 0.02, 0.5, 10);
			utex.print2d( "ogl-query: OGL-minor: "&glint'image(minor), 0.02, 0.45, 10);

			glgetintegerv(gl_max_texture_units, mtu'address);
			utex.print2d( "ogl-query: maxTexUnits: "&glint'image(mtu), 0.02, 0.4, 10);

			glgetintegerv(gl_max_texture_image_units, mtu'address);
			utex.print2d( "ogl-query: maxTexImgUnits: "&glint'image(mtu), 0.02, 0.35, 10);

			glgetintegerv(gl_max_combined_texture_image_units, mtu'address);
			utex.print2d( "ogl-query: maxCombTexImgUnits: "&glint'image(mtu), 0.02, 0.3, 10);

			glgetintegerv(gl_max_uniform_buffer_bindings, mul'address);
			utex.print2d("ogl-query: maxUnifBufferBindings: "&glint'image(mul),0.02,0.25,10);

			glgetintegerv(gl_max_uniform_locations, mul'address);
			utex.print2d("ogl-query: maxUniformLocations: "&glint'image(mul), 0.02,0.20,10);


--------- end OGL queries -----------------------------------------





		end if; -- worming/detales





		--minimal gl error check if dbug
		if dbug then
			if dumpGLerrorQueue("gameutils.island_ftn loop end")>0 then
				raise beach_error;
			end if;
		end if;




		sdl_gl_swapwindow( mainWindow );

   end loop; 
	----------------------- main event loop end -----------------------

	if not userexit then
		snd4ada_hpp.stopLoops;
	end if; --otherwise stopSnd is called at end of main

	-- set dhdstate=5 if solved for all k, k=1..4

	myassert( (dhdstate>0) or userexit , 114 );
	myassert( dhdstate <= 5, 115 );

	return dhdstate;


exception -- added 8jan18

	when ada.numerics.argument_error =>

		new_line;
		put("iFtn:  xme="&float'image(xme));
		put("iFtn:  zme="&float'image(zme));
		new_line;

		put("iFtn:  xcam="&float'image(xcam));
		put("iFtn:  zcam="&float'image(zcam));
		new_line;

		put("iFtn:  xme-xcam="&float'image(xme-xcam));
		put("iFtn:  zme-zcam="&float'image(zme-zcam));
		new_line;

		raise;



end island_ftn;


