
separate (gameutils)


procedure setup_textures is  -- prepare dungeon textures
	use glext.binding;
begin 

marstex := loadPng(repeat, "data/mars.png"); --use yseteli
juptex := loadPng(repeat, "data/jupitermap.png"); --use yseteli


	--new fireball (level=3):
	firetexshadid := loadshaders("./data/fireball.vs", "./data/fireball.fs");
	fmatrixid := glgetuniformlocation(firetexshadid, pmvp);
	funiftex  := glgetuniformlocation(firetexshadid, pmyts);
	fopacid  := glgetuniformlocation(firetexshadid, pmyopac);
	ftimeid  := glgetuniformlocation(firetexshadid, ptime);
	firecenid  := glgetuniformlocation(firetexshadid, pwPos);
	fbrad := glgetuniformlocation(firetexshadid, pwRad);
	fbunifside:= glgetuniformlocation(firetexshadid, pside);
	fbunifme  := glgetuniformlocation(firetexshadid, pme);
	fbunifport1:=glgetuniformlocation(firetexshadid,pport1);
	fbunifport2:=glgetuniformlocation(firetexshadid,pport2);
	ball_texid:= loadPng(mirror,"data/explosion.png"); --radial color
	fireballobj.setrect(fireball,j1,j2,j3,j4,j5,j6);




	--new kwhoosh (level=0):
	kwshadid := loadshaders("./data/kwhoosh.vs", "./data/kwhoosh.fs");
	kwlevid := glgetuniformlocation(kwshadid,pmylevel);
	kwmatrixid := glgetuniformlocation(kwshadid, pmvp);
	kwuniftex  := glgetuniformlocation(kwshadid, pmyts);
	kwopacid  := glgetuniformlocation(kwshadid, pmyopac);
	kwtimeid  := glgetuniformlocation(kwshadid, ptime);
	kwcenid  := glgetuniformlocation(kwshadid, pwPos);
	kwradid := glgetuniformlocation(kwshadid, pwRad);
	kwunifside:= glgetuniformlocation(kwshadid, pside);
	kwunifme  := glgetuniformlocation(kwshadid, pme);
	kwunifport1:=glgetuniformlocation(kwshadid,pport1);
	kwunifport2:=glgetuniformlocation(kwshadid,pport2);
	kw_texid:= loadPng(mirror,"data/whoosh1.png"); --radial color
	--kw_texid:= loadPng(mirror,"data/whoosh2.png"); --radial color
	kwhooshobj.setrect(kwhoosh,j1,j2,j3,j4,j5,j6);









	--cartoon palmTree
	x1picshadid := loadshaders("data/picZ.vs", "data/palmTreeWindmill.fs");
	x1pictimeid := glgetuniformlocation(x1picshadid, ptime);
	x1picresid  := glgetuniformlocation(x1picshadid, presol);
	x1picmatid  := glgetuniformlocation(x1picshadid, pmvp);
	x1picradid  := glgetuniformlocation(x1picshadid, pwRad);
	x1piccenid  := glgetuniformlocation(x1picshadid, pwPos);
	--------------------------------------------------------------
	x1unifside := glgetuniformlocation(x1picshadid, pside);
	x1unifme  := glgetuniformlocation(x1picshadid, pme);
	x1unifport1:=glgetuniformlocation(x1picshadid,pport1);
	x1unifport2:=glgetuniformlocation(x1picshadid,pport2);



	--waterworld
	x2picshadid := loadshaders("data/picZ.vs", "data/waterworldCCNCSA3.fs");
	x2pictimeid := glgetuniformlocation(x2picshadid, ptime);
	x2picresid  := glgetuniformlocation(x2picshadid, presol);
	x2picmatid  := glgetuniformlocation(x2picshadid, pmvp);
	x2picradid  := glgetuniformlocation(x2picshadid, pwRad);
	x2piccenid  := glgetuniformlocation(x2picshadid, pwPos);
	--------------------------------------------------------------
	x2unifside := glgetuniformlocation(x2picshadid, pside);
	x2unifme  := glgetuniformlocation(x2picshadid, pme);
	x2unifport1:=glgetuniformlocation(x2picshadid,pport1);
	x2unifport2:=glgetuniformlocation(x2picshadid,pport2);



	--mountainscape
	x2pic2shadid := loadshaders("data/picZ.vs", "data/mountainscape.fs");

	x2pic2timeid := glgetuniformlocation(x2pic2shadid, ptime);
	x2pic2resid  := glgetuniformlocation(x2pic2shadid, presol);
	x2pic2matid  := glgetuniformlocation(x2pic2shadid, pmvp);
	x2pic2radid  := glgetuniformlocation(x2pic2shadid, pwRad);
	x2pic2cenid  := glgetuniformlocation(x2pic2shadid, pwPos);
	--------------------------------------------------------------
	x22unifside := glgetuniformlocation(x2pic2shadid, pside);
	x22unifme  := glgetuniformlocation(x2pic2shadid, pme);
	x22unifport1:=glgetuniformlocation(x2pic2shadid,pport1);
	x22unifport2:=glgetuniformlocation(x2pic2shadid,pport2);



	--DaliClock
	x3picshadid := loadshaders("data/picZfog.vs", "data/bwClock.fs");

	x3pictimeid := glgetuniformlocation(x3picshadid, ptime);
	x3picresid  := glgetuniformlocation(x3picshadid, presol);

	x3picmatid  := glgetuniformlocation(x3picshadid, pmvp);
	x3picmvid  := glgetuniformlocation(x3picshadid, pmv);

	x3picradid  := glgetuniformlocation(x3picshadid, pwRad);
	x3piccenid  := glgetuniformlocation(x3picshadid, pwPos);
	--------------------------------------------------------------
	x3unifside := glgetuniformlocation(x3picshadid, pside);
	x3unifme  := glgetuniformlocation(x3picshadid, pme);
	x3unifport1:=glgetuniformlocation(x3picshadid,pport1);
	x3unifport2:=glgetuniformlocation(x3picshadid,pport2);



	--MagmaPlanet
	x3pic2shadid := loadshaders("data/picZfog.vs", "data/redPlanet.fs");
	x3pic2timeid := glgetuniformlocation(x3pic2shadid, ptime);
	x3pic2resid  := glgetuniformlocation(x3pic2shadid, presol);

	x3pic2matid  := glgetuniformlocation(x3pic2shadid, pmvp);
	x3pic2mvid  := glgetuniformlocation(x3pic2shadid, pmv);

	x3pic2radid  := glgetuniformlocation(x3pic2shadid, pwRad);
	x3pic2cenid  := glgetuniformlocation(x3pic2shadid, pwPos);
	--------------------------------------------------------------
	x32unifside := glgetuniformlocation(x3pic2shadid, pside);
	x32unifme  := glgetuniformlocation(x3pic2shadid, pme);
	x32unifport1:=glgetuniformlocation(x3pic2shadid,pport1);
	x32unifport2:=glgetuniformlocation(x3pic2shadid,pport2);


	--spinning Galaxy
	x4picshadid := loadshaders("data/picZ.vs", "data/blueSpiral.fs");
	x4pictimeid := glgetuniformlocation(x4picshadid, ptime);
	x4picresid  := glgetuniformlocation(x4picshadid, presol);
	x4picmatid  := glgetuniformlocation(x4picshadid, pmvp);
	x4picradid  := glgetuniformlocation(x4picshadid, pwRad);
	x4piccenid  := glgetuniformlocation(x4picshadid, pwPos);
	--------------------------------------------------------------
	x4unifside := glgetuniformlocation(x4picshadid, pside);
	x4unifme  := glgetuniformlocation(x4picshadid, pme);
	x4unifport1:=glgetuniformlocation(x4picshadid,pport1);
	x4unifport2:=glgetuniformlocation(x4picshadid,pport2);


-------------------- 25feb15 addenda end ---------------------------


	nontexshadid := loadshaders("./data/nontex.vs", "./data/nontex.fs");
	ntmatrixid := glgetuniformlocation(nontexshadid, pmvp);


	--to Island:

	-- back to Island:
	tunshadid3 := loadshaders("./data/tunnelstars.vs", "./data/tunnelstars.fs");
	-- great rotating star universe;  a lost-in-space feel (not a wormhole feel).

	-- from Island:
	tunshadid1 := loadshaders("./data/tunnelstars.vs", "./data/mystartunnel.fs");
	-- forward thru a rotating colored star tunnel with wormhole feel.

---------------------------------------------------------------------------------

	-- dungeon local:
	--tunshadid2 := loadshaders("./data/tunnelstars.vs", "./data/myswiss2.fs");
	-- forward thru a rotating swiss cheese cavern
	-- awesome, but graphically heavier than myspiral.fs

	-- dungeon local:
	tunshadid2 := loadshaders("./data/tunnelstars.vs", "./data/myspiral.fs");
	-- very nice too;  great lightweight color spiral (no stars)

---------------------------------------------------------------------------------


	tuntimeid1 := glgetuniformlocation(tunshadid1, ptime); -- need glint
	tunresid1  := glgetuniformlocation(tunshadid1, presol);
	tunmatid1  := glgetuniformlocation(tunshadid1, pmvp);

	tuntimeid2 := glgetuniformlocation(tunshadid2, ptime);
	tunresid2  := glgetuniformlocation(tunshadid2, presol);
	tunmatid2  := glgetuniformlocation(tunshadid2, pmvp);

	tuntimeid3 := glgetuniformlocation(tunshadid3, ptime);
	tunresid3  := glgetuniformlocation(tunshadid3, presol);
	tunmatid3  := glgetuniformlocation(tunshadid3, pmvp);




	--very nice black&white clouds in a black sky (lightweight)
	star2shadid := loadshaders("./data/skyX.vs", "./data/bw2clouds.fs"); --gluint
	star2timeid := glgetuniformlocation(star2shadid, ptime); -- need glint
	star2resid  := glgetuniformlocation(star2shadid, presol);
	star2matid  := glgetuniformlocation(star2shadid, pmvp);

	-- portal-exterior discard uniforms
	sunifside := glgetuniformlocation(star2shadid, pside);
	sunifme  := glgetuniformlocation(star2shadid, pme);
	sunifport1:=glgetuniformlocation(star2shadid,pport1);
	sunifport2:=glgetuniformlocation(star2shadid,pport2);




	--preferred colored stars in moving galaxy clouds
	starshadid := loadshaders("./data/skyX.vs", "./data/starfield3.fs"); --gluint
	startimeid := glgetuniformlocation(starshadid, ptime); -- need glint
	starresid  := glgetuniformlocation(starshadid, presol);
	starmatid  := glgetuniformlocation(starshadid, pmvp);

	-- portal-exterior discard uniforms
	stunifside := glgetuniformlocation(starshadid, pside);
	stunifme  := glgetuniformlocation(starshadid, pme);
	stunifport1:=glgetuniformlocation(starshadid,pport1);
	stunifport2:=glgetuniformlocation(starshadid,pport2);




-- fish begin -------------------------------------------------------------
	fishtexshadid := loadshaders("./data/fishw2.vs","./data/fish.fs");
	fishmatrixid := glgetuniformlocation(fishtexshadid, pmvp);
	fishuniftime := glgetuniformlocation(fishtexshadid, pmytime);
	fcenid       := glgetuniformlocation(fishtexshadid, pwPos);

	fishunifrad  := glGetUniformLocation( fishTexShadID, prad );     
	fishunifsvel := glGetUniformLocation( fishTexShadID, psvel );     
	fishunifwvel := glGetUniformLocation( fishTexShadID, pwvel );     
	fishunifwamp := glGetUniformLocation( fishTexShadID, pwamp );

	fishunifrot := glGetUniformLocation( fishTexShadID, prot ); --28jan17

------ fish.fs:

	fishuniftex  := glgetuniformlocation(fishtexshadid, pmyts);

	-- portal-exterior discard uniforms (fish.fs)
	funifside := glgetuniformlocation(fishtexshadid, pside);
	funifme  := glgetuniformlocation(fishtexshadid, pme);
	funifport1:=glgetuniformlocation(fishtexshadid,pport1);
	funifport2:=glgetuniformlocation(fishtexshadid,pport2);



-- fish end -------------------------------------------------------------



	poolshadid := loadshaders("./data/poolobjFog.vs","./data/bluwater.fs");
	poolmvid := glgetuniformlocation(poolshadid, pmv);
	poolmatid := glgetuniformlocation(poolshadid, pmvp);
	timeid    := glgetuniformlocation(poolshadid, pmytime);
	wlevid    := glgetuniformlocation(poolshadid, pwaterlevel);
	pradid    := glgetuniformlocation(poolshadid, pwRad);
	pcenid    := glgetuniformlocation(poolshadid, pwPos);

	bunifside := glgetuniformlocation(poolshadid, pside);
	bunifme  := glgetuniformlocation(poolshadid, pme);
	bunifport1:=glgetuniformlocation(poolshadid,pport1);
	bunifport2:=glgetuniformlocation(poolshadid,pport2);



	-- 16nov17 similar effect but lighter-weight :
	dpoolshadid := loadshaders("./data/poolobjFog.vs","./data/darkwater.fs");
	dpoolmvid := glgetuniformlocation(dpoolshadid, pmv);
	dpoolmatid := glgetuniformlocation(dpoolshadid, pmvp);
	dtimeid    := glgetuniformlocation(dpoolshadid, pmytime);
	dwlevid    := glgetuniformlocation(dpoolshadid, pwaterlevel);
	dpradid    := glgetuniformlocation(dpoolshadid, pwRad);
	dpcenid    := glgetuniformlocation(dpoolshadid, pwPos);

	dunifside := glgetuniformlocation(dpoolshadid, pside);
	dunifme  := glgetuniformlocation(dpoolshadid, pme);
	dunifport1:=glgetuniformlocation(dpoolshadid,pport1);
	dunifport2:=glgetuniformlocation(dpoolshadid,pport2);


	lava_texid := loadPng(mirror,"data/explosion.png");


	-- original circular wave ftn with fancy frag shader:
	lpoolshadid := loadshaders("./data/volcano.vs", "./data/volcano.fs");

	lpoolmvid := glgetuniformlocation(lpoolshadid, pmv);
	lpoolmatid := glgetuniformlocation(lpoolshadid, pmvp);
	lresid  := glgetuniformlocation(lpoolshadid, presol);
	ltimeid := glgetuniformlocation(lpoolshadid, pmytime);
	lwlevid := glgetuniformlocation(lpoolshadid, pwaterlevel);
	lpradid := glgetuniformlocation(lpoolshadid, pwRad);
	lpcenid := glgetuniformlocation(lpoolshadid, pwPos);

	lunifside := glgetuniformlocation(lpoolshadid, pside);
	lunifme  := glgetuniformlocation(lpoolshadid, pme);
	lunifport1:=glgetuniformlocation(lpoolshadid,pport1);
	lunifport2:=glgetuniformlocation(lpoolshadid,pport2);





------- begin typical shaders with lighting ------------------------------------
	pgmtexshadid := loadshaders("./data/texhalf.vs", "./data/texhalf.fs");
	unifprad:= glgetuniformlocation(pgmtexshadid,pprad); 
	unifisel:= glgetuniformlocation(pgmtexshadid,pisel); 
	unifport1:=glgetuniformlocation(pgmtexshadid,pport1);
	unifport2:=glgetuniformlocation(pgmtexshadid,pport2);
	mvid := glgetuniformlocation(pgmtexshadid, pmv);
	matrixid := glgetuniformlocation(pgmtexshadid, pmvp);
	uniftex  := glgetuniformlocation(pgmtexshadid, pmyts);

	uniflev  := glgetuniformlocation(pgmtexshadid, pmylev);
	unifclr  := glgetuniformlocation(pgmtexshadid, pmyclr);

	unifopac := glgetuniformlocation(pgmtexshadid, popac); --to reduce opacity

	unifside := glgetuniformlocation(pgmtexshadid, pside);
	unifme  := glgetuniformlocation(pgmtexshadid, pme);

	---------------------- begin lighting effects addendum ----------------------
	uniflag := glgetuniformlocation(pgmtexshadid, pflag); --lightingEffects flag
	-- set to zero unless object defines normals

	unifpcol := glgetuniformlocation(pgmtexshadid, ppcolor);
	unifpos1 := glgetuniformlocation(pgmtexshadid, ppos1);
	unifpos2 := glgetuniformlocation(pgmtexshadid, ppos2);
	unifpos3 := glgetuniformlocation(pgmtexshadid, ppos3);

	unifeye := glgetuniformlocation(pgmtexshadid, peyepos);

------- end typical lighting shaders -------------------------------------------





------- begin turtle shaders ------------------------------------
	tpgmtexshadid := loadshaders("./data/turtle.vs", "./data/turt.fs");
	tmvid := glgetuniformlocation(tpgmtexshadid, pmv);      -- vs3
	tmatrixid := glgetuniformlocation(tpgmtexshadid, pmvp); -- vs2
	tuniftex  := glgetuniformlocation(tpgmtexshadid, pmyts); -- fs1

	tfcenid   := glgetuniformlocation(tpgmtexshadid, pwPos); -- vs5
	tfangid   := glgetuniformlocation(tpgmtexshadid, pangl); -- vs6

	tuniflev  := glgetuniformlocation(tpgmtexshadid, pmylev); --FOG fs11
	tunifclr  := glgetuniformlocation(tpgmtexshadid, pmyclr); --FOG fs11

	-- portal-exterior-discard uniforms
	tunifside := glgetuniformlocation(tpgmtexshadid, pside); -- fs7
	tunifme  := glgetuniformlocation(tpgmtexshadid, pme); -- fs10
	tunifport1:=glgetuniformlocation(tpgmtexshadid,pport1);
	tunifport2:=glgetuniformlocation(tpgmtexshadid,pport2);


	---------------------- begin lighting effects addendum ----------------
	tuniflag := glgetuniformlocation(tpgmtexshadid, pflag); -- flag fs2 vs4
	-- set to zero unless object defines normals
	-- and lighting effects are desired

	tunifpcol := glgetuniformlocation(tpgmtexshadid, ppcolor); -- fs3
	tunifpos1 := glgetuniformlocation(tpgmtexshadid, ppos1); -- fs4
	tunifpos2 := glgetuniformlocation(tpgmtexshadid, ppos2); -- fs5
	tunifpos3 := glgetuniformlocation(tpgmtexshadid, ppos3); -- fs6
	tunifeye  := glgetuniformlocation(tpgmtexshadid, peyepos);

	---------------------- end lighting effects addendum ----------------

------- end turtle shaders --------------------------------------

	turtle_texid := loadPng(mirror,"data/turtbody2.png"); 
	turhead_texid := loadPng(mirror,"data/turthead4.png"); 

	turtleobj.setround(turtle, 0.4, 0.3, 0.5);
	turtleobj.setround(turhead, 0.1, 0.05, 0.2);

	-- 16 uniforms 11fs, 6vs (1 used twice)












	-- level 2 reflective pool:
	rpoolshadid := loadshaders("./data/reflwater.vs", "./data/reflwater.fs");
	envmapid   := glgetuniformlocation(rpoolshadid, penvmap);
	rpeyeid    := glgetuniformlocation(rpoolshadid, peyePos);
	rpoolmvid := glgetuniformlocation(rpoolshadid, pmv);
	rpoolmatid := glgetuniformlocation(rpoolshadid, pmvp);
	rtimeid    := glgetuniformlocation(rpoolshadid, pmytime);
	rwlevid    := glgetuniformlocation(rpoolshadid, pwaterlevel);
	rpradid    := glgetuniformlocation(rpoolshadid, pwRad);
	rpcenid    := glgetuniformlocation(rpoolshadid, pwPos);

	runifside := glgetuniformlocation(rpoolshadid, pside);
	runifme  := glgetuniformlocation(rpoolshadid, pme);
	runifport1:=glgetuniformlocation(rpoolshadid,pport1);
	runifport2:=glgetuniformlocation(rpoolshadid,pport2);


	-- level 2 reflective pool;  
	-- Here, only used as reflective environment, but not drawn.
	-- ...in this case, a close match to actual environment...
	cubemap_texid := loadCubePng(
	"data/woodenceiling2.png",	"data/woodenceiling2.png",
	"data/grungeRGBA.png",	   "data/grungeRGBA.png",
	"data/woodenceiling2.png", "data/grungeRGBA.png");



------ begin level 5 epilog setup ----------------------------------------------

	-- pretty awesome:
	-- used as reflective environment, but also drawn
	circubemap_texid := loadCubePng(
	"data/skyBoxes/totality/ft.png",	"data/skyBoxes/totality/bk.png",
	"data/skyBoxes/totality/upmsg.png",	"data/skyBoxes/totality/dn.png",
	"data/skyBoxes/totality/rt.png",	"data/skyBoxes/totality/lf.png"	);


	pidskyb := loadshaders("./data/osky.vs", "./data/osky.fs");
	sbmvpuid := glgetuniformlocation(pidskyb, pmvp);
	sbmapuid := glgetuniformlocation(pidskyb, pcubemap);

	pidskyw := loadshaders("./data/sundown.vs", "./data/sundown.fs");
	cmvpuid  := glgetuniformlocation(pidskyw, pmvp);
	ctimeid  := glgetuniformlocation(pidskyw, pmytime);
	cwlevid  := glgetuniformlocation(pidskyw, pwaterlevel);
	cpeyeid  := glgetuniformlocation(pidskyw, peyePos);
	cemuid   := glgetuniformlocation(pidskyw, penvMap);

------ end level 5 epilog setup ------------------------------------------------



-- load textures used in all levels:


	lining_texid := loadPng(mirror,"data/bricksr.png");


	opaqueport_texid := loadPng(mirror,"data/stargate_opaque.png");
	port_texid := loadPng(mirror,"data/stargate_texture.png");
	offport_texid := loadPng(mirror,"data/stargate_off.png");
	xbox1_texid := loadPng(mirror,"data/door.png");
	xbox2_texid := loadPng(mirror,"data/stargate_off.png");
	barloc0_texid:= loadPng(mirror,"data/stargate_off.png");
	offportr_texid:= loadPng(mirror,"data/stargateRed_off.png");
	offportg_texid:= loadPng(mirror,"data/stargateGreen_off.png");
	barloc1_texid:= loadPng(mirror,"data/stargate_texture.png");

	granite_texid  := loadPng(mirror,"data/granitergb.png");
	grunge_texid := loadPng(mirror,"data/grungeRGBA.png");

	bricksw_texid  := loadPng(mirror,"data/bricksq.png");
	woodw_texid := loadPng(mirror,"data/woodenceilingW.png");
	woodt_texid := loadPng(mirror,"data/woodenceilingT.png");
	wood2_texid := loadPng(mirror,"data/woodenceiling2.png");


	adobe_texid := loadPng(mirror,"data/wallT.png"); 
	--dark, contrasting adobe

	pfish_texid  := loadPng(mirror,"data/p1.png");

	-- ...and these 3 others are loaded dynamically (per level):
	-- room_texid,  pic_texid, ceil_texid



---- ava begin ----------------------------

	avaTexShadID:=LoadShaders("./data/avatarobj.vs","./data/avatarobj.fs");
	avaunifmat := glGetUniformLocation( avaTexShadID, pmvp );     
	avaunifcen := glGetUniformLocation(avaTexShadID, pwpos); --// vec3
	avaunifang := glgetuniformlocation(avatexshadid, phori); --horiAng
	avauniftime := glGetUniformLocation( avaTexShadID, pmytime );
	avaunifdir := glGetUniformLocation( avaTexShadID, pmydir );
	avaunifade := glGetUniformLocation( avaTexShadID, pmyfade );
	avainterior := glGetUniformLocation( avaTexShadID, pinterior );
	avauniftex := glGetUniformLocation( avaTexShadID, pmyts );
	ava_texid := loadPng(mirror,"data/skin.png",false); --noInvert

	avatarobj.setrect(ava);


end setup_textures; -----------------------------------------------



