/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.activities;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.activities.ActivitiesListener;
import com.biglybt.activities.ActivitiesLoadedListener;
import com.biglybt.core.Core;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.messenger.config.PlatformVuzeActivitiesMessenger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivitiesManager {
    private static final long MAX_LIFE_MS = 63072000000L;
    private static final long DEFAULT_PLATFORM_REFRESH = 86400000L;
    private static final String SAVE_FILENAME = "VuzeActivities.config";
    private static final ArrayList<ActivitiesListener> listeners = new ArrayList();
    private static ArrayList<ActivitiesLoadedListener> listenersLoaded = new ArrayList();
    private static final Object listenersLoadedLock = new Object();
    private static final CopyOnWriteList<ActivitiesEntry> allEntries = new CopyOnWriteList();
    private static final AEMonitor allEntries_mon = new AEMonitor("VuzeActivityMan");
    private static final List<ActivitiesEntry> removedEntries = new ArrayList<ActivitiesEntry>();
    private static PlatformVuzeActivitiesMessenger.GetEntriesReplyListener replyListener;
    static AEDiagnosticsLogger diag_logger;
    private static Map<String, Long> lastNewsAt;
    private static boolean skipAutoSave;
    private static final AEMonitor config_mon;
    static boolean saveEventsOnClose;

    static {
        lastNewsAt = new HashMap<String, Long>();
        skipAutoSave = true;
        config_mon = new AEMonitor("ConfigMon");
        saveEventsOnClose = false;
        if (System.getProperty("debug.vuzenews", "0").equals("1")) {
            diag_logger = AEDiagnostics.getLogger("v3.vuzenews");
            diag_logger.log("\n\nVuze News Logging Starts");
        } else {
            diag_logger = null;
        }
    }

    public static void initialize(final Core core) {
        new AEThread2("lazy init", true){

            @Override
            public void run() {
                ActivitiesManager._initialize(core);
            }
        }.start();
    }

    static void _initialize(Core core) {
        if (diag_logger != null) {
            diag_logger.log("Initialize Called");
        }
        core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void stopping(Core core) {
                if (saveEventsOnClose) {
                    ActivitiesManager.saveEventsNow();
                }
            }
        });
        ActivitiesManager.loadEvents();
        replyListener = new PlatformVuzeActivitiesMessenger.GetEntriesReplyListener(){

            @Override
            public void gotVuzeNewsEntries(ActivitiesEntry[] entries, long refreshInMS) {
                if (diag_logger != null) {
                    diag_logger.log("Received Reply from platform with " + entries.length + " entries.  Refresh in " + refreshInMS);
                }
                ActivitiesManager.addEntries(entries);
                if (refreshInMS <= 0L) {
                    refreshInMS = 86400000L;
                }
                SimpleTimer.addEvent("GetVuzeNews", SystemTime.getOffsetTime(refreshInMS), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        ActivitiesManager.pullActivitiesNow(5000L, "timer", false);
                    }
                });
            }
        };
        ActivitiesManager.pullActivitiesNow(5000L, "initial", false);
    }

    public static void pullActivitiesNow(long delay, String reason, boolean alwaysPull) {
        String id = "1";
        Long oLastPullTime = lastNewsAt.get(id);
        long lastPullTime = oLastPullTime != null ? oLastPullTime : 0L;
        long now = SystemTime.getCurrentTime();
        long diff = now - lastPullTime;
        if (!alwaysPull && diff < 5000L) {
            return;
        }
        if (diff > 63072000000L) {
            diff = 63072000000L;
        }
        PlatformVuzeActivitiesMessenger.getEntries(diff, delay, reason, replyListener);
    }

    public static void clearLastPullTimes() {
        lastNewsAt = new HashMap<String, Long>();
    }

    public static void resetRemovedEntries() {
        removedEntries.clear();
        ActivitiesManager.saveEvents();
    }

    private static void saveEvents() {
        saveEventsOnClose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEvents() {
        block42: {
            Object value;
            long cutoffTime;
            block41: {
                List newRemovedEntries;
                long lastVuzeNewsAt;
                Map map;
                block40: {
                    skipAutoSave = true;
                    map = FileUtil.readResilientConfigFile(SAVE_FILENAME);
                    if (map == null || map.size() <= 0 || MapUtils.getMapLong(map, "version", 0L) >= 2L) break block40;
                    ActivitiesManager.clearLastPullTimes();
                    skipAutoSave = false;
                    ActivitiesManager.saveEventsNow();
                    skipAutoSave = false;
                    Object object = listenersLoadedLock;
                    synchronized (object) {
                        if (listenersLoaded != null) {
                            for (ActivitiesLoadedListener l : listenersLoaded) {
                                try {
                                    l.vuzeActivitiesLoaded();
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                }
                            }
                            listenersLoaded = null;
                        }
                    }
                    return;
                }
                cutoffTime = ActivitiesManager.getCutoffTime();
                try {
                    lastNewsAt = MapUtils.getMapMap(map, "LastChecks", new HashMap());
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                if (lastNewsAt.size() == 0 && (lastVuzeNewsAt = MapUtils.getMapLong(map, "LastCheck", 0L)) > 0L) {
                    if (lastVuzeNewsAt < cutoffTime) {
                        lastVuzeNewsAt = cutoffTime;
                    }
                    lastNewsAt.put("1", lastVuzeNewsAt);
                }
                if ((newRemovedEntries = (List)MapUtils.getMapObject(map, "removed-entries", null, List.class)) != null) {
                    for (Object newRemovedEntry : newRemovedEntries) {
                        ActivitiesEntry entry;
                        value = newRemovedEntry;
                        if (!(value instanceof Map) || (entry = ActivitiesManager.createEntryFromMap((Map)value, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                        removedEntries.add(entry);
                    }
                }
                if ((value = map.get("entries")) instanceof List) break block41;
                skipAutoSave = false;
                Object object = listenersLoadedLock;
                synchronized (object) {
                    if (listenersLoaded != null) {
                        for (ActivitiesLoadedListener l : listenersLoaded) {
                            try {
                                l.vuzeActivitiesLoaded();
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        listenersLoaded = null;
                    }
                }
                return;
            }
            try {
                List entries = (List)value;
                ArrayList<ActivitiesEntry> entriesToAdd = new ArrayList<ActivitiesEntry>(entries.size());
                for (Object entry1 : entries) {
                    ActivitiesEntry entry;
                    value = entry1;
                    if (!(value instanceof Map) || (entry = ActivitiesManager.createEntryFromMap((Map)value, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                    entriesToAdd.add(entry);
                }
                int num = entriesToAdd.size();
                if (num > 0) {
                    ActivitiesManager.addEntries(entriesToAdd.toArray(new ActivitiesEntry[num]));
                }
                break block42;
            }
            catch (Throwable throwable) {
                skipAutoSave = false;
                Object object = listenersLoadedLock;
                synchronized (object) {
                    if (listenersLoaded != null) {
                        for (ActivitiesLoadedListener l : listenersLoaded) {
                            try {
                                l.vuzeActivitiesLoaded();
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        listenersLoaded = null;
                    }
                }
            }
            throw throwable;
        }
        skipAutoSave = false;
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                for (ActivitiesLoadedListener l : listenersLoaded) {
                    try {
                        l.vuzeActivitiesLoaded();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                listenersLoaded = null;
            }
        }
    }

    static void saveEventsNow() {
        if (skipAutoSave) {
            return;
        }
        try {
            try {
                config_mon.enter();
                HashMap<String, Object> mapSave = new HashMap<String, Object>();
                mapSave.put("LastChecks", lastNewsAt);
                mapSave.put("version", 2L);
                ArrayList<Map<String, Object>> entriesList = new ArrayList<Map<String, Object>>();
                List<ActivitiesEntry> allEntries = ActivitiesManager.getAllEntries();
                for (ActivitiesEntry entry : allEntries) {
                    boolean isHeader;
                    if (entry == null || (isHeader = "Header".equals(entry.getTypeID()))) continue;
                    entriesList.add(entry.toMap());
                }
                mapSave.put("entries", entriesList);
                ArrayList<Map<String, Object>> removedEntriesList = new ArrayList<Map<String, Object>>();
                for (ActivitiesEntry entry : removedEntries) {
                    removedEntriesList.add(entry.toDeletedMap());
                }
                mapSave.put("removed-entries", removedEntriesList);
                FileUtil.writeResilientConfigFile(SAVE_FILENAME, mapSave);
            }
            catch (Throwable t) {
                Debug.out(t);
                config_mon.exit();
            }
        }
        finally {
            config_mon.exit();
        }
    }

    private static long getCutoffTime() {
        return SystemTime.getOffsetTime(-63072000000L);
    }

    public static void addListener(ActivitiesListener l) {
        listeners.add(l);
    }

    public static void removeListener(ActivitiesListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ActivitiesLoadedListener l) {
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                listenersLoaded.add(l);
            } else {
                try {
                    l.vuzeActivitiesLoaded();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ActivitiesLoadedListener l) {
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                listenersLoaded.remove(l);
            }
        }
    }

    public static ActivitiesEntry[] addEntries(ActivitiesEntry[] entries) {
        long cutoffTime = ActivitiesManager.getCutoffTime();
        ArrayList<ActivitiesEntry> newEntries = new ArrayList<ActivitiesEntry>(entries.length);
        ArrayList<ActivitiesEntry> existingEntries = new ArrayList<ActivitiesEntry>(0);
        try {
            allEntries_mon.enter();
            ActivitiesEntry[] activitiesEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ActivitiesEntry entry = activitiesEntryArray[n2];
                boolean isHeader = "Header".equals(entry.getTypeID());
                if ((entry.getTimestamp() >= cutoffTime || isHeader) && !removedEntries.contains(entry)) {
                    ActivitiesEntry existing_entry = allEntries.get(entry);
                    if (existing_entry != null) {
                        existingEntries.add(existing_entry);
                        if (existing_entry.getTimestamp() < entry.getTimestamp()) {
                            existing_entry.updateFrom(entry);
                        }
                    } else {
                        newEntries.add(entry);
                        allEntries.add(entry);
                    }
                }
                ++n2;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        ActivitiesEntry[] newEntriesArray = newEntries.toArray(new ActivitiesEntry[newEntries.size()]);
        if (newEntriesArray.length > 0) {
            Object[] listenersArray;
            ActivitiesManager.saveEventsNow();
            Object[] objectArray = listenersArray = listeners.toArray();
            int n = listenersArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object aListenersArray = objectArray[n3];
                ActivitiesListener l = (ActivitiesListener)aListenersArray;
                l.vuzeNewsEntriesAdded(newEntriesArray);
                ++n3;
            }
        }
        if (existingEntries.size() > 0) {
            if (newEntriesArray.length == 0) {
                ActivitiesManager.saveEvents();
            }
            for (ActivitiesEntry entry : existingEntries) {
                ActivitiesManager.triggerEntryChanged(entry);
            }
        }
        return newEntriesArray;
    }

    public static void removeEntries(ActivitiesEntry[] entries) {
        ActivitiesManager.removeEntries(entries, false);
    }

    public static void removeEntries(ActivitiesEntry[] entries, boolean allowReAdd) {
        Object[] listenersArray;
        int n;
        long cutoffTime = ActivitiesManager.getCutoffTime();
        try {
            allEntries_mon.enter();
            ActivitiesEntry[] activitiesEntryArray = entries;
            n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ActivitiesEntry entry = activitiesEntryArray[n2];
                if (entry != null) {
                    allEntries.remove(entry);
                    boolean isHeader = "Header".equals(entry.getTypeID());
                    if (!(allowReAdd || entry.getTimestamp() <= cutoffTime || isHeader || entry.allowReAdd())) {
                        removedEntries.add(entry);
                    }
                }
                ++n2;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        Object[] objectArray = listenersArray = listeners.toArray();
        int n3 = listenersArray.length;
        n = 0;
        while (n < n3) {
            Object aListenersArray = objectArray[n];
            ActivitiesListener l = (ActivitiesListener)aListenersArray;
            l.vuzeNewsEntriesRemoved(entries);
            ++n;
        }
        ActivitiesManager.saveEventsNow();
    }

    public static ActivitiesEntry getEntryByID(String id) {
        try {
            allEntries_mon.enter();
            for (ActivitiesEntry entry : allEntries) {
                String entryID;
                if (entry == null || (entryID = entry.getID()) == null || !entryID.equals(id)) continue;
                ActivitiesEntry activitiesEntry = entry;
                return activitiesEntry;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        return null;
    }

    public static boolean isEntryIdRemoved(String id) {
        for (ActivitiesEntry entry : removedEntries) {
            if (!entry.getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static List<ActivitiesEntry> getAllEntries() {
        return allEntries.getList();
    }

    public static Object[] getMostRecentUnseen() {
        ActivitiesEntry newest = null;
        long newest_time = 0L;
        int num_unseen = 0;
        for (ActivitiesEntry entry : allEntries) {
            if (entry.getViewed()) continue;
            ++num_unseen;
            long t = entry.getTimestamp();
            if (t <= newest_time) continue;
            newest = entry;
            newest_time = t;
        }
        return new Object[]{newest, num_unseen};
    }

    public static int getNumEntries() {
        return allEntries.size();
    }

    public static void log(String s) {
        if (diag_logger != null) {
            diag_logger.log(s);
        }
    }

    public static void triggerEntryChanged(ActivitiesEntry entry) {
        Object[] listenersArray;
        Object[] objectArray = listenersArray = listeners.toArray();
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object aListenersArray = objectArray[n2];
            ActivitiesListener l = (ActivitiesListener)aListenersArray;
            l.vuzeNewsEntryChanged(entry);
            ++n2;
        }
        ActivitiesManager.saveEvents();
    }

    public static ActivitiesEntry createEntryFromMap(Map<?, ?> map, boolean internalMap) {
        ActivitiesEntry entry = new ActivitiesEntry();
        if (internalMap) {
            entry.loadFromInternalMap(map);
        } else {
            entry.loadFromExternalMap(map);
        }
        return entry;
    }
}

