/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.config.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.ConfigurationParameterNotFoundException;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.speedmanager.impl.v2.SpeedLimitConfidence;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.ConcurrentHashMapWrapper;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ConfigurationDefaults {
    private static final Long ZERO = new Long(0L);
    private static final Long ONE = new Long(1L);
    private static final Long SIXTY = new Long(60L);
    private static final Long FALSE = ZERO;
    private static final Long TRUE = ONE;
    private static ConfigurationDefaults configdefaults;
    private static final AEMonitor class_mon;
    private ConcurrentHashMapWrapper<String, Object> def = null;
    public static final int def_int = 0;
    public static final long def_long = 0L;
    public static final float def_float = 0.0f;
    public static final int def_boolean = 0;
    public static final String def_String = "";
    public static final byte[] def_bytes;
    public static final String DEFAULT_FILE_CONVERSION_CHARS = "\"='";
    private final Hashtable parameter_verifiers = new Hashtable();
    public static final String CFG_TORRENTADD_OPENOPTIONS_MANY = "many";
    public static final String CFG_TORRENTADD_OPENOPTIONS_ALWAYS = "always";
    public static final String CFG_TORRENTADD_OPENOPTIONS_NEVER = "never";
    public static final String CFG_TORRENTADD_OPENOPTIONS = "ui.addtorrent.openoptions";
    public static final String CFG_TORRENTADD_OPENOPTIONS_SEP = "ui.addtorrent.openoptions.sep";

    static {
        class_mon = new AEMonitor("ConfigDef");
        def_bytes = null;
    }

    public static ConfigurationDefaults getInstance() {
        try {
            class_mon.enter();
            if (configdefaults == null) {
                try {
                    configdefaults = new ConfigurationDefaults();
                }
                catch (Throwable e) {
                    System.out.println("Falling back to default defaults as environment is restricted");
                    configdefaults = new ConfigurationDefaults(new HashMap());
                }
            }
            ConfigurationDefaults configurationDefaults = configdefaults;
            return configurationDefaults;
        }
        finally {
            class_mon.exit();
        }
    }

    protected ConfigurationDefaults() {
        LogIDs[] configurableLOGIDs;
        this.def = new ConcurrentHashMapWrapper(2000, 0.75f, 8);
        this.def.put("Override Ip", def_String);
        this.def.put("Enable incremental file creation", FALSE);
        this.def.put("Enable reorder storage mode", FALSE);
        this.def.put("Reorder storage mode min MB", new Long(10L));
        this.def.put("TCP.Listen.Port", new Long(6881L));
        this.def.put("TCP.Listen.Port.Enable", TRUE);
        this.def.put("TCP.Listen.Port.Override", def_String);
        this.def.put("UDP.Listen.Port", new Long(6881L));
        this.def.put("UDP.Listen.Port.Enable", TRUE);
        this.def.put("UDP.NonData.Listen.Port", new Long(6881L));
        this.def.put("UDP.NonData.Listen.Port.Same", TRUE);
        this.def.put("HTTP.Data.Listen.Port", new Long(Constants.isWindows ? 80 : 8080));
        this.def.put("HTTP.Data.Listen.Port.Override", ZERO);
        this.def.put("HTTP.Data.Listen.Port.Enable", FALSE);
        this.def.put("Listen.Port.Randomize.Enable", FALSE);
        this.def.put("Listen.Port.Randomize.Together", TRUE);
        this.def.put("Listen.Port.Randomize.Range", "10000-65535");
        this.def.put("peercontrol.tcp.public.enable", TRUE);
        this.def.put("peercontrol.udp.public.enable", TRUE);
        this.def.put("webseed.activation.uses.availability", TRUE);
        this.def.put("webseed.activation.min.speed.kbps", 5);
        this.def.put("IPV6 Enable Support", FALSE);
        this.def.put("IPV6 Enable Multiple Address Checks", TRUE);
        this.def.put("IPV6 Prefer Addresses", FALSE);
        this.def.put("IPV4 Prefer Stack", FALSE);
        this.def.put("IPV4 Ignore Network Addresses", FALSE);
        this.def.put("IPV6 Ignore Network Addresses", FALSE);
        this.def.put("max active torrents", new Long(4L));
        this.def.put("max downloads", new Long(4L));
        this.def.put("min downloads", ONE);
        this.def.put("Newly Seeding Torrents Get First Priority", TRUE);
        this.def.put("Max.Peer.Connections.Per.Torrent", new Long(50L));
        this.def.put("Max.Peer.Connections.Per.Torrent.When.Seeding", new Long(25L));
        this.def.put("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", TRUE);
        this.def.put("Max.Peer.Connections.Total", new Long(250L));
        this.def.put("Non-Public Peer Extra Slots Per Torrent", 2);
        this.def.put("Non-Public Peer Extra Connections Per Torrent", 4);
        this.def.put("Peer.Fast.Initial.Unchoke.Enabled", FALSE);
        this.def.put("File Max Open", new Long(50L));
        this.def.put("Use Config File Backups", TRUE);
        this.def.put("Max Uploads", new Long(4L));
        this.def.put("Max Uploads Seeding", new Long(4L));
        this.def.put("enable.seedingonly.maxuploads", FALSE);
        this.def.put("max.uploads.when.busy.inc.min.secs", new Long(30L));
        this.def.put("Max Download Speed KBs", ZERO);
        this.def.put("Down Rate Limits Include Protocol", TRUE);
        this.def.put("Use Request Limiting", TRUE);
        this.def.put("Use Request Limiting Priorities", TRUE);
        this.def.put("Max Upload Speed KBs", ZERO);
        this.def.put("Max Upload Speed Seeding KBs", ZERO);
        this.def.put("Up Rate Limits Include Protocol", FALSE);
        this.def.put("enable.seedingonly.upload.rate", FALSE);
        this.def.put("Max Seeds Per Torrent", ZERO);
        this.def.put("Auto Upload Speed Enabled", FALSE);
        this.def.put("Auto Upload Speed Seeding Enabled", FALSE);
        this.def.put("AutoSpeed Available", FALSE);
        this.def.put("AutoSpeed Min Upload KBs", ZERO);
        this.def.put("AutoSpeed Max Upload KBs", ZERO);
        this.def.put("AutoSpeed Max Increment KBs", ONE);
        this.def.put("AutoSpeed Max Decrement KBs", new Long(4L));
        this.def.put("AutoSpeed Choking Ping Millis", new Long(200L));
        this.def.put("AutoSpeed Download Adj Enable", FALSE);
        this.def.put("AutoSpeed Download Adj Ratio", "1.0");
        this.def.put("AutoSpeed Latency Factor", new Long(50L));
        this.def.put("AutoSpeed Forced Min KBs", new Long(4L));
        this.def.put("Auto Upload Speed Debug Enabled", FALSE);
        this.def.put("Auto Adjust Transfer Defaults", TRUE);
        this.def.put("Bias Upload Enable", TRUE);
        this.def.put("Bias Upload Slack KBs", new Long(5L));
        this.def.put("Bias Upload Handle No Limit", TRUE);
        this.def.put("ASN Autocheck Performed Time", ZERO);
        this.def.put("LAN Speed Enabled", TRUE);
        this.def.put("Max LAN Download Speed KBs", ZERO);
        this.def.put("Max LAN Upload Speed KBs", ZERO);
        this.def.put("On Resume Recheck All", FALSE);
        this.def.put("Save Resume Interval", new Long(5L));
        this.def.put("Check Pieces on Completion", TRUE);
        this.def.put("Check Pieces on Completion Before Move", FALSE);
        this.def.put("Merge Same Size Files", TRUE);
        this.def.put("Merge Same Size Files Extended", FALSE);
        this.def.put("Merge Same Size Files Tolerance", ZERO);
        this.def.put("Merge Same Size Files Min Pieces", 5);
        this.def.put("Skip Complete Download File Checks", FALSE);
        this.def.put("Skip Incomplete Download File Checks", FALSE);
        this.def.put("Fail To Delete Origin File After Move Is Warning", FALSE);
        this.def.put("Stop Ratio", new Float(0.0f));
        this.def.put("Stop Peers Ratio", ZERO);
        this.def.put("Disconnect Seed", TRUE);
        this.def.put("Seeding Piece Check Recheck Enable", TRUE);
        this.def.put("priorityExtensions", def_String);
        this.def.put("priorityExtensionsIgnoreCase", FALSE);
        this.def.put("file.auto.sequential.exts", def_String);
        this.def.put("quick.view.exts", ".nfo;.txt;.rar;.gif;.jpg;.png;.bmp");
        this.def.put("quick.view.maxkb", new Long(512L));
        this.def.put("Rename Incomplete Files", FALSE);
        this.def.put("Rename Incomplete Files Extension", ".az!");
        this.def.put("Enable Subfolder for DND Files", FALSE);
        this.def.put("Subfolder for DND Files", ".dnd_az!");
        this.def.put("Max File Links Supported", 2048);
        this.def.put("Ip Filter Enabled", TRUE);
        this.def.put("Ip Filter Allow", FALSE);
        this.def.put("Ip Filter Enable Banning", TRUE);
        this.def.put("Ip Filter Disable For Updates", FALSE);
        this.def.put("Ip Filter Ban Block Limit", new Long(4L));
        this.def.put("Ip Filter Ban Discard Ratio", "5.0");
        this.def.put("Ip Filter Ban Discard Min KB", new Long(128L));
        this.def.put("Ip Filter Banning Persistent", TRUE);
        this.def.put("Ip Filter Dont Ban LAN", FALSE);
        this.def.put("Ip Filter Enable Description Cache", TRUE);
        this.def.put("Ip Filter Autoload File", def_String);
        this.def.put("Ip Filter V6 Autoload File", def_String);
        this.def.put("Ip Filter Autoload Last Date", ZERO);
        this.def.put("Ip Filter Autoload Days", 7L);
        this.def.put("Ip Filter Clear On Reload", TRUE);
        this.def.put("Allow Same IP Peers", FALSE);
        this.def.put("Dual IPV4 IPV6 Connection Action", ZERO);
        this.def.put("Use Super Seeding", FALSE);
        this.def.put("Enable Light Seeding", TRUE);
        this.def.put("StartStopManager_bAddForDownloadingSR1", TRUE);
        this.def.put("Start On Login", FALSE);
        this.def.put("Start In Low Resource Mode", FALSE);
        this.def.put("LRMS UI", TRUE);
        this.def.put("LRMS UDP Peers", TRUE);
        this.def.put("LRMS DHT Sleep", TRUE);
        this.def.put("Auto Register App", FALSE);
        this.def.put("Pause Downloads On Exit", FALSE);
        this.def.put("Resume Downloads On Start", FALSE);
        this.def.put("On Downloading Complete Do", "Nothing");
        this.def.put("On Seeding Complete Do", "Nothing");
        this.def.put("Stop Triggers Auto Reset", TRUE);
        this.def.put("Force Terminate After Mins", 2);
        this.def.put("Prompt To Abort Shutdown", TRUE);
        this.def.put("Prevent Sleep Downloading", TRUE);
        this.def.put("Prevent Sleep FP Seeding", FALSE);
        this.def.put("Prevent Sleep Tag", def_String);
        this.def.put("Auto Restart When Idle", ZERO);
        this.def.put("Auto Restart When Idle Prompt", TRUE);
        this.def.put("Download History Enabled", TRUE);
        this.def.put("User Mode", ZERO);
        this.def.put(CFG_TORRENTADD_OPENOPTIONS, CFG_TORRENTADD_OPENOPTIONS_ALWAYS);
        this.def.put(CFG_TORRENTADD_OPENOPTIONS_SEP, TRUE);
        File f = null;
        if (Constants.isAndroid) {
            try {
                File dirDownloads = PlatformManagerFactory.getPlatformManager().getLocation(5L);
                if (dirDownloads != null) {
                    f = FileUtil.newFile(dirDownloads, Constants.APP_NAME);
                }
            }
            catch (Throwable dirDownloads) {
                // empty catch block
            }
            if (f == null) {
                f = FileUtil.newFile(SystemProperties.getDocPath(), "Downloads");
            }
        } else {
            f = FileUtil.newFile(SystemProperties.getDocPath(), String.valueOf(Constants.APP_NAME) + " Downloads");
        }
        this.def.put("Default save path", f.getAbsolutePath());
        this.def.put("saveTo_list.max_entries", new Long(15L));
        this.def.put("update.start", TRUE);
        this.def.put("update.periodic", TRUE);
        this.def.put("update.opendialog", TRUE);
        this.def.put("update.autodownload", FALSE);
        this.def.put("update.anonymous", FALSE);
        this.def.put("Config Verify Frequency", new Long(1800000L));
        this.def.put("Send Version Info", TRUE);
        this.def.put("Logger.Enabled", FALSE);
        this.def.put("Logging Enable", FALSE);
        this.def.put("Logging Dir", def_String);
        this.def.put("Logging Timestamp", "HH:mm:ss.SSS");
        this.def.put("Logging Max Size", new Long(5L));
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 3;
        int[] logTypes = nArray;
        LogIDs[] logIDsArray = configurableLOGIDs = new LogIDs[]{LogIDs.STDOUT, LogIDs.ALERT, LogIDs.CORE, LogIDs.DISK, LogIDs.GUI, LogIDs.NET, LogIDs.NWMAN, LogIDs.PEER, LogIDs.PLUGIN, LogIDs.TRACKER, LogIDs.CACHE, LogIDs.PIECES};
        int n = configurableLOGIDs.length;
        int n2 = 0;
        while (n2 < n) {
            LogIDs logID = logIDsArray[n2];
            int[] nArray2 = logTypes;
            int n3 = logTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                int logType = nArray2[n4];
                this.def.put("bLog." + logType + "." + logID.toString(), TRUE);
                ++n4;
            }
            ++n2;
        }
        this.def.put("Logger.DebugFiles.Enabled", TRUE);
        this.def.put("Logger.DebugFiles.SizeKB", 256);
        this.def.put("Logger.DebugFiles.Enabled.Force", FALSE);
        this.def.put("Logging Enable UDP Transport", FALSE);
        this.def.put("Enable.Proxy", FALSE);
        this.def.put("Enable.SOCKS", FALSE);
        this.def.put("Proxy.Host", def_String);
        this.def.put("Proxy.Port", def_String);
        this.def.put("Proxy.Username", "<none>");
        this.def.put("Proxy.Password", def_String);
        this.def.put("Proxy.Check.On.Start", TRUE);
        this.def.put("Proxy.SOCKS.ShowIcon", TRUE);
        this.def.put("Proxy.SOCKS.ShowIcon.FlagIncoming", TRUE);
        this.def.put("Proxy.SOCKS.Tracker.DNS.Disable", TRUE);
        this.def.put("Proxy.SOCKS.disable.plugin.proxies", TRUE);
        this.def.put("Proxy.Data.Enable", FALSE);
        this.def.put("Proxy.Data.SOCKS.version", "V4");
        this.def.put("Proxy.Data.SOCKS.inform", TRUE);
        this.def.put("Proxy.Data.Same", TRUE);
        int i = 1;
        while (i <= 3) {
            if (i == 1) {
                this.def.put("Proxy.Data.Host", def_String);
                this.def.put("Proxy.Data.Port", def_String);
                this.def.put("Proxy.Data.Username", "<none>");
                this.def.put("Proxy.Data.Password", def_String);
            } else {
                this.def.put("Proxy.Data.Host." + i, def_String);
                this.def.put("Proxy.Data.Port." + i, def_String);
                this.def.put("Proxy.Data.Username." + i, "<none>");
                this.def.put("Proxy.Data.Password." + i, def_String);
            }
            ++i;
        }
        this.def.put("DNS Alt Servers", "8.8.8.8");
        this.def.put("DNS Alt Servers SOCKS Enable", TRUE);
        this.def.put("Start Num Peers", new Long(-1L));
        this.def.put("Max Upload Speed", new Long(-1L));
        this.def.put("Max Clients", new Long(-1L));
        this.def.put("Server.shared.port", TRUE);
        this.def.put("Low Port", new Long(6881L));
        this.def.put("Already_Migrated", FALSE);
        this.def.put("ID", def_String);
        this.def.put("Play Download Finished", FALSE);
        this.def.put("Play Download Finished File", def_String);
        this.def.put("Watch Torrent Folder", FALSE);
        this.def.put("Watch Torrent Folder Interval", ONE);
        this.def.put("Watch Torrent Folder Interval Secs", SIXTY);
        this.def.put("Start Watched Torrents Stopped", FALSE);
        this.def.put("Watch Torrents Add Mode", ZERO);
        this.def.put("Watch Torrent Always Rename", FALSE);
        this.def.put("Watch Torrent Folder Path", def_String);
        this.def.put("Watch Torrent Folder Path Count", ONE);
        this.def.put("Prioritize First Piece", FALSE);
        this.def.put("Prioritize First MB", 0);
        this.def.put("Prioritize First Piece Force", FALSE);
        this.def.put("Prioritize Most Completed Files", FALSE);
        this.def.put("Piece Picker Request Hint Enabled", TRUE);
        this.def.put("Use Lazy Bitfield", FALSE);
        this.def.put("Zero New", FALSE);
        this.def.put("Zero New Stop", FALSE);
        this.def.put("Enable Sparse Files", FALSE);
        this.def.put("XFS Allocation", FALSE);
        this.def.put("Copy And Delete Data Rather Than Move", FALSE);
        this.def.put("Move If On Same Drive", FALSE);
        this.def.put("File.save.peers.enable", TRUE);
        this.def.put("File.strict.locking", TRUE);
        this.def.put("Move Deleted Data To Recycle Bin", TRUE);
        this.def.put("Delete Partial Files On Library Removal", FALSE);
        this.def.put("Popup Download Finished", FALSE);
        this.def.put("Popup File Finished", FALSE);
        this.def.put("Popup Download Added", FALSE);
        this.def.put("Popup Check Complete", FALSE);
        this.def.put("Notify Download Finished", FALSE);
        this.def.put("Show Timestamp For Alerts", FALSE);
        this.def.put("Request Attention On New Download", TRUE);
        this.def.put("Activate Window On External Download", TRUE);
        this.def.put("Add Torrent Queue Position", ONE);
        this.def.put("Files Auto Tag Enable", FALSE);
        this.def.put("Files Auto Tag Count", ONE);
        this.def.put("Files Auto Tag Best Size", FALSE);
        this.def.put("Files Auto Tag Mod Enable", FALSE);
        this.def.put("Insufficient Space Download Restart Enable", FALSE);
        this.def.put("Insufficient Space Download Restart Period", 10);
        this.def.put("Missing File Download Restart Enable", FALSE);
        this.def.put("Missing File Download Restart Period", 30);
        this.def.put("Play Download Error", FALSE);
        this.def.put("Play Download Error File", def_String);
        this.def.put("Play Download Error Announcement", FALSE);
        this.def.put("Play Download Error Announcement Text", "Download Error");
        this.def.put("Popup Download Error", FALSE);
        this.def.put("Play Notification Added Announcement", FALSE);
        this.def.put("Play Notification Added Announcement Text", "Notification Added");
        this.def.put("Play Notification Added", FALSE);
        this.def.put("Play Notification Added File", def_String);
        this.def.put("Auto Tag Interesting Trackers", TRUE);
        this.def.put("Tag Auto Full Reapply Period Secs", 30);
        this.def.put("Show Swarm Tags In Overview", TRUE);
        this.def.put("Save Torrent Files", TRUE);
        this.def.put("General_sDefaultTorrent_Directory", String.valueOf(SystemProperties.getUserPath()) + "torrents");
        this.def.put("Delete Original Torrent Files", FALSE);
        this.def.put("Delete Saved Torrent Files", FALSE);
        this.def.put("Bind IP", def_String);
        this.def.put("Check Bind IP On Start", TRUE);
        this.def.put("Enforce Bind IP", FALSE);
        this.def.put("Enforce Bind IP Pause", FALSE);
        this.def.put("Show IP Bindings Icon", TRUE);
        this.def.put("Additional Service Bind IPs", def_String);
        this.def.put("Ignore Bind For LAN", FALSE);
        this.def.put("Stats Period", 30L);
        this.def.put("Stats Export Peer Details", FALSE);
        this.def.put("Stats Export File Details", FALSE);
        this.def.put("Stats XSL File", def_String);
        this.def.put("Stats Enable", FALSE);
        this.def.put("Stats Period", new Long(30000L));
        this.def.put("Stats Dir", def_String);
        this.def.put("Stats File", "BiglyBT_Stats.xml");
        this.def.put("long.term.stats.enable", TRUE);
        this.def.put("long.term.stats.weekstart", 1);
        this.def.put("Stats Smoothing Secs", new Long(120L));
        this.def.put("File.Torrent.AutoSkipExtensions", def_String);
        this.def.put("File.Torrent.AutoSkipFiles", def_String);
        this.def.put("File.Torrent.AutoSkipFiles.RegExp", FALSE);
        this.def.put("File.Torrent.AutoSkipMinSizeKB", ZERO);
        this.def.put("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
        this.def.put("File.save.peers.max", new Long(512L));
        this.def.put("File.Character.Conversions", DEFAULT_FILE_CONVERSION_CHARS);
        this.def.put("Tracker Compact Enable", TRUE);
        this.def.put("Tracker Key Enable Client", TRUE);
        this.def.put("Tracker Key Enable Server", TRUE);
        this.def.put("Tracker Separate Peer IDs", FALSE);
        this.def.put("Tracker Client Connect Timeout", new Long(120L));
        this.def.put("Tracker Client Read Timeout", SIXTY);
        this.def.put("Tracker Client Closedown Timeout", 20L);
        this.def.put("Tracker Client Concurrent Announce", 32);
        this.def.put("Tracker Client Send OS and Java Version", FALSE);
        this.def.put("Tracker Client Show Warnings", TRUE);
        this.def.put("Tracker Client Min Announce Interval", ZERO);
        this.def.put("Tracker Client Numwant Limit", new Long(100L));
        this.def.put("Tracker Client No Port Announce", FALSE);
        this.def.put("Tracker Client Smart Activation", TRUE);
        this.def.put("Tracker Client Exclude LAN", TRUE);
        this.def.put("Tracker Public Enable", FALSE);
        this.def.put("Tracker Public Enable Known Only", FALSE);
        this.def.put("Tracker Log Enable", FALSE);
        this.def.put("Tracker Port Enable", FALSE);
        this.def.put("Tracker Port", new Long(6969L));
        this.def.put("Tracker Port Backups", def_String);
        this.def.put("Tracker Port SSL Enable", FALSE);
        this.def.put("Tracker Port SSL", new Long(7000L));
        this.def.put("Tracker Port SSL Backups", def_String);
        this.def.put("Tracker Port Force External", FALSE);
        this.def.put("Tracker Host Add Our Announce URLs", TRUE);
        this.def_put("Tracker IP", def_String, new IPVerifier());
        this.def.put("Tracker Port UDP Enable", FALSE);
        this.def.put("Tracker Port UDP Version", new Long(2L));
        this.def.put("Tracker Send Peer IDs", TRUE);
        this.def.put("Tracker Max Peers Returned", new Long(100L));
        this.def.put("Tracker Scrape Cache", new Long(5000L));
        this.def.put("Tracker Announce Cache", new Long(500L));
        this.def.put("Tracker Announce Cache Min Peers", new Long(500L));
        this.def.put("Tracker Poll Interval Min", new Long(120L));
        this.def.put("Tracker Poll Interval Max", new Long(3600L));
        this.def.put("Tracker Poll Seed Interval Mult", new Long(1L));
        this.def.put("Tracker Scrape Retry Percentage", new Long(200L));
        this.def.put("Tracker Password Enable Web", FALSE);
        this.def.put("Tracker Password Web HTTPS Only", FALSE);
        this.def.put("Tracker Password Enable Torrent", FALSE);
        this.def.put("Tracker Username", def_String);
        this.def.put("Tracker Password", null);
        this.def.put("Tracker Poll Inc By", new Long(60L));
        this.def.put("Tracker Poll Inc Per", new Long(10L));
        this.def.put("Tracker NAT Check Enable", TRUE);
        this.def.put("Tracker NAT Check Timeout", new Long(15L));
        this.def.put("Tracker Max Seeds Retained", ZERO);
        this.def.put("Tracker Max Seeds", ZERO);
        this.def.put("Tracker Max GET Time", new Long(20L));
        this.def.put("Tracker Max POST Time Multiplier", ONE);
        this.def.put("Tracker Max Threads", new Long(48L));
        this.def.put("Tracker TCP NonBlocking", FALSE);
        this.def.put("Tracker TCP NonBlocking Restrict Request Types", TRUE);
        this.def.put("Tracker TCP NonBlocking Conc Max", new Long(2048L));
        this.def.put("Tracker TCP NonBlocking Immediate Close", FALSE);
        this.def.put("Tracker Client Scrape Enable", TRUE);
        this.def.put("Tracker Client Scrape Total Disable", FALSE);
        this.def.put("Tracker Client Scrape Stopped Enable", TRUE);
        this.def.put("Tracker Client Scrape Never Started Disable", TRUE);
        this.def.put("Tracker Client Scrape Single Only", FALSE);
        this.def.put("Tracker Server Full Scrape Enable", TRUE);
        this.def.put("Tracker Server Not Found Redirect", def_String);
        this.def.put("Tracker Server Support Experimental Extensions", FALSE);
        this.def.put("Network Selection Prompt", FALSE);
        this.def.put("Network Selection Default.Public", TRUE);
        this.def.put("Network Selection Default.I2P", FALSE);
        this.def.put("Network Selection Default.Tor", FALSE);
        this.def.put("Tracker Network Selection Default.Public", TRUE);
        this.def.put("Tracker Network Selection Default.I2P", TRUE);
        this.def.put("Tracker Network Selection Default.Tor", TRUE);
        this.def.put("Sharing Network Selection Global", TRUE);
        this.def.put("Sharing Network Selection Default.Public", TRUE);
        this.def.put("Sharing Network Selection Default.I2P", FALSE);
        this.def.put("Sharing Network Selection Default.Tor", FALSE);
        this.def.put("Peer Source Selection Default.Tracker", TRUE);
        this.def.put("Peer Source Selection Default.DHT", TRUE);
        this.def.put("Peer Source Selection Default.PeerExchange", TRUE);
        this.def.put("Peer Source Selection Default.Plugin", TRUE);
        this.def.put("Peer Source Selection Default.Incoming", TRUE);
        this.def.put("Peer Source Selection Default.HolePunch", TRUE);
        this.def.put("config.style.useSIUnits", FALSE);
        this.def.put("config.style.forceSIValues", Constants.isOSX ? FALSE : TRUE);
        this.def.put("config.style.useUnitsRateBits", FALSE);
        this.def.put("config.style.separateProtDataStats", FALSE);
        this.def.put("config.style.dataStatsOnly", FALSE);
        this.def.put("config.style.doNotUseGB", FALSE);
        this.def.put("Save Torrent Backup", FALSE);
        this.def.put("Sharing Protocol", "DHT");
        this.def.put("Sharing Add Hashes", FALSE);
        this.def.put("Sharing Rescan Enable", FALSE);
        this.def.put("Sharing Rescan Period", SIXTY);
        this.def.put("Sharing Torrent Comment", def_String);
        this.def.put("Sharing Permit DHT", TRUE);
        this.def.put("Sharing Torrent Private", FALSE);
        this.def.put("Sharing Disable RCM", FALSE);
        this.def.put("Sharing Is Persistent", FALSE);
        this.def.put("File.Decoder.Prompt", FALSE);
        this.def.put("File.Decoder.Default", def_String);
        this.def.put("File.Decoder.ShowLax", FALSE);
        this.def.put("File.Decoder.ShowAll", FALSE);
        this.def.put("Password enabled", FALSE);
        this.def.put("Password", null);
        this.def.put("config.interface.checkassoc", TRUE);
        this.def.put("confirmationOnExit", FALSE);
        this.def.put("locale", Locale.getDefault().toString());
        this.def.put("locale.set.complete.count", ZERO);
        this.def.put("Password Confirm", null);
        this.def.put("Auto Update", TRUE);
        this.def.put("Alert on close", FALSE);
        this.def.put("diskmanager.hashchecking.strategy", ONE);
        this.def.put("diskmanager.hashchecking.smallestfirst", TRUE);
        this.def.put("diskmanager.one.op.per.fs", FALSE);
        this.def.put("diskmanager.one.op.per.fs.conc.read", FALSE);
        this.def.put("diskmanager.hashchecking.maxactive", ONE);
        this.def.put("Default Start Torrents Stopped", FALSE);
        this.def.put("Default Start Torrents Stopped Auto Pause", FALSE);
        this.def.put("Server Enable UDP", TRUE);
        this.def.put("Tracker UDP Probe Enable", TRUE);
        this.def.put("Tracker Client Enable TCP", TRUE);
        this.def.put("Tracker DNS Records Enable", TRUE);
        this.def.put("diskmanager.perf.cache.enable", TRUE);
        this.def.put("diskmanager.perf.cache.enable.read", FALSE);
        this.def.put("diskmanager.perf.cache.enable.write", TRUE);
        this.def.put("diskmanager.perf.cache.size", new Long(4L));
        this.def.put("diskmanager.perf.cache.notsmallerthan", new Long(1024L));
        this.def.put("diskmanager.perf.read.maxthreads", new Long(32L));
        this.def.put("diskmanager.perf.read.maxmb", new Long(10L));
        this.def.put("diskmanager.perf.write.maxthreads", new Long(32L));
        this.def.put("diskmanager.perf.write.maxmb", new Long(10L));
        this.def.put("diskmanager.perf.cache.trace", FALSE);
        this.def.put("diskmanager.perf.cache.flushpieces", TRUE);
        this.def.put("diskmanager.perf.read.aggregate.enable", FALSE);
        this.def.put("diskmanager.perf.read.aggregate.request.limit", ZERO);
        this.def.put("diskmanager.perf.read.aggregate.byte.limit", ZERO);
        this.def.put("diskmanager.perf.write.aggregate.enable", FALSE);
        this.def.put("diskmanager.perf.write.aggregate.request.limit", ZERO);
        this.def.put("diskmanager.perf.write.aggregate.byte.limit", ZERO);
        this.def.put("diskmanager.perf.checking.read.priority", FALSE);
        this.def.put("diskmanager.perf.checking.fully.async", FALSE);
        this.def.put("diskmanager.perf.queue.torrent.bias", TRUE);
        this.def.put("peercontrol.udp.fallback.connect.fail", TRUE);
        this.def.put("peercontrol.udp.fallback.connect.drop", TRUE);
        this.def.put("peercontrol.udp.probe.enable", FALSE);
        this.def.put("peercontrol.hide.piece", FALSE);
        this.def.put("peercontrol.scheduler.use.priorities", TRUE);
        this.def.put("peercontrol.prefer.udp", FALSE);
        this.def.put("peercontrol.prefer.ipv6", FALSE);
        this.def.put("File.truncate.if.too.large", FALSE);
        this.def.put("Enable System Tray", TRUE);
        this.def.put("System Tray Disabled Override", FALSE);
        this.def.put("Show Status In Window Title", FALSE);
        this.def.put("config.style.table.defaultSortOrder", 3);
        this.def.put("Ignore.peer.ports", "0");
        this.def.put("Security.JAR.tools.dir", def_String);
        this.def.put("security.cert.auto.install", TRUE);
        this.def.put("security.cert.auto.decline", FALSE);
        boolean tcp_half_open_limited = Constants.isWindows && !Constants.isWindowsVistaSP2OrHigher && !Constants.isWindows7OrHigher;
        this.def.put("network.max.simultaneous.connect.attempts", new Long(tcp_half_open_limited ? 8 : 24));
        this.def.put("network.tcp.max.connections.outstanding", new Long(2048L));
        this.def.put("network.tcp.connect.outbound.enable", TRUE);
        this.def.put("network.tcp.mtu.size", new Long(1500L));
        this.def.put("network.udp.mtu.size", new Long(1500L));
        this.def.put("network.udp.poll.time", new Long(100L));
        this.def.put("network.tcp.socket.SO_SNDBUF", ZERO);
        this.def.put("network.tcp.socket.SO_RCVBUF", ZERO);
        this.def.put("network.tcp.socket.IPDiffServ", def_String);
        this.def.put("network.tcp.read.select.time", new Long(25L));
        this.def.put("network.tcp.read.select.min.time", ZERO);
        this.def.put("network.tcp.write.select.time", new Long(25L));
        this.def.put("network.tcp.write.select.min.time", ZERO);
        this.def.put("network.tcp.connect.select.time", new Long(100L));
        this.def.put("network.tcp.connect.select.min.time", ZERO);
        this.def.put("network.tracker.tcp.select.time", new Long(100L));
        this.def.put("network.control.write.idle.time", new Long(50L));
        this.def.put("network.control.write.aggressive", FALSE);
        this.def.put("network.control.read.idle.time", new Long(50L));
        this.def.put("network.control.read.aggressive", FALSE);
        this.def.put("network.control.read.processor.count", new Long(1L));
        this.def.put("network.control.write.processor.count", new Long(1L));
        this.def.put("peermanager.schedule.time", new Long(100L));
        this.def.put("enable_small_osx_fonts", TRUE);
        this.def.put("Play Download Finished Announcement", FALSE);
        this.def.put("Play Download Finished Announcement Text", "Download Complete");
        this.def.put("Play File Finished", FALSE);
        this.def.put("Play File Finished File", def_String);
        this.def.put("Play File Finished Announcement", FALSE);
        this.def.put("Play File Finished Announcement Text", "File Complete");
        this.def.put("filechannel.rt.buffer.millis", new Long(60000L));
        this.def.put("filechannel.rt.buffer.pieces", new Long(5L));
        this.def.put("BT Request Max Block Size", new Long(65536L));
        this.def.put("network.transport.encrypted.require", FALSE);
        this.def.put("network.transport.encrypted.min_level", "RC4");
        this.def.put("network.transport.encrypted.fallback.outgoing", FALSE);
        this.def.put("network.transport.encrypted.fallback.incoming", FALSE);
        this.def.put("network.transport.encrypted.use.crypto.port", FALSE);
        this.def.put("network.transport.encrypted.allow.incoming", TRUE);
        this.def.put("network.bind.local.port", ZERO);
        this.def.put("network.admin.maybe.vpn.enable", TRUE);
        this.def.put("crypto.keys.system.managed", FALSE);
        this.def.put("peer.nat.traversal.request.conc.max", new Long(3L));
        this.def.put("memory.slice.limit.multiplier", new Long(1L));
        this.def.put("Move Completed When Done", FALSE);
        this.def.put("Completed Files Directory", def_String);
        this.def.put("Move Only When In Default Save Dir", TRUE);
        this.def.put("Move Torrent When Done", TRUE);
        this.def.put("File.move.add.sub.dir", FALSE);
        this.def.put("file.use.temp.path.and.move.path", def_String);
        this.def.put("file.use.temp.path.and.move.enable", FALSE);
        this.def.put("Move Completed When Done", FALSE);
        this.def.put("Completed Files Directory", def_String);
        this.def.put("Set Completion Flag For Completed Downloads On Start", TRUE);
        this.def.put("File.move.download.removed.enabled", FALSE);
        this.def.put("File.move.download.removed.path", def_String);
        this.def.put("File.move.download.removed.only_in_default", TRUE);
        this.def.put("File.move.download.removed.move_torrent", TRUE);
        this.def.put("File.move.download.removed.move_torrent_path", def_String);
        this.def.put("File.move.download.removed.move_partial", FALSE);
        this.def.put("File.delete.include_files_outside_save_dir", FALSE);
        this.def.put("FilesView.show.full.path", FALSE);
        this.def.put("MyTorrentsView.menu.show_parent_folder_enabled", FALSE);
        this.def.put("FileBrowse.usePathFinder", FALSE);
        this.def.put("Beta Programme Enabled", FALSE);
        this.def.put("def.deletetorrent", TRUE);
        this.def.put("def.deleteallselected", FALSE);
        this.def.put("tb.confirm.delete.content", 0L);
        this.def.put("br.backup.auto.enable", FALSE);
        this.def.put("br.backup.auto.everydays", ONE);
        this.def.put("br.backup.auto.everyhours", ZERO);
        this.def.put("br.backup.auto.retain", 5L);
        this.def.put("br.restore.doplugins", TRUE);
        try {
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", new Long(61440L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", new Long(30720L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.good.setpoint", new Long(50L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.good.tolerance", new Long(100L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.bad.setpoint", new Long(900L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.bad.tolerance", new Long(500L));
            this.def.put("Auto Upload Speed Version", 2);
            this.def.put("SpeedLimitMonitor.setting.download.limit.conf", SpeedLimitConfidence.NONE.getString());
            this.def.put("SpeedLimitMonitor.setting.upload.limit.conf", SpeedLimitConfidence.NONE.getString());
            this.def.put("SpeedLimitMonitor.setting.choke.ping.count", new Long(1L));
            this.def.put("SpeedLimitMonitor.setting.upload.used.seeding.mode", new Long(90L));
            this.def.put("SpeedLimitMonitor.setting.upload.used.download.mode", SIXTY);
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust", TRUE);
            this.def.put("SpeedManagerAlgorithmProviderV2.intervals.between.adjust", new Long(2L));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.def.put("subscriptions.max.non.deleted.results", new Long(512L));
        this.def.put("subscriptions.auto.start.downloads", TRUE);
        this.def.put("subscriptions.auto.start.min.mb", ZERO);
        this.def.put("subscriptions.auto.start.max.mb", ZERO);
        this.def.put("subscriptions.auto.dl.mark.read.days", ZERO);
        this.def.put("Show Side Bar", TRUE);
        this.def.put("Side Bar Top Level Gap", ONE);
        this.def.put("Show Options In Side Bar", FALSE);
        this.def.put("Show New In Side Bar", TRUE);
        this.def.put("Show Downloading In Side Bar", TRUE);
        this.def.put("Side Bar Close Position", ZERO);
        this.def.put("Side Bar Indent Expanders", TRUE);
        this.def.put("Side Bar Compact View", FALSE);
        this.def.put("Side Bar Hide Left Icon", FALSE);
        this.def.put("Share Ratio Progress Interval", 1000L);
        this.def.put("search.showRCMView", FALSE);
        this.def.put("search.rss.template.timeout", 20);
        this.def.put("Use System Theme", FALSE);
        this.def.put("installer.mode", def_String);
    }

    protected ConfigurationDefaults(Map _def) {
        this.def = new ConcurrentHashMapWrapper(_def);
    }

    protected void def_put(String key, String key_def, COConfigurationManager.ParameterVerifier verifier) {
        this.def.put(key, key_def);
        ArrayList<COConfigurationManager.ParameterVerifier> l = (ArrayList<COConfigurationManager.ParameterVerifier>)this.parameter_verifiers.get(key);
        if (l == null) {
            l = new ArrayList<COConfigurationManager.ParameterVerifier>(1);
            this.parameter_verifiers.put(key, l);
        }
        l.add(verifier);
    }

    private void checkParameterExists(String p) throws ConfigurationParameterNotFoundException {
        if (!this.def.containsKey(p)) {
            ConfigurationParameterNotFoundException cpnfe = new ConfigurationParameterNotFoundException(p);
            throw cpnfe;
        }
    }

    public String getStringParameter(String p) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(p);
        Object o = this.def.get(p);
        if (o instanceof Number) {
            return ((Number)o).toString();
        }
        return (String)o;
    }

    public int getIntParameter(String p) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(p);
        return ((Number)this.def.get(p)).intValue();
    }

    public long getLongParameter(String p) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(p);
        return ((Number)this.def.get(p)).longValue();
    }

    public float getFloatParameter(String p) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(p);
        return ((Float)this.def.get(p)).floatValue();
    }

    public byte[] getByteParameter(String p) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(p);
        return (byte[])this.def.get(p);
    }

    public boolean getBooleanParameter(String p) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(p);
        return ((Long)this.def.get(p)).equals(TRUE);
    }

    public boolean hasParameter(String p) {
        return this.def.containsKey(p);
    }

    public Object getDefaultValueAsObject(String key) {
        return this.def.get(key);
    }

    public Set<String> getAllowedParameters() {
        return this.def.keySet();
    }

    public void addParameter(String sKey, String sParameter) {
        this.def.put(sKey, sParameter);
    }

    public void addParameter(String sKey, int iParameter) {
        this.def.put(sKey, new Long(iParameter));
    }

    public void addParameter(String sKey, byte[] bParameter) {
        this.def.put(sKey, bParameter);
    }

    public void addParameter(String sKey, boolean bParameter) {
        Long lParameter = new Long(bParameter ? 1 : 0);
        this.def.put(sKey, lParameter);
    }

    public void addParameter(String sKey, long lParameter) {
        this.def.put(sKey, new Long(lParameter));
    }

    public void addParameter(String sKey, float fParameter) {
        this.def.put(sKey, new Float(fParameter));
    }

    public void registerExternalDefaults(Map addmap) {
        this.def.putAll(addmap);
    }

    public boolean doesParameterDefaultExist(String p) {
        return this.def.containsKey(p);
    }

    public Object getParameter(String key) {
        return this.def.get(key);
    }

    public List getVerifiers(String key) {
        return (List)this.parameter_verifiers.get(key);
    }

    protected void runVerifiers() {
        for (Map.Entry entry : this.parameter_verifiers.entrySet()) {
            String key = (String)entry.getKey();
            List verifiers = (List)entry.getValue();
            int i = 0;
            while (i < verifiers.size()) {
                COConfigurationManager.ParameterVerifier verifier = (COConfigurationManager.ParameterVerifier)verifiers.get(i);
                Object val_def = this.getDefaultValueAsObject(key);
                if (val_def != null) {
                    if (!(val_def instanceof String)) {
                        Debug.out("Unsupported verifier type for parameter '" + key + "' - " + val_def);
                    } else {
                        String val = COConfigurationManager.getStringParameter(key);
                        if (val != null && !verifier.verify(key, val)) {
                            Debug.out("Parameter '" + key + "', value '" + val + "' failed verification - setting back to default '" + val_def + "'");
                            COConfigurationManager.removeParameter(key);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected static class IPVerifier
    implements COConfigurationManager.ParameterVerifier {
        protected IPVerifier() {
        }

        @Override
        public boolean verify(String parameter, Object _value) {
            String value = (String)_value;
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '.' && c != '-' && c != ':' && c != '~') {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

