/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.content;

import com.biglybt.core.content.Content;
import com.biglybt.core.content.ContentDirectory;
import com.biglybt.core.content.ContentDirectoryListener;
import com.biglybt.core.content.ContentDirectoryManager;
import com.biglybt.core.content.ContentDownload;
import com.biglybt.core.content.ContentFile;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlatformContentDirectory
implements ContentDirectory {
    private static boolean registered = false;
    private static TorrentAttribute ta_category;
    private final DownloadManager downloadManager = PluginInitializer.getDefaultInterface().getDownloadManager();
    private static CopyOnWriteList<ContentDirectoryListener> listeners;

    static {
        listeners = new CopyOnWriteList();
    }

    public static synchronized void register() {
        if (!registered) {
            registered = true;
            ta_category = PluginInitializer.getDefaultInterface().getTorrentManager().getAttribute("Category");
            ContentDirectoryManager.registerDirectory(new PlatformContentDirectory());
        }
    }

    @Override
    public Content lookupContent(Map attributes) {
        return null;
    }

    @Override
    public ContentDownload lookupContentDownload(Map attributes) {
        byte[] hash = (byte[])attributes.get("btih");
        try {
            final Download download = this.downloadManager.getDownload(hash);
            if (download == null) {
            }
            return new ContentDownload(){

                @Override
                public Download getDownload() {
                    return download;
                }

                @Override
                public Object getProperty(String name) {
                    return null;
                }
            };
        }
        finally {
            return null;
        }
    }

    @Override
    public ContentFile lookupContentFile(Map attributes) {
        byte[] hash = (byte[])attributes.get("btih");
        int index = (Integer)attributes.get("file_index");
        try {
            Download download = this.downloadManager.getDownload(hash);
            if (download == null) {
            }
            Torrent t_torrent = download.getTorrent();
            if (t_torrent == null) {
            }
            String ud_key = "PlatformContentDirectory:" + index;
            ContentFile acf = (ContentFile)download.getUserData(ud_key);
            if (acf != null) {
                return acf;
            }
            final DiskManagerFileInfo file = download.getDiskManagerFileInfo(index);
            acf = new ContentFile(){

                @Override
                public DiskManagerFileInfo getFile() {
                    return file;
                }

                @Override
                public Object getProperty(String name) {
                    try {
                        if (name.equals("date")) {
                            return new Long(file.getDownload().getCreationTime());
                        }
                        if (name.equals("cats")) {
                            try {
                                String cat = file.getDownload().getCategoryName();
                                if (cat != null && cat.length() > 0 && !cat.equalsIgnoreCase("Categories.uncategorized")) {
                                    return new String[]{cat};
                                }
                            }
                            catch (Throwable cat) {
                                // empty catch block
                            }
                            return new String[0];
                        }
                        if (name.equals("tags")) {
                            List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(PluginCoreUtils.unwrap(file.getDownload()));
                            ArrayList<String> tag_names = new ArrayList<String>();
                            for (Tag tag : tags) {
                                if (tag.getTagType().getTagType() != 3) continue;
                                tag_names.add(tag.getTagName(true));
                            }
                            return tag_names.toArray(new String[tag_names.size()]);
                        }
                        if (name.equals("percent")) {
                            long size = file.getLength();
                            return new Long(size == 0L ? 100L : 1000L * file.getDownloaded() / size);
                        }
                        if (name.equals("eta")) {
                            return PlatformContentDirectory.this.getETA(file);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            };
            download.setUserData(ud_key, acf);
            final ContentFile f_acf = acf;
            download.addAttributeListener(new DownloadAttributeListener(){

                @Override
                public void attributeEventOccurred(Download download, TorrentAttribute attribute, int eventType) {
                    PlatformContentDirectory.fireCatsChanged(f_acf);
                }
            }, ta_category, 1);
            TagManagerFactory.getTagManager().getTagType(3).addTagListener(PluginCoreUtils.unwrap(download), new TagListener(){

                @Override
                public void taggableSync(Tag tag) {
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    this.update(tagged);
                }

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    this.update(tagged);
                }

                private void update(Taggable tagged) {
                    PlatformContentDirectory.fireTagsChanged(f_acf);
                }
            });
            return acf;
        }
        finally {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getETA(DiskManagerFileInfo file) {
        try {
            if (file.getDownloaded() == file.getLength()) {
                return 0L;
            }
            if (file.isDeleted() || file.isSkipped()) {
                return Long.MAX_VALUE;
            }
            long eta = file.getDownload().getStats().getETASecs();
            if (eta < 0L) {
                return Long.MAX_VALUE;
            }
            return eta;
        }
        catch (Throwable e) {
            return Long.MAX_VALUE;
        }
    }

    public static void fireCatsChanged(ContentFile acf) {
        for (ContentDirectoryListener l : listeners) {
            l.contentChanged(acf, "cats");
        }
    }

    public static void fireTagsChanged(ContentFile acf) {
        for (ContentDirectoryListener l : listeners) {
            l.contentChanged(acf, "tags");
        }
    }

    @Override
    public void addListener(ContentDirectoryListener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeListener(ContentDirectoryListener listener) {
        listeners.remove(listener);
    }
}

