/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.content;

import com.biglybt.core.content.RelatedContentManager;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.download.Download;

public abstract class RelatedContent {
    public static final int VERSION_NA = -1;
    public static final int VERSION_INITIAL = 0;
    public static final int VERSION_BETTER_SCRAPE = 1;
    public static final String[] NO_TAGS = new String[0];
    private final String title;
    private final byte[] hash;
    private final String tracker;
    private final long size;
    private int version;
    private int date;
    private int seeds_leechers;
    private byte[] related_to_hash;
    private byte[] tracker_keys;
    private byte[] ws_keys;
    private String[] tags;
    private byte nets;
    private long changed_locally_on;

    public RelatedContent(int _version, byte[] _related_to_hash, String _title, byte[] _hash, String _tracker, byte[] _tracker_keys, byte[] _ws_keys, String[] _tags, byte _nets, long _size, int _date, int _seeds_leechers) {
        this.version = _version;
        this.related_to_hash = _related_to_hash;
        this.title = this.fixTitle(_title);
        this.hash = _hash;
        this.tracker = _tracker;
        this.tracker_keys = _tracker_keys;
        this.ws_keys = _ws_keys;
        this.tags = _tags;
        this.nets = _nets;
        this.size = _size;
        this.date = _date;
        this.seeds_leechers = _seeds_leechers;
        this.setChangedLocallyOn(0L);
    }

    public RelatedContent(String _title, byte[] _hash, String _tracker, long _size, int _date, int _seeds_leechers) {
        this(-1, _title, _hash, _tracker, null, null, null, 1, _size, _date, _seeds_leechers);
    }

    public RelatedContent(int _version, String _title, byte[] _hash, String _tracker, byte[] _tracker_keys, byte[] _ws_keys, String[] _tags, byte _nets, long _size, int _date, int _seeds_leechers) {
        this.version = _version;
        this.title = this.fixTitle(_title);
        this.hash = _hash;
        this.tracker = _tracker;
        this.tracker_keys = _tracker_keys;
        this.ws_keys = _ws_keys;
        this.tags = _tags;
        this.nets = _nets;
        this.size = _size;
        this.date = _date;
        this.seeds_leechers = _seeds_leechers;
        this.setChangedLocallyOn(0L);
    }

    private String fixTitle(String str) {
        if (str != null && str.startsWith("urlencode(")) {
            if ((str = str.substring(10)).endsWith(")")) {
                str = str.substring(0, str.length() - 1);
            }
            if ((str = str.trim()).isEmpty()) {
                str = "download";
            }
        }
        return str;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int _version) {
        this.version = _version;
    }

    protected void setRelatedToHash(byte[] h) {
        this.related_to_hash = h;
    }

    public byte[] getRelatedToHash() {
        return this.related_to_hash;
    }

    public abstract Download getRelatedToDownload();

    public String getTitle() {
        return this.title;
    }

    public abstract int getRank();

    public byte[] getHash() {
        return this.hash;
    }

    public abstract int getLevel();

    public abstract boolean isUnread();

    public abstract void setUnread(boolean var1);

    public abstract int getLastSeenSecs();

    public abstract int getFirstSeenSecs();

    public String getTracker() {
        return this.tracker;
    }

    public byte[] getTrackerKeys() {
        return this.tracker_keys;
    }

    public byte[] getWebSeedKeys() {
        return this.ws_keys;
    }

    public String[] getTags() {
        return this.tags == null ? NO_TAGS : this.tags;
    }

    protected void setTags(String[] _tags) {
        this.tags = _tags;
        this.setChangedLocallyOn(0L);
    }

    public String[] getNetworks() {
        return RelatedContentManager.convertNetworks(this.nets);
    }

    protected byte getNetworksInternal() {
        return this.nets;
    }

    protected void setNetworksInternal(byte n) {
        this.nets = n;
    }

    public long getSize() {
        return this.size;
    }

    public long getPublishDate() {
        return (long)(this.date * 60 * 60) * 1000L;
    }

    protected int getDateHours() {
        return this.date;
    }

    protected void setDateHours(int _date) {
        this.date = _date;
        this.setChangedLocallyOn(0L);
    }

    public int getLeechers() {
        if (this.seeds_leechers == -1) {
            return -1;
        }
        return this.seeds_leechers & 0xFFFF;
    }

    public int getSeeds() {
        if (this.seeds_leechers == -1) {
            return -1;
        }
        return this.seeds_leechers >> 16 & 0xFFFF;
    }

    protected int getSeedsLeechers() {
        return this.seeds_leechers;
    }

    protected void setSeedsLeechers(int _sl) {
        this.seeds_leechers = _sl;
        this.setChangedLocallyOn(0L);
    }

    public long getChangedLocallyOn() {
        return this.changed_locally_on;
    }

    public void setChangedLocallyOn(long _changed_locally_on) {
        this.changed_locally_on = _changed_locally_on == 0L ? SystemTime.getCurrentTime() : _changed_locally_on;
    }

    public abstract void delete();

    public String getString() {
        return "title=" + this.title + ", ver=" + this.version + ", hash=" + (this.hash == null ? "null" : Base32.encode(this.hash)) + ", tracker=" + this.tracker + ", date=" + this.date + ", sl=" + this.seeds_leechers + ", nets=" + this.nets;
    }
}

