/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceMediaRendererImpl;
import com.biglybt.core.devices.impl.TranscodeFileImpl;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.xml.util.XMLEscapeWriter;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.rssgen.RSSGeneratorPlugin;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class DeviceManagerRSSFeed
implements RSSGeneratorPlugin.Provider {
    private static final String PROVIDER = "devices";
    private DeviceManagerImpl manager;
    private RSSGeneratorPlugin generator;

    protected DeviceManagerRSSFeed(DeviceManagerImpl _manager) {
        this.manager = _manager;
        this.generator = RSSGeneratorPlugin.getSingleton();
        if (this.generator != null) {
            RSSGeneratorPlugin.registerProvider(PROVIDER, this);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.manager.isRSSPublishEnabled();
    }

    public String getFeedURL() {
        return this.generator == null ? "Feature Disabled" : String.valueOf(this.generator.getURL()) + PROVIDER;
    }

    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        InetSocketAddress local_address = request2.getLocalAddress();
        if (local_address == null) {
            return false;
        }
        URL url = request2.getAbsoluteURL();
        String path = url.getPath();
        path = path.substring(PROVIDER.length() + 1);
        DeviceImpl[] devices = this.manager.getDevices();
        OutputStream os = response.getOutputStream();
        XMLEscapeWriter pw = new XMLEscapeWriter(new PrintWriter(new OutputStreamWriter(os, "UTF-8")));
        pw.setEnabled(false);
        boolean hide_generic = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true);
        boolean show_only_tagged = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.showonlytagged", false);
        if (path.length() <= 1) {
            response.setContentType("text/html; charset=UTF-8");
            pw.println("<HTML><HEAD><TITLE>" + Constants.APP_NAME + " Device Feeds</TITLE></HEAD><BODY>");
            DeviceImpl[] deviceImplArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceImpl d = deviceImplArray[n2];
                if (!(d.getType() != 3 || d.isHidden() || !d.isRSSPublishEnabled() || hide_generic && d.isNonSimple() || show_only_tagged && !d.isTagged())) {
                    String name = d.getName();
                    String device_url = "devices/" + URLEncoder.encode(name, "UTF-8");
                    pw.println("<LI><A href=\"" + device_url + "\">" + name + "</A>&nbsp;&nbsp;-&nbsp;&nbsp;<font size=\"-1\"><a href=\"" + device_url + "?format=html\">html</a></font></LI>");
                }
                ++n2;
            }
            pw.println("</BODY></HTML>");
        } else {
            String device_name = URLDecoder.decode(path.substring(1), "UTF-8");
            DeviceImpl device = null;
            DeviceImpl[] device_url = devices;
            int name = devices.length;
            int n = 0;
            while (n < name) {
                DeviceImpl d = device_url[n];
                if (d.getName().equals(device_name) && d.isRSSPublishEnabled()) {
                    device = d;
                    break;
                }
                ++n;
            }
            if (device == null) {
                response.setReplyStatus(404);
                return true;
            }
            TranscodeFileImpl[] _files = device.getFiles();
            ArrayList<TranscodeFileImpl> files = new ArrayList<TranscodeFileImpl>(_files.length);
            files.addAll(Arrays.asList(_files));
            Collections.sort(files, new Comparator<TranscodeFileImpl>(){

                @Override
                public int compare(TranscodeFileImpl f1, TranscodeFileImpl f2) {
                    long added1 = f1.getCreationDateMillis() / 1000L;
                    long added2 = f2.getCreationDateMillis() / 1000L;
                    return (int)(added2 - added1);
                }
            });
            URL feed_url = url;
            String host = (String)request2.getHeaders().get("host");
            if (host != null) {
                int pos = host.indexOf(58);
                if (pos != -1) {
                    host = host.substring(0, pos);
                }
                feed_url = UrlUtils.setHost(url, host);
            }
            if (device instanceof DeviceMediaRendererImpl) {
                ((DeviceMediaRendererImpl)device).browseReceived();
            }
            String channel_title = String.valueOf(Constants.APP_NAME) + " Device: " + this.escape(device.getName());
            boolean html = request2.getURL().contains("format=html");
            if (html) {
                response.setContentType("text/html; charset=UTF-8");
                pw.println("<HTML><HEAD><TITLE>" + channel_title + "</TITLE></HEAD><BODY>");
                for (TranscodeFileImpl file : files) {
                    URL stream_url;
                    if (!file.isComplete() && !file.isTemplate() || (stream_url = file.getStreamURL(feed_url.getHost())) == null) continue;
                    String url_ext = stream_url.toExternalForm();
                    pw.println("<p>");
                    pw.println("<a href=\"" + url_ext + "\">" + this.escape(file.getName()) + "</a>");
                    url_ext = String.valueOf(url_ext) + (url_ext.indexOf(63) == -1 ? "?" : "&");
                    url_ext = String.valueOf(url_ext) + "action=download";
                    pw.println("&nbsp;&nbsp;-&nbsp;&nbsp;<font size=\"-1\"><a href=\"" + url_ext + "\">save</a></font>");
                }
                pw.println("</BODY></HTML>");
            } else {
                boolean debug = request2.getURL().contains("format=debug");
                if (debug) {
                    response.setContentType("text/html; charset=UTF-8");
                    pw.println("<HTML><HEAD><TITLE>" + channel_title + "</TITLE></HEAD><BODY>");
                    pw.println("<pre>");
                    pw.setEnabled(true);
                } else {
                    response.setContentType("application/xml; charset=UTF-8");
                }
                try {
                    pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\">");
                    pw.println("<channel>");
                    pw.println("<title>" + channel_title + "</title>");
                    pw.println("<link>http://biglybt.com</link>");
                    pw.println("<atom:link href=\"" + feed_url.toExternalForm() + "\" rel=\"self\" type=\"application/rss+xml\" />");
                    pw.println("<description>" + Constants.APP_NAME + " RSS Feed for device " + this.escape(device.getName()) + "</description>");
                    pw.println("<itunes:image href=\"http://biglybt.com/img/biglybt128.png\"/>");
                    pw.println("<image><url>https://www.biglybt.com/img/biglybt128.png</url><title>" + channel_title + "</title><link>http://biglybt.com</link></image>");
                    String feed_date_key = "devices.feed_date." + device.getID();
                    long feed_date = COConfigurationManager.getLongParameter(feed_date_key);
                    boolean new_date = false;
                    for (TranscodeFileImpl file : files) {
                        long file_date = file.getCreationDateMillis();
                        if (file_date <= feed_date) continue;
                        new_date = true;
                        feed_date = file_date;
                    }
                    if (new_date) {
                        COConfigurationManager.setParameter(feed_date_key, feed_date);
                    }
                    pw.println("<pubDate>" + TimeFormatter.getHTTPDate(feed_date) + "</pubDate>");
                    for (TranscodeFileImpl file : files) {
                        if (!file.isComplete() && !file.isTemplate()) continue;
                        try {
                            String[] tags;
                            String[] categories;
                            pw.println("<item>");
                            pw.println("<title>" + this.escape(file.getName()) + "</title>");
                            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(file.getCreationDateMillis()) + "</pubDate>");
                            pw.println("<guid isPermaLink=\"false\">" + this.escape(file.getKey()) + "</guid>");
                            String[] stringArray = categories = file.getCategories();
                            int n3 = categories.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String category = stringArray[n4];
                                pw.println("<category>" + this.escape(category) + "</category>");
                                ++n4;
                            }
                            String[] stringArray2 = tags = file.getTags(true);
                            int n5 = tags.length;
                            n3 = 0;
                            while (n3 < n5) {
                                String tag = stringArray2[n3];
                                pw.println("<tag>" + this.escape(tag) + "</tag>");
                                ++n3;
                            }
                            String mediaContent = "";
                            URL stream_url = file.getStreamURL(feed_url.getHost());
                            if (stream_url != null) {
                                String url_ext = this.escape(stream_url.toExternalForm());
                                long fileSize = file.getTargetFile().getLength();
                                pw.println("<link>" + url_ext + "</link>");
                                mediaContent = "<media:content medium=\"video\" fileSize=\"" + fileSize + "\" url=\"" + url_ext + "\"";
                                String mime_type = file.getMimeType();
                                if (mime_type != null) {
                                    mediaContent = String.valueOf(mediaContent) + " type=\"" + mime_type + "\"";
                                }
                                pw.println("<enclosure url=\"" + url_ext + "\" length=\"" + fileSize + (mime_type == null ? "" : "\" type=\"" + mime_type) + "\"></enclosure>");
                            }
                            String thumb_url = null;
                            String author = null;
                            String description = null;
                            try {
                                Torrent torrent = file.getSourceFile().getDownload().getTorrent();
                                TOTorrent toTorrent = PluginCoreUtils.unwrap(torrent);
                                long duration_secs = PlatformTorrentUtils.getContentVideoRunningTime(toTorrent);
                                if (mediaContent.length() > 0 && duration_secs > 0L) {
                                    mediaContent = String.valueOf(mediaContent) + " duration=\"" + duration_secs + "\"";
                                }
                                thumb_url = PlatformTorrentUtils.getContentThumbnailUrl(toTorrent);
                                author = PlatformTorrentUtils.getContentAuthor(toTorrent);
                                description = PlatformTorrentUtils.getContentDescription(toTorrent);
                                if (description != null) {
                                    description = this.escapeMultiline(description);
                                    pw.println("<description>" + description + "</description>");
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (mediaContent.length() > 0) {
                                mediaContent = String.valueOf(mediaContent) + "></media:content>";
                                pw.println(mediaContent);
                            }
                            pw.println("<media:title>" + this.escape(file.getName()) + "</media:title>");
                            if (description != null) {
                                pw.println("<media:description>" + description + "</media:description>");
                            }
                            if (thumb_url != null) {
                                pw.println("<media:thumbnail url=\"" + thumb_url + "\"/>");
                            }
                            if (thumb_url != null) {
                                pw.println("<itunes:image href=\"" + thumb_url + "\"/>");
                            }
                            if (author != null) {
                                pw.println("<itunes:author>" + this.escape(author) + "</itunees:author>");
                            }
                            pw.println("<itunes:summary>" + this.escape(file.getName()) + "</itunes:summary>");
                            pw.println("<itunes:duration>" + TimeFormatter.formatColon(file.getDurationMillis() / 1000L) + "</itunes:duration>");
                            pw.println("</item>");
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    pw.println("</channel>");
                    pw.println("</rss>");
                }
                finally {
                    if (debug) {
                        pw.setEnabled(false);
                        pw.println("</pre>");
                        pw.println("</BODY></HTML>");
                    }
                }
            }
        }
        pw.flush();
        return true;
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    protected String escapeMultiline(String str) {
        return XUXmlWriter.escapeXML(str.replaceAll("[\r\n]+", "<BR>"));
    }
}

