/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceiTunes;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.PluginManager;

public class DeviceiTunesManager {
    private DeviceManagerImpl device_manager;
    private DeviceiTunes itunes_device;

    protected DeviceiTunesManager(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                DeviceiTunesManager.this.init(core);
            }
        });
    }

    void init(Core core) {
        final PluginManager pm = core.getPluginManager();
        final PluginInterface default_pi = pm.getDefaultPluginInterface();
        default_pi.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                PluginInterface[] plugins;
                default_pi.addEventListener(new PluginEventListener(){

                    @Override
                    public void handleEvent(PluginEvent ev) {
                        int type = ev.getType();
                        if (type == 8) {
                            DeviceiTunesManager.this.pluginAdded((PluginInterface)ev.getValue());
                        }
                        if (type == 9) {
                            DeviceiTunesManager.this.pluginRemoved((PluginInterface)ev.getValue());
                        }
                    }
                });
                PluginInterface[] pluginInterfaceArray = plugins = pm.getPlugins();
                int n = plugins.length;
                int n2 = 0;
                while (n2 < n) {
                    PluginInterface pi = pluginInterfaceArray[n2];
                    if (pi.getPluginState().isOperational()) {
                        DeviceiTunesManager.this.pluginAdded(pi);
                    }
                    ++n2;
                }
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pi) {
        if (pi.getPluginState().isBuiltIn()) {
            return;
        }
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("azitunes")) {
            DeviceiTunes new_device;
            DeviceiTunesManager deviceiTunesManager = this;
            synchronized (deviceiTunesManager) {
                if (this.itunes_device != null) {
                    return;
                }
                this.itunes_device = new_device = new DeviceiTunes(this.device_manager, pi);
            }
            this.device_manager.addDevice(new_device, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pi) {
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("azitunes")) {
            DeviceiTunes existing_device;
            DeviceiTunesManager deviceiTunesManager = this;
            synchronized (deviceiTunesManager) {
                if (this.itunes_device == null) {
                    return;
                }
                existing_device = this.itunes_device;
                this.itunes_device = null;
            }
            existing_device.remove();
        }
    }
}

