/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.impl.TranscodeFileImpl;
import com.biglybt.core.devices.impl.TranscodeJobImpl;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRandomReadRequest;
import com.biglybt.pif.disk.DiskManagerRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TranscodeJobOutputLeecher
implements DiskManagerFileInfo {
    TranscodeJobImpl job;
    TranscodeFileImpl file;
    File save_to;
    private byte[] hash;

    public TranscodeJobOutputLeecher(TranscodeJobImpl _job, TranscodeFileImpl _file) throws TranscodeException {
        this.job = _job;
        this.file = _file;
        this.save_to = this.file.getCacheFile();
        try {
            this.hash = new SHA1Simple().calculateHash(this.save_to.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void setPriority(boolean b) {
    }

    @Override
    public int getNumericPriority() {
        return 0;
    }

    @Override
    public void setNumericPriority(int priority) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setSkipped(boolean b) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Boolean isSkipping() {
        return null;
    }

    @Override
    public void setDeleted(boolean b) {
    }

    @Override
    public void setLink(File link_destination, boolean dont_delete) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public File getLink() {
        return null;
    }

    @Override
    public int getAccessMode() {
        return 1;
    }

    @Override
    public long getDownloaded() {
        return this.getLength();
    }

    @Override
    public long getLastModified() {
        return this.save_to.lastModified();
    }

    @Override
    public long getLength() {
        if (this.file.isComplete()) {
            try {
                return this.file.getTargetFile().getLength();
            }
            catch (Throwable e) {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public File getFile() {
        return this.save_to;
    }

    @Override
    public File getFile(boolean follow_link) {
        return this.save_to;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getFirstPieceNumber() {
        return 0;
    }

    @Override
    public long getPieceSize() {
        return 32768L;
    }

    @Override
    public int getNumPieces() {
        return -1;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public boolean isSkipped() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public byte[] getDownloadHash() throws DownloadException {
        return this.hash;
    }

    @Override
    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        return new Channel();
    }

    @Override
    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        throw new DownloadException("Not supported");
    }

    protected class Channel
    implements DiskManagerChannel {
        volatile boolean channel_destroyed;
        volatile long channel_position;
        private RandomAccessFile raf;

        protected Channel() {
        }

        @Override
        public DiskManagerRequest createRequest() {
            return new request();
        }

        @Override
        public DiskManagerFileInfo getFile() {
            return TranscodeJobOutputLeecher.this;
        }

        @Override
        public long getPosition() {
            return this.channel_position;
        }

        @Override
        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            Channel channel2 = this;
            synchronized (channel2) {
                this.channel_destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.raf = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int read(byte[] buffer, long offset, int length) throws IOException {
            Channel channel2 = this;
            synchronized (channel2) {
                if (this.channel_destroyed) {
                    throw new IOException("Channel destroyed");
                }
                if (this.raf == null) {
                    if (TranscodeJobOutputLeecher.this.save_to.exists()) {
                        this.raf = new RandomAccessFile(TranscodeJobOutputLeecher.this.save_to, "r");
                    } else {
                        int state = TranscodeJobOutputLeecher.this.job.getState();
                        if (state == 7) {
                            throw new IOException("Job has been removed");
                        }
                        if (state == 5) throw new IOException("Job has failed or been cancelled");
                        if (state == 4) {
                            throw new IOException("Job has failed or been cancelled");
                        }
                        if (state == 3) {
                            throw new IOException("Job is complete but file missing");
                        }
                    }
                }
                if (this.raf != null) {
                    if (this.raf.length() > offset) {
                        this.raf.seek(offset);
                        return this.raf.read(buffer, 0, length);
                    }
                    if (TranscodeJobOutputLeecher.this.file.isComplete()) {
                        return -1;
                    }
                }
            }
            try {
                Thread.sleep(500L);
                return 0;
            }
            catch (Throwable e) {
                throw new IOException("Interrupted");
            }
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean request_cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            @Override
            public void setType(int type) {
                if (type != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            @Override
            public void setOffset(long _offset) {
                this.offset = _offset;
            }

            @Override
            public void setLength(long _length) {
                this.length = _length == -1L ? Long.MAX_VALUE : _length;
            }

            @Override
            public void setMaximumReadChunkSize(int size) {
                if (size > 16384) {
                    this.max_read_chunk = size;
                }
            }

            @Override
            public long getAvailableBytes() {
                return this.getRemaining();
            }

            @Override
            public long getRemaining() {
                return this.length == Long.MAX_VALUE ? this.length : this.offset + this.length - this.position;
            }

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[this.max_read_chunk];
                    long rem = this.length;
                    long pos = this.offset;
                    while (rem > 0L) {
                        if (this.request_cancelled) {
                            throw new Exception("Cancelled");
                        }
                        if (Channel.this.channel_destroyed) {
                            throw new Exception("Destroyed");
                        }
                        int chunk = (int)Math.min(rem, (long)this.max_read_chunk);
                        int len = Channel.this.read(buffer, pos, chunk);
                        if (len == -1) {
                            if (this.length != Long.MAX_VALUE) {
                                throw new Exception("Premature end of stream (complete)");
                            }
                            break;
                        }
                        if (len == 0) {
                            this.sendEvent(new event(pos));
                            continue;
                        }
                        this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                        rem -= (long)len;
                        pos += (long)len;
                    }
                }
                catch (Throwable e) {
                    this.sendEvent(new event(e));
                }
            }

            @Override
            public void cancel() {
                this.request_cancelled = true;
            }

            @Override
            public void setUserAgent(String agent) {
            }

            protected void sendEvent(event ev) {
                for (DiskManagerListener l : this.listeners) {
                    l.eventOccurred(ev);
                }
            }

            @Override
            public void addListener(DiskManagerListener listener) {
                this.listeners.add(listener);
            }

            @Override
            public void removeListener(DiskManagerListener listener) {
                this.listeners.remove(listener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable _error) {
                    this.event_type = 2;
                    this.error = _error;
                }

                protected event(long _offset) {
                    this.event_type = 3;
                    this.event_offset = _offset;
                    ((request)request.this).Channel.this.channel_position = _offset;
                }

                protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                    this.event_type = 1;
                    this.buffer = _buffer;
                    this.event_offset = _offset;
                    this.event_length = _length;
                    ((request)request.this).Channel.this.channel_position = _offset + (long)_length - 1L;
                }

                @Override
                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                @Override
                public long getOffset() {
                    return this.event_offset;
                }

                @Override
                public int getLength() {
                    return this.event_length;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                @Override
                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

