/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.control.impl;

import com.biglybt.core.dht.control.DHTControlStats;
import com.biglybt.core.dht.control.impl.DHTControlImpl;
import com.biglybt.core.dht.transport.DHTTransport;
import com.biglybt.core.dht.transport.DHTTransportFullStats;
import com.biglybt.core.dht.transport.DHTTransportStats;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;

public class DHTControlStatsImpl
implements DHTTransportFullStats,
DHTControlStats {
    private static final int UPDATE_INTERVAL = 10000;
    private static final int UPDATE_PERIOD = 120;
    final DHTControlImpl control;
    private final Average packets_in_average = Average.getInstance(10000, 120);
    private final Average packets_out_average = Average.getInstance(10000, 120);
    private final Average bytes_in_average = Average.getInstance(10000, 120);
    private final Average bytes_out_average = Average.getInstance(10000, 120);
    private DHTTransportStats transport_snapshot;
    private long[] router_snapshot;
    private int[] value_details_snapshot;

    protected DHTControlStatsImpl(DHTControlImpl _control) {
        this.control = _control;
        this.transport_snapshot = this.control.getTransport().getStats().snapshot();
        this.router_snapshot = this.control.getRouter().getStats().getStats();
        SimpleTimer.addPeriodicEvent("DHTCS:update", 10000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                DHTControlStatsImpl.this.update();
                DHTControlStatsImpl.this.control.poke();
            }
        });
    }

    protected void update() {
        DHTTransport transport = this.control.getTransport();
        DHTTransportStats t_stats = transport.getStats().snapshot();
        this.packets_in_average.addValue(t_stats.getPacketsReceived() - this.transport_snapshot.getPacketsReceived());
        this.packets_out_average.addValue(t_stats.getPacketsSent() - this.transport_snapshot.getPacketsSent());
        this.bytes_in_average.addValue(t_stats.getBytesReceived() - this.transport_snapshot.getBytesReceived());
        this.bytes_out_average.addValue(t_stats.getBytesSent() - this.transport_snapshot.getBytesSent());
        this.transport_snapshot = t_stats;
        this.router_snapshot = this.control.getRouter().getStats().getStats();
        this.value_details_snapshot = null;
    }

    @Override
    public long getTotalBytesReceived() {
        return this.transport_snapshot.getBytesReceived();
    }

    @Override
    public long getTotalBytesSent() {
        return this.transport_snapshot.getBytesSent();
    }

    @Override
    public long getTotalPacketsReceived() {
        return this.transport_snapshot.getPacketsReceived();
    }

    @Override
    public long getTotalPacketsSent() {
        return this.transport_snapshot.getPacketsSent();
    }

    @Override
    public long getTotalPingsReceived() {
        return this.transport_snapshot.getPings()[3];
    }

    @Override
    public long getTotalFindNodesReceived() {
        return this.transport_snapshot.getFindNodes()[3];
    }

    @Override
    public long getTotalFindValuesReceived() {
        return this.transport_snapshot.getFindValues()[3];
    }

    @Override
    public long getTotalStoresReceived() {
        return this.transport_snapshot.getStores()[3];
    }

    @Override
    public long getTotalKeyBlocksReceived() {
        return this.transport_snapshot.getKeyBlocks()[3];
    }

    @Override
    public long getAverageBytesReceived() {
        return this.bytes_in_average.getAverage();
    }

    @Override
    public long getAverageBytesSent() {
        return this.bytes_out_average.getAverage();
    }

    @Override
    public long getAveragePacketsReceived() {
        return this.packets_in_average.getAverage();
    }

    @Override
    public long getAveragePacketsSent() {
        return this.packets_out_average.getAverage();
    }

    @Override
    public long getIncomingRequests() {
        return this.transport_snapshot.getIncomingRequests();
    }

    protected int[] getValueDetails() {
        int[] vd = this.value_details_snapshot;
        if (vd == null) {
            this.value_details_snapshot = vd = this.control.getDataBase().getStats().getValueDetails();
        }
        return vd;
    }

    @Override
    public long getDBValuesStored() {
        int[] vd = this.getValueDetails();
        return vd[0];
    }

    @Override
    public long getDBKeyCount() {
        return this.control.getDataBase().getStats().getKeyCount();
    }

    @Override
    public long getDBValueCount() {
        return this.control.getDataBase().getStats().getValueCount();
    }

    @Override
    public long getDBKeysBlocked() {
        return this.control.getDataBase().getStats().getKeyBlockCount();
    }

    @Override
    public long getDBKeyDivSizeCount() {
        int[] vd = this.getValueDetails();
        return vd[5];
    }

    @Override
    public long getDBKeyDivFreqCount() {
        int[] vd = this.getValueDetails();
        return vd[4];
    }

    @Override
    public long getDBStoreSize() {
        return this.control.getDataBase().getStats().getSize();
    }

    @Override
    public long getRouterNodes() {
        return this.router_snapshot[0];
    }

    @Override
    public long getRouterLeaves() {
        return this.router_snapshot[1];
    }

    @Override
    public long getRouterContacts() {
        return this.router_snapshot[2];
    }

    @Override
    public long getRouterUptime() {
        return this.control.getRouterUptime();
    }

    @Override
    public int getRouterCount() {
        return this.control.getRouterCount();
    }

    @Override
    public String getVersion() {
        return "3.4.0.0";
    }

    @Override
    public long getEstimatedDHTSize() {
        return this.control.getEstimatedDHTSize();
    }

    @Override
    public String getString() {
        return "transport:" + this.getTotalBytesReceived() + "," + this.getTotalBytesSent() + "," + this.getTotalPacketsReceived() + "," + this.getTotalPacketsSent() + "," + this.getTotalPingsReceived() + "," + this.getTotalFindNodesReceived() + "," + this.getTotalFindValuesReceived() + "," + this.getTotalStoresReceived() + "," + this.getTotalKeyBlocksReceived() + "," + this.getAverageBytesReceived() + "," + this.getAverageBytesSent() + "," + this.getAveragePacketsReceived() + "," + this.getAveragePacketsSent() + "," + this.getIncomingRequests() + ",router:" + this.getRouterNodes() + "," + this.getRouterLeaves() + "," + this.getRouterContacts() + ",database:" + this.getDBKeyCount() + "," + this.getDBValueCount() + "," + this.getDBValuesStored() + "," + this.getDBStoreSize() + "," + this.getDBKeyDivFreqCount() + "," + this.getDBKeyDivSizeCount() + "," + this.getDBKeysBlocked() + ",version:" + this.getVersion() + "," + this.getRouterUptime() + "," + this.getRouterCount();
    }
}

