/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.transport.DHTTransportAlternativeContact;
import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;

public class DHTUDPPacketReplyPing
extends DHTUDPPacketReply {
    private static final DHTTransportAlternativeContact[] EMPTY_CONTACTS = new DHTTransportAlternativeContact[0];
    private DHTTransportAlternativeContact[] alt_contacts = EMPTY_CONTACTS;
    private Object upload_stats;

    public DHTUDPPacketReplyPing(DHTTransportUDPImpl transport, DHTUDPPacketRequestPing request2, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1025, request2, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyPing(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1025, trans_id);
        byte protocol_version = this.getProtocolVersion();
        if (protocol_version >= 10) {
            DHTUDPUtils.deserialiseVivaldi(this, is);
        }
        if (protocol_version >= 52) {
            this.alt_contacts = DHTUDPUtils.deserialiseAltContacts(is);
        }
        if (this.getNetwork() == 4 && protocol_version >= 55) {
            this.upload_stats = DHTUDPUtils.deserialiseUploadStats(is);
        }
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        byte protocol_version = this.getProtocolVersion();
        if (protocol_version >= 10) {
            DHTUDPUtils.serialiseVivaldi(this, os);
        }
        if (protocol_version >= 52) {
            DHTUDPUtils.serialiseAltContacts(os, this.alt_contacts);
        }
        if (this.getNetwork() == 4) {
            DHTUDPUtils.serialiseUploadStats(protocol_version, this.getAction(), os);
        }
    }

    protected void setAltContacts(List<DHTTransportAlternativeContact> _contacts) {
        int MAX_CONTACTS = 16;
        if (_contacts.size() < 16) {
            this.alt_contacts = _contacts.toArray(new DHTTransportAlternativeContact[_contacts.size()]);
        } else {
            this.alt_contacts = new DHTTransportAlternativeContact[16];
            int i = 0;
            while (i < this.alt_contacts.length) {
                this.alt_contacts[i] = _contacts.get(i);
                ++i;
            }
        }
    }

    protected DHTTransportAlternativeContact[] getAltContacts() {
        return this.alt_contacts;
    }

    protected Object getUploadStats() {
        return this.upload_stats;
    }
}

