/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.dht.impl.DHTLog;
import com.biglybt.core.dht.netcoords.DHTNetworkPosition;
import com.biglybt.core.dht.netcoords.DHTNetworkPositionManager;
import com.biglybt.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.biglybt.core.dht.netcoords.vivaldi.ver1.VivaldiPositionFactory;
import com.biglybt.core.dht.transport.DHTTransportAlternativeContact;
import com.biglybt.core.dht.transport.DHTTransportAlternativeNetwork;
import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.dht.transport.DHTTransportException;
import com.biglybt.core.dht.transport.DHTTransportFullStats;
import com.biglybt.core.dht.transport.DHTTransportValue;
import com.biglybt.core.dht.transport.udp.DHTTransportUDP;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportAlternativeContactImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacket;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SystemTime;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DHTUDPUtils {
    public static final IOException INVALID_PROTOCOL_VERSION_EXCEPTION = new IOException("Invalid DHT protocol version, please update " + Constants.APP_NAME);
    protected static final int CT_UDP = 1;
    private static final Map<String, byte[]> node_id_history = new LinkedHashMap<String, byte[]>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, byte[]> eldest) {
            return this.size() > 128;
        }
    };
    private static final SHA1Simple hasher = new SHA1Simple();
    public static final int INETSOCKETADDRESS_IPV4_SIZE = 7;
    public static final int INETSOCKETADDRESS_IPV6_SIZE = 19;
    public static final int DHTTRANSPORTCONTACT_SIZE = 9;
    public static final int DHTTRANSPORTVALUE_SIZE_WITHOUT_VALUE = 26;
    private static final List<DHTTransportUDPImpl> transports = new ArrayList<DHTTransportUDPImpl>();
    private static final List<DHTTransportAlternativeNetwork> alt_networks = new ArrayList<DHTTransportAlternativeNetwork>();
    private static final int MAX_CC_STATS = 24;
    private static final int CALC_PERIOD = 60000;
    private static volatile long last_calc = SystemTime.getMonotonousTime() - 60001L;
    private static volatile GlobalManagerStats.CountryDetails[] last_details_recv = new GlobalManagerStats.CountryDetails[0];
    private static volatile GlobalManagerStats.CountryDetails[] last_details_sent = new GlobalManagerStats.CountryDetails[0];
    private static volatile long last_details_recv_total;
    private static volatile long last_details_sent_total;
    private static volatile GlobalManagerStats gm_stats;
    private static volatile long last_upload_stats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static byte[] getNodeID(InetSocketAddress address, byte protocol_version) throws DHTTransportException {
        String key;
        InetAddress ia = address.getAddress();
        if (ia == null) {
            if (!address.getHostName().equals("dht6.biglybt.com")) throw new DHTTransportException("Address '" + address + "' is unresolved");
            key = "IPv6SeedHack";
        } else if (protocol_version >= 50) {
            byte[] bytes = ia.getAddress();
            if (bytes.length == 4) {
                long K2 = 2500L;
                long K3 = 50L;
                long K4 = 5L;
                long result = (long)address.getPort() % 5L;
                result = ((long)bytes[3] << 8 & 0xFF00L | result) % 50L;
                result = ((long)bytes[2] << 16 & 0xFF0000L | result) % 2500L;
                result = (long)bytes[1] << 24 & 0xFF000000L | result;
                result = (long)bytes[0] << 32 & 0xFF00000000L | result;
                key = String.valueOf(result);
            } else {
                key = String.valueOf(ia.getHostAddress()) + ":" + address.getPort() % 8;
            }
        } else {
            key = protocol_version >= 33 ? String.valueOf(ia.getHostAddress()) + ":" + address.getPort() % 8 : (protocol_version >= 32 ? String.valueOf(ia.getHostAddress()) + ":" + address.getPort() % 1999 : String.valueOf(ia.getHostAddress()) + ":" + address.getPort());
        }
        Map<String, byte[]> map = node_id_history;
        synchronized (map) {
            byte[] res = node_id_history.get(key);
            if (res == null) {
                res = hasher.calculateHash(key.getBytes());
                node_id_history.put(key, res);
            }
            return res;
        }
    }

    protected static byte[] getBogusNodeID() {
        byte[] id = new byte[20];
        RandomUtils.nextBytes(id);
        return id;
    }

    protected static void serialiseLength(DataOutputStream os, int len, int max_length) throws IOException {
        if (len > max_length) {
            throw new IOException("Invalid DHT data length: max=" + max_length + ",actual=" + len);
        }
        if (max_length < 256) {
            os.writeByte(len);
        } else if (max_length < 65536) {
            os.writeShort(len);
        } else {
            os.writeInt(len);
        }
    }

    protected static int deserialiseLength(DataInputStream is, int max_length) throws IOException {
        int len = max_length < 256 ? is.readByte() & 0xFF : (max_length < 65536 ? is.readShort() & 0xFFFF : is.readInt());
        if (len > max_length) {
            throw new IOException("Invalid DHT data length: max=" + max_length + ",actual=" + len);
        }
        return len;
    }

    protected static byte[] deserialiseByteArray(DataInputStream is, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        byte[] data = new byte[len];
        is.read(data);
        return data;
    }

    protected static void serialiseByteArray(DataOutputStream os, byte[] data, int max_length) throws IOException {
        DHTUDPUtils.serialiseByteArray(os, data, 0, data.length, max_length);
    }

    protected static void serialiseByteArray(DataOutputStream os, byte[] data, int start, int length, int max_length) throws IOException {
        DHTUDPUtils.serialiseLength(os, length, max_length);
        os.write(data, start, length);
    }

    protected static void serialiseByteArrayArray(DataOutputStream os, byte[][] data, int max_length) throws IOException {
        DHTUDPUtils.serialiseLength(os, data.length, max_length);
        int i = 0;
        while (i < data.length) {
            DHTUDPUtils.serialiseByteArray(os, data[i], max_length);
            ++i;
        }
    }

    protected static byte[][] deserialiseByteArrayArray(DataInputStream is, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        byte[][] data = new byte[len][];
        int i = 0;
        while (i < data.length) {
            data[i] = DHTUDPUtils.deserialiseByteArray(is, max_length);
            ++i;
        }
        return data;
    }

    protected static void serialiseAddress(DataOutputStream os, InetSocketAddress address) throws IOException, DHTTransportException {
        InetAddress ia = address.getAddress();
        if (ia == null) {
            DHTUDPUtils.serialiseByteArray(os, new byte[4], 16);
            os.writeShort(0);
        } else {
            DHTUDPUtils.serialiseByteArray(os, ia.getAddress(), 16);
            os.writeShort(address.getPort());
        }
    }

    protected static InetSocketAddress deserialiseAddress(DataInputStream is) throws IOException {
        byte[] bytes = DHTUDPUtils.deserialiseByteArray(is, 16);
        int port = is.readShort() & 0xFFFF;
        return new InetSocketAddress(InetAddress.getByAddress(bytes), port);
    }

    protected static DHTTransportValue[][] deserialiseTransportValuesArray(DHTUDPPacket packet, DataInputStream is, long skew, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        DHTTransportValue[][] data = new DHTTransportValue[len][];
        int i = 0;
        while (i < data.length) {
            data[i] = DHTUDPUtils.deserialiseTransportValues(packet, is, skew);
            ++i;
        }
        return data;
    }

    protected static void serialiseTransportValuesArray(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue[][] values, long skew, int max_length) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(os, values.length, max_length);
        int i = 0;
        while (i < values.length) {
            DHTUDPUtils.serialiseTransportValues(packet, os, values[i], skew);
            ++i;
        }
    }

    protected static void serialiseContact(DataOutputStream os, DHTTransportContact contact) throws IOException, DHTTransportException {
        if (!(contact.getTransport() instanceof DHTTransportUDP)) {
            throw new IOException("Unsupported contact type:" + contact.getClass().getName());
        }
        os.writeByte(1);
        os.writeByte(contact.getProtocolVersion());
        DHTUDPUtils.serialiseAddress(os, contact.getExternalAddress());
    }

    protected static DHTTransportUDPContactImpl deserialiseContact(DHTTransportUDPImpl transport, DataInputStream is) throws IOException, DHTTransportException {
        byte ct = is.readByte();
        if (ct != 1) {
            throw new IOException("Unsupported contact type:" + ct);
        }
        byte version = is.readByte();
        InetSocketAddress external_address = DHTUDPUtils.deserialiseAddress(is);
        return new DHTTransportUDPContactImpl(false, transport, external_address, external_address, version, 0, 0L, 0);
    }

    protected static void serialiseAltContact(DataOutputStream os, DHTTransportAlternativeContact contact) throws IOException, DHTTransportException {
        os.write((byte)contact.getNetworkType());
        os.write((byte)contact.getVersion());
        os.writeShort(contact.getAge());
        byte[] encoded = BEncoder.encode(contact.getProperties());
        DHTUDPUtils.serialiseByteArray(os, encoded, 65535);
    }

    protected static DHTTransportAlternativeContactImpl deserialiseAltContact(DataInputStream is) throws IOException, DHTTransportException {
        byte network_type = is.readByte();
        byte version = is.readByte();
        short age = is.readShort();
        byte[] encoded = DHTUDPUtils.deserialiseByteArray(is, 65535);
        return new DHTTransportAlternativeContactImpl(network_type, version, age, encoded);
    }

    protected static DHTTransportValue[] deserialiseTransportValues(DHTUDPPacket packet, DataInputStream is, long skew) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 65535);
        ArrayList<DHTTransportValue> l = new ArrayList<DHTTransportValue>(len);
        int i = 0;
        while (i < len) {
            try {
                l.add(DHTUDPUtils.deserialiseTransportValue(packet, is, skew));
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        DHTTransportValue[] res = new DHTTransportValue[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseTransportValues(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue[] values, long skew) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(os, values.length, 65535);
        int i = 0;
        while (i < values.length) {
            DHTUDPUtils.serialiseTransportValue(packet, os, values[i], skew);
            ++i;
        }
    }

    protected static DHTTransportValue deserialiseTransportValue(DHTUDPPacket packet, DataInputStream is, long skew) throws IOException, DHTTransportException {
        final int version = packet.getProtocolVersion() >= 11 ? is.readInt() : -1;
        final long created = is.readLong() + skew;
        final byte[] value_bytes = DHTUDPUtils.deserialiseByteArray(is, 512);
        final DHTTransportUDPContactImpl originator = DHTUDPUtils.deserialiseContact(packet.getTransport(), is);
        final int flags = is.readByte() & 0xFF;
        final int life_hours = packet.getProtocolVersion() >= 23 ? is.readByte() & 0xFF : 0;
        final byte rep_control = packet.getProtocolVersion() >= 24 ? (byte)is.readByte() : (byte)-1;
        DHTTransportValue value = new DHTTransportValue(){

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public long getCreationTime() {
                return created;
            }

            @Override
            public byte[] getValue() {
                return value_bytes;
            }

            @Override
            public int getVersion() {
                return version;
            }

            @Override
            public DHTTransportContact getOriginator() {
                return originator;
            }

            @Override
            public int getFlags() {
                return flags;
            }

            @Override
            public int getLifeTimeHours() {
                return life_hours;
            }

            @Override
            public byte getReplicationControl() {
                return rep_control;
            }

            @Override
            public byte getReplicationFactor() {
                return rep_control == -1 ? (byte)-1 : (byte)(rep_control & 0xF);
            }

            @Override
            public byte getReplicationFrequencyHours() {
                return rep_control == -1 ? (byte)-1 : (byte)(rep_control >> 4);
            }

            @Override
            public String getString() {
                long now = SystemTime.getCurrentTime();
                return String.valueOf(DHTLog.getString(value_bytes)) + " - " + new String(value_bytes) + "{v=" + version + ",f=" + Integer.toHexString(flags) + ",l=" + life_hours + ",r=" + Integer.toHexString(this.getReplicationControl()) + ",ca=" + (now - created) + ",or=" + originator.getString() + "}";
            }
        };
        return value;
    }

    protected static void serialiseTransportValue(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue value, long skew) throws IOException, DHTTransportException {
        if (packet.getProtocolVersion() >= 11) {
            int version = value.getVersion();
            os.writeInt(version);
        } else {
            os.writeInt(0);
        }
        os.writeLong(value.getCreationTime() + skew);
        DHTUDPUtils.serialiseByteArray(os, value.getValue(), 512);
        DHTUDPUtils.serialiseContact(os, value.getOriginator());
        os.writeByte(value.getFlags());
        if (packet.getProtocolVersion() >= 23) {
            os.writeByte(value.getLifeTimeHours());
        }
        if (packet.getProtocolVersion() >= 24) {
            os.writeByte(value.getReplicationControl());
        }
    }

    protected static void serialiseContacts(DataOutputStream os, DHTTransportContact[] contacts) throws IOException {
        DHTUDPUtils.serialiseLength(os, contacts.length, 65535);
        int i = 0;
        while (i < contacts.length) {
            try {
                DHTUDPUtils.serialiseContact(os, contacts[i]);
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
            ++i;
        }
    }

    protected static DHTTransportContact[] deserialiseContacts(DHTTransportUDPImpl transport, DataInputStream is) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 65535);
        ArrayList<DHTTransportUDPContactImpl> l = new ArrayList<DHTTransportUDPContactImpl>(len);
        int i = 0;
        while (i < len) {
            try {
                DHTTransportUDPContactImpl contact = DHTUDPUtils.deserialiseContact(transport, is);
                if (contact.getAddress().getPort() > 0) {
                    l.add(contact);
                }
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        DHTTransportContact[] res = new DHTTransportContact[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseAltContacts(DataOutputStream os, DHTTransportAlternativeContact[] contacts) throws IOException {
        if (contacts == null) {
            contacts = new DHTTransportAlternativeContact[]{};
        }
        DHTUDPUtils.serialiseLength(os, contacts.length, 64);
        int i = 0;
        while (i < contacts.length) {
            try {
                DHTUDPUtils.serialiseAltContact(os, contacts[i]);
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
            ++i;
        }
    }

    protected static DHTTransportAlternativeContact[] deserialiseAltContacts(DataInputStream is) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 64);
        ArrayList<DHTTransportAlternativeContactImpl> l = new ArrayList<DHTTransportAlternativeContactImpl>(len);
        int i = 0;
        while (i < len) {
            try {
                DHTTransportAlternativeContactImpl contact = DHTUDPUtils.deserialiseAltContact(is);
                l.add(contact);
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        DHTTransportAlternativeContact[] res = new DHTTransportAlternativeContact[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseAltContactRequest(DHTUDPPacketRequestPing ping, DataOutputStream os) throws IOException {
        int[] nets = ping.getAltNetworks();
        int[] counts = ping.getAltNetworkCounts();
        int len = nets == null || counts == null ? 0 : nets.length;
        DHTUDPUtils.serialiseLength(os, len, 16);
        int i = 0;
        while (i < len) {
            os.write(nets[i]);
            os.write(counts[i]);
            ++i;
        }
    }

    protected static void deserialiseAltContactRequest(DHTUDPPacketRequestPing ping, DataInputStream is) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 16);
        int[] nets = new int[len];
        int[] counts = new int[len];
        int i = 0;
        while (i < len) {
            nets[i] = is.read();
            counts[i] = is.read();
            if (nets[i] == -1 || counts[i] == -1) {
                throw new EOFException();
            }
            ++i;
        }
        ping.setAltContactRequest(nets, counts);
    }

    protected static void serialiseVivaldi(DHTUDPPacketReply reply, DataOutputStream os) throws IOException {
        DHTNetworkPosition[] nps = reply.getNetworkPositions();
        if (reply.getProtocolVersion() >= 15) {
            DHTNetworkPosition np;
            boolean v1_found = false;
            int i = 0;
            while (i < nps.length) {
                np = nps[i];
                if (np.getPositionType() == 1) {
                    v1_found = true;
                    break;
                }
                ++i;
            }
            if (!v1_found && reply.getProtocolVersion() < 51) {
                VivaldiPosition np2 = VivaldiPositionFactory.createPosition(Float.NaN);
                DHTNetworkPosition[] new_nps = new DHTNetworkPosition[nps.length + 1];
                System.arraycopy(nps, 0, new_nps, 0, nps.length);
                new_nps[nps.length] = np2;
                nps = new_nps;
            }
            os.writeByte((byte)nps.length);
            i = 0;
            while (i < nps.length) {
                np = nps[i];
                os.writeByte(np.getPositionType());
                os.writeByte(np.getSerialisedSize());
                np.serialise(os);
                ++i;
            }
        } else {
            int i = 0;
            while (i < nps.length) {
                if (nps[i].getPositionType() == 1) {
                    nps[i].serialise(os);
                    return;
                }
                ++i;
            }
            Debug.out("Vivaldi V1 missing");
            throw new IOException("Vivaldi V1 missing");
        }
    }

    protected static void deserialiseVivaldi(DHTUDPPacketReply reply, DataInputStream is) throws IOException {
        DHTNetworkPosition[] nps;
        if (reply.getProtocolVersion() >= 15) {
            int entries = is.readByte() & 0xFF;
            nps = new DHTNetworkPosition[entries];
            int skipped = 0;
            int i = 0;
            while (i < entries) {
                byte type = is.readByte();
                int size = is.readByte();
                DHTNetworkPosition np = DHTNetworkPositionManager.deserialise(reply.getAddress().getAddress(), type, is);
                if (np == null) {
                    ++skipped;
                    int j = 0;
                    while (j < size) {
                        is.readByte();
                        ++j;
                    }
                } else {
                    nps[i] = np;
                }
                ++i;
            }
            if (skipped > 0) {
                DHTNetworkPosition[] x = new DHTNetworkPosition[entries - skipped];
                int pos = 0;
                int i2 = 0;
                while (i2 < nps.length) {
                    if (nps[i2] != null) {
                        x[pos++] = nps[i2];
                    }
                    ++i2;
                }
                nps = x;
            }
        } else {
            nps = new DHTNetworkPosition[]{DHTNetworkPositionManager.deserialise(reply.getAddress().getAddress(), (byte)1, is)};
        }
        reply.setNetworkPositions(nps);
    }

    protected static void serialiseStats(int version, DataOutputStream os, DHTTransportFullStats stats2) throws IOException {
        os.writeLong(stats2.getDBValuesStored());
        os.writeLong(stats2.getRouterNodes());
        os.writeLong(stats2.getRouterLeaves());
        os.writeLong(stats2.getRouterContacts());
        os.writeLong(stats2.getTotalBytesReceived());
        os.writeLong(stats2.getTotalBytesSent());
        os.writeLong(stats2.getTotalPacketsReceived());
        os.writeLong(stats2.getTotalPacketsSent());
        os.writeLong(stats2.getTotalPingsReceived());
        os.writeLong(stats2.getTotalFindNodesReceived());
        os.writeLong(stats2.getTotalFindValuesReceived());
        os.writeLong(stats2.getTotalStoresReceived());
        os.writeLong(stats2.getAverageBytesReceived());
        os.writeLong(stats2.getAverageBytesSent());
        os.writeLong(stats2.getAveragePacketsReceived());
        os.writeLong(stats2.getAveragePacketsSent());
        os.writeLong(stats2.getIncomingRequests());
        String azversion = String.valueOf(stats2.getVersion()) + "[" + version + "]";
        DHTUDPUtils.serialiseByteArray(os, azversion.getBytes(), 64);
        os.writeLong(stats2.getRouterUptime());
        os.writeInt(stats2.getRouterCount());
        if (version >= 14) {
            os.writeLong(stats2.getDBKeysBlocked());
            os.writeLong(stats2.getTotalKeyBlocksReceived());
        }
        if (version >= 20) {
            os.writeLong(stats2.getDBKeyCount());
            os.writeLong(stats2.getDBValueCount());
            os.writeLong(stats2.getDBStoreSize());
            os.writeLong(stats2.getDBKeyDivFreqCount());
            os.writeLong(stats2.getDBKeyDivSizeCount());
        }
    }

    protected static DHTTransportFullStats deserialiseStats(int version, DataInputStream is) throws IOException {
        long db_size_divs;
        long db_freq_divs;
        long db_store_size;
        long db_value_count;
        long db_key_count;
        long total_key_blocks_received;
        long db_keys_blocked;
        final long db_values_stored = is.readLong();
        final long router_nodes = is.readLong();
        final long router_leaves = is.readLong();
        final long router_contacts = is.readLong();
        final long total_bytes_received = is.readLong();
        final long total_bytes_sent = is.readLong();
        final long total_packets_received = is.readLong();
        final long total_packets_sent = is.readLong();
        final long total_pings_received = is.readLong();
        final long total_find_nodes_received = is.readLong();
        final long total_find_values_received = is.readLong();
        final long total_stores_received = is.readLong();
        final long average_bytes_received = is.readLong();
        final long average_bytes_sent = is.readLong();
        final long average_packets_received = is.readLong();
        final long average_packets_sent = is.readLong();
        final long incoming_requests = is.readLong();
        final String az_version = new String(DHTUDPUtils.deserialiseByteArray(is, 64));
        final long router_uptime = is.readLong();
        final int router_count = is.readInt();
        if (version >= 14) {
            db_keys_blocked = is.readLong();
            total_key_blocks_received = is.readLong();
        } else {
            db_keys_blocked = -1L;
            total_key_blocks_received = -1L;
        }
        if (version >= 20) {
            db_key_count = is.readLong();
            db_value_count = is.readLong();
            db_store_size = is.readLong();
            db_freq_divs = is.readLong();
            db_size_divs = is.readLong();
        } else {
            db_key_count = -1L;
            db_value_count = -1L;
            db_store_size = -1L;
            db_freq_divs = -1L;
            db_size_divs = -1L;
        }
        DHTTransportFullStats res = new DHTTransportFullStats(){

            @Override
            public long getDBValuesStored() {
                return db_values_stored;
            }

            @Override
            public long getDBKeysBlocked() {
                return db_keys_blocked;
            }

            @Override
            public long getDBValueCount() {
                return db_value_count;
            }

            @Override
            public long getDBKeyCount() {
                return db_key_count;
            }

            @Override
            public long getDBKeyDivSizeCount() {
                return db_size_divs;
            }

            @Override
            public long getDBKeyDivFreqCount() {
                return db_freq_divs;
            }

            @Override
            public long getDBStoreSize() {
                return db_store_size;
            }

            @Override
            public long getRouterNodes() {
                return router_nodes;
            }

            @Override
            public long getRouterLeaves() {
                return router_leaves;
            }

            @Override
            public long getRouterContacts() {
                return router_contacts;
            }

            @Override
            public long getRouterUptime() {
                return router_uptime;
            }

            @Override
            public int getRouterCount() {
                return router_count;
            }

            @Override
            public long getTotalBytesReceived() {
                return total_bytes_received;
            }

            @Override
            public long getTotalBytesSent() {
                return total_bytes_sent;
            }

            @Override
            public long getTotalPacketsReceived() {
                return total_packets_received;
            }

            @Override
            public long getTotalPacketsSent() {
                return total_packets_sent;
            }

            @Override
            public long getTotalPingsReceived() {
                return total_pings_received;
            }

            @Override
            public long getTotalFindNodesReceived() {
                return total_find_nodes_received;
            }

            @Override
            public long getTotalFindValuesReceived() {
                return total_find_values_received;
            }

            @Override
            public long getTotalStoresReceived() {
                return total_stores_received;
            }

            @Override
            public long getTotalKeyBlocksReceived() {
                return total_key_blocks_received;
            }

            @Override
            public long getAverageBytesReceived() {
                return average_bytes_received;
            }

            @Override
            public long getAverageBytesSent() {
                return average_bytes_sent;
            }

            @Override
            public long getAveragePacketsReceived() {
                return average_packets_received;
            }

            @Override
            public long getAveragePacketsSent() {
                return average_packets_sent;
            }

            @Override
            public long getIncomingRequests() {
                return incoming_requests;
            }

            @Override
            public String getVersion() {
                return az_version;
            }

            @Override
            public String getString() {
                return "transport:" + this.getTotalBytesReceived() + "," + this.getTotalBytesSent() + "," + this.getTotalPacketsReceived() + "," + this.getTotalPacketsSent() + "," + this.getTotalPingsReceived() + "," + this.getTotalFindNodesReceived() + "," + this.getTotalFindValuesReceived() + "," + this.getTotalStoresReceived() + "," + this.getTotalKeyBlocksReceived() + "," + this.getAverageBytesReceived() + "," + this.getAverageBytesSent() + "," + this.getAveragePacketsReceived() + "," + this.getAveragePacketsSent() + "," + this.getIncomingRequests() + ",router:" + this.getRouterNodes() + "," + this.getRouterLeaves() + "," + this.getRouterContacts() + ",database:" + this.getDBKeyCount() + "," + this.getDBValueCount() + "," + this.getDBValuesStored() + "," + this.getDBStoreSize() + "," + this.getDBKeyDivFreqCount() + "," + this.getDBKeyDivSizeCount() + "," + this.getDBKeysBlocked() + ",version:" + this.getVersion() + "," + this.getRouterUptime() + "," + this.getRouterCount();
            }
        };
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerTransport(DHTTransportUDPImpl transport) {
        List<DHTTransportUDPImpl> list = transports;
        synchronized (list) {
            transports.add(transport);
            for (DHTTransportAlternativeNetwork net : alt_networks) {
                transport.registerAlternativeNetwork(net);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAlternativeNetwork(DHTTransportAlternativeNetwork net) {
        List<DHTTransportUDPImpl> list = transports;
        synchronized (list) {
            alt_networks.add(net);
            for (DHTTransportUDPImpl transport : transports) {
                transport.registerAlternativeNetwork(net);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTTransportAlternativeNetwork getAlternativeNetwork(int type) {
        List<DHTTransportUDPImpl> list = transports;
        synchronized (list) {
            for (DHTTransportAlternativeNetwork net : alt_networks) {
                if (net.getNetworkType() != type) continue;
                return net;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAlternativeNetwork(DHTTransportAlternativeNetwork net) {
        List<DHTTransportUDPImpl> list = transports;
        synchronized (list) {
            alt_networks.remove(net);
            for (DHTTransportUDPImpl transport : transports) {
                transport.unregisterAlternativeNetwork(net);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DHTTransportAlternativeContact> getAlternativeContacts(int network, int max) {
        ArrayList<DHTTransportAlternativeContact> result_list = new ArrayList<DHTTransportAlternativeContact>(max);
        if (max > 0) {
            TreeSet<DHTTransportAlternativeContact> result_set = new TreeSet<DHTTransportAlternativeContact>(new Comparator<DHTTransportAlternativeContact>(){

                @Override
                public int compare(DHTTransportAlternativeContact o1, DHTTransportAlternativeContact o2) {
                    int res = o2.getLastAlive() - o1.getLastAlive();
                    if (res == 0) {
                        res = o1.getID() - o2.getID();
                    }
                    return res;
                }
            });
            List<DHTTransportUDPImpl> list = transports;
            synchronized (list) {
                for (DHTTransportAlternativeNetwork net : alt_networks) {
                    List<DHTTransportAlternativeContact> temp;
                    if (net.getNetworkType() != network || (temp = net.getContacts(max)) == null) continue;
                    result_set.addAll(temp);
                }
                for (DHTTransportUDPImpl transport : transports) {
                    List<DHTTransportAlternativeContact> temp;
                    DHTTransportAlternativeNetwork alt = transport.getAlternativeNetwork(network);
                    if (alt == null || (temp = alt.getContacts(max)) == null) continue;
                    result_set.addAll(temp);
                }
            }
            HashSet<Integer> used_ids = new HashSet<Integer>();
            Iterator<DHTTransportAlternativeContact> it = result_set.iterator();
            while (it.hasNext() && result_list.size() < max) {
                DHTTransportAlternativeContact c = it.next();
                int id = c.getID();
                if (used_ids.contains(id)) continue;
                used_ids.add(id);
                result_list.add(c);
            }
        }
        return result_list;
    }

    protected static void serialiseUploadStats(int protocol_version, int packet_type, DataOutputStream os) throws IOException {
        if (protocol_version < 55) {
            return;
        }
        long now = SystemTime.getMonotonousTime();
        if (now - last_upload_stats < 333L) {
            os.writeByte(255);
            return;
        }
        last_upload_stats = now;
        if (now - last_calc > 60000L) {
            if (gm_stats == null) {
                gm_stats = CoreFactory.getSingleton().getGlobalManager().getStats();
            }
            Iterator<GlobalManagerStats.CountryDetails> it = gm_stats.getCountryDetails();
            ArrayList<GlobalManagerStats.CountryDetails> recvs = new ArrayList<GlobalManagerStats.CountryDetails>(128);
            ArrayList<GlobalManagerStats.CountryDetails> sents = new ArrayList<GlobalManagerStats.CountryDetails>(128);
            final HashMap<GlobalManagerStats.CountryDetails, Long> recv_cache = new HashMap<GlobalManagerStats.CountryDetails, Long>();
            final HashMap<GlobalManagerStats.CountryDetails, Long> sent_cache = new HashMap<GlobalManagerStats.CountryDetails, Long>();
            long recv_total = 0L;
            long sent_total = 0L;
            while (it.hasNext()) {
                long sent;
                GlobalManagerStats.CountryDetails cd = it.next();
                if (cd.getCC().isEmpty()) continue;
                long recv = cd.getAverageReceived();
                if (recv > 0L) {
                    recv_total += recv;
                    recvs.add(cd);
                    recv_cache.put(cd, recv);
                }
                if ((sent = cd.getAverageSent()) <= 0L) continue;
                sent_total += sent;
                sents.add(cd);
                sent_cache.put(cd, sent);
            }
            GlobalManagerStats.CountryDetails[] recvs_a = recvs.toArray(new GlobalManagerStats.CountryDetails[0]);
            Arrays.sort(recvs_a, new Comparator<GlobalManagerStats.CountryDetails>(){

                @Override
                public int compare(GlobalManagerStats.CountryDetails o1, GlobalManagerStats.CountryDetails o2) {
                    Long l1 = (Long)recv_cache.get(o1);
                    Long l2 = (Long)recv_cache.get(o2);
                    return Long.compare(l2, l1);
                }
            });
            GlobalManagerStats.CountryDetails[] sents_a = sents.toArray(new GlobalManagerStats.CountryDetails[0]);
            Arrays.sort(sents_a, new Comparator<GlobalManagerStats.CountryDetails>(){

                @Override
                public int compare(GlobalManagerStats.CountryDetails o1, GlobalManagerStats.CountryDetails o2) {
                    Long l1 = (Long)sent_cache.get(o1);
                    Long l2 = (Long)sent_cache.get(o2);
                    return Long.compare(l2, l1);
                }
            });
            last_details_recv_total = recv_total;
            last_details_sent_total = sent_total;
            last_details_recv = recvs_a;
            last_details_sent = sents_a;
            last_calc = now;
        }
        GlobalManagerStats.CountryDetails[] details_recv = last_details_recv;
        GlobalManagerStats.CountryDetails[] details_sent = last_details_sent;
        os.writeByte(2);
        os.writeFloat(last_details_recv_total);
        os.writeFloat(last_details_sent_total);
        int num_recv = details_recv.length;
        int num_sent = details_sent.length;
        if (num_recv + num_sent > 24) {
            int half = 12;
            if (num_recv < 12) {
                num_sent = 24 - num_recv;
            } else if (num_sent < 12) {
                num_recv = 24 - num_sent;
            } else {
                num_sent = 12;
                num_recv = 12;
            }
        }
        int loop = 0;
        while (loop < 2) {
            int records;
            GlobalManagerStats.CountryDetails[] details;
            if (loop == 0) {
                details = details_recv;
                records = num_recv;
            } else {
                details = details_sent;
                records = num_sent;
            }
            os.writeByte((byte)records);
            int i = 0;
            while (i < records) {
                GlobalManagerStats.CountryDetails cd = details[i];
                String cc = cd.getCC();
                if (cc.length() > 2) {
                    cc = cc.equals("I2P") ? "X0" : (cc.equals("Tor") ? "X1" : "X2");
                }
                os.writeByte((byte)cc.charAt(0));
                os.writeByte((byte)cc.charAt(1));
                os.writeFloat(loop == 0 ? cd.getAverageReceived() : cd.getAverageSent());
                ++i;
            }
            ++loop;
        }
    }

    protected static Object deserialiseUploadStats(DataInputStream is) throws IOException {
        byte version;
        block20: {
            version = is.readByte();
            if (version != 0 && version != 1) break block20;
            int records = is.readByte() & 0xFF;
            if (records > 0 && records <= 24) {
                GlobalManagerStats.RemoteCountryStats[] stats2 = new GlobalManagerStats.RemoteCountryStats[records];
                int i = 0;
                while (i < records) {
                    byte c1 = is.readByte();
                    byte c2 = is.readByte();
                    String cc = "" + (char)c1 + (char)c2;
                    if (c1 == 88) {
                        if (cc.equals("X0")) {
                            cc = "I2P";
                        } else if (cc.equals("X1")) {
                            cc = "Tor";
                        }
                    }
                    final String f_cc = cc;
                    final long bytes = version == 0 ? (long)(is.readInt() & 0xFFFFFFFF) * 1024L : (version == 1 ? (long)is.readFloat() : 0L);
                    stats2[i] = new GlobalManagerStats.RemoteCountryStats(){

                        @Override
                        public String getCC() {
                            return f_cc;
                        }

                        @Override
                        public long getAverageReceivedBytes() {
                            return bytes;
                        }

                        @Override
                        public long getAverageSentBytes() {
                            return 0L;
                        }
                    };
                    ++i;
                }
                return stats2;
            }
            return null;
        }
        try {
            if (version == 2) {
                String cc;
                long total_recv = (long)is.readFloat();
                long total_sent = (long)is.readFloat();
                HashMap<String, long[]> stats_map = new HashMap<String, long[]>();
                stats_map.put("", new long[]{total_recv, total_sent});
                int loop = 0;
                while (loop < 2) {
                    int records = is.readByte() & 0xFF;
                    if (records > 0 && records <= 24) {
                        int i = 1;
                        while (i <= records) {
                            long[] values;
                            byte c1 = is.readByte();
                            byte c2 = is.readByte();
                            cc = "" + (char)c1 + (char)c2;
                            if (c1 == 88) {
                                if (cc.equals("X0")) {
                                    cc = "I2P";
                                } else if (cc.equals("X1")) {
                                    cc = "Tor";
                                }
                            }
                            if ((values = (long[])stats_map.get(cc)) == null) {
                                values = new long[2];
                                stats_map.put(cc, values);
                            }
                            values[loop] = (long)is.readFloat();
                            ++i;
                        }
                    }
                    ++loop;
                }
                GlobalManagerStats.RemoteCountryStats[] stats3 = new GlobalManagerStats.RemoteCountryStats[stats_map.size()];
                int pos = 0;
                for (Map.Entry entry : stats_map.entrySet()) {
                    long[] values = (long[])entry.getValue();
                    cc = (String)entry.getKey();
                    final long recv = values[0];
                    final long sent = values[1];
                    stats3[pos++] = new GlobalManagerStats.RemoteCountryStats(){

                        @Override
                        public String getCC() {
                            return cc;
                        }

                        @Override
                        public long getAverageReceivedBytes() {
                            return recv;
                        }

                        @Override
                        public long getAverageSentBytes() {
                            return sent;
                        }
                    };
                }
                return stats3;
            }
            return null;
        }
        catch (Throwable e) {
            if (Constants.IS_CVS_VERSION) {
                Debug.out(e);
            }
            return null;
        }
    }

    protected static void receiveUploadStats(DHTTransportUDPContactImpl contact, Object _stats) {
        if (_stats == null) {
            return;
        }
        final GlobalManagerStats.RemoteCountryStats[] stats2 = (GlobalManagerStats.RemoteCountryStats[])_stats;
        final InetAddress address = contact.getTransportAddress().getAddress();
        if (gm_stats == null) {
            gm_stats = CoreFactory.getSingleton().getGlobalManager().getStats();
        }
        gm_stats.receiveRemoteStats(new GlobalManagerStats.RemoteStats(){

            @Override
            public GlobalManagerStats.RemoteCountryStats[] getStats() {
                return stats2;
            }

            @Override
            public InetAddress getRemoteAddress() {
                return address;
            }
        });
    }
}

