/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import java.io.File;
import java.io.IOException;

public interface DiskManagerFileInfo {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int ST_LINEAR = 1;
    public static final int ST_COMPACT = 2;
    public static final int ST_REORDER = 3;
    public static final int ST_REORDER_COMPACT = 4;

    public void setPriority(int var1);

    public void setSkipped(boolean var1);

    public boolean setLink(File var1, boolean var2);

    public boolean setLinkAtomic(File var1, boolean var2);

    public boolean setLinkAtomic(File var1, boolean var2, FileUtil.ProgressListener var3);

    public File getLink();

    default public boolean isLinked() {
        File file;
        File link = this.getLink();
        return link != null && !FileUtil.areFilePathsIdentical(link, file = this.getFile(false));
    }

    default public boolean setStorageType(int type) {
        return this.setStorageType(type, false);
    }

    public boolean setStorageType(int var1, boolean var2);

    public int getStorageType();

    public int getAccessMode();

    public long getDownloaded();

    public long getLastModified();

    public String getExtension();

    public int getFirstPieceNumber();

    public int getLastPieceNumber();

    public long getLength();

    public int getNbPieces();

    public int getPriority();

    public boolean isSkipped();

    public Boolean isSkipping();

    public boolean exists();

    public int getIndex();

    public DownloadManager getDownloadManager();

    public DiskManager getDiskManager();

    public File getFile(boolean var1);

    public TOTorrentFile getTorrentFile();

    public DirectByteBuffer read(long var1, int var3) throws IOException;

    public void flushCache() throws Exception;

    public int getReadBytesPerSecond();

    public int getWriteBytesPerSecond();

    public long getETA();

    public void recheck();

    public void close();

    public String getLastError();

    public void addListener(DiskManagerFileInfoListener var1);

    public void removeListener(DiskManagerFileInfoListener var1);
}

