/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.DiskManagerAllocationScheduler;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerPieceImpl;
import com.biglybt.core.disk.impl.DiskManagerRecheckScheduler;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.disk.impl.access.DMAccessFactory;
import com.biglybt.core.disk.impl.access.DMChecker;
import com.biglybt.core.disk.impl.access.DMReader;
import com.biglybt.core.disk.impl.access.DMWriter;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapper;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFactory;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFile;
import com.biglybt.core.disk.impl.resume.RDResumeHandler;
import com.biglybt.core.diskmanager.access.DiskAccessController;
import com.biglybt.core.diskmanager.access.DiskAccessControllerFactory;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.diskmanager.cache.CacheFileManagerFactory;
import com.biglybt.core.diskmanager.file.FMFileManager;
import com.biglybt.core.diskmanager.file.FMFileManagerFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.impl.DownloadManagerMoveHandler;
import com.biglybt.core.download.impl.DownloadManagerStatsImpl;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.internat.LocaleUtilEncodingException;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LinkFileMap;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper,
DiskManagerUtil.MoveTaskAapter {
    private static final int DM_FREE_PIECELIST_TIMEOUT = 120000;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final DiskAccessController disk_access_controller;
    static boolean reorder_storage_mode;
    static int reorder_storage_mode_min_mb;
    static volatile boolean missing_file_dl_restart_enabled;
    static boolean skip_incomp_dl_file_checks;
    static boolean skip_comp_dl_file_checks;
    private static final DiskManagerRecheckScheduler recheck_scheduler;
    private static final DiskManagerAllocationScheduler allocation_scheduler;
    private static final ThreadPool start_pool;
    private boolean used = false;
    private boolean started = false;
    final AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private volatile boolean stopping;
    private volatile int state_set_via_method;
    private volatile String errorMessage_set_via_method = "";
    private volatile int errorType = 0;
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long allocate_not_required;
    private long remaining;
    private volatile String allocation_task;
    private volatile long remaining_excluding_dnd;
    private final TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceMap piece_map_use_accessor;
    private long piece_map_use_accessor_time;
    private DiskManagerFileInfoImpl[] files;
    private DiskManagerFileInfoSet fileset;
    protected final DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private final AtomicLong priority_change_marker = new AtomicLong(RandomUtils.nextLong());
    private boolean checking_enabled;
    private volatile boolean move_in_progress;
    private volatile long[] move_progress;
    private volatile File move_subtask;
    private volatile int move_state;
    private static final int LDT_STATE_CHANGED = 1;
    private static final int LDT_PRIO_CHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_FILE_COMPLETED = 4;
    protected static final ListenerManager<DiskManagerListener> listeners_aggregator;
    private final ListenerManager<DiskManagerListener> listeners;
    final AEMonitor start_stop_mon;
    private final Object file_piece_lock;
    private final BitFlags availability;
    public long garbage;

    static {
        int max_read_threads = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int max_read_mb = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int max_write_threads = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int max_write_mb = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create("core", max_read_threads, max_read_mb, max_write_threads, max_write_mb);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + max_read_threads + "/" + max_read_mb + "/" + max_write_threads + "/" + max_write_mb));
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable reorder storage mode", "Reorder storage mode min MB"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                reorder_storage_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                reorder_storage_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Missing File Download Restart Enable", "Skip Complete Download File Checks", "Skip Incomplete Download File Checks"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                missing_file_dl_restart_enabled = COConfigurationManager.getBooleanParameter("Missing File Download Restart Enable");
                skip_comp_dl_file_checks = COConfigurationManager.getBooleanParameter("Skip Complete Download File Checks");
                skip_incomp_dl_file_checks = COConfigurationManager.getBooleanParameter("Skip Incomplete Download File Checks");
            }
        });
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener listener, int type, Object value) {
                Object[] params = (Object[])value;
                DiskManager dm = (DiskManager)params[0];
                if (type == 1) {
                    listener.stateChanged(dm, (Integer)params[1], (Integer)params[2]);
                } else if (type == 2) {
                    listener.filePriorityChanged(dm, (DiskManagerFileInfo)params[1]);
                } else if (type == 3) {
                    listener.pieceDoneChanged(dm, (DiskManagerPiece)params[1]);
                } else if (type == 4) {
                    listener.fileCompleted(dm, (DiskManagerFileInfo)params[1]);
                }
            }
        });
    }

    public static DiskAccessController getDefaultDiskAccessController() {
        return disk_access_controller;
    }

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        if (this.priority_change_marker.get() == 0L) {
            this.priority_change_marker.incrementAndGet();
        }
        this.checking_enabled = true;
        this.move_state = 1;
        this.listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener listener, int type, Object value) {
                listeners_aggregator.dispatch(listener, type, value);
            }
        });
        this.start_stop_mon = new AEMonitor("DiskManager:startStop");
        this.file_piece_lock = new Object();
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        this.errorType = 0;
        if (this.torrent == null) {
            this.setErrorState("Torrent not available");
            this.availability = null;
            return;
        }
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.availability = new BitFlags(this.nbPieces);
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.setErrorState(TorrentUtils.exceptionToText(e));
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.setErrorState("Initialisation failed - " + Debug.getNestedExceptionMessage(e));
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(locale_decoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.setErrorState("Failed to build piece map - " + Debug.getNestedExceptionMessage(e));
            return;
        }
        this.remaining_excluding_dnd = this.remaining = (this.totalLength = this.piece_mapper.getTotalLength());
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        int i = 0;
        while (i < this.nbPieces) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i, i == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength);
            ++i;
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    @Override
    public String getDisplayName() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public DownloadManager getDownload() {
        return this.download_manager;
    }

    @Override
    public void start() {
        try {
            if (this.move_in_progress) {
                Debug.out("start called while move in progress!");
            }
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    boolean stop_required;
                    block14: {
                        try {
                            try {
                                try {
                                    DiskManagerImpl.this.start_stop_mon.enter();
                                    if (DiskManagerImpl.this.stopping) {
                                        throw new Exception("Stopped during startup");
                                    }
                                }
                                finally {
                                    DiskManagerImpl.this.start_stop_mon.exit();
                                }
                                DiskManagerImpl.this.startSupport();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                DiskManagerImpl.this.setErrorState(String.valueOf(Debug.getNestedExceptionMessage(e)) + " (start)");
                                DiskManagerImpl.this.started_sem.release();
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            DiskManagerImpl.this.started_sem.release();
                            throw throwable;
                        }
                        DiskManagerImpl.this.started_sem.release();
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        stop_required = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                    }
                    finally {
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    if (stop_required) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    void startSupport() {
        boolean files_exist = false;
        if (this.download_manager.isPersistent()) {
            File[] move_to_dirs = DownloadManagerMoveHandler.getRelatedDirs(this.download_manager);
            int i = 0;
            while (i < move_to_dirs.length) {
                File move_to_dir = move_to_dirs[i].getAbsoluteFile();
                if (this.filesExist(move_to_dir, true)) {
                    files_exist = true;
                    this.alreadyMoved = true;
                    this.download_manager.setTorrentSaveDir(move_to_dir, false);
                    break;
                }
                ++i;
            }
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        if (!this.alreadyMoved && !this.download_manager.isDataAlreadyAllocated()) {
            SaveLocationChange transfer;
            if (!files_exist) {
                files_exist = this.filesExist();
            }
            if (!files_exist && (transfer = DownloadManagerMoveHandler.onInitialisation(this.download_manager)) != null) {
                if (transfer.download_location != null || transfer.download_name != null) {
                    File dl_location = transfer.download_location;
                    if (dl_location == null) {
                        dl_location = this.download_manager.getAbsoluteSaveLocation().getParentFile();
                    }
                    if (transfer.download_name == null) {
                        this.download_manager.setTorrentSaveDir(dl_location, false);
                    } else {
                        this.download_manager.setTorrentSaveDir(FileUtil.newFile(dl_location, transfer.download_name), true);
                    }
                }
                if (transfer.torrent_location != null || transfer.torrent_name != null) {
                    try {
                        this.download_manager.setTorrentFile(transfer.torrent_location, transfer.torrent_name);
                    }
                    catch (DownloadManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        boolean[] stop_after_start = new boolean[1];
        int[] alloc_result = this.allocateFiles(stop_after_start);
        int newFiles = alloc_result[0];
        int notNeededFiles = alloc_result[1];
        int numPadFiles = alloc_result[2];
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (this.checking_enabled) {
            if (newFiles == 0) {
                this.resume_handler.checkAllPieces(false, this.download_manager.isForceRechecking(), p -> {
                    this.percentDone = p;
                });
                if (this.getRemainingExcludingDND() == 0L) {
                    this.checkFreePieceList(true);
                }
            } else if (newFiles + notNeededFiles + numPadFiles != this.files.length) {
                this.resume_handler.checkAllPieces(true, this.download_manager.isForceRechecking(), p -> {
                    this.percentDone = p;
                });
            }
        }
        if (this.getState() == 10) {
            if (this.resume_handler.isCancelled()) {
                Debug.out("toot");
            }
            return;
        }
        this.skipped_file_set_changed = true;
        if (stop_after_start[0]) {
            this.setErrorState(3);
        } else {
            this.setState(4);
        }
    }

    @Override
    public boolean stop(boolean closing) {
        try {
            if (this.move_in_progress) {
                Debug.out("stop called while move in progress!");
            }
            this.start_stop_mon.enter();
            if (!this.started) {
                return false;
            }
            if (this.starting) {
                this.stopping = true;
                this.checker.stop();
                this.writer.stop();
                this.reader.stop();
                this.resume_handler.stop(closing);
                this.saveState(false);
                return true;
            }
            this.started = false;
            this.stopping = false;
        }
        finally {
            this.start_stop_mon.exit();
        }
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(closing);
        if (this.files != null) {
            int i = 0;
            while (i < this.files.length) {
                try {
                    if (this.files[i] != null) {
                        this.files[i].getCacheFile().close();
                    }
                }
                catch (Throwable e) {
                    this.setFailed(1, "File close fails", e);
                }
                ++i;
            }
        }
        if (this.getState() == 4 || this.getState() == 10 && this.errorType == 3) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception e) {
                this.setFailed(1, "Resume data save fails", e);
            }
        }
        this.saveState(false);
        this.listeners.clear();
        return false;
    }

    @Override
    public boolean isStopped() {
        if (this.move_in_progress) {
            Debug.out("isStopped called while move in progress!");
        }
        try {
            this.start_stop_mon.enter();
            boolean bl = !this.started && !this.starting && !this.stopping;
            return bl;
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    @Override
    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParentFile(), false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(File root_dir, boolean exact) {
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = FileUtil.newFile(root_dir, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        String[] storage_types = this.getStorageTypes();
        DownloadManagerState state = this.download_manager.getDownloadState();
        int i = 0;
        while (i < pm_files.length) {
            block19: {
                DMPieceMapperFile pm_info = pm_files[i];
                String relative_file = pm_info.getRelativeDataPath();
                long target_length = pm_info.getLength();
                DiskManagerFileInfoImpl file_info = (DiskManagerFileInfoImpl)pm_info.getFileInfo();
                boolean close_it = false;
                try {
                    if (file_info == null) {
                        int storage_type = DiskManagerUtil.convertDMStorageTypeFromString(storage_types[i]);
                        file_info = this.createFileInfo(state, pm_info, i, root_dir, relative_file, storage_type);
                        close_it = true;
                    }
                    try {
                        CacheFile cache_file = file_info.getCacheFile();
                        File data_file = file_info.getFile(true);
                        if (!cache_file.exists()) {
                            File current = data_file;
                            while (!current.exists()) {
                                File parent = current.getParentFile();
                                if (parent == null) break;
                                if (!parent.exists()) {
                                    current = parent;
                                    continue;
                                }
                                if (parent.isDirectory()) {
                                    this.setErrorMessage(String.valueOf(current.toString()) + " not found.");
                                } else {
                                    this.setErrorMessage(String.valueOf(parent.toString()) + " is not a directory.");
                                }
                                return false;
                            }
                            this.setErrorMessage(String.valueOf(data_file.toString()) + " not found.");
                            return false;
                        }
                        long existing_length = file_info.getCacheFile().getLength();
                        if (exact && !file_info.isSkipped() && existing_length != target_length) {
                            this.setErrorMessage(String.valueOf(data_file.toString()) + " incorrect size.");
                            return false;
                        }
                        if (existing_length <= target_length) break block19;
                        if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                            file_info.setAccessMode(2);
                            file_info.getCacheFile().setLength(target_length);
                            Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                            break block19;
                        }
                        this.setErrorMessage("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath());
                        return false;
                    }
                    finally {
                        if (close_it) {
                            file_info.getCacheFile().close();
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    this.setErrorMessage(e, "filesExist:" + relative_file);
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private DiskManagerFileInfoImpl createFileInfo(DownloadManagerState state, DMPieceMapperFile pm_info, int file_index, File root_dir, String relative_file, int storage_type) throws CacheFileManagerException {
        block9: {
            try {
                return new DiskManagerFileInfoImpl(this, root_dir, relative_file, file_index, pm_info.getTorrentFile(), storage_type);
            }
            catch (CacheFileManagerException e) {
                if (!Debug.getNestedExceptionMessage(e).contains("volume label syntax is incorrect")) break block9;
                target_file = FileUtil.newFile(root_dir, new String[]{relative_file});
                actual_file = state.getFileLink(file_index, target_file);
                if (actual_file == null) {
                    actual_file = target_file;
                }
                temp = actual_file;
                comps = new Stack<String>();
                fixed = false;
                ** while (temp != null)
            }
lbl-1000:
            // 1 sources

            {
                if (temp.exists()) break;
                old_name = temp.getName();
                new_name = "";
                var19_19 = chars = old_name.toCharArray();
                var18_18 = chars.length;
                var17_17 = 0;
                while (var17_17 < var18_18) {
                    c = var19_19[var17_17];
                    i_c = c;
                    new_name = i_c >= '\u0000' && i_c < ' ' ? String.valueOf(new_name) + "_" : String.valueOf(new_name) + c;
                    ++var17_17;
                }
                comps.push(new_name);
                if (!old_name.equals(new_name)) {
                    fixed = true;
                }
                temp = temp.getParentFile();
                continue;
            }
lbl31:
            // 2 sources

            if (fixed) {
                while (!comps.isEmpty()) {
                    comp = (String)comps.pop();
                    if (comps.isEmpty()) {
                        prefix = Base32.encode(new SHA1Simple().calculateHash(relative_file.getBytes(Constants.UTF_8))).substring(0, 4);
                        comp = String.valueOf(prefix) + "_" + comp;
                    }
                    temp = FileUtil.newFile(temp, new String[]{comp});
                }
                Debug.outNoStack("Fixing unsupported file path: " + actual_file.getAbsolutePath() + " -> " + temp.getAbsolutePath());
                state.setFileLink(file_index, target_file, temp);
                return new DiskManagerFileInfoImpl(this, root_dir, relative_file, file_index, pm_info.getTorrentFile(), storage_type);
            }
        }
        throw e;
    }

    /*
     * Exception decompiling
     */
    private int[] allocateFiles(boolean[] stop_after_start) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 40[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean allocateFile(DiskManagerAllocationScheduler.AllocationInstance allocation_instance, DiskManagerFileInfoImpl fileInfo2, File data_file, long existing_length, long target_length, boolean[] stop_after_start, long alloc_strategy) throws Throwable {
        block28: {
            boolean def_strategy;
            while (this.started && !this.stopping) {
                if (allocation_instance.getPermission()) break;
            }
            if (this.stopping || !this.started) {
                this.setErrorState("File allocation interrupted - download is stopping");
                return false;
            }
            fileInfo2.setAccessMode(2);
            boolean bl = def_strategy = alloc_strategy == 0L;
            if (def_strategy && COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                if (existing_length < 0L) {
                    fileInfo2.getCacheFile().setLength(0L);
                }
                this.allocated += target_length;
            } else if (def_strategy && target_length > 0L && !Constants.isWindows && COConfigurationManager.getBooleanParameter("XFS Allocation")) {
                long resvp_len;
                long resvp_start;
                fileInfo2.getCacheFile().setLength(target_length);
                if (existing_length > 0L) {
                    resvp_start = existing_length;
                    resvp_len = target_length - existing_length;
                } else {
                    resvp_start = 0L;
                    resvp_len = target_length;
                }
                String[] cmd = new String[]{"/usr/sbin/xfs_io", "-c", "resvsp " + resvp_start + " " + resvp_len, data_file.getAbsolutePath()};
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    int count = p.getErrorStream().read(buffer);
                    while (count > 0) {
                        os.write(buffer, 0, count);
                        count = p.getErrorStream().read(buffer);
                    }
                    os.close();
                    p.waitFor();
                }
                catch (IOException e) {
                    String message = MessageText.getString("xfs.allocation.xfs_io.not.found", new String[]{e.getMessage()});
                    Logger.log(new LogAlert((Object)this, false, 3, message));
                }
                if (os.size() > 0) {
                    String message = os.toString().trim();
                    if (message.endsWith("is not on an XFS filesystem")) {
                        Logger.log(new LogEvent(this, LogIDs.DISK, "XFS file allocation impossible because \"" + data_file.getAbsolutePath() + "\" is not on an XFS filesystem. Original error reported by xfs_io : \"" + message + "\""));
                    } else {
                        throw new Exception(message);
                    }
                }
                this.allocated += target_length;
            } else {
                if (COConfigurationManager.getBooleanParameter("Zero New") || alloc_strategy == 1L || alloc_strategy == 2L) {
                    boolean successfulAlloc = false;
                    try {
                        try {
                            DownloadManagerState dms;
                            long start_from = 0L;
                            if (existing_length > 0L && existing_length < target_length && this.download_manager.getState() == 30) {
                                start_from = existing_length;
                            }
                            if (!(!(successfulAlloc = this.writer.zeroFile(allocation_instance, fileInfo2, start_from, target_length, b -> this.allocated += b)) || stop_after_start[0] || !COConfigurationManager.getBooleanParameter("Zero New Stop") && alloc_strategy != 2L || (dms = this.download_manager.getDownloadState()).getFlag(512L) || dms.getFlag(16384L))) {
                                stop_after_start[0] = true;
                            }
                            break block28;
                        }
                        catch (Throwable e) {
                            this.fileAllocFailed(data_file, target_length, existing_length == -1L, e);
                            throw e;
                        }
                    }
                    finally {
                        if (!successfulAlloc) {
                            try {
                                fileInfo2.getCacheFile().close();
                                fileInfo2.getCacheFile().delete();
                            }
                            catch (Throwable throwable) {}
                            this.setErrorState();
                        }
                    }
                }
                fileInfo2.getCacheFile().setLength(target_length);
                this.allocated += target_length;
            }
        }
        fileInfo2.setAccessMode(1);
        return true;
    }

    private void fileAllocFailed(File file, long length, boolean is_new, Throwable e) {
        this.setErrorMessage(length, e, "allocateFiles " + (is_new ? "new" : "existing") + ":" + file.toString());
    }

    @Override
    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    @Override
    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    @Override
    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        return this.reader.hasOutstandingReadRequestForPiece(piece_number);
    }

    @Override
    public int getNbPieces() {
        return this.nbPieces;
    }

    @Override
    public int getPercentDone() {
        return this.percentDone;
    }

    @Override
    public int getPercentAllocated() {
        return (int)((this.allocated + this.allocate_not_required) * 1000L / this.totalLength);
    }

    @Override
    public long[] getLatency() {
        return new long[]{this.reader.getLatency(), this.writer.getLatency()};
    }

    @Override
    public String getAllocationTask() {
        return this.allocation_task;
    }

    @Override
    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupSkippedCalculation() {
        DiskManagerFileInfoImpl[] current_files;
        if (this.skipped_file_set_changed && (current_files = this.files) != null) {
            this.skipped_file_set_changed = false;
            Object object = this.file_piece_lock;
            synchronized (object) {
                try {
                    long skipped = 0L;
                    long downloaded = 0L;
                    int i = 0;
                    while (i < current_files.length) {
                        DiskManagerFileInfoImpl file = current_files[i];
                        if (file.isSkipped()) {
                            skipped += file.getLength();
                            downloaded += file.getDownloaded();
                        }
                        ++i;
                    }
                    this.skipped_file_set_size = skipped;
                    this.skipped_but_downloaded = downloaded;
                }
                finally {
                    this.remaining_excluding_dnd = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded);
                    if (this.remaining_excluding_dnd < 0L) {
                        Debug.out("remaining_excluding_dnd went negative");
                        this.remaining_excluding_dnd = 0L;
                    }
                }
            }
            DownloadManagerStats stats2 = this.download_manager.getStats();
            if (stats2 instanceof DownloadManagerStatsImpl) {
                ((DownloadManagerStatsImpl)stats2).setSkippedFileStats(this.skipped_file_set_size, this.skipped_but_downloaded);
            }
        }
    }

    @Override
    public long getRemainingExcludingDND() {
        this.fixupSkippedCalculation();
        return this.remaining_excluding_dnd;
    }

    @Override
    public long getSizeExcludingDND() {
        this.fixupSkippedCalculation();
        return this.totalLength - this.skipped_file_set_size;
    }

    @Override
    public int getPercentDoneExcludingDND() {
        long sizeExcludingDND = this.getSizeExcludingDND();
        if (sizeExcludingDND <= 0L) {
            return 0;
        }
        float pct = (float)(sizeExcludingDND - this.getRemainingExcludingDND()) / (float)sizeExcludingDND;
        return (int)(1000.0f * pct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
        int piece_number = dmPiece.getPieceNumber();
        int piece_length = dmPiece.getLength();
        Object object = this.file_piece_lock;
        synchronized (object) {
            block38: {
                try {
                    if (dmPiece.isDone() == done) break block38;
                    dmPiece.setDoneSupport(done);
                    if (done) {
                        this.availability.set(piece_number);
                        this.remaining -= (long)piece_length;
                    } else {
                        this.availability.unset(piece_number);
                        this.remaining += (long)piece_length;
                    }
                    DMPieceList piece_list = this.getPieceList(piece_number);
                    int i = 0;
                    while (i < piece_list.size()) {
                        long file_done;
                        DMPieceMapEntry piece_map_entry = piece_list.get(i);
                        DiskManagerFileInfoImpl this_file = (DiskManagerFileInfoImpl)piece_map_entry.getFile();
                        long file_length = this_file.getLength();
                        long file_done_before = file_done = this_file.getDownloaded();
                        file_done = done ? (file_done += (long)piece_map_entry.getLength()) : (file_done -= (long)piece_map_entry.getLength());
                        if (file_done < 0L) {
                            Debug.out("piece map entry length negative");
                            file_done = 0L;
                        } else if (file_done > file_length) {
                            Debug.out("piece map entry length too large");
                            file_done = file_length;
                        }
                        if (this_file.isSkipped()) {
                            this.skipped_but_downloaded += file_done - file_done_before;
                        }
                        this_file.setDownloaded(file_done);
                        if (file_done == file_length) {
                            try {
                                DownloadManagerState state = this.download_manager.getDownloadState();
                                try {
                                    String suffix = state.getAttribute("incompfilesuffix");
                                    if (suffix != null && suffix.length() > 0) {
                                        File save_location;
                                        String name;
                                        String prefix = state.getAttribute("dnd_pfx");
                                        if (prefix == null) {
                                            prefix = "";
                                        }
                                        File base_file = this_file.getFile(false);
                                        int file_index = this_file.getIndex();
                                        File link = state.getFileLink(file_index, base_file);
                                        if (link != null) {
                                            String name2 = link.getName();
                                            if (name2.endsWith(suffix) && name2.length() > suffix.length()) {
                                                File new_file;
                                                String new_name = name2.substring(0, name2.length() - suffix.length());
                                                if (!this_file.isSkipped() && prefix.length() > 0 && new_name.startsWith(prefix)) {
                                                    new_name = new_name.substring(prefix.length());
                                                }
                                                if (!(new_file = FileUtil.newFile(link.getParentFile(), new_name)).exists()) {
                                                    this_file.renameFile(new_name);
                                                    if (base_file.equals(new_file)) {
                                                        state.setFileLink(file_index, base_file, null);
                                                    } else {
                                                        state.setFileLink(file_index, base_file, new_file);
                                                    }
                                                }
                                            }
                                        } else if (this_file.getTorrentFile().getTorrent().isSimpleTorrent() && (name = (save_location = this.download_manager.getSaveLocation()).getName()).endsWith(suffix) && name.length() > suffix.length()) {
                                            File new_file;
                                            String new_name = name.substring(0, name.length() - suffix.length());
                                            if (!this_file.isSkipped() && prefix.length() > 0 && new_name.startsWith(prefix)) {
                                                new_name = new_name.substring(prefix.length());
                                            }
                                            if (!(new_file = FileUtil.newFile(save_location.getParentFile(), new_name)).exists()) {
                                                this_file.renameFile(new_name);
                                                if (save_location.equals(new_file)) {
                                                    state.setFileLink(0, save_location, null);
                                                } else {
                                                    state.setFileLink(0, save_location, new_file);
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (this_file.getAccessMode() == 2) {
                                        this_file.setAccessMode(1);
                                    }
                                    if (this.getState() == 4) {
                                        state.setLongParameter("stats.download.file.completed.time", SystemTime.getCurrentTime());
                                        this.listeners.dispatch(4, new Object[]{this, this_file});
                                    }
                                    throw throwable;
                                }
                                if (this_file.getAccessMode() == 2) {
                                    this_file.setAccessMode(1);
                                }
                                if (this.getState() == 4) {
                                    state.setLongParameter("stats.download.file.completed.time", SystemTime.getCurrentTime());
                                    this.listeners.dispatch(4, new Object[]{this, this_file});
                                }
                            }
                            catch (Throwable e) {
                                this.setFailed(this_file.getCacheFile().exists() ? 6 : 4, "Disk access error", e);
                                Debug.printStackTrace(e);
                            }
                        }
                        ++i;
                    }
                    if (this.getState() == 4) {
                        this.listeners.dispatch(3, new Object[]{this, dmPiece});
                    }
                }
                finally {
                    this.remaining_excluding_dnd = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded);
                    if (this.remaining_excluding_dnd < 0L) {
                        Debug.out("remaining_excluding_dnd went negative");
                        this.remaining_excluding_dnd = 0L;
                    }
                }
            }
        }
    }

    @Override
    public BitFlags getAvailability() {
        return this.availability;
    }

    @Override
    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    @Override
    public DiskManagerPiece getPiece(int PieceNumber) {
        return this.pieces[PieceNumber];
    }

    @Override
    public int getPieceLength() {
        return this.pieceLength;
    }

    @Override
    public int getPieceLength(int piece_number) {
        if (piece_number == this.nbPieces - 1) {
            return this.lastPieceLength;
        }
        return this.pieceLength;
    }

    @Override
    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    @Override
    public int getState() {
        return this.state_set_via_method;
    }

    private void setErrorMessage(String str) {
        this.errorMessage_set_via_method = str;
    }

    private void setErrorMessage(Throwable e, String str) {
        this.errorMessage_set_via_method = String.valueOf(Debug.getNestedExceptionMessage(e)) + " (" + str + ")";
    }

    private void setErrorMessage(long file_length, Throwable e, String str) {
        if (DiskManagerUtil.isNoSpaceException(e)) {
            this.errorType = 2;
            this.errorMessage_set_via_method = file_length >= 0x100000000L ? MessageText.getString("DiskManager.error.nospace_fat32") : MessageText.getString("DiskManager.error.nospace");
        } else {
            String exception_str = Debug.getNestedExceptionMessage(e);
            this.errorMessage_set_via_method = String.valueOf(exception_str) + " (" + str + ")";
        }
    }

    private void setErrorState() {
        this.setState(10);
    }

    private void setErrorState(String msg) {
        this.setErrorMessage(msg);
        this.setState(10);
    }

    private void setErrorState(int type, String msg) {
        this.setErrorMessage(msg);
        this.errorType = type;
        this.setState(10);
    }

    private void setErrorState(int type, String msg, Throwable cause) {
        String exception_str = Debug.getNestedExceptionMessage(cause);
        this.errorMessage_set_via_method = String.valueOf(msg) + ": " + exception_str;
        this.errorType = type;
        this.setState(10);
    }

    private void setErrorState(int type) {
        this.errorType = type;
        this.setState(10);
    }

    private void setState(int _state) {
        if (this.state_set_via_method == 10) {
            if (_state != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + _state);
            }
            return;
        }
        if (this.state_set_via_method != _state) {
            Object[] params = new Object[]{this, this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            if (_state == 10 && this.errorType == 0) {
                this.errorType = 1;
            }
            this.listeners.dispatch(1, params);
        }
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public DiskManagerFileInfoSet getFileSet() {
        return this.fileset;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage_set_via_method;
    }

    @Override
    public int getErrorType() {
        return this.errorType;
    }

    @Override
    public void setFailed(final int type, final String reason, final Throwable cause) {
        new AEThread2("DiskManager:setFailed"){

            @Override
            public void run() {
                String msg = String.valueOf(reason) + ": " + Debug.getNestedExceptionMessage(cause);
                if (missing_file_dl_restart_enabled && type == 4) {
                    Logger.log(new LogEvent((Object)DiskManagerImpl.this, LOGID, 3, msg));
                } else {
                    msg = String.valueOf(DiskManagerImpl.this.getDisplayName()) + ": " + msg;
                    Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, msg));
                }
                DiskManagerImpl.this.setErrorState(type, reason, cause);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    @Override
    public void setFailedAndRecheck(final DiskManagerFileInfo file, final String reason) {
        new AEThread2("DiskManager:setFailed"){

            @Override
            public void run() {
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, reason));
                DiskManagerImpl.this.setErrorState(reason);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, file);
            }
        }.start();
    }

    @Override
    public int getCacheMode() {
        return 1;
    }

    @Override
    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[2];
        }
        return this.reader.getStats();
    }

    @Override
    public long[] getWriteStats() {
        if (this.writer == null) {
            return new long[4];
        }
        return this.writer.getStats();
    }

    @Override
    public DMPieceMap getPieceMap() {
        DMPieceMap map = this.piece_map_use_accessor;
        if (map == null) {
            this.piece_map_use_accessor = map = this.piece_mapper.getPieceMap();
        }
        this.piece_map_use_accessor_time = SystemTime.getCurrentTime();
        return map;
    }

    @Override
    public DMPieceList getPieceList(int piece_number) {
        DMPieceMap map = this.getPieceMap();
        return map.getPieceList(piece_number);
    }

    public void checkFreePieceList(boolean force_discard) {
        if (this.piece_map_use_accessor == null) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (!force_discard) {
            if (now < this.piece_map_use_accessor_time) {
                this.piece_map_use_accessor_time = now;
                return;
            }
            if (now - this.piece_map_use_accessor_time < 120000L) {
                return;
            }
        }
        this.piece_map_use_accessor = null;
    }

    @Override
    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    @Override
    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return this.checker.createCheckRequest(pieceNumber, user_data);
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        return this.checker.hasOutstandingCheckRequestForPiece(piece_number);
    }

    @Override
    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCompleteRecheckRequest(request2, listener);
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCheckRequest(request2, listener);
    }

    @Override
    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    @Override
    public boolean getRecheckCancelled() {
        return this.checker.getRecheckCancelled() || this.resume_handler.isCancelled();
    }

    @Override
    public long[] getMoveProgress() {
        if (this.move_in_progress) {
            return this.move_progress;
        }
        return null;
    }

    @Override
    public String getMoveSubTask() {
        File f;
        if (this.move_in_progress && (f = this.move_subtask) != null) {
            return f.getName();
        }
        return "";
    }

    @Override
    public void setMoveState(int state) {
        this.move_state = this.move_in_progress ? state : 1;
    }

    @Override
    public void setPieceCheckingEnabled(boolean enabled) {
        this.checking_enabled = enabled;
        this.checker.setCheckingEnabled(enabled);
    }

    @Override
    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        return this.writer.createWriteRequest(pieceNumber, offset, data, user_data);
    }

    @Override
    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        this.writer.writeBlock(request2, listener);
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        return this.writer.hasOutstandingWriteRequestForPiece(piece_number);
    }

    @Override
    public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int length = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            length = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " > length=" + length));
            }
            return false;
        }
        int size = data.remaining((byte)8);
        if (size <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " size=" + size + " <= 0"));
            }
            return false;
        }
        if (offset + size > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " + size=" + size + " > length=" + length));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, originator, peer_request, pieceNumber, offset, length);
    }

    @Override
    public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, originator, pieceNumber, offset, length);
    }

    @Override
    public void saveResumeData(boolean interim_save) throws Exception {
        this.resume_handler.saveResumeData(interim_save);
    }

    @Override
    public DiskManager.DownloadEndedProgress downloadEnded(boolean start_of_day) {
        DownloadEndedProgressImpl progress = new DownloadEndedProgressImpl();
        AEThread2.createAndStartDaemon("DownloadEnded", () -> this.moveDownloadFilesWhenEndedOrRemoved(false, true, progress, start_of_day));
        return progress;
    }

    @Override
    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true, new DownloadEndedProgressImpl(), false);
    }

    private void moveDownloadFilesWhenEndedOrRemoved(boolean removing, boolean torrent_file_exists, final DownloadEndedProgressImpl progress, boolean start_of_day) {
        try {
            boolean ending;
            this.start_stop_mon.enter();
            boolean bl = ending = !removing;
            if (ending) {
                if (this.alreadyMoved) {
                    progress.setComplete();
                    FileUtil.log("Move of \"" + this.download_manager.getDisplayName() + "\" ignored, already moved");
                    return;
                }
                this.alreadyMoved = true;
            }
            if (removing) {
                SaveLocationChange remove_details = DownloadManagerMoveHandler.onRemoval(this.download_manager);
                if (remove_details != null) {
                    this.moveDownloadFilesWhenEndedOrRemoved0(remove_details, progress);
                } else {
                    progress.setComplete();
                }
            } else {
                final boolean[] delegated = new boolean[1];
                DownloadManagerMoveHandler.onCompletion(this.download_manager, new DownloadManagerMoveHandler.MoveCallback(){

                    @Override
                    public void perform(SaveLocationChange move_details) {
                        delegated[0] = true;
                        DiskManagerImpl.this.moveDownloadFilesWhenEndedOrRemoved0(move_details, progress);
                    }
                }, start_of_day);
                if (!delegated[0]) {
                    if (!start_of_day) {
                        FileUtil.log("Move of \"" + this.download_manager.getDisplayName() + "\" not required");
                    }
                    progress.setComplete();
                }
            }
            return;
        }
        finally {
            this.start_stop_mon.exit();
            if (!removing) {
                try {
                    if (!this.download_manager.isDestroyed()) {
                        this.saveResumeData(false);
                    }
                }
                catch (Throwable e) {
                    this.setFailed(1, "Resume data save fails", e);
                }
            }
        }
    }

    private void moveDownloadFilesWhenEndedOrRemoved0(SaveLocationChange loc_change, DownloadEndedProgressImpl progress) {
        Runnable target = () -> {
            try {
                this.moveFiles(loc_change, true);
            }
            finally {
                progress.setComplete();
            }
        };
        File destination = loc_change.download_location;
        if (destination == null) {
            destination = this.download_manager.getAbsoluteSaveLocation();
        }
        try {
            DiskManagerUtil.runMoveTask(this.download_manager, destination, target, this);
        }
        catch (Throwable e) {
            progress.setComplete();
            Debug.out(e);
        }
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name) {
        SaveLocationChange loc_change = new SaveLocationChange();
        loc_change.download_location = new_parent_dir;
        loc_change.download_name = new_name;
        this.moveFiles(loc_change, false);
    }

    protected void moveFiles(SaveLocationChange loc_change, boolean change_to_read_only) {
        boolean move_files = false;
        if (loc_change.hasDownloadChange()) {
            boolean bl = move_files = !this.isFileDestinationIsItself(loc_change);
            if (!move_files) {
                FileUtil.log("Move of \"" + this.download_manager.getDisplayName() + "\" to " + loc_change.getString() + " not required as already in correct place");
            }
        }
        try {
            try {
                this.start_stop_mon.enter();
                boolean files_moved = true;
                if (move_files) {
                    try {
                        this.move_progress = new long[2];
                        this.move_subtask = null;
                        this.move_state = 1;
                        this.move_in_progress = true;
                        files_moved = this.moveDataFiles0(loc_change, change_to_read_only);
                    }
                    finally {
                        this.move_in_progress = false;
                        this.move_subtask = null;
                        this.move_state = 1;
                    }
                }
                if (loc_change.hasTorrentChange() && (files_moved || !move_files)) {
                    this.moveTorrentFile(loc_change);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.start_stop_mon.exit();
            }
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void logMoveFileError(File destination_path, String message) {
        FileUtil.log(String.valueOf(this.download_manager.getDisplayName()) + ": failed to move to " + destination_path + ", " + message);
        Logger.log(new LogEvent((Object)this, LOGID, 3, message));
        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{destination_path.toString(), message});
    }

    private boolean isFileDestinationIsItself(SaveLocationChange loc_change) {
        File new_location;
        File old_location;
        block4: {
            old_location = this.download_manager.getAbsoluteSaveLocation();
            new_location = loc_change.normaliseDownloadLocation(old_location);
            old_location = old_location.getCanonicalFile();
            new_location = new_location.getCanonicalFile();
            if (!old_location.equals(new_location)) break block4;
            return true;
        }
        try {
            if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(new_location, old_location)) {
                String msg = "Target is sub-directory of files";
                this.logMoveFileError(new_location, msg);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean moveDataFiles0(SaveLocationChange loc_change, boolean change_to_read_only) throws Exception {
        var3_3 = this.file_piece_lock;
        synchronized (var3_3) {
            this.garbage += this.remaining_excluding_dnd;
        }
        current_save_location = this.download_manager.getAbsoluteSaveLocation();
        move_to_dir = loc_change.download_location == null ? current_save_location.getParentFile() : loc_change.download_location;
        new_name = loc_change.download_name;
        if (this.files == null) {
            FileUtil.log("Move of \"" + this.download_manager.getDisplayName() + "\" failed, files=null");
            return false;
        }
        if (this.isFileDestinationIsItself(loc_change)) {
            FileUtil.log("Move of \"" + this.download_manager.getDisplayName() + "\" to " + loc_change.getString() + " not required as already in correct place");
            return false;
        }
        log_str = "Move active \"" + this.download_manager.getDisplayName() + "\" from  " + current_save_location + " to " + move_to_dir;
        files_accepted = 0;
        files_skipped = 0;
        files_done = 0;
        total_size_bytes = 0L;
        total_done_bytes = 0L;
        try {
            FileUtil.log(String.valueOf(log_str) + " starts");
            this.reader.setSuspended(true);
            simple_torrent = this.download_manager.getTorrent().isSimpleTorrent();
            save_location = current_save_location;
            move_from_name = save_location.getName();
            move_from_dir = save_location.getParentFile().getCanonicalFile();
            new_files = new File[this.files.length];
            old_files = new File[this.files.length];
            link_only = new boolean[this.files.length];
            file_lengths_to_move = new long[this.files.length];
            i = 0;
            while (i < this.files.length) {
                old_file = this.files[i].getFile(false);
                linked_file = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, i, old_file);
                if (!linked_file.equals(old_file)) {
                    if (simple_torrent) {
                        if (linked_file.getParentFile().getCanonicalPath().equals(save_location.getParentFile().getCanonicalPath())) {
                            old_file = linked_file;
                        } else {
                            FileUtil.log("File linkage prohibits move: " + linked_file.getCanonicalPath() + " / " + save_location.getCanonicalPath());
                            link_only[i] = true;
                        }
                    } else if (FileUtil.isAncestorOf(save_location, linked_file)) {
                        old_file = linked_file;
                    } else {
                        FileUtil.log("File linkage prohibits move: " + linked_file.getCanonicalPath() + " / " + save_location.getCanonicalPath());
                        link_only[i] = true;
                    }
                }
                old_files[i] = old_file;
                old_parent = old_file.getParentFile();
                sub_path = FileUtil.getRelativePath(move_from_dir, old_parent);
                if (sub_path == null) {
                    this.logMoveFileError(move_to_dir, "Could not determine relative path for file - " + old_parent);
                    throw new IOException("relative path assertion failed: move_from_dir=\"" + move_from_dir + "\", old_parent_path=\"" + old_parent + "\"");
                }
                if (new_name == null) {
                    new_file = FileUtil.newFile(FileUtil.newFile(move_to_dir, new String[]{sub_path}), new String[]{old_file.getName()});
                } else if (simple_torrent) {
                    new_file = FileUtil.newFile(FileUtil.newFile(move_to_dir, new String[]{sub_path}), new String[]{new_name});
                } else {
                    pos = sub_path.indexOf(File.separator);
                    if (pos == -1) {
                        new_path = new_name;
                    } else {
                        sub_sub_path = sub_path.substring(pos);
                        expected_old_name = sub_path.substring(0, pos);
                        new_path = String.valueOf(new_name) + sub_sub_path;
                        assert_expected_old_name = expected_old_name.equals(save_location.getName());
                        if (!assert_expected_old_name) {
                            Debug.out("Assertion check for renaming file in multi-name torrent " + (assert_expected_old_name != false ? "passed" : "failed") + "\n" + "  Old parent path: " + old_parent + "\n" + "  Subpath: " + sub_path + "\n" + "  Sub-subpath: " + sub_sub_path + "\n" + "  Expected old name: " + expected_old_name + "\n" + "  Torrent pre-move name: " + save_location.getName() + "\n" + "  New torrent name: " + new_name + "\n" + "  Old file: " + old_file + "\n" + "  Linked file: " + linked_file + "\n" + "\n" + "  Move-to-dir: " + move_to_dir + "\n" + "  New path: " + new_path + "\n" + "  Old file [name]: " + old_file.getName() + "\n");
                        }
                    }
                    new_file = FileUtil.newFile(FileUtil.newFile(move_to_dir, new String[]{new_path}), new String[]{old_file.getName()});
                }
                new_files[i] = new_file;
                if (link_only[i]) {
                    ++files_skipped;
                } else {
                    ++files_accepted;
                    file_lengths_to_move[i] = old_file.length();
                    total_size_bytes += file_lengths_to_move[i];
                    if (new_file.exists()) {
                        msg = linked_file.getName() + " already exists in MoveTo destination dir";
                        Logger.log(new LogEvent((Object)this, DiskManagerImpl.LOGID, 3, msg));
                        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefileexists"), new String[]{old_file.getName()});
                        Debug.out(msg);
                        return false;
                    }
                    FileUtil.mkdirs(new_file.getParentFile());
                }
                ++i;
            }
            abs_path = move_to_dir.getAbsolutePath();
            _average_config_key = null;
            try {
                _average_config_key = "dm.move.target.abps." + Base32.encode(abs_path.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            average_config_key = _average_config_key;
            stats_total_bytes = total_size_bytes == 0L ? 1L : total_size_bytes;
            done_bytes = 0L;
            progress_lock = new Object();
            current_file_index = new int[1];
            current_file_bs = new long[1];
            last_progress_bytes = new long[1];
            last_progress_update = new long[]{SystemTime.getMonotonousTime()};
            move_failed = new boolean[1];
            timer_event1 = SimpleTimer.addPeriodicEvent("MoveFile:speedster", 1000L, new TimerEventPerformer(average_config_key){
                private final long start_time = SystemTime.getMonotonousTime();
                private long last_update_processed;
                private long estimated_speed = 0x100000L;
                {
                    long val;
                    if (string != null && (val = COConfigurationManager.getLongParameter(string, 0L)) > 0L) {
                        this.estimated_speed = val;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    Object object = progress_lock;
                    synchronized (object) {
                        long secs_since_last_update;
                        if (move_failed[0]) {
                            return;
                        }
                        int file_index = current_file_index[0];
                        if (file_index >= new_files.length) {
                            return;
                        }
                        long now = SystemTime.getMonotonousTime();
                        long last_update = last_progress_update[0];
                        long bytes_moved = last_progress_bytes[0];
                        if (last_update != this.last_update_processed) {
                            this.last_update_processed = last_update;
                            if (bytes_moved > 0xA00000L) {
                                long elapsed = now - this.start_time;
                                this.estimated_speed = bytes_moved * 1000L / elapsed;
                            }
                        }
                        if ((secs_since_last_update = (now - last_update) / 1000L) > 2L) {
                            long file_start_overall = current_file_bs[0];
                            long file_end_overall = file_start_overall + file_lengths_to_move[file_index];
                            long bytes_of_file_remaining = file_end_overall - bytes_moved;
                            long pretend_bytes = 0L;
                            long current_speed = this.estimated_speed;
                            long current_remaining = bytes_of_file_remaining;
                            long current_added = 0L;
                            int percentage_to_slow_at = 80;
                            int i = 0;
                            while ((long)i < secs_since_last_update) {
                                pretend_bytes += current_speed;
                                if ((current_added += current_speed) > (long)percentage_to_slow_at * current_remaining / 100L) {
                                    percentage_to_slow_at = 50;
                                    current_remaining = bytes_of_file_remaining - pretend_bytes;
                                    current_added = 0L;
                                    if ((current_speed /= 2L) < 1024L) {
                                        current_speed = 1024L;
                                    }
                                }
                                if (pretend_bytes >= bytes_of_file_remaining) {
                                    pretend_bytes = bytes_of_file_remaining;
                                    break;
                                }
                                ++i;
                            }
                            long pretend_bytes_moved = bytes_moved + pretend_bytes;
                            DiskManagerImpl.this.move_progress = new long[]{(int)(1000L * pretend_bytes_moved / stats_total_bytes), stats_total_bytes};
                        }
                    }
                }
            });
            timer_event2 = SimpleTimer.addPeriodicEvent("MoveFile:observer", 500L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    File file;
                    int index;
                    Object object = progress_lock;
                    synchronized (object) {
                        if (move_failed[0]) {
                            return;
                        }
                        index = current_file_index[0];
                        if (index >= new_files.length) {
                            return;
                        }
                        file = new_files[index];
                    }
                    long file_length = file.length();
                    Object object2 = progress_lock;
                    synchronized (object2) {
                        if (move_failed[0]) {
                            return;
                        }
                        if (index == current_file_index[0]) {
                            long done_bytes = current_file_bs[0] + file_length;
                            DiskManagerImpl.this.move_progress = new long[]{(int)(1000L * done_bytes / stats_total_bytes), stats_total_bytes};
                            last_progress_bytes[0] = done_bytes;
                            last_progress_update[0] = SystemTime.getMonotonousTime();
                        }
                    }
                }
            });
            start = SystemTime.getMonotonousTime();
            if (simple_torrent) {
                old_root_dir = move_from_dir;
                new_root_dir = FileUtil.newFile(move_to_dir, new String[0]);
            } else {
                old_root_dir = FileUtil.newFile(move_from_dir, new String[]{move_from_name});
                new_root_dir = FileUtil.newFile(move_to_dir, new String[]{new_name == null ? move_from_name : new_name});
            }
            pl = new FileUtil.ProgressListener(){

                @Override
                public void setTotalSize(long size) {
                }

                @Override
                public void setCurrentFile(File file) {
                }

                @Override
                public int getState() {
                    return DiskManagerImpl.this.move_state;
                }

                @Override
                public void complete() {
                }

                @Override
                public void bytesDone(long num) {
                }
            };
            try {
                i = 0;
                while (i < this.files.length) {
                    block57: {
                        new_file = new_files[i];
                        initial_done_bytes = done_bytes;
                        try {
                            this.move_subtask = old_files[i];
                            this.files[i].moveFile(new_root_dir, new_file, link_only[i], pl);
                            ++files_done;
                            total_done_bytes += file_lengths_to_move[i];
                            var46_49 = progress_lock;
                            synchronized (var46_49) {
                                current_file_index[0] = i + 1;
                                current_file_bs[0] = done_bytes = initial_done_bytes + file_lengths_to_move[i];
                                this.move_progress = new long[]{(int)(1000L * done_bytes / stats_total_bytes), stats_total_bytes};
                                last_progress_bytes[0] = done_bytes;
                                last_progress_update[0] = SystemTime.getMonotonousTime();
                            }
                            if (change_to_read_only) {
                                this.files[i].setAccessMode(1);
                            }
                            break block57;
                        }
                        catch (CacheFileManagerException e) {
                            var47_51 = progress_lock;
                            synchronized (var47_51) {
                                move_failed[0] = true;
                            }
                            msg = "Failed to move " + old_files[i].toString() + " to destination " + new_root_dir + ": " + new_file + "/" + link_only[i];
                            Logger.log(new LogEvent((Object)this, DiskManagerImpl.LOGID, 3, msg));
                            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_files[i].toString(), Debug.getNestedExceptionMessage(e)});
                            bytes_moved = 0L;
                            j = 0;
                            ** while (j < i)
                        }
lbl-1000:
                        // 1 sources

                        {
                            bytes_moved += file_lengths_to_move[j];
                            ++j;
                            continue;
                        }
lbl158:
                        // 1 sources

                        j = 0;
                        while (j < i) {
                            this.move_subtask = old_files[j];
                            this.move_progress = new long[]{(int)(1000L * bytes_moved / stats_total_bytes), stats_total_bytes};
                            bytes_this_file = file_lengths_to_move[j];
                            bytes_moved_at_start = bytes_moved;
                            pl_undo = new FileUtil.ProgressListener(){
                                private long total_done = 0L;

                                @Override
                                public void setTotalSize(long size) {
                                }

                                @Override
                                public void setCurrentFile(File file) {
                                }

                                @Override
                                public int getState() {
                                    return 1;
                                }

                                @Override
                                public void complete() {
                                }

                                @Override
                                public void bytesDone(long num) {
                                    this.total_done += num;
                                    if (this.total_done > bytes_this_file) {
                                        this.total_done = bytes_this_file;
                                    }
                                    DiskManagerImpl.this.move_progress = new long[]{(int)(1000L * (bytes_moved_at_start - this.total_done) / stats_total_bytes), stats_total_bytes};
                                }
                            };
                            try {
                                this.files[j].moveFile(old_root_dir, old_files[j], link_only[j], pl_undo);
                            }
                            catch (Throwable f) {
                                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{old_files[j].toString(), Debug.getNestedExceptionMessage(f)});
                            }
                            bytes_moved -= bytes_this_file;
                            ++j;
                        }
                        if (new_root_dir.isDirectory()) {
                            TorrentUtils.recursiveEmptyDirDelete(new_root_dir, false);
                        }
                        return false;
                    }
                    ++i;
                }
            }
            finally {
                timer_event1.cancel();
                timer_event2.cancel();
            }
            elapsed_secs = (SystemTime.getMonotonousTime() - start) / 1000L;
            if (total_size_bytes > 0xA00000L && elapsed_secs > 10L) {
                bps = total_size_bytes / elapsed_secs;
                if (average_config_key != null) {
                    COConfigurationManager.setParameter(average_config_key, bps);
                }
            }
            if (save_location.isDirectory()) {
                TorrentUtils.recursiveEmptyDirDelete(save_location, false);
            }
            if (new_name == null) {
                this.download_manager.setTorrentSaveDir(FileUtil.newFile(move_to_dir, new String[0]), false);
            } else {
                this.download_manager.setTorrentSaveDir(FileUtil.newFile(move_to_dir, new String[]{new_name}), true);
            }
            return true;
        }
        finally {
            this.reader.setSuspended(false);
            FileUtil.log(String.valueOf(log_str) + " ends (files accepted=" + files_accepted + ", skipped=" + files_skipped + ", done=" + files_done + "; bytes total=" + total_size_bytes + ", done=" + total_done_bytes + ")");
        }
    }

    private void moveTorrentFile(SaveLocationChange loc_change) {
        if (!loc_change.hasTorrentChange()) {
            return;
        }
        File old_torrent_file = FileUtil.newFile(this.download_manager.getTorrentFileName(), new String[0]);
        File new_torrent_file = loc_change.normaliseTorrentLocation(old_torrent_file);
        if (!old_torrent_file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + old_torrent_file.getPath() + "' has been deleted, move operation ignored"));
            }
            return;
        }
        try {
            this.download_manager.setTorrentFile(loc_change.torrent_location, loc_change.torrent_name);
        }
        catch (DownloadManagerException e) {
            String msg = "Failed to move " + old_torrent_file.toString() + " to " + new_torrent_file.toString();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
            }
            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_torrent_file.toString(), new_torrent_file.toString()});
            Debug.out(msg);
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        Object[] params = new Object[]{this, this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    @Override
    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    @Override
    public boolean hasListener(DiskManagerListener l) {
        return this.listeners.hasListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) {
        if (torrent == null || torrent_save_file == null) {
            return;
        }
        try {
            if (torrent.isSimpleTorrent()) {
                File target = FileUtil.newFile(torrent_save_dir, torrent_save_file);
                target = FMFileManagerFactory.getSingleton().getFileLink(torrent, 0, target.getCanonicalFile());
                FileUtil.deleteWithRecycle(target, force_no_recycle);
            } else {
                PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
                boolean deleted = false;
                if (Constants.isOSX && torrent_save_file.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !force_no_recycle && mgr.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    String dir = String.valueOf(torrent_save_dir) + File.separatorChar + torrent_save_file + File.separatorChar;
                    int numDataFiles = DiskManagerImpl.countDataFiles(torrent, torrent_save_dir, torrent_save_file);
                    if (DiskManagerImpl.countFiles(FileUtil.newFile(dir, new String[0]), numDataFiles) == numDataFiles && FileUtil.deleteWithRecycle(FileUtil.newFile(dir, new String[0]), false)) {
                        deleted = true;
                    }
                }
                if (!deleted) {
                    DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private static int countFiles(File f, int stopAfterCount) {
        if (f.isFile()) {
            return 1;
        }
        int res = 0;
        File[] files = f.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if ((res += DiskManagerImpl.countFiles(files[i], stopAfterCount)) > stopAfterCount) break;
                ++i;
            }
        }
        return res;
    }

    private static int countDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        try {
            int res = 0;
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] files = torrent.getFiles();
            int i = 0;
            while (i < files.length) {
                byte[][] path_comps = files[i].getPathComponents();
                File file = FileUtil.newFile(torrent_save_dir, torrent_save_file);
                int j = 0;
                while (j < path_comps.length) {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    file = FileUtil.newFile(file, comp2);
                    ++j;
                }
                file = file.getCanonicalFile();
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, i, file);
                boolean skip = false;
                if (linked_file != file && !FileUtil.isAncestorOf(FileUtil.newFile(torrent_save_dir, new String[0]), linked_file)) {
                    skip = true;
                }
                if (!skip && file.exists() && !file.isDirectory()) {
                    ++res;
                }
                ++i;
            }
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
        TOTorrentFile[] files = torrent.getFiles();
        File root_path_file = FileUtil.newFile(torrent_save_dir, torrent_save_file);
        FMFileManager fm_factory = FMFileManagerFactory.getSingleton();
        boolean has_links = fm_factory.hasLinks(torrent);
        if (!has_links) {
            if (!root_path_file.isDirectory()) {
                return;
            }
            if (root_path_file.list().length == 0) {
                TorrentUtils.recursiveEmptyDirDelete(root_path_file);
                return;
            }
        }
        boolean delete_if_not_in_dir = COConfigurationManager.getBooleanParameter("File.delete.include_files_outside_save_dir");
        int i = 0;
        while (i < files.length) {
            boolean delete;
            File file;
            block17: {
                byte[][] path_comps = files[i].getPathComponents();
                file = root_path_file;
                int j = 0;
                while (j < path_comps.length) {
                    try {
                        String comp2 = locale_decoder.decodeString(path_comps[j]);
                        comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                        file = FileUtil.newFile(file, comp2);
                    }
                    catch (UnsupportedEncodingException e) {
                        Debug.out("file - unsupported encoding!!!!");
                    }
                    ++j;
                }
                if (has_links) {
                    File linked_file = fm_factory.getFileLink(torrent, i, file);
                    if (linked_file == file) {
                        delete = true;
                    } else {
                        try {
                            if (delete_if_not_in_dir || FileUtil.isAncestorOf(root_path_file, linked_file)) {
                                file = linked_file;
                                delete = true;
                                break block17;
                            }
                            delete = false;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            delete = false;
                        }
                    }
                } else {
                    delete = true;
                }
            }
            if (delete && file.exists() && !file.isDirectory()) {
                try {
                    FileUtil.deleteWithRecycle(file, force_no_recycle);
                }
                catch (Exception e) {
                    Debug.out(e.toString());
                }
            }
            ++i;
        }
        TorrentUtils.recursiveEmptyDirDelete(root_path_file);
    }

    @Override
    public void skippedFileSetChanged(DiskManagerFileInfo file) {
        this.skipped_file_set_changed = true;
        if (this.priority_change_marker.incrementAndGet() == 0L) {
            this.priority_change_marker.incrementAndGet();
        }
        this.listeners.dispatch(2, new Object[]{this, file});
    }

    @Override
    public void priorityChanged(DiskManagerFileInfo file) {
        if (this.priority_change_marker.incrementAndGet() == 0L) {
            this.priority_change_marker.incrementAndGet();
        }
        this.listeners.dispatch(2, new Object[]{this, file});
    }

    @Override
    public void storageTypeChanged(DiskManagerFileInfo file) {
        this.listeners.dispatch(2, new Object[]{this, file});
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        DiskManagerUtil.storeFilePriorities(download_manager, files);
    }

    protected static void storeFileDownloaded(DownloadManager download_manager, DiskManagerFileInfo[] files, boolean persist, boolean interim) {
        DownloadManagerState state = download_manager.getDownloadState();
        HashMap details = new HashMap();
        ArrayList<Long> downloaded = new ArrayList<Long>();
        details.put("downloaded", downloaded);
        int i = 0;
        while (i < files.length) {
            downloaded.add(new Long(files[i].getDownloaded()));
            ++i;
        }
        state.setMapAttribute("filedownloaded", details);
        if (persist) {
            state.save(interim);
        }
    }

    @Override
    public void saveState(boolean interim) {
        this.saveStateSupport(true, interim);
    }

    protected void saveStateSupport(boolean persist, boolean interim) {
        if (this.files != null) {
            if (this.getState() == 4) {
                DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, persist, interim);
            }
            this.storeFilePriorities();
        }
        this.checkFreePieceList(false);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    @Override
    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    @Override
    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    @Override
    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    @Override
    public String getStorageType(int fileIndex) {
        return DiskManagerImpl.getStorageType(this.download_manager, fileIndex);
    }

    public static String[] getStorageTypes(DownloadManager download_manager) {
        DownloadManagerState state = download_manager.getDownloadState();
        String[] types = state.getListAttribute("storetypes");
        if (types == null || types.length == 0) {
            TOTorrentFile[] files = download_manager.getTorrent().getFiles();
            types = new String[download_manager.getTorrent().getFiles().length];
            if (reorder_storage_mode) {
                int existing = state.getIntAttribute("reordermb");
                if (existing < 0) {
                    existing = reorder_storage_mode_min_mb;
                    state.setIntAttribute("reordermb", existing);
                }
                int i = 0;
                while (i < types.length) {
                    types[i] = files[i].getLength() / 0x100000L >= (long)existing ? "R" : "L";
                    ++i;
                }
            } else {
                int i = 0;
                while (i < types.length) {
                    types[i] = "L";
                    ++i;
                }
            }
            state.setListAttribute("storetypes", types);
        }
        return types;
    }

    public static String getStorageType(DownloadManager download_manager, int fileIndex) {
        DownloadManagerState state = download_manager.getDownloadState();
        String type = state.getListAttribute("storetypes", fileIndex);
        if (type != null) {
            return type;
        }
        return DiskManagerImpl.getStorageTypes(download_manager)[fileIndex];
    }

    public static void setFileLinks(DownloadManager download_manager, LinkFileMap links) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(download_manager.getTorrent(), links);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    @Override
    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    @Override
    public boolean isInteresting(int pieceNumber) {
        return this.pieces[pieceNumber].isInteresting();
    }

    @Override
    public boolean isDone(int pieceNumber) {
        return this.pieces[pieceNumber].isDone();
    }

    @Override
    public long getPriorityChangeMarker() {
        return this.priority_change_marker.get();
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("Disk Manager");
        try {
            writer.indent();
            writer.println("percent_done=" + this.percentDone + ",allocated=" + this.allocated + ",remaining=" + this.remaining);
            writer.println("skipped_file_set_size=" + this.skipped_file_set_size + ",skipped_but_downloaded=" + this.skipped_but_downloaded);
            writer.println("already_moved=" + this.alreadyMoved);
        }
        finally {
            writer.exdent();
        }
    }

    private static class DownloadEndedProgressImpl
    implements DiskManager.DownloadEndedProgress {
        private volatile boolean complete;

        private DownloadEndedProgressImpl() {
        }

        private void setComplete() {
            this.complete = true;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }
}

