/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.access.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DiskAccessControllerInstance {
    final int aggregation_request_limit;
    final int aggregation_byte_limit;
    private final String name;
    final boolean enable_aggregation;
    final boolean invert_threads = !COConfigurationManager.getBooleanParameter("diskmanager.perf.queue.torrent.bias");
    final int max_threads;
    private int max_kb_queued;
    private final groupSemaphore max_kb_sem;
    private long request_bytes_queued;
    private long requests_queued;
    long total_requests;
    long total_single_requests_made;
    long total_aggregated_requests_made;
    long total_bytes;
    long total_single_bytes;
    long total_aggregated_bytes;
    long io_time;
    long io_count;
    private final requestDispatcher[] dispatchers;
    private long last_check = 0L;
    private final Map torrent_dispatcher_map = new HashMap();
    private static final int REQUEST_NUM_LOG_CHUNK = 100;
    private static final int REQUEST_BYTE_LOG_CHUNK = 0x100000;
    private int next_request_num_log = 100;
    private long next_request_byte_log = 0x100000L;
    static final ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return null;
        }
    };

    public DiskAccessControllerInstance(String _name, boolean _enable_aggregation, int _aggregation_request_limit, int _aggregation_byte_limit, int _max_threads, int _max_mb) {
        this.name = _name;
        this.enable_aggregation = _enable_aggregation;
        this.aggregation_request_limit = _aggregation_request_limit;
        this.aggregation_byte_limit = _aggregation_byte_limit;
        this.max_kb_queued = _max_mb * 1024;
        this.max_kb_sem = new groupSemaphore(this.max_kb_queued);
        this.max_threads = _max_threads;
        this.dispatchers = new requestDispatcher[this.invert_threads ? 1 : this.max_threads];
        int i = 0;
        while (i < this.dispatchers.length) {
            this.dispatchers[i] = new requestDispatcher(i);
            ++i;
        }
    }

    protected String getName() {
        return this.name;
    }

    protected long getBlockCount() {
        return this.max_kb_sem.getBlockCount();
    }

    protected long getQueueSize() {
        return this.requests_queued;
    }

    protected long getQueuedBytes() {
        return this.request_bytes_queued;
    }

    protected long getTotalRequests() {
        return this.total_requests;
    }

    protected long getTotalSingleRequests() {
        return this.total_single_requests_made;
    }

    protected long getTotalAggregatedRequests() {
        return this.total_aggregated_requests_made;
    }

    public long getTotalBytes() {
        return this.total_bytes;
    }

    public long getTotalSingleBytes() {
        return this.total_single_bytes;
    }

    public long getTotalAggregatedBytes() {
        return this.total_aggregated_bytes;
    }

    public long getIOTime() {
        return this.io_time;
    }

    public long getIOCount() {
        return this.io_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueRequest(DiskAccessRequestImpl request2) {
        requestDispatcher dispatcher;
        if (this.dispatchers.length == 1) {
            dispatcher = this.dispatchers[0];
        } else {
            Map map = this.torrent_dispatcher_map;
            synchronized (map) {
                TOTorrent torrent;
                long now = System.currentTimeMillis();
                boolean check = false;
                if (now - this.last_check > 60000L || now < this.last_check) {
                    check = true;
                    this.last_check = now;
                }
                if (check) {
                    Iterator it = this.torrent_dispatcher_map.values().iterator();
                    while (it.hasNext()) {
                        requestDispatcher d = (requestDispatcher)it.next();
                        long last_active = d.getLastRequestTime();
                        if (now - last_active > 60000L) {
                            it.remove();
                            continue;
                        }
                        if (now >= last_active) continue;
                        d.setLastRequestTime(now);
                    }
                }
                if ((dispatcher = (requestDispatcher)this.torrent_dispatcher_map.get(torrent = request2.getFile().getTorrentFile().getTorrent())) == null) {
                    int min_index = 0;
                    int min_size = Integer.MAX_VALUE;
                    int i = 0;
                    while (i < this.dispatchers.length) {
                        int size = this.dispatchers[i].size();
                        if (size == 0) {
                            min_index = i;
                            break;
                        }
                        if (size < min_size) {
                            min_size = size;
                            min_index = i;
                        }
                        ++i;
                    }
                    dispatcher = this.dispatchers[min_index];
                    this.torrent_dispatcher_map.put(torrent, dispatcher);
                }
                dispatcher.setLastRequestTime(now);
            }
        }
        dispatcher.queue(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSpaceAllowance(DiskAccessRequestImpl request2) {
        int kb_diff;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int size = request2.getSize();
            this.request_bytes_queued += (long)size;
            kb_diff = (size + 1023) / 1024;
            if (kb_diff > this.max_kb_queued) {
                this.max_kb_sem.releaseGroup(kb_diff - this.max_kb_queued);
                this.max_kb_queued = kb_diff;
            }
            ++this.requests_queued;
            if (this.requests_queued >= (long)this.next_request_num_log) {
                this.next_request_num_log += 100;
            }
            if (this.request_bytes_queued >= this.next_request_byte_log) {
                this.next_request_byte_log += 0x100000L;
            }
            request2.setSpaceAllowance(kb_diff);
        }
        this.max_kb_sem.reserveGroup(kb_diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSpaceAllowance(DiskAccessRequestImpl request2) {
        int kb_diff;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            this.request_bytes_queued -= (long)request2.getSize();
            --this.requests_queued;
            kb_diff = request2.getSpaceAllowance();
        }
        if (kb_diff > 0) {
            this.max_kb_sem.releaseGroup(kb_diff);
        }
    }

    protected String getString() {
        return String.valueOf(this.name) + ",agg=" + this.enable_aggregation + ",max_t=" + this.max_threads + ",max_kb=" + this.max_kb_queued + ",q_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.request_bytes_queued) + ",q_req=" + this.requests_queued + ",t_req=" + this.total_requests + ",t_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.total_bytes) + ",io=" + this.io_count;
    }

    protected static class groupSemaphore {
        private int value;
        private final List<mutableInteger> waiters = new LinkedList<mutableInteger>();
        private long blocks;

        protected groupSemaphore(int _value) {
            this.value = _value;
        }

        protected long getBlockCount() {
            return this.blocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reserveGroup(int num) {
            mutableInteger wait;
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (num <= this.value && this.waiters.size() == 0) {
                    this.value -= num;
                    return;
                }
                ++this.blocks;
                wait = new mutableInteger(num - this.value);
                this.value = 0;
                this.waiters.add(wait);
            }
            wait.reserve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void releaseGroup(int num) {
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (this.waiters.size() == 0) {
                    this.value += num;
                } else {
                    while (this.waiters.size() > 0) {
                        mutableInteger wait = this.waiters.get(0);
                        int wait_num = wait.getValue();
                        if (wait_num <= num) {
                            wait.release();
                            this.waiters.remove(0);
                            num -= wait_num;
                            continue;
                        }
                        wait.setValue(wait_num - num);
                        num = 0;
                        break;
                    }
                    this.value = num;
                }
                return;
            }
        }

        protected static class mutableInteger {
            private int i;
            private boolean released;

            protected mutableInteger(int _i) {
                this.i = _i;
            }

            protected int getValue() {
                return this.i;
            }

            protected void setValue(int _i) {
                this.i = _i;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void release() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    this.released = true;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void reserve() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    if (this.released) {
                        return;
                    }
                    try {
                        int spurious_count = 0;
                        while (true) {
                            this.wait();
                            if (!this.released) {
                                if (++spurious_count > 1024) {
                                    Debug.out("DAC::mutableInteger: spurious wakeup limit exceeded");
                                    throw new RuntimeException("die die die");
                                }
                                Debug.out("DAC::mutableInteger: spurious wakeup, ignoring");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Semaphore: operation interrupted");
                    }
                }
            }
        }
    }

    protected class requestDispatcher {
        private final int index;
        final AEThread2[] threads;
        int active_threads;
        final LinkedList requests;
        final Map request_map;
        private long last_request_map_tidy;
        final AESemaphore request_sem;
        final AESemaphore schedule_sem;
        private long last_request_time;

        protected requestDispatcher(int _index) {
            this.threads = new AEThread2[DiskAccessControllerInstance.this.invert_threads ? DiskAccessControllerInstance.this.max_threads : 1];
            this.requests = new LinkedList();
            this.request_map = new HashMap();
            this.request_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:request");
            this.schedule_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:schedule", 1);
            this.index = _index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void queue(DiskAccessRequestImpl request2) {
            if (tls.get() != null) {
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    ++DiskAccessControllerInstance.this.total_requests;
                    ++DiskAccessControllerInstance.this.total_single_requests_made;
                    DiskAccessControllerInstance.this.total_bytes += (long)request2.getSize();
                    DiskAccessControllerInstance.this.total_single_bytes += (long)request2.getSize();
                }
                try {
                    request2.runRequest();
                }
                catch (Throwable e) {
                    ++DiskAccessControllerInstance.this.io_count;
                    Debug.printStackTrace(e);
                }
            } else {
                DiskAccessControllerInstance.this.getSpaceAllowance(request2);
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    ++DiskAccessControllerInstance.this.total_requests;
                    DiskAccessControllerInstance.this.total_bytes += (long)request2.getSize();
                    boolean added = false;
                    int priority = request2.getPriority();
                    if (priority >= 0) {
                        int pos = 0;
                        for (DiskAccessRequestImpl r : this.requests) {
                            if (r.getPriority() < priority) {
                                this.requests.add(pos, request2);
                                added = true;
                                break;
                            }
                            ++pos;
                        }
                    }
                    if (!added) {
                        this.requests.add(request2);
                    }
                    if (DiskAccessControllerInstance.this.enable_aggregation) {
                        HashMap<Long, DiskAccessRequestImpl> m = (HashMap<Long, DiskAccessRequestImpl>)this.request_map.get(request2.getFile());
                        if (m == null) {
                            m = new HashMap<Long, DiskAccessRequestImpl>();
                            this.request_map.put(request2.getFile(), m);
                        }
                        m.put(new Long(request2.getOffset()), request2);
                        long now = SystemTime.getCurrentTime();
                        if (now < this.last_request_map_tidy || now - this.last_request_map_tidy > 30000L) {
                            this.last_request_map_tidy = now;
                            Iterator it = this.request_map.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                if (((HashMap)entry.getValue()).size() != 0 || ((CacheFile)entry.getKey()).isOpen()) continue;
                                it.remove();
                            }
                        }
                    }
                    this.request_sem.release();
                    this.requestQueued();
                }
            }
        }

        protected long getLastRequestTime() {
            return this.last_request_time;
        }

        protected void setLastRequestTime(long l) {
            this.last_request_time = l;
        }

        protected int size() {
            return this.requests.size();
        }

        protected void requestQueued() {
            if (this.active_threads < this.threads.length && (this.active_threads == 0 || this.requests.size() > 32)) {
                int i = 0;
                while (i < this.threads.length) {
                    if (this.threads[i] == null) {
                        ++this.active_threads;
                        final int thread_index = i;
                        this.threads[thread_index] = new AEThread2("DiskAccessController:dispatch(" + DiskAccessControllerInstance.this.getName() + ")[" + this.index + "/" + thread_index + "]", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                DiskAccessControllerInstance.tls.set(this);
                                while (true) {
                                    block36: {
                                        request = null;
                                        aggregated = null;
                                        try {
                                            if (requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).invert_threads) {
                                                requestDispatcher.this.schedule_sem.reserve();
                                            }
                                            if (!requestDispatcher.this.request_sem.reserve(30000L)) break block36;
                                            var3_3 = requestDispatcher.this.requests;
                                            synchronized (var3_3) {
                                                request = (DiskAccessRequestImpl)requestDispatcher.this.requests.remove(0);
                                                if (requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).enable_aggregation) {
                                                    file = request.getFile();
                                                    file_map = (HashMap<K, V>)requestDispatcher.this.request_map.get(file);
                                                    if (file_map == null) {
                                                        file_map = new HashMap<K, V>();
                                                    }
                                                    file_map.remove(new Long(request.getOffset()));
                                                    if (request.getPriority() < 0 && !request.isCancelled()) {
                                                        current = request;
                                                        aggregated_bytes = 0L;
                                                        try {
                                                            while (true) {
                                                                current_size = current.getSize();
                                                                end = current.getOffset() + (long)current_size;
                                                                next = (DiskAccessRequestImpl)file_map.remove(new Long(end));
                                                                if (next != null && !next.isCancelled() && next.canBeAggregatedWith(request)) {
                                                                    requestDispatcher.this.requests.remove(next);
                                                                    if (!requestDispatcher.this.request_sem.reserve(30000L)) {
                                                                        Debug.out("shouldn't happen");
                                                                    }
                                                                    if (aggregated == null) {
                                                                        aggregated = new ArrayList<DiskAccessRequestImpl>(8);
                                                                        aggregated.add(current);
                                                                        aggregated_bytes += (long)current_size;
                                                                    }
                                                                    aggregated.add(next);
                                                                    if (aggregated.size() <= requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).aggregation_request_limit && (aggregated_bytes += (long)next.getSize()) < (long)requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).aggregation_byte_limit) {
                                                                        current = next;
                                                                        continue;
                                                                    }
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        finally {
                                                            if (aggregated != null) {
                                                                ++requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).total_aggregated_requests_made;
                                                            } else {
                                                                ++requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).total_single_requests_made;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        finally {
                                            if (requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).invert_threads) {
                                                requestDispatcher.this.schedule_sem.release();
                                            }
                                        }
                                    }
                                    try {
                                        block38: {
                                            io_start = SystemTime.getHighPrecisionCounter();
                                            if (aggregated == null) break block38;
                                            requests = aggregated.toArray(new DiskAccessRequestImpl[aggregated.size()]);
                                            try {
                                                DiskAccessRequestImpl.runAggregated(request, requests);
                                            }
                                            finally {
                                                io_end = SystemTime.getHighPrecisionCounter();
                                                requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).io_time += io_end - io_start;
                                                ++requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).io_count;
                                                i = 0;
                                                if (true) ** GOTO lbl99
                                            }
                                        }
                                        if (request != null) {
                                            try {
                                                request.runRequest();
                                                continue;
                                            }
                                            finally {
                                                io_end = SystemTime.getHighPrecisionCounter();
                                                requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).io_time += io_end - io_start;
                                                ++requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).io_count;
                                                requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).total_single_bytes += (long)request.getSize();
                                                requestDispatcher.access$0(requestDispatcher.this).releaseSpaceAllowance(request);
                                                continue;
                                            }
                                        }
                                        var5_7 = requestDispatcher.this.requests;
                                        synchronized (var5_7) {
                                            if (requestDispatcher.this.requests.size() == 0) {
                                                requestDispatcher.this.threads[thread_index] = null;
                                                --requestDispatcher.this.active_threads;
                                                return;
                                            }
                                            continue;
                                        }
                                        do {
                                            r = requests[i];
                                            requestDispatcher.access$0((requestDispatcher)requestDispatcher.this).total_aggregated_bytes += (long)r.getSize();
                                            requestDispatcher.access$0(requestDispatcher.this).releaseSpaceAllowance(r);
                                            ++i;
lbl99:
                                            // 2 sources

                                        } while (i < requests.length);
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        continue;
                                    }
                                    break;
                                }
                            }
                        };
                        this.threads[thread_index].start();
                        break;
                    }
                    ++i;
                }
            }
        }

        static /* synthetic */ DiskAccessControllerInstance access$0(requestDispatcher requestDispatcher2) {
            return requestDispatcher2.DiskAccessControllerInstance.this;
        }
    }
}

