/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerEnhancer;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.EnhancedDownloadManagerFile;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.PieceRTAProvider;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.RealTimeInfo;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.average.Average;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.util.ConstantsVuze;
import java.util.List;

public class EnhancedDownloadManager {
    public static int DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 30;
    public static int MINIMUM_INITIAL_BUFFER_SECS;
    public static final int REACTIVATE_PROVIDER_PERIOD = 5000;
    public static final int REACTIVATE_PROVIDER_PERIOD_TICKS = 5;
    public static final int LOG_PROG_STATS_PERIOD = 10000;
    public static final int LOG_PROG_STATS_TICKS = 10;
    private static final int content_stream_bps_min_increase_ratio = 5;
    private static final int content_stream_bps_max_increase_ratio = 8;
    DownloadManagerEnhancer enhancer;
    DownloadManager download_manager;
    boolean explicit_progressive;
    volatile PiecePicker current_piece_pickler;
    volatile boolean progressive_active = false;
    long content_min_delivery_bps;
    int minimum_initial_buffer_secs_for_eta;
    bufferETAProvider buffer_provider = new bufferETAProvider();
    progressiveStats progressive_stats;
    private boolean marked_active;
    private boolean destroyed;
    private DownloadManagerListener dmListener;
    private EnhancedDownloadManagerFile[] enhanced_files;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                int channel_buffer_millis = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                MINIMUM_INITIAL_BUFFER_SECS = 2 * channel_buffer_millis / 1000;
            }
        });
    }

    protected EnhancedDownloadManager(DownloadManagerEnhancer _enhancer, DownloadManager _download_manager) {
        this.enhancer = _enhancer;
        this.download_manager = _download_manager;
        DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfo();
        this.minimum_initial_buffer_secs_for_eta = DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA;
        this.enhanced_files = new EnhancedDownloadManagerFile[files.length];
        long offset = 0L;
        int i = 0;
        while (i < files.length) {
            DiskManagerFileInfo f = files[i];
            this.enhanced_files[i] = new EnhancedDownloadManagerFile(f, offset);
            offset += f.getLength();
            ++i;
        }
        int primary_index = this.getPrimaryFileIndex();
        EnhancedDownloadManagerFile primary_file = this.enhanced_files[primary_index == -1 ? 0 : primary_index];
        this.progressive_stats = this.createProgressiveStats(this.download_manager, primary_file);
        this.download_manager.addPeerListener(new DownloadManagerPeerListener(){

            @Override
            public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void peerManagerAdded(PEPeerManager manager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.current_piece_pickler = manager.getPiecePicker();
                    if (EnhancedDownloadManager.this.progressive_active && EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void peerManagerRemoved(PEPeerManager manager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    if (EnhancedDownloadManager.this.progressive_active) {
                        EnhancedDownloadManager.this.setProgressiveMode(false);
                    }
                }
            }

            @Override
            public void peerAdded(PEPeer peer) {
            }

            @Override
            public void peerRemoved(PEPeer peer) {
            }
        });
    }

    public int getPrimaryFileIndex() {
        DiskManagerFileInfo info = this.download_manager.getDownloadState().getPrimaryFile();
        if (info == null) {
            return -1;
        }
        return info.getIndex();
    }

    public void setExplicitProgressive(int min_initial_buffer_secs, long min_bps, int file_index) {
        if (file_index >= 0 && file_index < this.enhanced_files.length) {
            this.explicit_progressive = true;
            this.minimum_initial_buffer_secs_for_eta = min_initial_buffer_secs;
            this.content_min_delivery_bps = min_bps;
            EnhancedDownloadManagerFile primary_file = this.enhanced_files[file_index];
            this.progressive_stats = this.createProgressiveStats(this.download_manager, primary_file);
        }
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public byte[] getHash() {
        TOTorrent t = this.download_manager.getTorrent();
        if (t == null) {
            return null;
        }
        try {
            return t.getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public EnhancedDownloadManagerFile[] getFiles() {
        return this.enhanced_files;
    }

    protected long getTargetSpeed() {
        long target_speed;
        long l = target_speed = this.progressive_active ? this.progressive_stats.getStreamBytesPerSecondMax() : this.content_min_delivery_bps;
        if (target_speed < this.content_min_delivery_bps) {
            target_speed = this.content_min_delivery_bps;
        }
        return target_speed;
    }

    protected boolean updateStats(int tick_count) {
        return this.updateProgressiveStats(tick_count);
    }

    public boolean supportsProgressiveMode() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return false;
        }
        return this.enhancer.isProgressiveAvailable() && (PlatformTorrentUtils.isContentProgressive(torrent) || this.explicit_progressive);
    }

    public void prepareForProgressiveMode(boolean active) {
        this.enhancer.prepareForProgressiveMode(this.download_manager, active);
    }

    public boolean setProgressiveMode(boolean active) {
        return this.setProgressiveMode(active, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setProgressiveMode(boolean active, boolean switching_progressive_downloads) {
        TOTorrent torrent = this.download_manager.getTorrent();
        DiskManagerFileInfo primaryFile = this.download_manager.getDownloadState().getPrimaryFile();
        if (torrent == null || primaryFile == null) {
            return false;
        }
        EnhancedDownloadManagerFile enhanced_file = this.enhanced_files[primaryFile.getIndex()];
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            block26: {
                block25: {
                    if (this.progressive_active != active) break block25;
                    return true;
                }
                if (!active || this.supportsProgressiveMode()) break block26;
                Debug.out("Attempt to set progress mode on non-progressible content - " + this.getName());
                return false;
            }
            this.log("Progressive mode changed to " + active);
            GlobalManager gm = this.download_manager.getGlobalManager();
            if (active) {
                if (this.dmListener == null) {
                    this.dmListener = new DownloadManagerAdapter(){

                        @Override
                        public void downloadComplete(DownloadManager manager) {
                            EnhancedDownloadManager.this.enhancer.resume();
                        }
                    };
                }
                this.download_manager.addListener(this.dmListener);
                Object[] dms = gm.getDownloadManagers().toArray();
                int i = 0;
                while (i < dms.length) {
                    DownloadManager dmCheck = (DownloadManager)dms[i];
                    if (!dmCheck.equals(this.download_manager) && !dmCheck.isDownloadComplete(false)) {
                        EnhancedDownloadManager edmCheck;
                        int state = dmCheck.getState();
                        if (state == 50 || state == 75) {
                            this.enhancer.pause(dmCheck);
                        }
                        if ((edmCheck = this.enhancer.getEnhancedDownload(dmCheck)) != null && edmCheck.getProgressiveMode()) {
                            edmCheck.setProgressiveMode(false, true);
                        }
                    }
                    ++i;
                }
                if (this.download_manager.isPaused()) {
                    this.enhancer.resume(this.download_manager);
                }
                if (this.download_manager.getState() == 70) {
                    this.download_manager.setStateWaiting();
                }
                if (this.download_manager.getPosition() != 1) {
                    this.download_manager.getGlobalManager().moveTo(this.download_manager, 1);
                }
            } else {
                this.download_manager.removeListener(this.dmListener);
                if (!switching_progressive_downloads) {
                    this.enhancer.resume();
                }
            }
            this.progressive_active = active;
            if (this.progressive_active) {
                this.enhancer.progressiveActivated();
            }
            if (this.current_piece_pickler != null) {
                if (this.progressive_active) {
                    this.buffer_provider.activate(this.current_piece_pickler);
                    this.progressive_stats.update(0);
                } else {
                    this.buffer_provider.deactivate(this.current_piece_pickler);
                    this.progressive_stats = this.createProgressiveStats(this.download_manager, enhanced_file);
                }
            } else {
                this.progressive_stats = this.createProgressiveStats(this.download_manager, enhanced_file);
            }
            if (!switching_progressive_downloads) {
                if (active) {
                    RealTimeInfo.setProgressiveActive(this.progressive_stats.getStreamBytesPerSecondMax());
                } else {
                    RealTimeInfo.setProgressiveInactive();
                }
            }
        }
        return true;
    }

    public boolean getProgressiveMode() {
        return this.progressive_active;
    }

    public long getProgressivePlayETA() {
        progressiveStats stats2 = this.getProgressiveStats();
        if (stats2 == null) {
            return Long.MAX_VALUE;
        }
        long eta = stats2.getETA();
        return eta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected progressiveStats getProgressiveStats() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            block4: {
                if (this.progressive_stats != null) break block4;
                return null;
            }
            return this.progressive_stats.getCopy();
        }
    }

    protected progressiveStats createProgressiveStats(DownloadManager dm, EnhancedDownloadManagerFile file) {
        return new progressiveStatsCommon(dm, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateProgressiveStats(int tick_count) {
        if (!this.progressive_active) {
            return false;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            PiecePicker piece_picker;
            block7: {
                if (this.progressive_active && this.progressive_stats != null) break block7;
                return false;
            }
            if (tick_count % 5 == 0 && (piece_picker = this.current_piece_pickler) != null) {
                this.buffer_provider.checkActivation(piece_picker);
            }
            this.progressive_stats.update(tick_count);
            long current_max = this.progressive_stats.getStreamBytesPerSecondMax();
            if (RealTimeInfo.getProgressiveActiveBytesPerSec() != current_max) {
                RealTimeInfo.setProgressiveActive(current_max);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRTA(boolean active) {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.marked_active && !active) {
                this.marked_active = false;
                RealTimeInfo.removeRealTimeTask();
            }
            if (this.destroyed) {
                return;
            }
            if (!this.marked_active && active) {
                this.marked_active = true;
                RealTimeInfo.addRealTimeTask();
            }
        }
    }

    public long getContiguousAvailableBytes(int file_index, long file_start_offset, long stop_counting_after) {
        long max_available;
        long available;
        DiskManagerFileInfo file;
        block20: {
            if (file_index < 0 || file_index >= this.enhanced_files.length) {
                return -1L;
            }
            EnhancedDownloadManagerFile efile = this.enhanced_files[file_index];
            file = efile.getFile();
            DiskManager dm = this.download_manager.getDiskManager();
            if (dm == null) {
                if (file.getDownloaded() == file.getLength()) {
                    return file.getLength() - file_start_offset;
                }
                return -1L;
            }
            int piece_size = dm.getPieceLength();
            long start_index = efile.getByteOffestInTorrent() + file_start_offset;
            int first_piece_index = (int)(start_index / (long)piece_size);
            int first_piece_offset = (int)(start_index % (long)piece_size);
            int last_piece_index = file.getLastPieceNumber();
            DiskManagerPiece[] pieces = dm.getPieces();
            DiskManagerPiece first_piece = pieces[first_piece_index];
            available = 0L;
            if (!first_piece.isDone()) {
                boolean[] blocks = first_piece.getWritten();
                if (blocks == null) {
                    if (first_piece.isDone()) {
                        available = first_piece.getLength() - first_piece_offset;
                    }
                } else {
                    int piece_offset = 0;
                    int j = 0;
                    while (j < blocks.length) {
                        if (blocks[j]) {
                            int block_size = first_piece.getBlockSize(j);
                            piece_offset += block_size;
                            if (available == 0L) {
                                if (piece_offset > first_piece_offset) {
                                    available = piece_offset - first_piece_offset;
                                }
                            } else {
                                available += (long)block_size;
                            }
                            ++j;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                available = first_piece.getLength() - first_piece_offset;
                int i = first_piece_index + 1;
                while (i <= last_piece_index) {
                    if (stop_counting_after > 0L && available >= stop_counting_after) break;
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone()) {
                        available += (long)piece.getLength();
                    } else {
                        boolean[] blocks = piece.getWritten();
                        if (blocks == null) {
                            if (!piece.isDone()) break;
                            available += (long)piece.getLength();
                            break;
                        }
                        int j = 0;
                        while (j < blocks.length) {
                            if (blocks[j]) {
                                available += (long)piece.getBlockSize(j);
                                ++j;
                                continue;
                            }
                            break block20;
                        }
                        break;
                    }
                    ++i;
                }
            }
        }
        if (available > (max_available = file.getLength() - file_start_offset)) {
            available = max_available;
        }
        return available;
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            this.setRTA(false);
            this.destroyed = true;
        }
    }

    protected void log(String str) {
        this.log(str, true);
    }

    protected void log(String str, boolean to_file) {
        this.log(this.download_manager, str, to_file);
    }

    protected void log(DownloadManager dm, String str, boolean to_file) {
        str = String.valueOf(dm.toString()) + ": " + str;
        if (to_file) {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.Stream");
            diag_logger.log(str);
        }
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + "|" + System.currentTimeMillis() + "] " + str);
        }
    }

    protected class bufferETAProvider
    implements PieceRTAProvider {
        private boolean is_buffering = true;
        private long[] piece_rtas;
        private long last_buffer_size;
        private long last_buffer_size_time;
        private boolean active;
        private long last_recalc;

        protected bufferETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                if (!this.active) {
                    EnhancedDownloadManager.this.log("Activating RTA provider");
                    this.active = true;
                    picker.addRTAProvider(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                if (this.active) {
                    EnhancedDownloadManager.this.log("Deactivating RTA provider");
                    picker.removeRTAProvider(this);
                }
                this.piece_rtas = null;
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkActivation(PiecePicker picker) {
            if (EnhancedDownloadManager.this.getProgressivePlayETA() > 0L) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    if (this.piece_rtas == null) {
                        this.activate(picker);
                    }
                }
            }
        }

        @Override
        public long[] updateRTAs(PiecePicker picker) {
            block14: {
                long now;
                int end_piece;
                int start_piece;
                long piece_size;
                long buffer_bytes;
                progressiveStats stats2;
                block12: {
                    DiskManagerPiece[] pieces;
                    long block_time;
                    long buffer_size;
                    long abs_provider_pos;
                    DiskManager disk_manager;
                    block15: {
                        block13: {
                            long buffer_size2;
                            boolean buffering;
                            long mono_now = SystemTime.getMonotonousTime();
                            if (mono_now - this.last_recalc < 500L) {
                                return this.piece_rtas;
                            }
                            this.last_recalc = mono_now;
                            disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
                            stats2 = EnhancedDownloadManager.this.progressive_stats;
                            if (disk_manager == null || stats2 == null || stats2.getFile().isComplete()) {
                                this.deactivate(picker);
                                return null;
                            }
                            EnhancedDownloadManagerFile file = stats2.getFile();
                            abs_provider_pos = stats2.getCurrentProviderPosition(true);
                            long rel_provider_pos = stats2.getCurrentProviderPosition(false);
                            buffer_bytes = stats2.getBufferBytes();
                            boolean bl = buffering = EnhancedDownloadManager.this.getProgressivePlayETA() >= 0L;
                            if (buffering && (buffer_size2 = EnhancedDownloadManager.this.getContiguousAvailableBytes(file.getIndex(), rel_provider_pos, buffer_bytes)) == buffer_bytes) {
                                buffering = false;
                            }
                            if (buffering != this.is_buffering) {
                                if (buffering) {
                                    EnhancedDownloadManager.this.log("Switching to buffer mode");
                                } else {
                                    EnhancedDownloadManager.this.log("Switching to RTA mode");
                                }
                                this.is_buffering = buffering;
                            }
                            piece_size = disk_manager.getPieceLength();
                            start_piece = (int)(abs_provider_pos / piece_size);
                            end_piece = file.getFile().getLastPieceNumber();
                            this.piece_rtas = new long[picker.getNumberOfPieces()];
                            now = SystemTime.getCurrentTime();
                            if (!this.is_buffering) break block12;
                            int i = start_piece;
                            while (i <= end_piece) {
                                this.piece_rtas[i] = now + (long)(i * 60000);
                                ++i;
                            }
                            buffer_size = EnhancedDownloadManager.this.getContiguousAvailableBytes(file.getIndex(), rel_provider_pos, 0L);
                            if (this.last_buffer_size == buffer_size) break block13;
                            this.last_buffer_size = buffer_size;
                            this.last_buffer_size_time = now;
                            break block14;
                        }
                        if (now >= this.last_buffer_size_time) break block15;
                        this.last_buffer_size_time = now;
                        break block14;
                    }
                    long stalled_for = now - this.last_buffer_size_time;
                    long dl_speed = EnhancedDownloadManager.this.progressive_stats.getDownloadBytesPerSecond();
                    if (dl_speed <= 0L || stalled_for <= Math.max(5000L, 5L * (block_time = 0xFA0000L / dl_speed))) break block14;
                    long target_rta = now + block_time;
                    int blocked_piece_index = (int)((abs_provider_pos + buffer_size) / (long)disk_manager.getPieceLength());
                    if (blocked_piece_index < (pieces = disk_manager.getPieces()).length && pieces[blocked_piece_index].isDone()) {
                        if (++blocked_piece_index < pieces.length) {
                            if (pieces[blocked_piece_index].isDone()) {
                                blocked_piece_index = -1;
                            }
                        } else {
                            blocked_piece_index = -1;
                        }
                    }
                    if (blocked_piece_index < 0) break block14;
                    this.piece_rtas[blocked_piece_index] = target_rta;
                    EnhancedDownloadManager.this.log("Buffer provider: reprioritising lagging piece " + blocked_piece_index + " with rta " + block_time);
                    break block14;
                }
                long bytes_offset = 0L;
                long max_bps = stats2.getStreamBytesPerSecondMax();
                int i = start_piece;
                while (i <= end_piece) {
                    this.piece_rtas[i] = now + 1000L * (bytes_offset / max_bps);
                    if ((bytes_offset += piece_size) > buffer_bytes) break;
                    ++i;
                }
            }
            return this.piece_rtas;
        }

        @Override
        public long getCurrentPosition() {
            return 0L;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getStartPosition() {
            return 0L;
        }

        @Override
        public long getBlockingPosition() {
            return 0L;
        }

        @Override
        public void setBufferMillis(long millis, long delay_millis) {
        }

        @Override
        public String getUserAgent() {
            return null;
        }
    }

    protected static abstract class progressiveStats
    implements Cloneable {
        protected progressiveStats() {
        }

        protected abstract EnhancedDownloadManagerFile getFile();

        protected abstract boolean isProviderActive();

        protected abstract long getCurrentProviderPosition(boolean var1);

        protected abstract long getStreamBytesPerSecondMax();

        protected abstract long getStreamBytesPerSecondMin();

        protected abstract long getDownloadBytesPerSecond();

        protected abstract long getETA();

        public abstract long getBufferBytes();

        protected abstract long getSecondsToDownload();

        protected abstract long getSecondsToWatch();

        protected abstract void update(int var1);

        protected progressiveStats getCopy() {
            try {
                return (progressiveStats)this.clone();
            }
            catch (CloneNotSupportedException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }

        protected String formatBytes(long l) {
            return DisplayFormatters.formatByteCountToKiBEtc(l);
        }

        protected String formatSpeed(long l) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
        }
    }

    protected class progressiveStatsCommon
    extends progressiveStats {
        private EnhancedDownloadManagerFile primary_file;
        private PieceRTAProvider current_provider;
        private String current_user_agent;
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private Average capped_download_rate_average = AverageFactory.MovingImmediateAverage(10);
        private Average discard_rate_average = AverageFactory.MovingImmediateAverage(10);
        private long last_discard_bytes;
        private long actual_bytes_to_download;
        private long weighted_bytes_to_download;
        private long provider_life_secs;
        private long provider_initial_position;
        private long provider_byte_position;
        private long provider_last_byte_position;
        private long provider_blocking_byte_position;
        private Average provider_speed_average;

        protected progressiveStatsCommon(DownloadManager _dm, EnhancedDownloadManagerFile _primary_file) {
            this.last_discard_bytes = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.provider_last_byte_position = -1L;
            this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
            this.primary_file = _primary_file;
            TOTorrent torrent = EnhancedDownloadManager.this.download_manager.getTorrent();
            long l = this.content_stream_bps_min = EnhancedDownloadManager.this.explicit_progressive ? EnhancedDownloadManager.this.content_min_delivery_bps : PlatformTorrentUtils.getContentStreamSpeedBps(torrent);
            if (this.content_stream_bps_min == 0L) {
                long size = torrent.getSize();
                this.content_stream_bps_min = size < 0xC800000L ? 30720L : (size < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_min += this.content_stream_bps_min / 5L;
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / 8L;
            EnhancedDownloadManager.this.setRTA(false);
            EnhancedDownloadManager.this.log(EnhancedDownloadManager.this.download_manager, "content_stream_bps=" + this.getStreamBytesPerSecondMin() + ",primary=" + this.primary_file.getFile().getIndex(), true);
        }

        protected void updateCurrentProvider(PieceRTAProvider provider) {
            long file_start = this.primary_file.getByteOffestInTorrent();
            if (this.current_provider != provider || provider == null) {
                this.current_provider = provider;
                this.current_user_agent = null;
                this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
                if (this.current_provider == null) {
                    this.provider_life_secs = 0L;
                    this.provider_initial_position = file_start;
                    this.provider_byte_position = file_start;
                    this.provider_blocking_byte_position = -1L;
                    this.provider_last_byte_position = -1L;
                } else {
                    this.provider_byte_position = this.provider_initial_position = Math.max(file_start, this.current_provider.getStartPosition());
                    this.provider_last_byte_position = this.provider_initial_position;
                    this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                    this.provider_life_secs = (SystemTime.getCurrentTime() - this.current_provider.getStartTime()) / 1000L;
                    if (this.provider_life_secs < 0L) {
                        this.provider_life_secs = 0L;
                    }
                }
                EnhancedDownloadManager.this.setRTA(this.current_provider != null);
            } else {
                ++this.provider_life_secs;
                if (this.current_user_agent == null) {
                    this.current_user_agent = this.current_provider.getUserAgent();
                    if (this.current_user_agent != null) {
                        EnhancedDownloadManager.this.log("Provider user agent = " + this.current_user_agent);
                    }
                }
                this.provider_byte_position = Math.max(file_start, this.current_provider.getCurrentPosition());
                this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                long bytes_read = this.provider_byte_position - this.provider_last_byte_position;
                this.provider_speed_average.update(bytes_read);
                this.provider_last_byte_position = this.provider_byte_position;
            }
        }

        @Override
        protected boolean isProviderActive() {
            return this.current_provider != null;
        }

        protected long getInitialProviderPosition() {
            return this.provider_initial_position;
        }

        @Override
        protected long getCurrentProviderPosition(boolean absolute) {
            long res = this.provider_byte_position;
            if (absolute) {
                if (res == 0L) {
                    res = this.primary_file.getByteOffestInTorrent();
                }
            } else if ((res -= this.primary_file.getByteOffestInTorrent()) < 0L) {
                res = 0L;
            }
            return res;
        }

        protected long getProviderLifeSecs() {
            return this.provider_life_secs;
        }

        @Override
        protected void update(int tick_count) {
            long download_rate = EnhancedDownloadManager.this.download_manager.getStats().getDataReceiveRate();
            this.capped_download_rate_average.update(download_rate);
            long discards = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.discard_rate_average.update(discards - this.last_discard_bytes);
            this.last_discard_bytes = discards;
            DiskManager disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            PiecePicker picker = EnhancedDownloadManager.this.current_piece_pickler;
            if (this.getStreamBytesPerSecondMin() > 0L && disk_manager != null && picker != null) {
                List providers = picker.getRTAProviders();
                long max_cp = 0L;
                PieceRTAProvider best_provider = null;
                int i = 0;
                while (i < providers.size()) {
                    long cp;
                    PieceRTAProvider provider = (PieceRTAProvider)providers.get(i);
                    if (provider.getStartTime() > 0L && (cp = provider.getCurrentPosition()) >= max_cp) {
                        best_provider = provider;
                        max_cp = cp;
                    }
                    ++i;
                }
                this.updateCurrentProvider(best_provider);
                if (best_provider != null) {
                    long relative_pos = this.getCurrentProviderPosition(false);
                    long buffer_bytes = EnhancedDownloadManager.this.getContiguousAvailableBytes(this.primary_file.getIndex(), relative_pos, this.getStreamBytesPerSecondMin() * 60L);
                    long buffer_secs = buffer_bytes / this.getStreamBytesPerSecondMin();
                    buffer_secs = Math.max(10L, buffer_secs);
                    best_provider.setBufferMillis(15000L, buffer_secs * 1000L);
                }
                DiskManagerPiece[] pieces = disk_manager.getPieces();
                this.actual_bytes_to_download = 0L;
                this.weighted_bytes_to_download = 0L;
                int first_incomplete_piece = -1;
                int piece_size = disk_manager.getPieceLength();
                int last_piece_number = this.primary_file.getFile().getLastPieceNumber();
                int i2 = (int)(this.provider_byte_position / (long)piece_size);
                while (i2 <= last_piece_number) {
                    DiskManagerPiece piece = pieces[i2];
                    if (!piece.isDone()) {
                        if (first_incomplete_piece == -1) {
                            first_incomplete_piece = i2;
                        }
                        boolean[] blocks = piece.getWritten();
                        int bytes_this_piece = 0;
                        if (blocks == null) {
                            bytes_this_piece = piece.getLength();
                        } else {
                            int j = 0;
                            while (j < blocks.length) {
                                if (!blocks[j]) {
                                    bytes_this_piece += piece.getBlockSize(j);
                                }
                                ++j;
                            }
                        }
                        if (bytes_this_piece > 0) {
                            this.actual_bytes_to_download += (long)bytes_this_piece;
                            int diff = i2 - first_incomplete_piece;
                            if (diff == 0) {
                                this.weighted_bytes_to_download += (long)bytes_this_piece;
                            } else {
                                int weighted_bytes_done = piece.getLength() - bytes_this_piece;
                                weighted_bytes_done = weighted_bytes_done * (pieces.length - i2) / (pieces.length - first_incomplete_piece);
                                this.weighted_bytes_to_download += (long)(piece.getLength() - weighted_bytes_done);
                            }
                        }
                    }
                    ++i2;
                }
            }
            EnhancedDownloadManager.this.log(this.getString(), tick_count % 10 == 0);
        }

        @Override
        protected long getETA() {
            long secs_to_watch;
            long secs_to_download;
            long eta;
            long buffer_done;
            DiskManagerFileInfo file = this.primary_file.getFile();
            if (file.getLength() == file.getDownloaded()) {
                return 0L;
            }
            long download_rate = this.getDownloadBytesPerSecond();
            if (download_rate <= 0L) {
                return Long.MAX_VALUE;
            }
            long buffer_bytes = this.getBufferBytes();
            long rem_buffer = buffer_bytes - (buffer_done = EnhancedDownloadManager.this.getContiguousAvailableBytes(file.getIndex(), this.getCurrentProviderPosition(false), buffer_bytes));
            long rem_secs = rem_buffer <= 0L ? 0L : rem_buffer / download_rate;
            if (rem_secs > (eta = (secs_to_download = this.getSecondsToDownload()) - (secs_to_watch = this.getSecondsToWatch())) && rem_secs > 0L) {
                eta = rem_secs;
            }
            return eta;
        }

        @Override
        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        @Override
        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        @Override
        public long getBufferBytes() {
            long min_dl = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            return min_dl;
        }

        @Override
        protected EnhancedDownloadManagerFile getFile() {
            return this.primary_file;
        }

        @Override
        protected long getDownloadBytesPerSecond() {
            int global_limit;
            long original;
            long current = original = (long)this.capped_download_rate_average.getAverage();
            int dl_limit = EnhancedDownloadManager.this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
            if (dl_limit > 0) {
                current = Math.min(current, (long)dl_limit);
            }
            if ((global_limit = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()) > 0) {
                current = Math.min(current, (long)global_limit);
            }
            return current;
        }

        @Override
        protected long getSecondsToDownload() {
            long download_rate = this.getDownloadBytesPerSecond();
            if (download_rate == 0L) {
                return Long.MAX_VALUE;
            }
            return this.weighted_bytes_to_download / download_rate;
        }

        @Override
        public long getSecondsToWatch() {
            return (this.primary_file.getLength() - this.getCurrentProviderPosition(false)) / this.getStreamBytesPerSecondMin();
        }

        protected String getString() {
            long dl_rate = this.getDownloadBytesPerSecond();
            long buffer_bytes = this.getBufferBytes();
            long buffer_done = EnhancedDownloadManager.this.getContiguousAvailableBytes(this.primary_file.getIndex(), this.getCurrentProviderPosition(false), buffer_bytes);
            return "play_eta=" + this.getETA() + "/d=" + this.getSecondsToDownload() + "/w=" + this.getSecondsToWatch() + ", dl_rate=" + this.formatSpeed(dl_rate) + ", download_rem=" + this.formatBytes(this.weighted_bytes_to_download) + "/" + this.formatBytes(this.actual_bytes_to_download) + ", discard_rate=" + this.formatSpeed((long)this.discard_rate_average.getAverage()) + ", buffer: " + buffer_bytes + "/" + buffer_done + ", prov: byte=" + this.formatBytes(this.provider_byte_position) + " secs=" + this.provider_byte_position / this.getStreamBytesPerSecondMin() + " speed=" + this.formatSpeed((long)this.provider_speed_average.getAverage()) + " block= " + this.formatBytes(this.provider_blocking_byte_position);
        }
    }
}

