/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerActivationListener;
import com.biglybt.core.download.DownloadManagerDiskListener;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerPieceListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.DownloadManagerTPSListener;
import com.biglybt.core.download.DownloadManagerTrackerListener;
import com.biglybt.core.download.impl.DownloadManagerController;
import com.biglybt.core.download.impl.DownloadManagerDefaultPaths;
import com.biglybt.core.download.impl.DownloadManagerMoveHandler;
import com.biglybt.core.download.impl.DownloadManagerStatsImpl;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.PeerManagerRegistration;
import com.biglybt.core.peermanager.control.PeerControlSchedulerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.TrackerPeerSourceAdapter;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerDataProvider;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerException;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerFactory;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerRequest;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.tracker.client.TRTrackerScraper;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.LinkFileMap;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import com.biglybt.plugin.tracker.dht.DHTTrackerPlugin;
import com.biglybt.plugin.tracker.local.LocalTrackerPlugin;
import java.io.File;
import java.io.FileFilter;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DownloadManagerImpl
extends LogRelation
implements DownloadManager,
Taggable,
DataSourceResolver.ExportableDataSource,
DiskManagerUtil.MoveTaskAapter {
    private static final long SCRAPE_DELAY_ERROR_TORRENTS = 0x6DDD00L;
    private static final long SCRAPE_DELAY_STOPPED_TORRENTS = 3600000L;
    private static final long SCRAPE_INITDELAY_ERROR_TORRENTS = 600000L;
    private static final long SCRAPE_INITDELAY_STOPPED_TORRENTS = 180000L;
    private static int upload_when_busy_min_secs;
    private static int max_connections_npp_extra;
    private static int default_light_seeding_status;
    private static final ClientIDManagerImpl client_id_manager;
    private static final String CFG_MOVE_COMPLETED_TOP = "Newly Seeding Torrents Get First Priority";
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_DOWNLOADCOMPLETE = 2;
    private static final int LDT_COMPLETIONCHANGED = 3;
    private static final int LDT_POSITIONCHANGED = 4;
    private static final int LDT_FILEPRIORITYCHANGED = 5;
    private static final int LDT_FILELOCATIONCHANGED = 6;
    private static Object port_init_lock;
    private final AEMonitor listeners_mon = new AEMonitor("DM:DownloadManager:L");
    static final ListenerManager<DownloadManagerListener> listeners_aggregator;
    static final CopyOnWriteList<DownloadManagerListener> global_dm_listeners;
    private static final DownloadManagerListener global_dm_listener;
    private static final Download.SeedingRank defaultSeedingRank;
    private static final AllTrackersManager.AllTrackers all_trackers;
    private final ListenerManager<DownloadManagerListener> listeners = ListenerManager.createManager("DM:ListenDispatcher", new ListenerManagerDispatcher<DownloadManagerListener>(){

        @Override
        public void dispatch(DownloadManagerListener listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private static final int LDT_TL_ANNOUNCERESULT = 1;
    private static final int LDT_TL_SCRAPERESULT = 2;
    final ListenerManager<DownloadManagerTrackerListener> tracker_listeners;
    private static final int LDT_PE_PEER_ADDED = 1;
    private static final int LDT_PE_PEER_REMOVED = 2;
    private static final int LDT_PE_PM_ADDED = 5;
    private static final int LDT_PE_PM_REMOVED = 6;
    static final ListenerManager<DownloadManagerPeerListener> peer_listeners_aggregator;
    static final Object TPS_Key;
    public static volatile String dnd_subfolder;
    private static Map<String, Boolean> save_dir_check_cache;
    private static TimerEventPeriodic save_dir_check_timer;
    private final ListenerManager<DownloadManagerPeerListener> peer_listeners;
    final AEMonitor peer_listeners_mon;
    final Map<PEPeer, String> current_peers;
    private final Map<PEPeer, Long> current_peers_unmatched_removal;
    private static final int LDT_PE_PIECE_ADDED = 3;
    private static final int LDT_PE_PIECE_REMOVED = 4;
    static final ListenerManager<DownloadManagerPieceListener> piece_listeners_aggregator;
    private final ListenerManager<DownloadManagerPieceListener> piece_listeners;
    private boolean constructed;
    private Object init_lock;
    private boolean initialised;
    private List<Runnable> post_init_tasks;
    private List<DownloadManagerTPSListener> tps_listeners;
    private final AEMonitor piece_listeners_mon;
    private final List<PEPiece> current_pieces;
    final DownloadManagerController controller;
    private final DownloadManagerStatsImpl stats;
    protected final AEMonitor this_mon;
    private final boolean persistent;
    private volatile boolean assumedComplete;
    private int last_informed_state;
    private boolean latest_informed_force_start;
    private long resume_time;
    final GlobalManager globalManager;
    private String torrentFileName;
    private boolean torrentFileExplicitlyDeleted;
    private boolean open_for_seeding;
    private String display_name;
    private String internal_name;
    private File torrent_save_location;
    private int position;
    private Object[] read_torrent_state;
    DownloadManagerState download_manager_state;
    private TOTorrent torrent;
    private String torrent_comment;
    private String torrent_created_by;
    private volatile Map<String, Object[]> url_group_map;
    private volatile long url_group_map_uid;
    private volatile TRTrackerAnnouncer _tracker_client;
    private volatile TRTrackerAnnouncer _tracker_client_for_queued_download;
    private volatile int light_seeding_status;
    private final TRTrackerAnnouncerListener tracker_client_listener;
    private final TRTrackerAnnouncerListener tracker_client_stats_listener;
    private final CopyOnWriteList<DownloadManagerActivationListener> activation_listeners;
    private final long scrape_random_seed;
    private volatile Map<Object, Object> data;
    private boolean data_already_allocated;
    private long creation_time;
    private Download.SeedingRank seedingRank;
    private boolean dl_identity_obtained;
    private byte[] dl_identity;
    private int dl_identity_hashcode;
    private int max_uploads;
    private int max_connections;
    private int max_connections_when_seeding;
    private boolean max_connections_when_seeding_enabled;
    private int max_seed_connections;
    private int max_uploads_when_seeding;
    private boolean max_uploads_when_seeding_enabled;
    private int max_upload_when_busy_bps;
    private int current_upload_when_busy_bps;
    private long last_upload_when_busy_update;
    private long last_upload_when_busy_dec_time;
    private int upload_priority_manual;
    private int upload_priority_auto;
    private int crypto_level;
    private int message_mode;
    private volatile int tcp_port_override;
    private volatile boolean removing;
    private volatile boolean destroyed;
    private File cached_save_location;
    private File cached_save_location_result;
    private static Object TTP_KEY;
    private volatile long[] move_progress;
    private volatile String move_subtask;
    private volatile int move_state;

    static {
        client_id_manager = ClientIDManagerImpl.getSingleton();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"max.uploads.when.busy.inc.min.secs", "Non-Public Peer Extra Connections Per Torrent", "Enable Light Seeding"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                upload_when_busy_min_secs = COConfigurationManager.getIntParameter("max.uploads.when.busy.inc.min.secs");
                max_connections_npp_extra = COConfigurationManager.getIntParameter("Non-Public Peer Extra Connections Per Torrent");
                default_light_seeding_status = COConfigurationManager.getBooleanParameter("Enable Light Seeding") ? 1 : 2;
            }
        });
        port_init_lock = new Object();
        listeners_aggregator = ListenerManager.createAsyncManager("DM:ListenAggregatorDispatcher", new ListenerManagerDispatcher<DownloadManagerListener>(){

            @Override
            public void dispatch(DownloadManagerListener listener, int type, Object _value) {
                Object[] value = (Object[])_value;
                DownloadManagerImpl dm = (DownloadManagerImpl)value[0];
                if (type == 1) {
                    listener.stateChanged(dm, (Integer)value[1]);
                } else if (type == 2) {
                    listener.downloadComplete(dm);
                } else if (type == 3) {
                    listener.completionChanged(dm, (Boolean)value[1]);
                } else if (type == 5) {
                    listener.filePriorityChanged(dm, (DiskManagerFileInfo)value[1]);
                } else if (type == 4) {
                    listener.positionChanged(dm, (Integer)value[1], (Integer)value[2]);
                } else if (type == 6) {
                    listener.fileLocationChanged(dm, (DiskManagerFileInfo)value[1]);
                }
            }
        });
        global_dm_listeners = new CopyOnWriteList();
        global_dm_listener = new DownloadManagerListener(){

            @Override
            public void stateChanged(DownloadManager manager, int state) {
                for (DownloadManagerListener listener : global_dm_listeners) {
                    try {
                        listener.stateChanged(manager, state);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                for (DownloadManagerListener listener : global_dm_listeners) {
                    try {
                        listener.positionChanged(download, oldPosition, newPosition);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                for (DownloadManagerListener listener : global_dm_listeners) {
                    try {
                        listener.filePriorityChanged(download, file);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void fileLocationChanged(DownloadManager download, DiskManagerFileInfo file) {
                for (DownloadManagerListener listener : global_dm_listeners) {
                    try {
                        listener.fileLocationChanged(download, file);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void downloadComplete(DownloadManager manager) {
                for (DownloadManagerListener listener : global_dm_listeners) {
                    try {
                        listener.downloadComplete(manager);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void completionChanged(DownloadManager manager, boolean bCompleted) {
                DownloadManagerState dms = manager.getDownloadState();
                long time = dms.getLongAttribute("complt");
                if (time == -1L) {
                    if (bCompleted) {
                        dms.setLongAttribute("complt", SystemTime.getCurrentTime());
                    }
                } else if (time > 0L) {
                    if (!bCompleted) {
                        dms.setLongAttribute("complt", -1L);
                    }
                } else if (bCompleted) {
                    long completedOn = dms.getLongParameter("stats.download.completed.time");
                    if (completedOn > 0L) {
                        dms.setLongAttribute("complt", completedOn);
                    }
                } else {
                    dms.setLongAttribute("complt", -1L);
                }
                for (DownloadManagerListener listener : global_dm_listeners) {
                    try {
                        listener.completionChanged(manager, bCompleted);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        defaultSeedingRank = new Download.SeedingRank(){};
        all_trackers = AllTrackersManager.getAllTrackers();
        peer_listeners_aggregator = ListenerManager.createAsyncManager("DM:PeerListenAggregatorDispatcher", new ListenerManagerDispatcher<DownloadManagerPeerListener>(){

            @Override
            public void dispatch(DownloadManagerPeerListener listener, int type, Object value) {
                if (type == 1) {
                    listener.peerAdded((PEPeer)value);
                } else if (type == 2) {
                    listener.peerRemoved((PEPeer)value);
                } else if (type == 5) {
                    listener.peerManagerAdded((PEPeerManager)value);
                } else if (type == 6) {
                    listener.peerManagerRemoved((PEPeerManager)value);
                }
            }
        });
        TPS_Key = new Object();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable Subfolder for DND Files", "Subfolder for DND Files"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                boolean enable = COConfigurationManager.getBooleanParameter("Enable Subfolder for DND Files");
                if (enable) {
                    String folder = COConfigurationManager.getStringParameter("Subfolder for DND Files").trim();
                    if (folder.length() > 0) {
                        folder = FileUtil.convertOSSpecificChars(folder, true).trim();
                    }
                    dnd_subfolder = folder.length() > 0 ? folder : null;
                } else {
                    dnd_subfolder = null;
                }
            }
        });
        save_dir_check_cache = new HashMap<String, Boolean>();
        save_dir_check_timer = null;
        piece_listeners_aggregator = ListenerManager.createAsyncManager("DM:PieceListenAggregatorDispatcher", new ListenerManagerDispatcher<DownloadManagerPieceListener>(){

            @Override
            public void dispatch(DownloadManagerPieceListener listener, int type, Object value) {
                if (type == 3) {
                    listener.pieceAdded((PEPiece)value);
                } else if (type == 4) {
                    listener.pieceRemoved((PEPiece)value);
                }
            }
        });
        TTP_KEY = new Object();
    }

    public static void addGlobalDownloadListener(DownloadManagerListener listener) {
        global_dm_listeners.add(listener);
    }

    public static void removeGlobalDownloadListener(DownloadManagerListener listener) {
        global_dm_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManagerImpl(GlobalManager _gm, byte[] _torrent_hash, String _torrentFileName, String _torrent_save_dir, String _torrent_save_file, int _initialState, boolean _persistent, boolean _recovered, boolean _open_for_seeding, boolean _has_ever_been_started, List _file_priorities) {
        List<Runnable> to_run;
        this.listeners.addListener(global_dm_listener);
        this.tracker_listeners = ListenerManager.createManager("DM:TrackerListenDispatcher", new ListenerManagerDispatcher<DownloadManagerTrackerListener>(){

            @Override
            public void dispatch(DownloadManagerTrackerListener listener, int type, Object value) {
                if (type == 1) {
                    listener.announceResult((TRTrackerAnnouncerResponse)value);
                } else if (type == 2) {
                    listener.scrapeResult((TRTrackerScraperResponse)value);
                }
            }
        });
        this.peer_listeners = ListenerManager.createManager("DM:PeerListenDispatcher", new ListenerManagerDispatcher<DownloadManagerPeerListener>(){

            @Override
            public void dispatch(DownloadManagerPeerListener listener, int type, Object value) {
                peer_listeners_aggregator.dispatch(listener, type, value);
            }
        });
        this.peer_listeners_mon = new AEMonitor("DM:DownloadManager:PeerL");
        this.current_peers = new IdentityHashMap<PEPeer, String>();
        this.current_peers_unmatched_removal = new IdentityHashMap<PEPeer, Long>();
        this.piece_listeners = ListenerManager.createManager("DM:PieceListenDispatcher", new ListenerManagerDispatcher<DownloadManagerPieceListener>(){

            @Override
            public void dispatch(DownloadManagerPieceListener listener, int type, Object value) {
                piece_listeners_aggregator.dispatch(listener, type, value);
            }
        });
        this.init_lock = new Object();
        this.post_init_tasks = new ArrayList<Runnable>();
        this.piece_listeners_mon = new AEMonitor("DM:DownloadManager:PeiceL");
        this.current_pieces = new ArrayList<PEPiece>();
        this.this_mon = new AEMonitor("DM:DownloadManager");
        this.last_informed_state = -1;
        this.display_name = "";
        this.internal_name = "";
        this.position = -1;
        this.url_group_map = new HashMap<String, Object[]>();
        this.url_group_map_uid = -1L;
        this.light_seeding_status = 0;
        this.tracker_client_listener = new TRTrackerAnnouncerListener(){

            @Override
            public void receivedTrackerResponse(TRTrackerAnnouncerRequest request2, TRTrackerAnnouncerResponse response) {
                PEPeerManager pm = DownloadManagerImpl.this.controller.getPeerManager();
                if (pm != null) {
                    pm.processTrackerResponse(response);
                }
                DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
            }

            @Override
            public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
                if (explicit) {
                    if (DownloadManagerImpl.this.torrent.getPrivate()) {
                        ArrayList<PEPeer> peers;
                        try {
                            DownloadManagerImpl.this.peer_listeners_mon.enter();
                            peers = new ArrayList<PEPeer>(DownloadManagerImpl.this.current_peers.keySet());
                        }
                        finally {
                            DownloadManagerImpl.this.peer_listeners_mon.exit();
                        }
                        new AEThread2("DM:torrentChangeFlusher", true){

                            @Override
                            public void run() {
                                int i = 0;
                                while (i < peers.size()) {
                                    PEPeer peer = (PEPeer)peers.get(i);
                                    peer.getManager().removePeer(peer, "Private torrent: tracker changed", 2);
                                    ++i;
                                }
                            }
                        }.start();
                    }
                    DownloadManagerImpl.this.requestTrackerAnnounce(true);
                }
            }

            @Override
            public void urlRefresh() {
                DownloadManagerImpl.this.requestTrackerAnnounce(true);
            }
        };
        this.tracker_client_stats_listener = new TRTrackerAnnouncerListener(){

            @Override
            public void receivedTrackerResponse(TRTrackerAnnouncerRequest request2, TRTrackerAnnouncerResponse response) {
                if (response.getStatus() == 2) {
                    DownloadManagerImpl.this.stats.updateTrackerSession(request2);
                }
            }

            @Override
            public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
            }

            @Override
            public void urlRefresh() {
            }
        };
        this.activation_listeners = new CopyOnWriteList();
        this.scrape_random_seed = SystemTime.getCurrentTime();
        this.data_already_allocated = false;
        this.creation_time = SystemTime.getCurrentTime();
        this.seedingRank = defaultSeedingRank;
        this.max_uploads = 2;
        this.max_uploads_when_seeding = 2;
        this.crypto_level = 0;
        this.message_mode = -1;
        this.move_progress = null;
        this.move_subtask = "";
        this.move_state = 1;
        Object object = this.init_lock;
        synchronized (object) {
            if (_initialState != 0 && _initialState != 70 && _initialState != 75) {
                Debug.out("DownloadManagerImpl: Illegal start state, " + _initialState);
            }
            this.persistent = _persistent;
            this.globalManager = _gm;
            this.open_for_seeding = _open_for_seeding;
            if (_file_priorities != null) {
                this.setUserData("file_priorities", _file_priorities);
            }
            this.stats = new DownloadManagerStatsImpl(this);
            this.controller = new DownloadManagerController(this);
            this.torrentFileName = _torrentFileName;
            _torrent_save_dir = FileUtil.removeTrailingSeparators(_torrent_save_dir);
            this.readTorrent(_torrent_save_dir, _torrent_save_file, _torrent_hash, this.persistent && !_recovered, _open_for_seeding, _has_ever_been_started, _initialState);
            if (this.torrent != null) {
                Map<Integer, File> linkage;
                this.buildURLGroupMap(this.torrent);
                this.torrent.addListener(new TOTorrentListener(){

                    @Override
                    public void torrentChanged(TOTorrent torrent, int change_type, Object data) {
                        DownloadManagerImpl.this.buildURLGroupMap(torrent);
                    }
                });
                if (_open_for_seeding && !_recovered && (linkage = TorrentUtils.getInitialLinkage(this.torrent)).size() > 0) {
                    DownloadManagerState dms = this.getDownloadState();
                    DiskManagerFileInfo[] files = this.getDiskManagerFileInfoSet().getFiles();
                    try {
                        dms.suppressStateSave(true);
                        for (Map.Entry<Integer, File> entry : linkage.entrySet()) {
                            int index = entry.getKey();
                            File target = entry.getValue();
                            dms.setFileLink(index, files[index].getFile(false), target);
                        }
                    }
                    finally {
                        dms.suppressStateSave(false);
                    }
                }
            }
            this.initialised = true;
            to_run = this.post_init_tasks;
            this.post_init_tasks = null;
        }
        for (Runnable r : to_run) {
            try {
                r.run();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void setConstructed() {
        this.constructed = true;
    }

    @Override
    public boolean isConstructed() {
        return this.constructed;
    }

    private void buildURLGroupMap(TOTorrent torrent) {
        int group = 0;
        HashMap<String, Object[]> new_map = new HashMap<String, Object[]>();
        TOTorrentAnnounceURLGroup t_group = torrent.getAnnounceURLGroup();
        this.url_group_map_uid = t_group.getUID();
        int overall_ls = 0;
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = t_group.getAnnounceURLSets();
        int n = tOTorrentAnnounceURLSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
            URL[] urls = set.getAnnounceURLs();
            if (urls.length > 1) {
                Integer g = ++group;
                URL[] uRLArray = urls;
                int n4 = urls.length;
                n3 = 0;
                while (n3 < n4) {
                    URL u = uRLArray[n3];
                    String key = all_trackers.ingestURL(u);
                    new_map.put(key, new Object[]{u, g});
                    overall_ls = Math.max(overall_ls, this.getLightSeedTrackerStatus(key));
                    ++n3;
                }
            } else {
                URL[] uRLArray = urls;
                n3 = urls.length;
                int n5 = 0;
                while (n5 < n3) {
                    URL u = uRLArray[n5];
                    String key = all_trackers.ingestURL(u);
                    overall_ls = Math.max(overall_ls, this.getLightSeedTrackerStatus(key));
                    ++n5;
                }
            }
            ++n2;
        }
        URL announce_url = torrent.getAnnounceURL();
        String announce_key = all_trackers.ingestURL(announce_url);
        this.light_seeding_status = overall_ls = Math.max(overall_ls, this.getLightSeedTrackerStatus(announce_key));
        this.url_group_map = new_map;
    }

    private int getLightSeedTrackerStatus(String name) {
        Number n;
        Map<String, Object> options;
        AllTrackersManager.AllTrackersTracker tracker;
        if (name != null && (tracker = all_trackers.getTracker(name)) != null && (options = tracker.getOptions()) != null && (n = (Number)options.get("ls")) != null) {
            return n.intValue();
        }
        return 0;
    }

    protected int getTrackerURLGroup(String key) {
        Object[] entry;
        if (this.torrent.getAnnounceURLGroup().getUID() != this.url_group_map_uid) {
            this.buildURLGroupMap(this.torrent);
        }
        return (entry = this.url_group_map.get(key)) == null ? -1 : (Integer)entry[1];
    }

    @Override
    public int getTaggableType() {
        return 2;
    }

    @Override
    public TaggableResolver getTaggableResolver() {
        return this.globalManager;
    }

    @Override
    public String getTaggableID() {
        return this.dl_identity == null ? null : Base32.encode(this.dl_identity);
    }

    @Override
    public String getTaggableName() {
        return this.getDisplayName();
    }

    @Override
    public DataSourceResolver.ExportedDataSource exportDataSource() {
        return new DataSourceResolver.ExportedDataSource(){

            @Override
            public Class<? extends DataSourceResolver.DataSourceImporter> getExporter() {
                return DownloadManagerImpl.this.globalManager.getClass();
            }

            @Override
            public Map<String, Object> getExport() {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("id", DownloadManagerImpl.this.getTaggableID());
                return m;
            }
        };
    }

    /*
     * Exception decompiling
     */
    private void readTorrent(String torrent_save_dir, String torrent_save_file, byte[] torrent_hash, boolean new_torrent, boolean for_seeding, boolean has_ever_been_started, int initial_state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void readTorrent() {
        if (this.read_torrent_state == null) {
            return;
        }
        this.readTorrent((String)this.read_torrent_state[0], (String)this.read_torrent_state[1], (byte[])this.read_torrent_state[2], (Boolean)this.read_torrent_state[3], (Boolean)this.read_torrent_state[4], (Boolean)this.read_torrent_state[5], (Integer)this.read_torrent_state[6]);
    }

    protected void readParameters() {
        this.max_connections = this.getDownloadState().getIntParameter("max.peers");
        this.max_connections_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.peers.when.seeding.enabled");
        this.max_connections_when_seeding = this.getDownloadState().getIntParameter("max.peers.when.seeding");
        this.max_seed_connections = this.getDownloadState().getIntParameter("max.seeds");
        this.max_uploads = this.getDownloadState().getIntParameter("max.uploads");
        this.max_uploads_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.uploads.when.seeding.enabled");
        this.max_uploads_when_seeding = this.getDownloadState().getIntParameter("max.uploads.when.seeding");
        this.max_upload_when_busy_bps = this.getDownloadState().getIntParameter("max.upload.when.busy") * 1024;
        this.max_uploads = Math.max(this.max_uploads, 2);
        this.max_uploads_when_seeding = Math.max(this.max_uploads_when_seeding, 2);
        this.upload_priority_manual = this.getDownloadState().getIntParameter("up.pri");
    }

    protected int[] getMaxConnections(boolean mixed) {
        if (mixed && this.max_connections > 0) {
            return new int[]{this.max_connections, max_connections_npp_extra};
        }
        int[] nArray = new int[2];
        nArray[0] = this.max_connections;
        return nArray;
    }

    protected int[] getMaxConnectionsWhenSeeding(boolean mixed) {
        if (mixed && this.max_connections_when_seeding > 0) {
            return new int[]{this.max_connections_when_seeding, max_connections_npp_extra};
        }
        int[] nArray = new int[2];
        nArray[0] = this.max_connections_when_seeding;
        return nArray;
    }

    protected boolean isMaxConnectionsWhenSeedingEnabled() {
        return this.max_connections_when_seeding_enabled;
    }

    protected int[] getMaxSeedConnections(boolean mixed) {
        if (mixed && this.max_seed_connections > 0) {
            return new int[]{this.max_seed_connections, max_connections_npp_extra};
        }
        int[] nArray = new int[2];
        nArray[0] = this.max_seed_connections;
        return nArray;
    }

    protected boolean isMaxUploadsWhenSeedingEnabled() {
        return this.max_uploads_when_seeding_enabled;
    }

    protected int getMaxUploadsWhenSeeding() {
        return this.max_uploads_when_seeding;
    }

    @Override
    public void updateAutoUploadPriority(Object key, boolean inc) {
        try {
            boolean key_exists;
            this.peer_listeners_mon.enter();
            boolean bl = key_exists = this.getUserData(key) != null;
            if (inc && !key_exists) {
                ++this.upload_priority_auto;
                this.setUserData(key, "");
            } else if (!inc && key_exists) {
                --this.upload_priority_auto;
                this.setUserData(key, null);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    @Override
    public int getEffectiveUploadPriority() {
        return this.upload_priority_manual + this.upload_priority_auto;
    }

    @Override
    public int getMaxUploads() {
        return this.max_uploads;
    }

    @Override
    public void setMaxUploads(int max) {
        this.download_manager_state.setIntParameter("max.uploads", max);
    }

    public void setManualUploadPriority(int priority) {
        this.download_manager_state.setIntParameter("up.pri", priority);
    }

    @Override
    public int getEffectiveMaxUploads() {
        if (this.isMaxUploadsWhenSeedingEnabled() && this.getState() == 60) {
            return this.getMaxUploadsWhenSeeding();
        }
        return this.max_uploads;
    }

    @Override
    public int getEffectiveUploadRateLimitBytesPerSecond() {
        int local_max_bps;
        int rate = local_max_bps = this.stats.getUploadRateLimitBytesPerSecond();
        if (this.max_upload_when_busy_bps != 0) {
            long now = SystemTime.getCurrentTime();
            if (now < this.last_upload_when_busy_update || now - this.last_upload_when_busy_update > 5000L) {
                this.last_upload_when_busy_update = now;
                String key = TransferSpeedValidator.getActiveUploadParameter(this.globalManager);
                int global_limit_bps = COConfigurationManager.getIntParameter(key) * 1024;
                if (global_limit_bps > 0 && this.max_upload_when_busy_bps < global_limit_bps) {
                    local_max_bps = local_max_bps == 0 ? global_limit_bps : local_max_bps;
                    GlobalManagerStats gm_stats = this.globalManager.getStats();
                    int actual = gm_stats.getDataSendRateNoLAN() + gm_stats.getProtocolSendRateNoLAN();
                    int move_by = (local_max_bps - this.max_upload_when_busy_bps) / 10;
                    if (move_by < 1024) {
                        move_by = 1024;
                    }
                    if (global_limit_bps - actual <= 2048) {
                        if (this.current_upload_when_busy_bps == 0) {
                            this.current_upload_when_busy_bps = local_max_bps;
                        }
                        int prev_upload_when_busy_bps = this.current_upload_when_busy_bps;
                        this.current_upload_when_busy_bps -= move_by;
                        if (this.current_upload_when_busy_bps < this.max_upload_when_busy_bps) {
                            this.current_upload_when_busy_bps = this.max_upload_when_busy_bps;
                        }
                        if (this.current_upload_when_busy_bps < prev_upload_when_busy_bps) {
                            this.last_upload_when_busy_dec_time = now;
                        }
                    } else if (this.current_upload_when_busy_bps != 0 && (upload_when_busy_min_secs == 0 || now < this.last_upload_when_busy_dec_time || now - this.last_upload_when_busy_dec_time >= (long)upload_when_busy_min_secs * 1000L)) {
                        this.current_upload_when_busy_bps += move_by;
                        if (this.current_upload_when_busy_bps >= local_max_bps) {
                            this.current_upload_when_busy_bps = 0;
                        }
                    }
                    if (this.current_upload_when_busy_bps > 0) {
                        rate = this.current_upload_when_busy_bps;
                    }
                } else {
                    this.current_upload_when_busy_bps = 0;
                }
            } else if (this.current_upload_when_busy_bps > 0) {
                rate = this.current_upload_when_busy_bps;
            }
        }
        return rate;
    }

    protected void setFileLinks() {
        this.cached_save_location = null;
        DiskManagerFactory.setFileLinks(this, this.download_manager_state.getFileLinks());
        this.controller.fileInfoChanged();
    }

    protected void clearFileLinks() {
        this.download_manager_state.clearFileLinks();
    }

    private void updateFileLinks(File old_save_path, File new_save_path) {
        old_save_path = FileUtil.getCanonicalFileSafe(old_save_path);
        new_save_path = FileUtil.getCanonicalFileSafe(new_save_path);
        LinkFileMap links = this.download_manager_state.getFileLinks();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        ArrayList<Integer> from_indexes = new ArrayList<Integer>();
        ArrayList<File> from_links = new ArrayList<File>();
        ArrayList<File> to_links = new ArrayList<File>();
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            try {
                File to = entry.getToFile();
                if (to == null) continue;
                to = FileUtil.getCanonicalFileSafe(to);
                int file_index = entry.getIndex();
                File from = entry.getFromFile();
                from = FileUtil.getCanonicalFileSafe(from);
                this.updateFileLink(file_index, old_save_path, new_save_path, from, to, from_indexes, from_links, to_links);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        if (from_links.size() > 0) {
            this.download_manager_state.setFileLinks(from_indexes, from_links, to_links);
        }
    }

    private void updateFileLink(int file_index, File old_path, File new_path, File from_loc, File to_loc, List<Integer> from_indexes, List<File> from_links, List<File> to_links) {
        String old_path_str = old_path.getPath();
        String new_path_str = new_path.getPath();
        if (this.torrent.isSimpleTorrent()) {
            if (!FileUtil.areFilePathsIdentical(old_path, from_loc)) {
                throw new RuntimeException("assert failure: old_path=" + old_path + ", from_loc=" + from_loc);
            }
            from_indexes.add(0);
            from_links.add(old_path);
            to_links.add(null);
            File new_path_parent = new_path.getParentFile();
            if (new_path_parent == null) {
                Debug.out("new_path " + new_path + " missing file separator, not good");
                new_path_parent = new_path;
            }
            String to_loc_name = to_loc.getName();
            File to_loc_to_use = FileUtil.newFile(new_path_parent, to_loc_name);
            from_indexes.add(0);
            from_links.add(new_path);
            to_links.add(to_loc_to_use);
        } else {
            String from_loc_to_use = FileUtil.translateMoveFilePath(old_path_str, new_path_str, from_loc.getAbsolutePath());
            if (from_loc_to_use == null) {
                return;
            }
            String to_loc_to_use = FileUtil.translateMoveFilePath(old_path_str, new_path_str, to_loc.getAbsolutePath());
            from_indexes.add(file_index);
            from_links.add(from_loc);
            to_links.add(null);
            from_indexes.add(file_index);
            from_links.add(FileUtil.newFile(from_loc_to_use, new String[0]));
            to_links.add(to_loc_to_use == null ? to_loc : FileUtil.newFile(to_loc_to_use, new String[0]));
        }
    }

    @Override
    public boolean filesExist(boolean expected_to_be_allocated) {
        return this.controller.filesExist(expected_to_be_allocated);
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public String getDisplayName() {
        String result;
        DownloadManagerState dms = this.getDownloadState();
        if (dms != null && (result = dms.getDisplayName()) != null) {
            return result;
        }
        return this.display_name;
    }

    @Override
    public String getInternalName() {
        return this.internal_name;
    }

    @Override
    public void setErrorState(int errorType, String errorDetails, int errorFlags) {
        this.controller.setErrorState(errorType, errorDetails, errorFlags);
    }

    @Override
    public String getErrorDetails() {
        return this.controller.getErrorDetail();
    }

    @Override
    public int getErrorType() {
        return this.controller.getErrorType();
    }

    @Override
    public int getErrorFlags() {
        return this.controller.getErrorFlags();
    }

    @Override
    public long getSize() {
        if (this.torrent != null) {
            return this.torrent.getSize();
        }
        return 0L;
    }

    protected void setFailed(String str) {
        this.controller.setFailed(str);
    }

    protected void setFailed(int error, String str) {
        this.controller.setFailed(error, str);
    }

    protected void setFailed(String str, Throwable e) {
        this.controller.setFailed(str, e);
    }

    protected void setTorrentInvalid(Throwable cause) {
        this.setFailed("Invalid torrent", cause);
        this.torrent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTCPPortOverride(boolean only_if_allocated) {
        if (this.tcp_port_override != 0) {
            return this.tcp_port_override > 0 ? this.tcp_port_override : 0;
        }
        if (this.getTorrentHashOverride() != null) {
            if (only_if_allocated) {
                return -1;
            }
            PeerManagerRegistration reg = this.controller.getPeerManagerRegistration();
            if (reg != null) {
                List<PeerManagerRegistration> others = reg.getOtherRegistrationsForHash();
                ArrayList<Integer> existing_ports = new ArrayList<Integer>();
                for (PeerManagerRegistration r : others) {
                    int port = r.getHashOverrideLocalPort(true);
                    if (port <= 0) continue;
                    existing_ports.add(port);
                }
                Object object = port_init_lock;
                synchronized (object) {
                    if (this.tcp_port_override == 0) {
                        this.tcp_port_override = TCPNetworkManager.getSingleton().getAdditionalTCPListeningPortNumber(existing_ports);
                    }
                    return this.tcp_port_override;
                }
            }
            return -1;
        }
        this.tcp_port_override = -1;
        return 0;
    }

    protected HashWrapper getTorrentHashOverride() {
        try {
            byte[] orig;
            if (this.torrent != null && (orig = TorrentUtils.getOriginalHash(this.torrent)) != null) {
                return new HashWrapper(orig);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getTCPListeningPortNumber() {
        int port = this.getTCPPortOverride(false);
        if (port > 0) {
            return port;
        }
        return TCPNetworkManager.getSingleton().getDefaultTCPListeningPortNumber();
    }

    @Override
    public void saveResumeData() {
        if (this.getState() == 50) {
            try {
                this.getDiskManager().saveResumeData(true);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails", e);
            }
        }
        if (!this.assumedComplete) {
            this.download_manager_state.save(true);
        }
    }

    @Override
    public void saveDownload(boolean interim) {
        DiskManager disk_manager = this.controller.getDiskManager();
        if (disk_manager != null) {
            disk_manager.saveState(interim);
        }
        this.download_manager_state.save(interim);
    }

    @Override
    public void initialize() {
        if (this.isDestroyed()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LogIDs.CORE, 3, "Initialize called after destroyed"));
            }
            return;
        }
        if (this.torrent == null) {
            this.readTorrent();
        }
        if (this.torrent == null) {
            this.setFailed("Failed to read torrent");
            return;
        }
        if (this.assumedComplete && !this.filesExist(true)) {
            return;
        }
        this.download_manager_state.setActive(true);
        try {
            try {
                this.this_mon.enter();
                this.stopQueuedTrackerClient();
                if (this._tracker_client != null) {
                    Debug.out("DownloadManager: initialize called with tracker client still available");
                    this._tracker_client.destroy();
                }
                this._tracker_client = TRTrackerAnnouncerFactory.create(this.torrent, new TRTrackerAnnouncerFactory.DataProvider(){

                    @Override
                    public String[] getNetworks() {
                        return DownloadManagerImpl.this.download_manager_state.getNetworks();
                    }

                    @Override
                    public HashWrapper getTorrentHashOverride() {
                        return DownloadManagerImpl.this.getTorrentHashOverride();
                    }
                });
                this._tracker_client.setTrackerResponseCache(this.download_manager_state.getTrackerResponseCache());
                this._tracker_client.addListener(this.tracker_client_listener);
                this._tracker_client.addListener(this.tracker_client_stats_listener);
            }
            finally {
                this.this_mon.exit();
            }
            try {
                this.controller.initializeDiskManager(this.open_for_seeding);
            }
            finally {
                this.open_for_seeding = false;
            }
        }
        catch (TRTrackerAnnouncerException e) {
            this.setFailed("Tracker initialisation failed", e);
        }
    }

    @Override
    public void checkLightSeeding(boolean full_sync) {
        String debug;
        int status;
        if (full_sync && this.torrent != null) {
            this.buildURLGroupMap(this.torrent);
        }
        if (this.seedingRank.getLightSeedEligibility() == 0L) {
            status = this.light_seeding_status;
            debug = status == 0 ? String.valueOf((status = default_light_seeding_status) == 1 ? "active" : "inactive") + " (default)" : String.valueOf(status == 1 ? "active" : "inactive") + " (explicit)";
        } else {
            status = 2;
            debug = "inactive";
        }
        if (status == 2) {
            if (this._tracker_client_for_queued_download != null) {
                try {
                    this.this_mon.enter();
                    this.stopQueuedTrackerClient();
                }
                finally {
                    this.this_mon.exit();
                }
            }
            this.seedingRank.setActivationStatus(debug);
            return;
        }
        if (this._tracker_client_for_queued_download != null) {
            this.seedingRank.setActivationStatus(debug);
            return;
        }
        if (this.getState() != 75) {
            this.seedingRank.setActivationStatus(String.valueOf(debug) + " but not queued");
            return;
        }
        if (!this.isDownloadComplete(false)) {
            this.seedingRank.setActivationStatus(String.valueOf(debug) + " but not complete");
            return;
        }
        try {
            this.this_mon.enter();
            this.startQueuedTrackerClient();
            this.seedingRank.setActivationStatus(debug);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected boolean isLightSeedTracker(InetSocketAddress isa) {
        TRTrackerAnnouncer ta = this._tracker_client_for_queued_download;
        if (ta != null) {
            return TorrentUtils.isTrackerAddress(ta.getTorrent(), isa);
        }
        return false;
    }

    private void startQueuedTrackerClient() {
        if (this._tracker_client == null && this._tracker_client_for_queued_download == null) {
            try {
                this._tracker_client_for_queued_download = TRTrackerAnnouncerFactory.create(this.torrent, new TRTrackerAnnouncerFactory.DataProvider(){

                    @Override
                    public String[] getNetworks() {
                        return DownloadManagerImpl.this.download_manager_state.getNetworks();
                    }

                    @Override
                    public HashWrapper getTorrentHashOverride() {
                        return DownloadManagerImpl.this.getTorrentHashOverride();
                    }
                });
                this._tracker_client_for_queued_download.addListener(new TRTrackerAnnouncerListener(){

                    @Override
                    public void urlRefresh() {
                    }

                    @Override
                    public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
                    }

                    @Override
                    public void receivedTrackerResponse(TRTrackerAnnouncerRequest request2, TRTrackerAnnouncerResponse response) {
                        response.getStatus();
                    }
                });
                this._tracker_client_for_queued_download.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){

                    @Override
                    public void setPeerSources(String[] allowed_sources) {
                        DownloadManagerState dms = DownloadManagerImpl.this.getDownloadState();
                        String[] sources = PEPeerSource.PS_SOURCES;
                        int i = 0;
                        while (i < sources.length) {
                            String s = sources[i];
                            boolean ok = false;
                            int j = 0;
                            while (j < allowed_sources.length) {
                                if (s.equals(allowed_sources[j])) {
                                    ok = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!ok) {
                                dms.setPeerSourcePermitted(s, false);
                            }
                            ++i;
                        }
                    }

                    @Override
                    public boolean isPeerSourceEnabled(String peer_source) {
                        return DownloadManagerImpl.this.controller.isPeerSourceEnabled(peer_source);
                    }

                    @Override
                    public int getUploadSpeedKBSec(boolean estimate) {
                        return 0;
                    }

                    @Override
                    public long getTotalSent() {
                        return 0L;
                    }

                    @Override
                    public long getTotalReceived() {
                        return 0L;
                    }

                    @Override
                    public int getTCPListeningPortNumber() {
                        return DownloadManagerImpl.this.controller.getTCPListeningPortNumber();
                    }

                    @Override
                    public long getRemaining() {
                        return DownloadManagerImpl.this.stats.getRemaining();
                    }

                    @Override
                    public int getPendingConnectionCount() {
                        return 0;
                    }

                    @Override
                    public String getName() {
                        return DownloadManagerImpl.this.getDisplayName();
                    }

                    @Override
                    public int getMaxNewConnectionsAllowed(String network) {
                        return DownloadManagerImpl.this.controller.getMaxConnections()[0];
                    }

                    @Override
                    public long getFailedHashCheck() {
                        return 0L;
                    }

                    @Override
                    public String getExtensions() {
                        return DownloadManagerImpl.this.controller.getTrackerClientExtensions();
                    }

                    @Override
                    public int getCryptoLevel() {
                        return DownloadManagerImpl.this.getCryptoLevel();
                    }

                    @Override
                    public int getConnectedConnectionCount() {
                        return 0;
                    }
                });
                this._tracker_client_for_queued_download.update(true);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void stopQueuedTrackerClient() {
        if (this._tracker_client_for_queued_download != null) {
            this._tracker_client_for_queued_download.stop(false);
            this._tracker_client_for_queued_download.destroy();
            this._tracker_client_for_queued_download = null;
        }
    }

    @Override
    public void setStateWaiting() {
        if (this.checkResuming()) {
            this.setForceStart(true);
        } else {
            this.controller.setStateWaiting();
        }
    }

    public void setStateFinishing() {
        this.controller.setStateFinishing();
    }

    @Override
    public void setStateQueued() {
        if (this.checkResuming()) {
            this.setForceStart(true);
        } else {
            this.controller.setStateQueued();
        }
    }

    @Override
    public int getState() {
        return this.controller.getState();
    }

    @Override
    public int getSubState() {
        int substate = this.controller.getSubState();
        if (substate == 75 && this._tracker_client_for_queued_download != null) {
            return 60;
        }
        return substate;
    }

    @Override
    public boolean canForceRecheck() {
        if (this.getTorrent() == null) {
            return false;
        }
        return this.controller.canForceRecheck();
    }

    protected void restoreResumeData(Map data) {
        this.controller.forceRecheck(data);
    }

    @Override
    public void forceRecheck() {
        this.controller.forceRecheck(null);
    }

    @Override
    public boolean isForceRechecking() {
        return this.controller.isForceRechecking();
    }

    @Override
    public void setPieceCheckingEnabled(boolean enabled) {
        this.controller.setPieceCheckingEnabled(enabled);
    }

    @Override
    public void resetFile(DiskManagerFileInfo file) {
        int state = this.getState();
        if (state == 70 || state == 100) {
            DiskManagerFactory.clearResumeData(this, file);
        } else {
            Debug.out("Download not stopped");
        }
    }

    @Override
    public void recheckFile(DiskManagerFileInfo file) {
        int state = this.getState();
        if (state == 70 || state == 100) {
            DiskManagerFactory.recheckFile(this, file);
        } else {
            Debug.out("Download not stopped");
        }
    }

    @Override
    public void requestAllocation(List<DiskManagerFileInfo> files) {
        if (files.isEmpty()) {
            return;
        }
        boolean paused = this.pause(true);
        try {
            HashMap<String, String> reqs = this.download_manager_state.getMapAttribute("allocreq");
            reqs = reqs == null ? new HashMap<String, String>() : new HashMap(reqs);
            for (DiskManagerFileInfo file : files) {
                reqs.put(String.valueOf(file.getIndex()), "");
            }
            this.download_manager_state.setMapAttribute("allocreq", reqs);
            this.setDataAlreadyAllocated(false);
        }
        finally {
            if (paused) {
                this.resume();
            }
        }
    }

    @Override
    public void startDownload() {
        this.message_mode = -1;
        this.controller.startDownload(this.getTrackerClient());
    }

    @Override
    public void stopIt(int state_after_stopping, boolean remove_torrent, boolean remove_data) {
        this.stopIt(state_after_stopping, remove_torrent, remove_data, false);
    }

    @Override
    public void setStopReason(String reason) {
        this.setUserData(UD_KEY_STOP_REASON, reason);
    }

    @Override
    public String getStopReason() {
        return (String)this.getUserData(UD_KEY_STOP_REASON);
    }

    @Override
    public void stopIt(int state_after_stopping, boolean remove_torrent, boolean remove_data, boolean for_removal) {
        if (for_removal) {
            this.removing = true;
        } else if (this.download_manager_state.getFlag(512L) && state_after_stopping == 70) {
            try {
                FileUtil.log("stopDownloadManager: stopping magnet" + ByteFormatter.encodeString(this.torrent.getHash()), new Exception());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            boolean skipSetTimeStopped;
            boolean closing = state_after_stopping == 71;
            int curState = this.getState();
            boolean alreadyStopped = curState == 70 || curState == 65 || curState == 100;
            boolean bl = skipSetTimeStopped = alreadyStopped || closing && curState == 75;
            if (alreadyStopped) {
                this.resume_time = 0L;
            }
            if (!skipSetTimeStopped) {
                this.download_manager_state.setLongAttribute("timestopped", SystemTime.getCurrentTime());
            }
            this.controller.stopIt(state_after_stopping, remove_torrent, remove_data, for_removal);
        }
        finally {
            this.download_manager_state.setActive(false);
        }
    }

    private boolean checkResuming() {
        return this.globalManager.resumingDownload(this);
    }

    @Override
    public boolean pause(boolean only_if_active) {
        return this.globalManager.pauseDownload(this, only_if_active);
    }

    @Override
    public boolean pause(boolean only_if_active, long _resume_time) {
        if (this.isPaused()) {
            if (only_if_active) {
                return false;
            }
            this.resume_time = _resume_time;
            return true;
        }
        int curState = this.getState();
        this.resume_time = curState == 70 ? _resume_time : -_resume_time;
        return this.globalManager.pauseDownload(this, only_if_active);
    }

    @Override
    public long getAutoResumeTime() {
        return this.resume_time;
    }

    @Override
    public void setAutoResumeTime(long time) {
        this.resume_time = time;
    }

    @Override
    public boolean stopPausedDownload() {
        if (this.globalManager.stopPausedDownload(this)) {
            this.resume_time = 0L;
            this.setStopReason(null);
            this.listeners.dispatch(1, new Object[]{this, new Integer(this.getState())});
            return true;
        }
        return false;
    }

    @Override
    public boolean isPaused() {
        return this.globalManager.isPaused(this);
    }

    @Override
    public void resume() {
        this.globalManager.resumeDownload(this);
    }

    @Override
    public boolean getAssumedComplete() {
        return this.assumedComplete;
    }

    @Override
    public boolean requestAssumedCompleteMode() {
        return this.requestAssumedCompleteMode(false);
    }

    protected boolean requestAssumedCompleteMode(boolean filePriorityChanged) {
        boolean bCompleteNoDND = this.controller.isDownloadComplete(false);
        this.setAssumedComplete(bCompleteNoDND, filePriorityChanged);
        return bCompleteNoDND;
    }

    protected void setAssumedComplete(boolean _assumedComplete) {
        this.setAssumedComplete(_assumedComplete, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAssumedComplete(boolean _assumedComplete, boolean filePriorityChanged) {
        if (_assumedComplete) {
            long completedOn = this.download_manager_state.getLongParameter("stats.download.completed.time");
            if (completedOn <= 0L) {
                final long now = SystemTime.getCurrentTime();
                this.download_manager_state.setLongParameter("stats.download.completed.time", now);
                long last_file = this.download_manager_state.getLongParameter("stats.download.file.completed.time");
                if (last_file <= 0L) {
                    Runnable set_it = new Runnable(){

                        @Override
                        public void run() {
                            DiskManagerFileInfo[] files;
                            long last_mod = 0L;
                            DiskManagerFileInfo[] diskManagerFileInfoArray = files = DownloadManagerImpl.this.getDiskManagerFileInfoSet().getFiles();
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long mod;
                                File f;
                                DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                                if (!file.isSkipped() && (f = file.getFile(true)).length() == file.getLength() && (mod = f.lastModified()) > last_mod) {
                                    last_mod = mod;
                                }
                                ++n2;
                            }
                            if (last_mod == 0L) {
                                last_mod = now;
                            }
                            DownloadManagerImpl.this.download_manager_state.setLongParameter("stats.download.file.completed.time", last_mod);
                            if (last_mod < now) {
                                DownloadManagerImpl.this.download_manager_state.setLongParameter("stats.download.completed.time", last_mod);
                            }
                        }
                    };
                    Object object = this.init_lock;
                    synchronized (object) {
                        if (!this.initialised) {
                            this.post_init_tasks.add(set_it);
                            set_it = null;
                        }
                    }
                    if (set_it != null) {
                        set_it.run();
                    }
                }
            }
        } else if (filePriorityChanged) {
            this.download_manager_state.setLongParameter("stats.download.completed.time", 0L);
        }
        if (this.assumedComplete == _assumedComplete) {
            return;
        }
        this.assumedComplete = _assumedComplete;
        if (!this.assumedComplete) {
            this.controller.setStateDownloading();
        }
        if (this.position != -1) {
            DownloadManager[] dms = new DownloadManager[]{this};
            this.position = this.globalManager.getDownloadManagers().size() + 1;
            if (_assumedComplete) {
                if (COConfigurationManager.getBooleanParameter(CFG_MOVE_COMPLETED_TOP)) {
                    this.globalManager.moveTop(dms);
                } else {
                    this.globalManager.moveEnd(dms);
                }
            } else {
                int qp = COConfigurationManager.getIntParameter("Add Torrent Queue Position", 1);
                if (qp == 0) {
                    this.globalManager.moveTop(dms);
                } else {
                    this.globalManager.moveEnd(dms);
                }
            }
            this.globalManager.fixUpDownloadManagerPositions();
        }
        this.listeners.dispatch(3, new Object[]{this, _assumedComplete});
    }

    @Override
    public int getNbSeeds() {
        PEPeerManager peerManager = this.controller.getPeerManager();
        if (peerManager != null) {
            return peerManager.getNbSeeds();
        }
        return 0;
    }

    @Override
    public int getNbPeers() {
        PEPeerManager peerManager = this.controller.getPeerManager();
        if (peerManager != null) {
            return peerManager.getNbPeers();
        }
        return 0;
    }

    @Override
    public String getTrackerStatus() {
        TRTrackerScraperResponse response;
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            return tc.getStatusString();
        }
        if (this.torrent != null && (response = this.getTrackerScrapeResponse()) != null) {
            return response.getStatusString();
        }
        return "";
    }

    @Override
    public TRTrackerAnnouncer getTrackerClient() {
        TRTrackerAnnouncer result = this._tracker_client;
        if (result == null) {
            result = this._tracker_client_for_queued_download;
        }
        return result;
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncer cl = this.getTrackerClient();
        if (cl == null) {
            return;
        }
        cl.setAnnounceResult(result);
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult result) {
        if (this.torrent != null && result != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            TRTrackerScraperResponse current_resp = this.getTrackerScrapeResponse();
            URL target_url = current_resp != null ? current_resp.getURL() : this.torrent.getAnnounceURL();
            scraper.setScrape(this.torrent, target_url, result);
        }
    }

    @Override
    public int getNbPieces() {
        if (this.torrent == null) {
            return 0;
        }
        return this.torrent.getNumberOfPieces();
    }

    @Override
    public int getTrackerTime() {
        TRTrackerScraperResponse response;
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            return tc.getTimeUntilNextUpdate();
        }
        if (this.torrent != null && (response = this.getTrackerScrapeResponse()) != null) {
            if (response.getStatus() == 3) {
                return -1;
            }
            return (int)((response.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L);
        }
        return 60;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public File getSaveLocation() {
        File save_location = this.torrent_save_location;
        if (save_location == this.cached_save_location) {
            return this.cached_save_location_result;
        }
        File res = this.torrent == null || this.torrent.isSimpleTorrent() ? this.download_manager_state.getFileLink(0, save_location) : save_location;
        res = res == null || res.equals(save_location) ? save_location : FileUtil.getCanonicalFileSafe(res);
        this.cached_save_location = save_location;
        this.cached_save_location_result = res;
        return res;
    }

    @Override
    public File getAbsoluteSaveLocation() {
        return this.torrent_save_location;
    }

    @Override
    public void setTorrentSaveDir(File _new_location, boolean locationIncludesName) {
        File old_location;
        File new_location = locationIncludesName ? _new_location : FileUtil.newFile(_new_location, this.torrent_save_location.getName());
        if (FileUtil.areFilePathsIdentical(new_location, old_location = this.torrent_save_location)) {
            return;
        }
        this.updateFileLinks(old_location, new_location);
        this.torrent_save_location = new_location;
        String key = String.valueOf(this.torrent_save_location.getAbsolutePath()) + "\n";
        this.torrent_save_location = FileUtil.getCanonicalFileSafe(this.torrent_save_location);
        this.download_manager_state.setAttribute("canosavedir", String.valueOf(key) + this.torrent_save_location.getAbsolutePath());
        Logger.log(new LogEvent(this, LogIDs.CORE, "Torrent save directory changing from \"" + old_location.getPath() + "\" to \"" + new_location.getPath()));
        this.controller.fileInfoChanged();
        this.informLocationChange(null);
    }

    @Override
    public String getPieceLength() {
        if (this.torrent != null) {
            return DisplayFormatters.formatByteCountToKiBEtc(this.torrent.getPieceLength());
        }
        return "";
    }

    @Override
    public String getTorrentFileName() {
        return this.torrentFileName;
    }

    @Override
    public void setTorrentFileName(String string) {
        this.torrentFileName = string;
    }

    @Override
    public void setTrackerScrapeResponse(TRTrackerScraperResponse response) {
        Object[] res = this.getActiveScrapeResponse();
        URL active_url = (URL)res[1];
        if (active_url != null && this.torrent != null) {
            this.torrent.setAnnounceURL(active_url);
        }
        if (response != null) {
            long minNextScrape;
            int state = this.getState();
            if (state == 100 || state == 70) {
                minNextScrape = response.getStatus() == 0 ? SystemTime.getCurrentTime() + (state == 100 ? 600000L : 180000L) : SystemTime.getCurrentTime() + (state == 100 ? 0x6DDD00L : 3600000L);
                if (response.getNextScrapeStartTime() < minNextScrape) {
                    response.setNextScrapeStartTime(minNextScrape);
                }
            } else if (!response.isValid() && response.getStatus() == 0) {
                int sr = this.getStats().getShareRatio();
                minNextScrape = SystemTime.getCurrentTime() + (long)((sr > 10000 ? 10000 : sr + 1000) * 60);
                if (response.getNextScrapeStartTime() < minNextScrape) {
                    response.setNextScrapeStartTime(minNextScrape);
                }
            }
            if (response.isValid() && response.getStatus() == 2) {
                long cache = ((long)response.getSeeds() & 0xFFFFFFL) << 32 | (long)response.getPeers() & 0xFFFFFFL;
                this.download_manager_state.setLongAttribute("scrapecache", cache);
            }
            this.tracker_listeners.dispatch(2, response);
        }
    }

    @Override
    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        Object[] res = this.getActiveScrapeResponse();
        return (TRTrackerScraperResponse)res[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] getActiveScrapeResponse() {
        TOTorrentAnnounceURLSet[] sets;
        TRTrackerScraperResponse response = null;
        URL active_url = null;
        TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            response = scraper.scrape(tc);
        }
        if (response != null || this.torrent == null) return new Object[]{response, active_url};
        TRTrackerScraperResponse non_null_response = null;
        try {
            sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
        }
        catch (Exception e) {
            return new Object[]{scraper.scrape(this.torrent), active_url};
        }
        if (sets.length == 0) {
            response = scraper.scrape(this.torrent);
            return new Object[]{response, active_url};
        }
        URL backup_url = null;
        TRTrackerScraperResponse backup_response = null;
        Random scrape_random = new Random(this.scrape_random_seed);
        int i = 0;
        while (response == null && i < sets.length) {
            URL url;
            TOTorrentAnnounceURLSet set = sets[i];
            URL[] urls = set.getAnnounceURLs();
            ArrayList<URL> rand_urls = new ArrayList<URL>();
            int j = 0;
            while (j < urls.length) {
                url = urls[j];
                int pos = (int)(scrape_random.nextDouble() * (double)(rand_urls.size() + 1));
                rand_urls.add(pos, url);
                ++j;
            }
            j = 0;
            while (response == null && j < rand_urls.size()) {
                block16: {
                    url = (URL)rand_urls.get(j);
                    response = scraper.scrape(this.torrent, url);
                    if (response != null) {
                        int status = response.getStatus();
                        if (status == 2) {
                            if (response.isDHTBackup()) {
                                backup_url = url;
                                backup_response = response;
                                response = null;
                                break block16;
                            } else {
                                active_url = url;
                                break;
                            }
                        }
                        if (status == 0 || status == 3) break;
                        if (!response.isValid() || status == 1) {
                            if (non_null_response == null) {
                                non_null_response = response;
                            }
                            response = null;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (response != null) return new Object[]{response, active_url};
        if (backup_response != null) {
            response = backup_response;
            active_url = backup_url;
            return new Object[]{response, active_url};
        } else {
            response = non_null_response;
        }
        return new Object[]{response, active_url};
    }

    @Override
    public List<TRTrackerScraperResponse> getGoodTrackerScrapeResponses() {
        ArrayList<TRTrackerScraperResponse> responses = new ArrayList<TRTrackerScraperResponse>();
        if (this.torrent != null) {
            TOTorrentAnnounceURLSet[] sets;
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            try {
                sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            }
            catch (Throwable e) {
                sets = new TOTorrentAnnounceURLSet[]{};
            }
            if (sets.length == 0) {
                int status;
                TRTrackerScraperResponse response = scraper.peekScrape(this.torrent, null);
                if (response != null && (status = response.getStatus()) == 2) {
                    responses.add(response);
                }
            } else {
                int i = 0;
                while (i < sets.length) {
                    URL[] urls;
                    TOTorrentAnnounceURLSet set = sets[i];
                    URL[] uRLArray = urls = set.getAnnounceURLs();
                    int n = urls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int status;
                        URL url = uRLArray[n2];
                        TRTrackerScraperResponse response = scraper.peekScrape(this.torrent, url);
                        if (response != null && (status = response.getStatus()) == 2) {
                            responses.add(response);
                        }
                        ++n2;
                    }
                    ++i;
                }
            }
        }
        return responses;
    }

    @Override
    public void requestTrackerAnnounce(boolean force) {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.update(force);
        } else {
            this.requestTrackerScrape(force);
        }
    }

    @Override
    public void requestTrackerScrape(boolean force) {
        if (this.torrent != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            scraper.scrape(this.torrent, force);
        }
    }

    protected void setTrackerRefreshDelayOverrides(int percent) {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.setRefreshDelayOverrides(percent);
        }
    }

    protected boolean activateRequest(int count) {
        for (DownloadManagerActivationListener listener : this.activation_listeners) {
            try {
                if (!listener.activateRequest(count)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    @Override
    public int getActivationCount() {
        return this.controller.getActivationCount();
    }

    @Override
    public String getTorrentComment() {
        return this.torrent_comment;
    }

    @Override
    public String getTorrentCreatedBy() {
        return this.torrent_created_by;
    }

    @Override
    public long getTorrentCreationDate() {
        if (this.torrent == null) {
            return 0L;
        }
        return this.torrent.getCreationDate();
    }

    @Override
    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    @Override
    public DiskManager getDiskManager() {
        return this.controller.getDiskManager();
    }

    @Override
    public DiskManagerPiece[] getDiskManagerPiecesSnapshot() {
        if (this.destroyed || this.removing) {
            return null;
        }
        return this.controller.getDiskManagerPiecesSnapshot();
    }

    @Override
    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        return this.controller.getDiskManagerFileInfoSet();
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return this.controller.getDiskManagerFileInfo();
    }

    @Override
    public int getNumFileInfos() {
        return this.torrent == null ? 0 : this.torrent.getFileCount();
    }

    @Override
    public PEPeerManager getPeerManager() {
        return this.controller.getPeerManager();
    }

    @Override
    public boolean isDownloadComplete(boolean bIncludeDND) {
        if (!bIncludeDND) {
            return this.assumedComplete;
        }
        return this.controller.isDownloadComplete(bIncludeDND);
    }

    @Override
    public void addListener(DownloadManagerListener listener) {
        this.addListener(listener, true);
    }

    @Override
    public void addListener(DownloadManagerListener listener, boolean triggerStateChange) {
        if (listener == null) {
            Debug.out("Warning: null listener");
            return;
        }
        try {
            try {
                this.listeners_mon.enter();
                this.listeners.addListener(listener);
                if (triggerStateChange) {
                    this.listeners.dispatch(listener, 1, new Object[]{this, new Integer(this.getState())});
                }
            }
            catch (Throwable t) {
                Debug.out("adding listener", t);
                this.listeners_mon.exit();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void removeListener(DownloadManagerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.removeListener(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    protected void informStateChanged() {
        try {
            this.listeners_mon.enter();
            int new_state = this.controller.getState();
            boolean new_force_start = this.controller.isForceStart();
            if (new_state != this.last_informed_state || new_force_start != this.latest_informed_force_start) {
                this.last_informed_state = new_state;
                this.latest_informed_force_start = new_force_start;
                if (this.resume_time < 0L) {
                    if (new_state == 70) {
                        this.resume_time = -this.resume_time;
                    }
                } else {
                    this.resume_time = 0L;
                }
                this.listeners.dispatch(1, new Object[]{this, new Integer(new_state)});
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    protected void informDownloadEnded() {
        try {
            this.listeners_mon.enter();
            this.listeners.dispatch(2, new Object[]{this});
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    protected void informPrioritiesChange(List files) {
        this.calcFilePriorityStats();
        this.controller.filePrioritiesChanged(files);
        try {
            this.listeners_mon.enter();
            int i = 0;
            while (i < files.size()) {
                this.listeners.dispatch(5, new Object[]{this, (DiskManagerFileInfo)files.get(i)});
                ++i;
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        this.requestAssumedCompleteMode(files.size() > 0);
    }

    protected void informLocationChange(int file_index) {
        try {
            this.listeners_mon.enter();
            this.listeners.dispatch(6, new Object[]{this, this.getDiskManagerFileInfoSet().getFiles()[file_index]});
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    protected void informLocationChange(DiskManagerFileInfo file) {
        try {
            this.listeners_mon.enter();
            this.listeners.dispatch(6, new Object[]{this, file});
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    protected void informPriorityChange(DiskManagerFileInfo file) {
        this.informPrioritiesChange(Collections.singletonList(file));
    }

    protected void informFileCompletionChange(DiskManagerFileInfo file) {
        this.calcFilePriorityStats();
    }

    protected void informPositionChanged(int new_position) {
        try {
            this.listeners_mon.enter();
            int old_position = this.position;
            if (new_position != old_position) {
                this.position = new_position;
                this.listeners.dispatch(4, new Object[]{this, new Integer(old_position), new Integer(new_position)});
                if (this.getState() == 60 || this.getState() == 50) {
                    PeerControlSchedulerFactory.updateScheduleOrdering();
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void addPeerListener(DownloadManagerPeerListener listener) {
        this.addPeerListener(listener, true);
    }

    @Override
    public void addPeerListener(DownloadManagerPeerListener listener, boolean bDispatchForExisting) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.addListener(listener);
            if (!bDispatchForExisting) {
                return;
            }
            for (PEPeer peer : this.current_peers.keySet()) {
                this.peer_listeners.dispatch(listener, 1, peer);
            }
            PEPeerManager temp = this.controller.getPeerManager();
            if (temp != null) {
                this.peer_listeners.dispatch(listener, 5, temp);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    @Override
    public void removePeerListener(DownloadManagerPeerListener listener) {
        this.peer_listeners.removeListener(listener);
    }

    @Override
    public void addPieceListener(DownloadManagerPieceListener listener) {
        this.addPieceListener(listener, true);
    }

    @Override
    public void addPieceListener(DownloadManagerPieceListener listener, boolean bDispatchForExisting) {
        try {
            this.piece_listeners_mon.enter();
            this.piece_listeners.addListener(listener);
            if (!bDispatchForExisting) {
                return;
            }
            int i = 0;
            while (i < this.current_pieces.size()) {
                this.piece_listeners.dispatch(listener, 3, this.current_pieces.get(i));
                ++i;
            }
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    @Override
    public void removePieceListener(DownloadManagerPieceListener listener) {
        this.piece_listeners.removeListener(listener);
    }

    public void addPeer(PEPeer peer) {
        try {
            this.peer_listeners_mon.enter();
            if (this.current_peers_unmatched_removal.remove(peer) != null) {
                return;
            }
            this.current_peers.put(peer, "");
            this.peer_listeners.dispatch(1, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePeer(PEPeer peer) {
        TRTrackerAnnouncer announcer;
        try {
            this.peer_listeners_mon.enter();
            if (this.current_peers.remove(peer) == null) {
                long now = SystemTime.getMonotonousTime();
                this.current_peers_unmatched_removal.put(peer, now);
                if (this.current_peers_unmatched_removal.size() > 100) {
                    Iterator<Map.Entry<PEPeer, Long>> it = this.current_peers_unmatched_removal.entrySet().iterator();
                    while (it.hasNext()) {
                        if (now - it.next().getValue() <= 10000L) continue;
                        Debug.out("Removing expired unmatched removal record");
                        it.remove();
                    }
                }
            }
            this.peer_listeners.dispatch(2, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        if ((peer.isSeed() || peer.isRelativeSeed()) && this.isDownloadComplete(false) && (announcer = this.getTrackerClient()) != null) {
            announcer.removeFromTrackerResponseCache(peer.getIp(), peer.getTCPListenPort());
        }
    }

    @Override
    public PEPeer[] getCurrentPeers() {
        try {
            this.peer_listeners_mon.enter();
            PEPeer[] pEPeerArray = this.current_peers.keySet().toArray(new PEPeer[this.current_peers.size()]);
            return pEPeerArray;
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void addPiece(PEPiece piece) {
        try {
            this.piece_listeners_mon.enter();
            this.current_pieces.add(piece);
            this.piece_listeners.dispatch(3, piece);
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    public void removePiece(PEPiece piece) {
        try {
            this.piece_listeners_mon.enter();
            this.current_pieces.remove(piece);
            this.piece_listeners.dispatch(4, piece);
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    @Override
    public PEPiece[] getCurrentPieces() {
        try {
            this.piece_listeners_mon.enter();
            PEPiece[] pEPieceArray = this.current_pieces.toArray(new PEPiece[this.current_pieces.size()]);
            return pEPieceArray;
        }
        finally {
            this.piece_listeners_mon.exit();
        }
    }

    protected void informWillBeStarted(PEPeerManager pm) {
        List<DownloadManagerPeerListener> l = this.peer_listeners.getListenersCopy();
        int i = 0;
        while (i < l.size()) {
            try {
                l.get(i).peerManagerWillBeAdded(pm);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void informStarted(PEPeerManager pm) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.dispatch(5, pm);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.update(true);
        }
    }

    protected void informStopped(PEPeerManager pm, boolean for_queue) {
        if (pm != null) {
            try {
                this.peer_listeners_mon.enter();
                this.peer_listeners.dispatch(6, pm);
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        try {
            this.this_mon.enter();
            if (this._tracker_client != null) {
                this._tracker_client.addListener(new TRTrackerAnnouncerListener(){

                    @Override
                    public void receivedTrackerResponse(TRTrackerAnnouncerRequest request2, TRTrackerAnnouncerResponse response) {
                        if (DownloadManagerImpl.this._tracker_client == null) {
                            response.setPeers(new TRTrackerAnnouncerResponsePeer[0]);
                        }
                        DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
                        DownloadManagerImpl.this.checkLightSeeding(false);
                    }

                    @Override
                    public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
                    }

                    @Override
                    public void urlRefresh() {
                    }
                });
                this._tracker_client.removeListener(this.tracker_client_listener);
                this.download_manager_state.setTrackerResponseCache(this._tracker_client.getTrackerResponseCache());
                this._tracker_client.getLastResponse().setPeers(new TRTrackerAnnouncerResponsePeer[0]);
                this._tracker_client.stop(for_queue && this.isDownloadComplete(false));
                this._tracker_client.destroy();
                this._tracker_client = null;
            }
            this.stopQueuedTrackerClient();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public DownloadManagerStats getStats() {
        return this.stats;
    }

    private void calcFilePriorityStats() {
        DiskManagerFileInfo[] files = this.getDiskManagerFileInfoSet().getFiles();
        int max_priority = Integer.MIN_VALUE;
        int max_priority_incomplete = Integer.MIN_VALUE;
        int priority_cumulative = 0;
        int priority_cumulative_incomplete = 0;
        DiskManagerFileInfo[] diskManagerFileInfoArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
            if (!file.isSkipped()) {
                int priority = file.getPriority();
                priority_cumulative += priority;
                if (priority > max_priority) {
                    max_priority = priority;
                }
                if (file.getLength() != file.getDownloaded()) {
                    priority_cumulative_incomplete += priority;
                    if (priority > max_priority_incomplete) {
                        max_priority_incomplete = priority;
                    }
                }
            }
            ++n2;
        }
        this.stats.setFilePriorityStats(new int[]{max_priority, max_priority_incomplete, priority_cumulative, priority_cumulative_incomplete});
    }

    @Override
    public boolean isForceStart() {
        return this.controller.isForceStart();
    }

    @Override
    public void setForceStart(boolean forceStart) {
        if (forceStart) {
            this.checkResuming();
        }
        this.controller.setForceStart(forceStart);
    }

    protected void downloadEnded(boolean never_downloaded) {
        TRTrackerAnnouncer tc;
        if (!never_downloaded) {
            this.setAssumedComplete(true);
            this.informDownloadEnded();
        }
        if ((tc = this.getTrackerClient()) != null) {
            boolean mask;
            DiskManager dm = this.getDiskManager();
            boolean globalMask = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
            Boolean dmMask = this.download_manager_state.getOptionalBooleanAttribute("mdlc");
            boolean bl = mask = dmMask == null ? globalMask : dmMask;
            if (dm != null && dm.getRemaining() == 0L && !mask) {
                tc.complete(never_downloaded);
            }
        }
    }

    @Override
    public void addDiskListener(DownloadManagerDiskListener listener) {
        this.controller.addDiskListener(listener);
    }

    @Override
    public void removeDiskListener(DownloadManagerDiskListener listener) {
        this.controller.removeDiskListener(listener);
    }

    @Override
    public void addActivationListener(DownloadManagerActivationListener listener) {
        this.activation_listeners.add(listener);
    }

    @Override
    public void removeActivationListener(DownloadManagerActivationListener listener) {
        this.activation_listeners.remove(listener);
    }

    @Override
    public int getHealthStatus() {
        int state = this.getState();
        PEPeerManager peerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null && peerManager != null && (state == 50 || state == 60)) {
            boolean isSeed;
            int nbSeeds = this.getNbSeeds();
            int nbPeers = this.getNbPeers();
            int nbRemotes = peerManager.getNbRemoteTCPConnections() + peerManager.getNbRemoteUTPConnections();
            TRTrackerAnnouncerResponse announce_response = tc.getLastResponse();
            int trackerStatus = announce_response.getStatus();
            boolean bl = isSeed = state == 60;
            if (nbSeeds + nbPeers == 0) {
                if (isSeed) {
                    return 2;
                }
                return 5;
            }
            if (!(isSeed || trackerStatus != 0 && trackerStatus != 1)) {
                return 2;
            }
            if (nbRemotes == 0) {
                TRTrackerScraperResponse scrape_response = this.getTrackerScrapeResponse();
                if (scrape_response != null && scrape_response.isValid() && nbSeeds == scrape_response.getSeeds() && nbPeers == scrape_response.getPeers()) {
                    return 4;
                }
                return 3;
            }
            return 4;
        }
        if (state == 100) {
            return 6;
        }
        return 1;
    }

    @Override
    public Object[] getNATStatus() {
        String nat_info;
        int nat_status;
        int state = this.getState();
        PEPeerManager peerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null && peerManager != null && (state == 50 || state == 60)) {
            int rem_tcp = peerManager.getNbRemoteTCPConnections();
            int rem_utp = peerManager.getNbRemoteUTPConnections();
            if (rem_tcp > 0 || rem_utp > 0) {
                nat_status = 1;
                nat_info = "Has remote " + (rem_tcp > 0 ? "TCP" : "uTP") + " connections";
            } else {
                long last_good_time = peerManager.getLastRemoteConnectionTime();
                if (last_good_time > 0L) {
                    if (SystemTime.getCurrentTime() - last_good_time < 1800000L) {
                        nat_status = 1;
                        nat_info = "Had a recent remote connection";
                    } else {
                        nat_status = 2;
                        nat_info = "Had a remote connection at some point";
                    }
                } else {
                    TRTrackerAnnouncerResponse announce_response = tc.getLastResponse();
                    int trackerStatus = announce_response.getStatus();
                    if (trackerStatus == 0 || trackerStatus == 1) {
                        nat_status = 0;
                        nat_info = "Tracker offline";
                    } else if (SystemTime.getCurrentTime() - peerManager.getTimeStarted(false) < 180000L) {
                        nat_status = 0;
                        nat_info = "Tracker OK but not remote connections yet";
                    } else {
                        TRTrackerScraperResponse scrape_response = this.getTrackerScrapeResponse();
                        if (scrape_response != null && scrape_response.isValid()) {
                            if (peerManager.getNbSeeds() == scrape_response.getSeeds() && peerManager.getNbPeers() == scrape_response.getPeers()) {
                                nat_status = 0;
                                nat_info = "Connected to all known peers, hard to tell";
                            } else if (state == 60 && scrape_response.getPeers() == 0) {
                                nat_status = 0;
                                nat_info = "Seeding and no peers, status can't be determined";
                            } else {
                                nat_status = 3;
                                nat_info = "There are peers, we should get some remote connections";
                            }
                        } else if (state == 60) {
                            nat_status = 0;
                            nat_info = "Tracker info unavailable and we're seeding, hard to tell";
                        } else {
                            nat_status = 3;
                            nat_info = "Tracker info unavailable, assuming bad";
                        }
                    }
                }
            }
        } else {
            nat_status = 0;
            nat_info = "Download not running, can't determine status";
        }
        return new Object[]{nat_status, nat_info};
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int new_position) {
        this.informPositionChanged(new_position);
    }

    @Override
    public void addTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.addListener(listener);
    }

    @Override
    public void removeTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.removeListener(listener);
    }

    protected void deleteDataFiles() {
        DownloadManagerState state = this.getDownloadState();
        DiskManagerFactory.deleteDataFiles(this.torrent, this.torrent_save_location.getParent(), this.torrent_save_location.getName(), state.getFlag(16L) || state.getFlag(128L));
        state.setFlag(4L, true);
    }

    protected void deletePartialDataFiles() {
        DiskManagerFileInfo[] files = this.getDiskManagerFileInfoSet().getFiles();
        String abs_root = this.torrent_save_location.getAbsolutePath();
        DiskManagerFileInfo[] diskManagerFileInfoArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            int storage_type;
            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
            if (file.isSkipped() && file.getDownloaded() != file.getLength() && ((storage_type = file.getStorageType()) == 2 || storage_type == 4) && (f = file.getFile(true)).exists()) {
                if (f.delete()) {
                    File parent = f.getParentFile();
                    while (parent != null) {
                        if (!parent.isDirectory() || parent.listFiles().length != 0 || !parent.getAbsolutePath().startsWith(abs_root)) break;
                        if (!parent.delete()) {
                            Debug.outNoStack("Failed to remove empty directory: " + parent);
                            break;
                        }
                        parent = parent.getParentFile();
                    }
                } else {
                    Debug.outNoStack("Failed to remove partial: " + f);
                }
            }
            ++n2;
        }
    }

    protected void deleteTorrentFile() {
        this.torrentFileExplicitlyDeleted = true;
        if (this.torrentFileName != null) {
            TorrentUtils.delete(FileUtil.newFile(this.torrentFileName, new String[0]), this.getDownloadState().getFlag(16L));
        }
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_manager_state;
    }

    @Override
    public Object getUserData(Object key) {
        Map<Object, Object> data_ref = this.data;
        if (data_ref == null) {
            return null;
        }
        return data_ref.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setUserData(Object key, Object value) {
        try {
            this.peer_listeners_mon.enter();
            Map<Object, Object> data_ref = this.data;
            if (data_ref == null && value == null) {
                return;
            }
            if (value == null) {
                if (!data_ref.containsKey(key)) return;
                if (data_ref.size() == 1) {
                    data_ref = null;
                } else {
                    data_ref = new LightHashMap<Object, Object>(data_ref);
                    data_ref.remove(key);
                }
            } else {
                data_ref = data_ref == null ? new LightHashMap<Object, Object>() : new LightHashMap<Object, Object>(data_ref);
                data_ref.put(key, value);
            }
            this.data = data_ref;
            return;
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTaggableTransientProperty(String key) {
        Object object = TTP_KEY;
        synchronized (object) {
            LightHashMap map;
            block4: {
                map = (LightHashMap)this.getUserData(TTP_KEY);
                if (map != null) break block4;
                return null;
            }
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTaggableTransientProperty(String key, Object value) {
        Object object = TTP_KEY;
        synchronized (object) {
            LightHashMap map = (LightHashMap)this.getUserData(TTP_KEY);
            if (map == null) {
                if (value == null) {
                    return;
                }
                map = new LightHashMap();
                map.put(key, value);
                this.setUserData(TTP_KEY, map);
            } else if (value == null) {
                map.remove(key);
                if (map.size() == 0) {
                    this.setUserData(TTP_KEY, null);
                }
            } else {
                map.put(key, value);
            }
        }
    }

    @Override
    public boolean isDataAlreadyAllocated() {
        return this.data_already_allocated;
    }

    @Override
    public void setDataAlreadyAllocated(boolean already_allocated) {
        this.data_already_allocated = already_allocated;
    }

    @Override
    public void setSeedingRank(Download.SeedingRank rank) {
        this.seedingRank = rank;
    }

    @Override
    public Download.SeedingRank getSeedingRank() {
        return this.seedingRank;
    }

    @Override
    public long getCreationTime() {
        return this.creation_time;
    }

    @Override
    public void setCreationTime(long t) {
        this.creation_time = t;
    }

    @Override
    public boolean isSwarmMerging() {
        return this.globalManager.isSwarmMerging(this);
    }

    @Override
    public String getSwarmMergingInfo() {
        return this.globalManager.getSwarmMergingInfo(this);
    }

    @Override
    public int getExtendedMessagingMode() {
        if (this.message_mode == -1) {
            byte[] hash = null;
            if (this.torrent != null) {
                try {
                    hash = this.torrent.getHash();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.message_mode = (Integer)client_id_manager.getProperty(hash, "Messaging-Mode");
        }
        return this.message_mode;
    }

    @Override
    public void setCryptoLevel(int level) {
        this.crypto_level = level;
    }

    @Override
    public int getCryptoLevel() {
        return this.crypto_level;
    }

    @Override
    public long[] getMoveProgress() {
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            return dm.getMoveProgress();
        }
        return this.move_progress;
    }

    @Override
    public String getMoveSubTask() {
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            return dm.getMoveSubTask();
        }
        return this.move_subtask;
    }

    @Override
    public void setMoveState(int state) {
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            dm.setMoveState(state);
        } else {
            this.move_state = state;
        }
    }

    @Override
    public void moveDataFiles(File new_parent_dir) throws DownloadManagerException {
        this.moveDataFiles(new_parent_dir, null);
    }

    @Override
    public void moveDataFilesLive(File new_parent_dir) throws DownloadManagerException {
        this.moveDataFiles(new_parent_dir, null, true);
    }

    @Override
    public void renameDownload(String new_name) throws DownloadManagerException {
        this.moveDataFiles(null, new_name);
    }

    @Override
    public void moveDataFiles(File destination, String new_name) throws DownloadManagerException {
        this.moveDataFiles(destination, new_name, false);
    }

    public void moveDataFiles(File destination, String new_name, boolean live) throws DownloadManagerException {
        if (destination == null && new_name == null) {
            throw new NullPointerException("destination and new name are both null");
        }
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("canMoveDataFiles is false!");
        }
        if (FileUtil.hasTask(this)) {
            throw new DownloadManagerException("Move operation already in progress");
        }
        SaveLocationChange slc = new SaveLocationChange();
        slc.download_location = destination;
        slc.download_name = new_name;
        File current_location = this.getSaveLocation();
        if (FileUtil.areFilePathsIdentical(slc.normaliseDownloadLocation(current_location), current_location)) {
            return;
        }
        Runnable target = () -> {
            try {
                if (live) {
                    this.moveDataFilesSupport0(destination, new_name);
                } else {
                    this.moveDataFilesSupport(destination, new_name);
                }
            }
            catch (DownloadManagerException e) {
                throw new RuntimeException(e);
            }
        };
        DiskManagerUtil.runMoveTask(this, destination, target, this);
    }

    void moveDataFilesSupport(File new_parent_dir, String new_filename) throws DownloadManagerException {
        boolean is_paused = this.pause(true);
        try {
            this.moveDataFilesSupport0(new_parent_dir, new_filename);
        }
        finally {
            if (is_paused) {
                this.resume();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void moveDataFilesSupport0(File new_parent_dir, String new_filename) throws DownloadManagerException {
        block20: {
            if (!this.canMoveDataFiles()) {
                throw new DownloadManagerException("canMoveDataFiles is false!");
            }
            if (new_filename != null) {
                new_filename = FileUtil.convertOSSpecificChars(new_filename, false);
            }
            File old_file = this.getSaveLocation();
            try {
                old_file = FileUtil.getCanonicalFileSafe(old_file);
                if (new_parent_dir != null) {
                    new_parent_dir = FileUtil.getCanonicalFileSafe(new_parent_dir);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new DownloadManagerException("Failed to get canonical paths", e);
            }
            File current_save_location = old_file;
            File new_save_location = FileUtil.newFile(new_parent_dir == null ? old_file.getParentFile() : new_parent_dir, new_filename == null ? old_file.getName() : new_filename);
            if (FileUtil.areFilePathsIdentical(current_save_location, new_save_location)) {
                return;
            }
            DiskManager dm = this.getDiskManager();
            if (dm == null || dm.getFiles() == null) {
                if (!old_file.exists()) {
                    FileUtil.mkdirs(new_save_location.getParentFile());
                    if (this.torrent.isSimpleTorrent()) {
                        if (!this.controller.getDiskManagerFileInfoSet().getFiles()[0].setLinkAtomic(new_save_location, false)) throw new DownloadManagerException("rename operation failed");
                        this.setTorrentSaveDir(new_save_location, true);
                        return;
                    }
                    this.setTorrentSaveDir(new_save_location, true);
                    return;
                }
                new_save_location = FileUtil.getCanonicalFileSafe(new_save_location);
                final int[] files_accepted = new int[1];
                final int[] files_skipped = new int[1];
                final int[] files_done = new int[1];
                final long[] total_size_bytes = new long[1];
                final long[] total_done_bytes = new long[1];
                FileUtil.ProgressListener pl = new FileUtil.ProgressListener(){

                    @Override
                    public void setTotalSize(long size) {
                        total_size_bytes[0] = size;
                    }

                    @Override
                    public void setCurrentFile(File file) {
                        files_done[0] = files_done[0] + 1;
                        DownloadManagerImpl.this.move_subtask = file.getName();
                    }

                    @Override
                    public void bytesDone(long num) {
                        total_done_bytes[0] = total_done_bytes[0] + num;
                        long total_size = total_size_bytes[0];
                        DownloadManagerImpl.this.move_progress = new long[]{total_size == 0L ? 0 : (int)Math.min(1000L, 1000L * total_done_bytes[0] / total_size), total_size};
                    }

                    @Override
                    public int getState() {
                        return DownloadManagerImpl.this.move_state;
                    }

                    @Override
                    public void complete() {
                        DownloadManagerImpl.this.move_progress = new long[]{1000L, total_size_bytes[0]};
                    }
                };
                String log_str = "Move inactive \"" + this.getDisplayName() + "\" from  " + current_save_location + " to " + new_save_location;
                try {
                    FileUtil.log(String.valueOf(log_str) + " starts");
                    this.move_progress = new long[2];
                    this.move_subtask = "";
                    if (FileUtil.areFilePathsIdentical(old_file, new_save_location)) break block20;
                    if (this.torrent.isSimpleTorrent()) {
                        DiskManagerFileInfo file = this.getDiskManagerFileInfoSet().getFiles()[0];
                        pl.setTotalSize(file.getFile(true).length());
                        files_accepted[0] = 1;
                        files_done[0] = 1;
                        if (!file.setLinkAtomic(new_save_location, false, pl)) throw new DownloadManagerException("Rename operation failed: " + file.getLastError());
                        this.setTorrentSaveDir(new_save_location, true);
                        break block20;
                    }
                    if (FileUtil.isAncestorOf(old_file, new_save_location)) {
                        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_file.toString(), "Target is sub-directory of files"});
                        throw new DownloadManagerException("Rename operation failed: Target is sub-directory of files");
                    }
                    long total_size = 0L;
                    final HashSet<File> files_to_move = new HashSet<File>();
                    files_to_move.add(null);
                    DiskManagerFileInfo[] info_files = this.getDiskManagerFileInfoSet().getFiles();
                    int i = 0;
                    block5: while (true) {
                        if (i >= info_files.length) {
                            FileFilter ff = new FileFilter(){

                                @Override
                                public boolean accept(File f) {
                                    boolean do_it = files_to_move.contains(f);
                                    if (f != null && f.isFile()) {
                                        if (do_it) {
                                            files_accepted[0] = files_accepted[0] + 1;
                                        } else {
                                            files_skipped[0] = files_skipped[0] + 1;
                                            FileUtil.log("File not selected for move: " + f.getAbsolutePath());
                                        }
                                    }
                                    return do_it;
                                }
                            };
                            pl.setTotalSize(total_size);
                            String result = FileUtil.renameFile(old_file, new_save_location, false, ff, pl);
                            if (result != null) {
                                if (!new_save_location.isDirectory()) throw new DownloadManagerException("Rename operation failed: " + result);
                                TorrentUtils.recursiveEmptyDirDelete(new_save_location, false);
                                throw new DownloadManagerException("Rename operation failed: " + result);
                            }
                            this.setTorrentSaveDir(new_save_location, true);
                            if (current_save_location.isDirectory()) {
                                TorrentUtils.recursiveEmptyDirDelete(current_save_location, false);
                            }
                            break block20;
                        }
                        File f = info_files[i].getFile(true);
                        total_size += f.length();
                        f = FileUtil.getCanonicalFileSafe(f);
                        boolean added_entry = files_to_move.add(f);
                        while (true) {
                            if (!added_entry) {
                                ++i;
                                continue block5;
                            }
                            f = f.getParentFile();
                            added_entry = files_to_move.add(f);
                        }
                        break;
                    }
                }
                finally {
                    pl.complete();
                    this.move_progress = null;
                    this.move_subtask = "";
                    this.move_state = 1;
                    FileUtil.log(String.valueOf(log_str) + " ends (files accepted=" + files_accepted[0] + ", skipped=" + files_skipped[0] + ", done=" + files_done[0] + "; bytes total=" + total_size_bytes[0] + ", done=" + total_done_bytes[0] + ")");
                }
            }
            dm.moveDataFiles(new_save_location.getParentFile(), new_save_location.getName());
        }
        if (!this.getAssumedComplete()) return;
        this.getDownloadState().setFlag(8L, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void copyDataFiles(File dest_parent_dir, final CoreOperationTask.ProgressCallback cb) throws DownloadManagerException {
        int n;
        if (dest_parent_dir.exists()) {
            if (!dest_parent_dir.isDirectory()) {
                throw new DownloadManagerException("'" + dest_parent_dir + "' is not a directory");
            }
        } else if (!dest_parent_dir.mkdirs()) {
            throw new DownloadManagerException("failed to create '" + dest_parent_dir + "'");
        }
        DiskManagerFileInfo[] files = this.controller.getDiskManagerFileInfoSet().getFiles();
        FileUtil.ProgressListener pl = null;
        if (cb != null) {
            long _total_size = 0L;
            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
            int n2 = files.length;
            n = 0;
            while (n < n2) {
                DiskManagerFileInfo file = diskManagerFileInfoArray[n];
                if (!file.isSkipped() && file.getDownloaded() == file.getLength()) {
                    _total_size += file.getLength();
                }
                ++n;
            }
            final long total_size = _total_size;
            cb.setSize(total_size);
            pl = new FileUtil.ProgressListener(){
                long total_done = 0L;

                @Override
                public void setTotalSize(long size) {
                }

                @Override
                public void setCurrentFile(File file) {
                    cb.setSubTaskName(file.getName());
                }

                @Override
                public void bytesDone(long num) {
                    if (total_size > 0L) {
                        this.total_done += num;
                        long prog = this.total_done * 1000L / total_size;
                        cb.setProgress((int)prog);
                    }
                }

                @Override
                public int getState() {
                    switch (cb.getTaskState()) {
                        case 1: {
                            return 2;
                        }
                        case 4: {
                            return 3;
                        }
                    }
                    return 1;
                }

                @Override
                public void complete() {
                    cb.setProgress(1000);
                }
            };
        }
        if (this.torrent.isSimpleTorrent()) {
            File file_from = files[0].getFile(true);
            try {
                File file_to = FileUtil.newFile(dest_parent_dir, file_from.getName());
                if (file_to.exists()) {
                    if (file_to.length() == file_from.length()) return;
                    throw new Exception("target file '" + file_to + " already exists");
                }
                FileUtil.copyFileWithException(file_from, file_to, pl);
                return;
            }
            catch (Throwable e) {
                throw new DownloadManagerException("copy of '" + file_from + "' failed", e);
            }
        }
        try {
            File sl_file = this.getSaveLocation();
            dest_parent_dir = FileUtil.newFile(dest_parent_dir, sl_file.getName());
            if (!dest_parent_dir.isDirectory()) {
                dest_parent_dir.mkdirs();
            }
            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
            n = files.length;
            int n3 = 0;
            while (n3 < n) {
                DiskManagerFileInfo file = diskManagerFileInfoArray[n3];
                if (!file.isSkipped() && file.getDownloaded() == file.getLength()) {
                    File file_from = file.getFile(true);
                    try {
                        String relativePath = FileUtil.getRelativePath(sl_file, file_from);
                        if (relativePath != null && !relativePath.isEmpty()) {
                            File file_to = FileUtil.newFile(dest_parent_dir, relativePath);
                            if (file_to.exists()) {
                                if (file_to.length() != file_from.length()) {
                                    throw new Exception("target file '" + file_to + " already exists");
                                }
                            } else {
                                File parent = file_to.getParentFile();
                                if (!parent.exists() && !parent.mkdirs()) {
                                    throw new Exception("Failed to make directory '" + parent + "'");
                                }
                                FileUtil.copyFileWithException(file_from, file_to, pl);
                            }
                        }
                    }
                    catch (Throwable e) {
                        throw new DownloadManagerException("copy of '" + file_from + "' failed", e);
                    }
                }
                ++n3;
            }
            return;
        }
        catch (Throwable e) {
            throw new DownloadManagerException("copy failed", e);
        }
    }

    private void copyTorrentFile(File parent_dir) throws DownloadManagerException {
        File file = FileUtil.newFile(this.getTorrentFileName(), new String[0]);
        File target = FileUtil.newFile(parent_dir, file.getName());
        if (!file.exists()) {
            TOTorrent internal_torrent = this.download_manager_state.getTorrent();
            try {
                TOTorrent clone = TorrentUtils.cloneTorrent(internal_torrent);
                clone.removeAdditionalProperties();
                TorrentUtils.writeToFile(clone, target, false);
                return;
            }
            catch (Throwable e) {
                Debug.out(e);
                throw new DownloadManagerException("Torrent file '" + file + "' doesn't exist");
            }
        }
        try {
            FileUtil.copyFileWithException(file, target, null);
        }
        catch (Throwable e) {
            throw new DownloadManagerException("Failed to copy torrent file", e);
        }
    }

    @Override
    public boolean canExportDownload() {
        return this.getAssumedComplete();
    }

    @Override
    public void exportDownload(final File parent_dir) throws DownloadManagerException {
        if (!this.canExportDownload()) {
            throw new DownloadManagerException("Not in correct state");
        }
        try {
            FileUtil.runAsTask(4, new CoreOperationTask(){
                private CoreOperationTask.ProgressCallback cb = new CoreOperationTask.ProgressCallbackAdapter(){
                    private int state = 0;

                    @Override
                    public int getSupportedTaskStates() {
                        return 15;
                    }
                };

                @Override
                public String getName() {
                    return DownloadManagerImpl.this.getDisplayName();
                }

                @Override
                public DownloadManager getDownload() {
                    return DownloadManagerImpl.this;
                }

                @Override
                public String[] getAffectedFileSystems() {
                    return FileUtil.getFileStoreNames(DownloadManagerImpl.this.getAbsoluteSaveLocation(), parent_dir);
                }

                @Override
                public void run(CoreOperation operation) {
                    try {
                        DownloadManagerImpl.this.copyDataFiles(parent_dir, this.cb);
                        DownloadManagerImpl.this.copyTorrentFile(parent_dir);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public CoreOperationTask.ProgressCallback getProgressCallback() {
                    return this.cb;
                }
            });
        }
        catch (Throwable e) {
            Throwable f = e.getCause();
            if (f instanceof DownloadManagerException) {
                throw (DownloadManagerException)f;
            }
            throw new DownloadManagerException("Export failed", e);
        }
    }

    @Override
    public void moveTorrentFile(File new_parent_dir) throws DownloadManagerException {
        this.moveTorrentFile(new_parent_dir, null);
    }

    @Override
    public void moveTorrentFile(File new_parent_dir, String new_name) throws DownloadManagerException {
        SaveLocationChange slc = new SaveLocationChange();
        slc.torrent_location = new_parent_dir;
        slc.torrent_name = new_name;
        File torrent_file_now = FileUtil.newFile(this.getTorrentFileName(), new String[0]);
        if (!slc.isDifferentTorrentLocation(torrent_file_now)) {
            return;
        }
        boolean is_paused = this.pause(true);
        try {
            this.moveTorrentFile0(new_parent_dir, new_name);
        }
        finally {
            if (is_paused) {
                this.resume();
            }
        }
    }

    private void moveTorrentFile0(File new_parent_dir, String new_name) throws DownloadManagerException {
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("Cannot move torrent file");
        }
        this.setTorrentFile(new_parent_dir, new_name);
    }

    @Override
    public void setTorrentFile(File new_parent_dir, String new_name) throws DownloadManagerException {
        File old_file = FileUtil.newFile(this.getTorrentFileName(), new String[0]);
        if (!old_file.exists()) {
            if (!this.torrentFileExplicitlyDeleted) {
                TOTorrent internal_torrent = this.download_manager_state.getTorrent();
                try {
                    TOTorrent clone = TorrentUtils.cloneTorrent(internal_torrent);
                    clone.removeAdditionalProperties();
                    TorrentUtils.writeToFile(clone, old_file, false);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (!old_file.exists()) {
                Debug.out("torrent file '" + old_file + "' doesn't exist!");
                return;
            }
        }
        if (new_parent_dir == null) {
            new_parent_dir = old_file.getParentFile();
        }
        if (new_name == null) {
            new_name = old_file.getName();
        }
        File new_file = FileUtil.newFile(new_parent_dir, new_name);
        try {
            old_file = FileUtil.getCanonicalFileSafe(old_file);
            new_file = FileUtil.getCanonicalFileSafe(new_file);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new DownloadManagerException("Failed to get canonical paths", e);
        }
        if (FileUtil.areFilePathsIdentical(new_file, old_file)) {
            return;
        }
        if (!TorrentUtils.move(old_file, new_file)) {
            throw new DownloadManagerException("rename operation failed");
        }
        this.setTorrentFileName(new_file.toString());
    }

    @Override
    public boolean isInDefaultSaveDir() {
        return DownloadManagerDefaultPaths.isInDefaultDownloadDir(this);
    }

    @Override
    public boolean seedPieceRecheck() {
        PEPeerManager pm = this.controller.getPeerManager();
        if (pm != null) {
            return pm.seedPieceRecheck();
        }
        return false;
    }

    @Override
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        this.controller.addRateLimiter(group, upload);
    }

    @Override
    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        return this.controller.getRateLimiters(upload);
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        this.controller.removeRateLimiter(group, upload);
    }

    @Override
    public boolean isTrackerError() {
        TRTrackerAnnouncerResponse resp;
        TRTrackerAnnouncer announcer = this.getTrackerClient();
        return announcer != null ? (resp = announcer.getLastResponse()) != null && resp.getStatus() == 1 : (resp = this.getTrackerScrapeResponse()) != null && resp.getStatus() == 1;
    }

    @Override
    public boolean isUnauthorisedOnTracker() {
        TRTrackerAnnouncer announcer = this.getTrackerClient();
        String status_str = null;
        if (announcer != null) {
            TRTrackerAnnouncerResponse resp = announcer.getLastResponse();
            if (resp != null && resp.getStatus() == 1) {
                status_str = resp.getStatusString();
            }
        } else {
            TRTrackerScraperResponse resp = this.getTrackerScrapeResponse();
            if (resp != null && resp.getStatus() == 1) {
                status_str = resp.getStatusString();
            }
        }
        return status_str != null && ((status_str = status_str.toLowerCase()).contains("not authorised") || status_str.contains("not authorized"));
    }

    @Override
    public List<TrackerPeerSource> getTrackerPeerSources() {
        try {
            ArrayList<TrackerPeerSource> tps;
            this.this_mon.enter();
            Object[] tps_data = (Object[])this.getUserData(TPS_Key);
            if (tps_data == null) {
                tps = new ArrayList();
                TOTorrentListener tol = new TOTorrentListener(){

                    @Override
                    public void torrentChanged(TOTorrent torrent, int type, Object data) {
                        if (type == 1) {
                            torrent.removeListener(this);
                            DownloadManagerImpl.this.informTPSChanged();
                        }
                    }
                };
                this.setUserData(TPS_Key, new Object[]{tps, tol});
                Download plugin_download = PluginCoreUtils.wrap(this);
                if (this.isDestroyed() || plugin_download == null) {
                    ArrayList<TrackerPeerSource> arrayList = tps;
                    return arrayList;
                }
                final TOTorrent t = this.getTorrent();
                if (t != null) {
                    t.addListener(tol);
                    TOTorrentAnnounceURLSet[] sets = t.getAnnounceURLGroup().getAnnounceURLSets();
                    if (sets.length == 0) {
                        sets = new TOTorrentAnnounceURLSet[]{t.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{this.torrent.getAnnounceURL()})};
                    }
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
                    int n = sets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                        final URL[] urls = set.getAnnounceURLs();
                        if (urls.length != 0 && !TorrentUtils.isDecentralised(urls[0])) {
                            tps.add(new TrackerPeerSource(){
                                private TrackerPeerSource _delegate;
                                private TRTrackerAnnouncer ta;
                                private long ta_fixup;
                                private long last_scrape_fixup_time;
                                private Object[] last_scrape;

                                private TrackerPeerSource fixup() {
                                    long now = SystemTime.getMonotonousTime();
                                    if (now - this.ta_fixup > 1000L) {
                                        TRTrackerAnnouncer current_ta = DownloadManagerImpl.this.getTrackerClient();
                                        if (current_ta == this.ta) {
                                            if (current_ta != null && this._delegate == null) {
                                                this._delegate = current_ta.getTrackerPeerSource(set);
                                            }
                                        } else {
                                            this._delegate = current_ta == null ? null : current_ta.getTrackerPeerSource(set);
                                            this.ta = current_ta;
                                        }
                                        this.ta_fixup = now;
                                    }
                                    return this._delegate;
                                }

                                protected Object[] getScrape() {
                                    long now = SystemTime.getMonotonousTime();
                                    if (now - this.last_scrape_fixup_time > 30000L || this.last_scrape == null) {
                                        TRTrackerScraper scraper = DownloadManagerImpl.this.globalManager.getTrackerScraper();
                                        int max_peers = -1;
                                        int max_seeds = -1;
                                        int max_comp = -1;
                                        int max_time = 0;
                                        int min_scrape = Integer.MAX_VALUE;
                                        String status_str = null;
                                        boolean found_usable = false;
                                        URL[] uRLArray = urls;
                                        int n = urls.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            URL u = uRLArray[n2];
                                            TRTrackerScraperResponse resp = scraper.peekScrape(DownloadManagerImpl.this.torrent, u);
                                            if (resp != null && !resp.isDHTBackup()) {
                                                found_usable = true;
                                                int peers = resp.getPeers();
                                                int seeds = resp.getSeeds();
                                                int comp2 = resp.getCompleted();
                                                if (peers > max_peers) {
                                                    max_peers = peers;
                                                }
                                                if (seeds > max_seeds) {
                                                    max_seeds = seeds;
                                                }
                                                if (comp2 > max_comp) {
                                                    max_comp = comp2;
                                                }
                                                status_str = resp.getStatusString();
                                                if (resp.getStatus() != 0) {
                                                    int ns;
                                                    long next_scrape;
                                                    int time = resp.getScrapeTime();
                                                    if (time > max_time) {
                                                        max_time = time;
                                                    }
                                                    if ((next_scrape = resp.getNextScrapeStartTime()) > 0L && (ns = (int)(next_scrape / 1000L)) < min_scrape) {
                                                        min_scrape = ns;
                                                    }
                                                }
                                            }
                                            ++n2;
                                        }
                                        if (found_usable || this.last_scrape == null) {
                                            this.last_scrape = new Object[]{max_seeds, max_peers, max_time, min_scrape, max_comp, status_str};
                                        }
                                        this.last_scrape_fixup_time = now;
                                    }
                                    return this.last_scrape;
                                }

                                @Override
                                public int getType() {
                                    return 1;
                                }

                                @Override
                                public String getName() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return urls[0].toExternalForm();
                                    }
                                    return delegate.getName();
                                }

                                @Override
                                public URL getURL() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return urls[0];
                                    }
                                    return delegate.getURL();
                                }

                                @Override
                                public int getStatus() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return 2;
                                    }
                                    return delegate.getStatus();
                                }

                                @Override
                                public String getStatusString() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return (String)this.getScrape()[5];
                                    }
                                    return delegate.getStatusString();
                                }

                                @Override
                                public int getSeedCount() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return (Integer)this.getScrape()[0];
                                    }
                                    int seeds = delegate.getSeedCount();
                                    if (seeds < 0) {
                                        seeds = (Integer)this.getScrape()[0];
                                    }
                                    return seeds;
                                }

                                @Override
                                public int getLeecherCount() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return (Integer)this.getScrape()[1];
                                    }
                                    int leechers = delegate.getLeecherCount();
                                    if (leechers < 0) {
                                        leechers = (Integer)this.getScrape()[1];
                                    }
                                    return leechers;
                                }

                                @Override
                                public int getCompletedCount() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return (Integer)this.getScrape()[4];
                                    }
                                    int comp2 = delegate.getCompletedCount();
                                    if (comp2 < 0) {
                                        comp2 = (Integer)this.getScrape()[4];
                                    }
                                    return comp2;
                                }

                                @Override
                                public int getPeers() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return -1;
                                    }
                                    return delegate.getPeers();
                                }

                                @Override
                                public int getInterval() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        Object[] si = this.getScrape();
                                        int last = (Integer)si[2];
                                        int next = (Integer)si[3];
                                        if (last > 0 && next < Integer.MAX_VALUE && last < next) {
                                            return next - last;
                                        }
                                        return -1;
                                    }
                                    return delegate.getInterval();
                                }

                                @Override
                                public int getMinInterval() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return -1;
                                    }
                                    return delegate.getMinInterval();
                                }

                                @Override
                                public boolean isUpdating() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return false;
                                    }
                                    return delegate.isUpdating();
                                }

                                @Override
                                public int getLastUpdate() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return (Integer)this.getScrape()[2];
                                    }
                                    return delegate.getLastUpdate();
                                }

                                @Override
                                public int getSecondsToUpdate() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        int next = (Integer)this.getScrape()[3];
                                        if (next < Integer.MAX_VALUE) {
                                            return (int)((long)next - SystemTime.getCurrentTime() / 1000L);
                                        }
                                        return Integer.MIN_VALUE;
                                    }
                                    return delegate.getSecondsToUpdate();
                                }

                                @Override
                                public boolean canManuallyUpdate() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate == null) {
                                        return false;
                                    }
                                    return delegate.canManuallyUpdate();
                                }

                                @Override
                                public void manualUpdate() {
                                    TrackerPeerSource delegate = this.fixup();
                                    if (delegate != null) {
                                        delegate.manualUpdate();
                                    }
                                }

                                @Override
                                public long[] getReportedStats() {
                                    TrackerPeerSource delegate = this.fixup();
                                    URL url = this.getURL();
                                    long[] url_stats = DownloadManagerImpl.this.stats.getTrackerReportedStats(url);
                                    long session_up = 0L;
                                    long session_down = 0L;
                                    if (delegate != null) {
                                        long[] session = delegate.getReportedStats();
                                        if (session == null) {
                                            return null;
                                        }
                                        session_up = session[0];
                                        session_down = session[1];
                                    }
                                    return new long[]{url_stats[0], url_stats[1], url_stats[2], url_stats[3], session_up, session_down};
                                }

                                @Override
                                public String getDetails() {
                                    Map map;
                                    Object[] entry;
                                    URL url = this.getURL();
                                    String key = all_trackers.ingestURL(url);
                                    if (DownloadManagerImpl.this.torrent.getAnnounceURLGroup().getUID() != DownloadManagerImpl.this.url_group_map_uid) {
                                        DownloadManagerImpl.this.buildURLGroupMap(DownloadManagerImpl.this.torrent);
                                    }
                                    if ((entry = (Object[])(map = DownloadManagerImpl.this.url_group_map).get(key)) != null) {
                                        String str = MessageText.getString("wizard.multitracker.group");
                                        long total_sent = 0L;
                                        long total_received = 0L;
                                        String sent_str = MessageText.getString("DHTView.transport.sent");
                                        String recv_str = MessageText.getString("DHTView.transport.received");
                                        for (Map.Entry e : map.entrySet()) {
                                            Object[] temp = (Object[])e.getValue();
                                            if (temp[1] != entry[1]) continue;
                                            URL u = (URL)temp[0];
                                            long[] url_stats = DownloadManagerImpl.this.stats.getTrackerReportedStats(u);
                                            long sent = url_stats[2];
                                            long received = url_stats[3];
                                            total_sent += sent;
                                            total_received += received;
                                            str = String.valueOf(str) + "\n\t" + u + ": " + sent_str + "=" + DisplayFormatters.formatByteCountToKiBEtc(sent) + ", " + recv_str + "=" + DisplayFormatters.formatByteCountToKiBEtc(received);
                                        }
                                        str = String.valueOf(str) + "\n\t" + MessageText.getString("SpeedView.stats.total") + ": " + sent_str + "=" + DisplayFormatters.formatByteCountToKiBEtc(total_sent) + ", " + recv_str + "=" + DisplayFormatters.formatByteCountToKiBEtc(total_received);
                                        return str;
                                    }
                                    return null;
                                }

                                @Override
                                public boolean canDelete() {
                                    return true;
                                }

                                @Override
                                public void delete() {
                                    List<List<String>> lists = TorrentUtils.announceGroupsToList(t);
                                    ArrayList<String> rem = new ArrayList<String>();
                                    URL[] uRLArray = urls;
                                    int n = urls.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        URL u = uRLArray[n2];
                                        rem.add(u.toExternalForm());
                                        ++n2;
                                    }
                                    lists = TorrentUtils.removeAnnounceURLs2(lists, rem, false);
                                    TorrentUtils.listToAnnounceGroups(lists, t);
                                }
                            });
                        }
                        ++n2;
                    }
                    tps.add(new TrackerPeerSourceAdapter(){
                        private TrackerPeerSource _delegate;
                        private TRTrackerAnnouncer ta;
                        private boolean enabled;
                        private long ta_fixup;

                        private TrackerPeerSource fixup() {
                            long now = SystemTime.getMonotonousTime();
                            if (now - this.ta_fixup > 1000L) {
                                TRTrackerAnnouncer current_ta = DownloadManagerImpl.this.getTrackerClient();
                                if (current_ta == this.ta) {
                                    if (current_ta != null && this._delegate == null) {
                                        this._delegate = current_ta.getCacheTrackerPeerSource();
                                    }
                                } else {
                                    this._delegate = current_ta == null ? null : current_ta.getCacheTrackerPeerSource();
                                    this.ta = current_ta;
                                }
                                this.enabled = DownloadManagerImpl.this.controller.isPeerSourceEnabled("Tracker");
                                this.ta_fixup = now;
                            }
                            return this._delegate;
                        }

                        @Override
                        public int getType() {
                            return 1;
                        }

                        @Override
                        public String getName() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return MessageText.getString("tps.tracker.cache");
                            }
                            return delegate.getName();
                        }

                        @Override
                        public URL getURL() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return null;
                            }
                            return delegate.getURL();
                        }

                        @Override
                        public int getStatus() {
                            TrackerPeerSource delegate = this.fixup();
                            if (!this.enabled) {
                                return 1;
                            }
                            if (delegate == null) {
                                return 2;
                            }
                            return 5;
                        }

                        @Override
                        public int getPeers() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null || !this.enabled) {
                                return -1;
                            }
                            return delegate.getPeers();
                        }
                    });
                }
                try {
                    ExternalSeedPlugin esp = DownloadManagerController.getExternalSeedPlugin();
                    if (esp != null) {
                        tps.add(esp.getTrackerPeerSource(plugin_download));
                    }
                }
                catch (Throwable esp) {
                    // empty catch block
                }
                try {
                    PluginInterface dht_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class);
                    if (dht_pi != null) {
                        tps.add(((DHTTrackerPlugin)dht_pi.getPlugin()).getTrackerPeerSource(plugin_download));
                    }
                }
                catch (Throwable dht_pi) {
                    // empty catch block
                }
                try {
                    PluginInterface lt_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(LocalTrackerPlugin.class);
                    if (lt_pi != null) {
                        tps.add(((LocalTrackerPlugin)lt_pi.getPlugin()).getTrackerPeerSource(plugin_download));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    tps.addAll(Arrays.asList(((DownloadImpl)plugin_download).getTrackerPeerSources()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                tps.add(new TrackerPeerSourceAdapter(){
                    private PEPeerManager _pm;
                    private TrackerPeerSource _delegate;

                    private TrackerPeerSource fixup() {
                        PEPeerManager pm = DownloadManagerImpl.this.getPeerManager();
                        if (pm == null) {
                            this._delegate = null;
                            this._pm = null;
                        } else if (pm != this._pm) {
                            this._pm = pm;
                            this._delegate = pm.getTrackerPeerSource();
                        }
                        return this._delegate;
                    }

                    @Override
                    public int getType() {
                        return 5;
                    }

                    @Override
                    public int getStatus() {
                        TrackerPeerSource delegate = this.fixup();
                        if (delegate == null) {
                            return 2;
                        }
                        return delegate.getStatus();
                    }

                    @Override
                    public String getName() {
                        TrackerPeerSource delegate = this.fixup();
                        if (delegate == null) {
                            return "";
                        }
                        return delegate.getName();
                    }

                    @Override
                    public String getStatusString() {
                        if (this.getStatus() == 1) {
                            try {
                                if (DownloadManagerImpl.this.torrent.getPrivate()) {
                                    return MessageText.getString("label.private");
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return null;
                    }

                    @Override
                    public int getPeers() {
                        TrackerPeerSource delegate = this.fixup();
                        if (delegate == null) {
                            return -1;
                        }
                        return delegate.getPeers();
                    }
                });
                tps.add(new TrackerPeerSourceAdapter(){
                    private long fixup_time;
                    private PEPeerManager _pm;
                    private int tcp;
                    private int udp;
                    private int utp;
                    private int total;
                    private boolean enabled;

                    private PEPeerManager fixup() {
                        long now = SystemTime.getMonotonousTime();
                        if (now - this.fixup_time > 1000L) {
                            this._pm = DownloadManagerImpl.this.getPeerManager();
                            PEPeerManager pm = this._pm;
                            if (pm != null) {
                                this.tcp = pm.getNbRemoteTCPConnections();
                                this.udp = pm.getNbRemoteUDPConnections();
                                this.utp = pm.getNbRemoteUTPConnections();
                                this.total = pm.getStats().getTotalIncomingConnections();
                            }
                            this.enabled = DownloadManagerImpl.this.controller.isPeerSourceEnabled("Incoming");
                            this.fixup_time = now;
                        }
                        return this._pm;
                    }

                    @Override
                    public int getType() {
                        return 6;
                    }

                    @Override
                    public int getStatus() {
                        if (!this.enabled) {
                            return 1;
                        }
                        PEPeerManager delegate = this.fixup();
                        if (delegate == null) {
                            if (DownloadManagerImpl.this._tracker_client_for_queued_download == null) {
                                return 2;
                            }
                            return 5;
                        }
                        return 5;
                    }

                    @Override
                    public String getName() {
                        PEPeerManager delegate = this.fixup();
                        if (delegate == null || !this.enabled) {
                            return "";
                        }
                        return MessageText.getString("tps.incoming.details", new String[]{String.valueOf(this.tcp), String.valueOf(this.udp + this.utp), String.valueOf(this.total)});
                    }

                    @Override
                    public int getPeers() {
                        PEPeerManager delegate = this.fixup();
                        if (delegate == null || !this.enabled) {
                            return -1;
                        }
                        return this.tcp + this.udp;
                    }
                });
            } else {
                tps = (List)tps_data[0];
            }
            ArrayList<TrackerPeerSource> arrayList = tps;
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addTPSListener(DownloadManagerTPSListener listener) {
        try {
            this.this_mon.enter();
            if (this.tps_listeners == null) {
                this.tps_listeners = new ArrayList<DownloadManagerTPSListener>(1);
            }
            this.tps_listeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeTPSListener(DownloadManagerTPSListener listener) {
        try {
            this.this_mon.enter();
            if (this.tps_listeners != null) {
                this.tps_listeners.remove(listener);
                if (this.tps_listeners.size() == 0) {
                    this.tps_listeners = null;
                    Object[] tps_data = (Object[])this.getUserData(TPS_Key);
                    if (tps_data != null) {
                        TOTorrent t = this.getTorrent();
                        if (t != null) {
                            t.removeListener((TOTorrentListener)tps_data[1]);
                        }
                        this.setUserData(TPS_Key, null);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void informTPSChanged() {
        ArrayList<DownloadManagerTPSListener> to_inform = null;
        try {
            this.this_mon.enter();
            this.setUserData(TPS_Key, null);
            if (this.tps_listeners != null) {
                to_inform = new ArrayList<DownloadManagerTPSListener>(this.tps_listeners);
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (to_inform != null) {
            for (DownloadManagerTPSListener l : to_inform) {
                try {
                    l.trackerPeerSourcesChanged();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    private byte[] getIdentity() {
        return this.dl_identity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DownloadManagerImpl) {
            DownloadManagerImpl other = (DownloadManagerImpl)obj;
            byte[] id1 = this.getIdentity();
            byte[] id2 = other.getIdentity();
            if (id1 == null || id2 == null) {
                return false;
            }
            return Arrays.equals(id1, id2);
        }
        return false;
    }

    public int hashCode() {
        return this.dl_identity_hashcode;
    }

    @Override
    public String getRelationText() {
        return "Download: '" + this.getDisplayName() + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.getTrackerClient()};
    }

    public String toString() {
        String status;
        String hash = "<unknown>";
        if (this.torrent != null) {
            try {
                hash = ByteFormatter.encodeString(this.torrent.getHash());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((status = DisplayFormatters.formatDownloadStatus(this)).length() > 10) {
            status = status.substring(0, 10);
        }
        return "DownloadManagerImpl#" + this.getPosition() + (this.getAssumedComplete() ? "s" : "d") + "@" + Integer.toHexString(this.hashCode()) + "/" + status + "/" + hash;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println(this.toString());
        PEPeerManager pm = this.getPeerManager();
        try {
            TRTrackerScraperResponse scrape;
            writer.indent();
            writer.println("Save Dir: " + Debug.secretFileName(this.getSaveLocation().toString()));
            if (this.current_peers.size() > 0) {
                writer.println("# Peers: " + this.current_peers.size());
            }
            if (this.current_pieces.size() > 0) {
                writer.println("# Pieces: " + this.current_pieces.size());
            }
            writer.println("Listeners: DownloadManager=" + this.listeners.size() + "; Disk=" + this.controller.getDiskListenerCount() + "; Peer=" + this.peer_listeners.size() + "; Tracker=" + this.tracker_listeners.size());
            writer.println("SR: " + this.seedingRank.getRank());
            String sFlags = "";
            if (this.open_for_seeding) {
                sFlags = String.valueOf(sFlags) + "Opened for Seeding; ";
            }
            if (this.data_already_allocated) {
                sFlags = String.valueOf(sFlags) + "Data Already Allocated; ";
            }
            if (this.assumedComplete) {
                sFlags = String.valueOf(sFlags) + "onlySeeding; ";
            }
            if (this.persistent) {
                sFlags = String.valueOf(sFlags) + "persistent; ";
            }
            if (sFlags.length() > 0) {
                writer.println("Flags: " + sFlags);
            }
            this.stats.generateEvidence(writer);
            this.download_manager_state.generateEvidence(writer);
            if (pm != null) {
                pm.generateEvidence(writer);
            }
            this.controller.generateEvidence(writer);
            TRTrackerAnnouncer announcer = this.getTrackerClient();
            if (announcer != null) {
                announcer.generateEvidence(writer);
            }
            if ((scrape = this.getTrackerScrapeResponse()) == null) {
                writer.println("Scrape: null");
            } else {
                writer.println("Scrape: " + scrape.getString());
            }
        }
        finally {
            writer.exdent();
        }
    }

    @Override
    public void destroy(boolean is_duplicate) {
        this.destroyed = true;
        if (is_duplicate) {
            this.controller.destroy();
        } else {
            try {
                if (!this.getSaveLocation().exists()) {
                    return;
                }
                DiskManager dm = this.getDiskManager();
                if (dm != null) {
                    dm.downloadRemoved();
                    return;
                }
                SaveLocationChange move_details = DownloadManagerMoveHandler.onRemoval(this);
                if (move_details == null) {
                    return;
                }
                boolean can_move_torrent = move_details.hasTorrentChange();
                try {
                    if (move_details.hasDownloadChange()) {
                        this.moveDataFiles(move_details.download_location, move_details.download_name);
                    }
                }
                catch (Exception e) {
                    can_move_torrent = false;
                    Logger.log(new LogAlert((Object)this, true, "Problem moving files to removed download directory", (Throwable)e));
                }
                if (can_move_torrent) {
                    try {
                        this.moveTorrentFile(move_details.torrent_location, move_details.torrent_name);
                    }
                    catch (Exception e) {
                        Logger.log(new LogAlert((Object)this, true, "Problem moving torrent to removed download directory", (Throwable)e));
                    }
                }
            }
            finally {
                this.clearFileLinks();
                this.controller.destroy();
                if (this.torrent != null) {
                    all_trackers.unregisterTorrent(this.torrent);
                }
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed || this.removing;
    }

    @Override
    public int[] getStorageType(DiskManagerFileInfo[] info) {
        String[] types = DiskManagerImpl.getStorageTypes(this);
        int[] result = new int[info.length];
        int i = 0;
        while (i < info.length) {
            result[i] = DiskManagerUtil.convertDMStorageTypeFromString(types[info[i].getIndex()]);
            ++i;
        }
        return result;
    }

    @Override
    public boolean canMoveDataFiles() {
        return this.isPersistent();
    }

    @Override
    public void rename(String name) throws DownloadManagerException {
        boolean paused = this.pause(true);
        try {
            this.renameDownload(name);
            this.getDownloadState().setAttribute("displayname", name);
            this.renameTorrentSafe(name);
        }
        finally {
            if (paused) {
                this.resume();
            }
        }
    }

    @Override
    public void renameTorrent(String name) throws DownloadManagerException {
        this.moveTorrentFile(null, name);
    }

    @Override
    public void renameTorrentSafe(String name) throws DownloadManagerException {
        String torrent_parent = FileUtil.newFile(this.getTorrentFileName(), new String[0]).getParent();
        String torrent_name = name;
        File new_path = FileUtil.newFile(torrent_parent, String.valueOf(torrent_name) + ".torrent");
        if (FileUtil.reallyExists(new_path)) {
            new_path = null;
        }
        int i = 1;
        while (i < 10) {
            if (new_path != null) break;
            new_path = FileUtil.newFile(torrent_parent, String.valueOf(torrent_name) + "(" + i + ").torrent");
            if (FileUtil.reallyExists(new_path)) {
                new_path = null;
            }
            ++i;
        }
        if (new_path == null) {
            throw new DownloadManagerException("cannot rename torrent file - file already exists");
        }
        this.renameTorrent(new_path.getName());
    }

    @Override
    public void requestAttention() {
        this.fireGlobalManagerEvent(1);
    }

    @Override
    public void fireGlobalManagerEvent(int eventType, Object eventData) {
        this.globalManager.fireGlobalManagerEvent(eventType, this, eventData);
    }

    @Override
    public void setFilePriorities(DiskManagerFileInfo[] fileInfos, int priority) {
        DiskManagerFileInfo[] diskManagerFileInfoArray = fileInfos;
        int n = fileInfos.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo fileInfo2 = diskManagerFileInfoArray[n2];
            fileInfo2.setPriority(priority);
            ++n2;
        }
    }

    protected static class NoStackException
    extends Exception {
        private final int error;

        protected NoStackException(int _error, String str) {
            super(str);
            this.error = _error;
        }

        protected int getError() {
            return this.error;
        }
    }
}

