/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.impl.DownloadManagerImpl;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerStats;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerRequest;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadManagerStatsImpl
implements DownloadManagerStats {
    private static final AllTrackersManager.AllTrackers all_trackers = AllTrackersManager.getAllTrackers();
    static int share_ratio_progress_interval;
    private final DownloadManagerImpl download_manager;
    private int completed;
    private long saved_data_bytes_downloaded;
    private long saved_protocol_bytes_downloaded;
    private long saved_data_bytes_uploaded;
    private long saved_protocol_bytes_uploaded;
    private long session_start_data_bytes_downloaded;
    private long session_start_data_bytes_uploaded;
    private long saved_discarded = 0L;
    private long saved_hashfails = 0L;
    private long saved_SecondsDownloading = 0L;
    private long saved_SecondsOnlySeeding = 0L;
    private int session_SecondsSinceDownload = -1;
    private int session_SecondsSinceUpload = -1;
    private int saved_SecondsSinceDownload = 0;
    private int saved_SecondsSinceUpload = 0;
    private long saved_peak_receive_rate = 0L;
    private long saved_peak_send_rate = 0L;
    private long saved_skipped_file_set_size = -1L;
    private long saved_skipped_but_downloaded;
    private long saved_completed_download_bytes = -1L;
    private int max_upload_rate_bps = 0;
    private int max_download_rate_bps = 0;
    private static final int HISTORY_MAX_SECS = 1800;
    private volatile boolean history_retention_required;
    private int history_last_tick = -1;
    private long[][] history;
    private int history_pos;
    private boolean history_wrapped;
    private int last_sr_progress = -1;
    private int[] file_priority_stats = new int[4];
    private static final int HISTORY_RATE_DIV = 64;
    private static final int HISTORY_TIME_DIV = 1;
    Map<String, Map<Long, long[]>> tracker_session_stats = new HashMap<String, Map<Long, long[]>>();
    FrequencyLimitedDispatcher stats_saver = new FrequencyLimitedDispatcher(AERunnable.create(() -> this.saveTrackerStats()), 1000);

    static {
        COConfigurationManager.addAndFireParameterListener("Share Ratio Progress Interval", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                share_ratio_progress_interval = COConfigurationManager.getIntParameter(name);
            }
        });
    }

    protected DownloadManagerStatsImpl(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    @Override
    public long getDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDataReceiveRate();
        }
        return 0L;
    }

    @Override
    public long getProtocolReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getProtocolReceiveRate();
        }
        return 0L;
    }

    @Override
    public long getDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDataSendRate();
        }
        return 0L;
    }

    @Override
    public long getProtocolSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getProtocolSendRate();
        }
        return 0L;
    }

    @Override
    public long getPeakDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        long result = this.saved_peak_receive_rate;
        if (pm != null) {
            result = Math.max(result, pm.getStats().getPeakDataReceiveRate());
        }
        return result;
    }

    @Override
    public long getPeakDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        long result = this.saved_peak_send_rate;
        if (pm != null) {
            result = Math.max(result, pm.getStats().getPeakDataSendRate());
        }
        return result;
    }

    @Override
    public long getSmoothedDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getSmoothedDataReceiveRate();
        }
        return 0L;
    }

    @Override
    public long getSmoothedDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getSmoothedDataSendRate();
        }
        return 0L;
    }

    @Override
    public long getETA() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getETA(false);
        }
        return -1L;
    }

    @Override
    public long getSmoothedETA() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getETA(true);
        }
        return -1L;
    }

    @Override
    public int getCompleted() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            int state = this.download_manager.getState();
            if (state == 20 || state == 30 || state == 5) {
                return this.completed;
            }
            return this.getDownloadCompleted(true);
        }
        if (dm.getState() == 2 || dm.getState() == 3 || dm.getState() == 1) {
            return dm.getPercentDone();
        }
        return this.getDownloadCompleted(true);
    }

    @Override
    public void setCompleted(int _completed) {
        this.completed = _completed;
    }

    @Override
    public int getDownloadCompleted(boolean bLive) {
        DiskManager dm;
        if (bLive && (dm = this.download_manager.getDiskManager()) != null) {
            int computed_completion;
            int state = dm.getState();
            boolean transient_state = state == 1 || state == 2 || state == 3;
            long total = dm.getTotalLength();
            long completed_download_bytes = total - dm.getRemaining();
            int n = computed_completion = total == 0L ? 0 : (int)(1000L * completed_download_bytes / total);
            if (!transient_state) {
                this.saved_completed_download_bytes = completed_download_bytes;
            }
            return computed_completion;
        }
        long total = this.download_manager.getSize();
        int computed_completion = total == 0L ? 0 : (int)(1000L * this.getDownloadCompletedBytes() / total);
        return computed_completion;
    }

    @Override
    public void setDownloadCompletedBytes(long completedBytes) {
        this.saved_completed_download_bytes = completedBytes;
    }

    @Override
    public void recalcDownloadCompleteBytes() {
        DiskManager dm = this.getDiskManagerIfNotTransient();
        if (dm != null) {
            long total = dm.getTotalLength();
            this.saved_completed_download_bytes = total - dm.getRemaining();
        }
        if (this.saved_completed_download_bytes < 0L) {
            DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfoSet().getFiles();
            long total_size = 0L;
            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                total_size += file.getDownloaded();
                ++n2;
            }
            this.saved_completed_download_bytes = total_size;
        }
    }

    @Override
    public long getDownloadCompletedBytes() {
        this.recalcDownloadCompleteBytes();
        return this.saved_completed_download_bytes;
    }

    @Override
    public String getElapsedTime() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getElapsedTime();
        }
        return "";
    }

    @Override
    public long getTimeStarted() {
        return this.getTimeStarted(false);
    }

    private long getTimeStarted(boolean mono) {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStarted(mono);
        }
        return -1L;
    }

    @Override
    public long getTimeStartedSeeding() {
        return this.getTimeStartedSeeding(false);
    }

    private long getTimeStartedSeeding(boolean mono) {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStartedSeeding(mono);
        }
        return -1L;
    }

    @Override
    public long getTotalDataBytesReceived() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_data_bytes_downloaded + pm.getStats().getTotalDataBytesReceived();
        }
        return this.saved_data_bytes_downloaded;
    }

    @Override
    public long getSessionDataBytesReceived() {
        long total = this.getTotalDataBytesReceived();
        long res = total - this.session_start_data_bytes_downloaded;
        if (res < 0L) {
            this.session_start_data_bytes_downloaded = total;
            res = 0L;
        }
        return res;
    }

    @Override
    public long getTotalGoodDataBytesReceived() {
        long downloaded = this.getTotalDataBytesReceived();
        if ((downloaded -= this.getHashFailBytes() + this.getDiscarded()) < 0L) {
            downloaded = 0L;
        }
        return downloaded;
    }

    @Override
    public long getTotalProtocolBytesReceived() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_protocol_bytes_downloaded + pm.getStats().getTotalProtocolBytesReceived();
        }
        return this.saved_protocol_bytes_downloaded;
    }

    @Override
    public void resetTotalBytesSentReceived(long new_sent, long new_received) {
        boolean running = this.download_manager.getPeerManager() != null;
        boolean forced = false;
        if (running) {
            forced = this.download_manager.isForceStart();
            this.download_manager.stopIt(70, false, false);
        }
        if (new_sent >= 0L) {
            this.saved_data_bytes_uploaded = new_sent;
            this.session_start_data_bytes_uploaded = new_sent;
            this.saved_protocol_bytes_uploaded = 0L;
        }
        if (new_received >= 0L) {
            this.saved_data_bytes_downloaded = new_received;
            this.session_start_data_bytes_downloaded = new_received;
            this.saved_protocol_bytes_downloaded = 0L;
        }
        this.saved_discarded = 0L;
        this.saved_hashfails = 0L;
        if (running) {
            this.download_manager.setStateWaiting();
            if (forced) {
                this.download_manager.setForceStart(true);
            }
        }
    }

    @Override
    public long getTotalDataBytesSent() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_data_bytes_uploaded + pm.getStats().getTotalDataBytesSent();
        }
        return this.saved_data_bytes_uploaded;
    }

    @Override
    public long getTotalProtocolBytesSent() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_protocol_bytes_uploaded + pm.getStats().getTotalProtocolBytesSent();
        }
        return this.saved_protocol_bytes_uploaded;
    }

    @Override
    public long getSessionDataBytesSent() {
        long total = this.getTotalDataBytesSent();
        long res = total - this.session_start_data_bytes_uploaded;
        if (res < 0L) {
            this.session_start_data_bytes_uploaded = total;
            res = 0L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecentHistoryRetention(boolean required) {
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (required) {
                if (!this.history_retention_required) {
                    this.history = new long[1800][2];
                    this.history_pos = 0;
                    this.history_retention_required = true;
                }
            } else {
                this.history = null;
                this.history_retention_required = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] getRecentHistory() {
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (this.history == null) {
                return new int[4][0];
            }
            int ticks = SimpleTimer.getTickCount();
            if (ticks != this.history_last_tick) {
                this.timerTick(ticks);
            }
            int entries = this.history_wrapped ? 1800 : this.history_pos;
            int start = this.history_wrapped ? this.history_pos : 0;
            int[][] result = new int[4][entries];
            int pos = start;
            int i = 0;
            while (i < entries) {
                if (pos == 1800) {
                    pos = 0;
                }
                long entry1 = this.history[pos][0];
                long entry2 = this.history[pos++][1];
                int send_rate = (int)(entry1 >> 42 & 0x1FFFFFL);
                int recv_rate = (int)(entry1 >> 21 & 0x1FFFFFL);
                int swarm_rate = (int)(entry1 & 0x1FFFFFL);
                int eta = (int)(entry2 & Integer.MAX_VALUE);
                result[0][i] = send_rate * 64;
                result[1][i] = recv_rate * 64;
                result[2][i] = swarm_rate * 64;
                result[3][i] = eta * 1;
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShareRatioProgress() {
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (this.last_sr_progress == -1) {
                long temp = this.download_manager.getDownloadState().getLongAttribute("sr.prog");
                this.last_sr_progress = (int)temp;
            }
            if (share_ratio_progress_interval <= 0) {
                if (this.last_sr_progress != 0) {
                    this.last_sr_progress = 0;
                    this.download_manager.getDownloadState().setLongAttribute("sr.prog", 0L);
                }
            } else {
                int current_sr = this.getShareRatio();
                if ((current_sr = current_sr / share_ratio_progress_interval * share_ratio_progress_interval) != this.last_sr_progress) {
                    this.last_sr_progress = current_sr;
                    long data = (SystemTime.getCurrentTime() / 1000L << 32) + (long)this.last_sr_progress;
                    this.download_manager.getDownloadState().setLongAttribute("sr.prog", data);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerTick(int tick_count) {
        long entry2;
        long entry1;
        if (tick_count % 15 == 0) {
            this.checkShareRatioProgress();
        }
        if (!this.history_retention_required) {
            return;
        }
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            PEPeerManagerStats stats2 = pm.getStats();
            long send_rate = stats2.getDataSendRate() + stats2.getProtocolSendRate();
            long receive_rate = stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate();
            long peer_swarm_average = this.getTotalAveragePerPeer();
            long eta = Math.max(this.getETA(), 0L);
            entry1 = (send_rate - 1L + 32L) / 64L << 42 & 0x7FFFFC0000000000L | (receive_rate - 1L + 32L) / 64L << 21 & 0x3FFFFE00000L | (peer_swarm_average - 1L + 32L) / 64L & 0x1FFFFFL;
            entry2 = eta & Integer.MAX_VALUE;
        } else {
            entry1 = 0L;
            entry2 = 0L;
        }
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (this.history != null) {
                int missed;
                if (this.history_last_tick == tick_count) {
                    return;
                }
                if (this.history_last_tick != -1 && (missed = tick_count - this.history_last_tick - 1) > 0) {
                    missed = Math.min(missed, 1800);
                    while (missed > 0) {
                        this.history[this.history_pos][0] = 0L;
                        this.history[this.history_pos++][1] = 0L;
                        if (this.history_pos == 1800) {
                            this.history_pos = 0;
                            this.history_wrapped = true;
                        }
                        --missed;
                    }
                }
                this.history_last_tick = tick_count;
                this.history[this.history_pos][0] = entry1;
                this.history[this.history_pos++][1] = entry2;
                if (this.history_pos == 1800) {
                    this.history_pos = 0;
                    this.history_wrapped = true;
                }
            }
        }
    }

    @Override
    public long getRemaining() {
        DiskManager disk_manager = this.getDiskManagerIfNotTransient();
        if (disk_manager == null) {
            long size = this.download_manager.getSize();
            return size - this.getDownloadCompletedBytes();
        }
        return disk_manager.getRemaining();
    }

    private DiskManager getDiskManagerIfNotTransient() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            return null;
        }
        int state = dm.getState();
        boolean transient_state = state == 1 || state == 2 || state == 3;
        return transient_state ? null : dm;
    }

    @Override
    public long getDiscarded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_discarded + pm.getStats().getTotalDiscarded();
        }
        return this.saved_discarded;
    }

    @Override
    public long getHashFailCount() {
        TOTorrent t = this.download_manager.getTorrent();
        if (t == null) {
            return 0L;
        }
        long total = this.getHashFailBytes();
        long res = total / t.getPieceLength();
        if (res == 0L && total > 0L) {
            res = 1L;
        }
        return res;
    }

    @Override
    public long getHashFailBytes() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_hashfails + pm.getStats().getTotalHashFailBytes();
        }
        return this.saved_hashfails;
    }

    @Override
    public long getTotalAverage() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getTotalAverage();
        }
        return 0L;
    }

    @Override
    public long getTotalAveragePerPeer() {
        int div = this.download_manager.getNbPeers() + (this.download_manager.isDownloadComplete(false) ? 0 : 1);
        long average = div < 1 ? 0L : this.getTotalAverage() / (long)div;
        return average;
    }

    @Override
    public int getShareRatio() {
        long downloaded = this.getTotalGoodDataBytesReceived();
        long uploaded = this.getTotalDataBytesSent();
        if (downloaded <= 0L) {
            return -1;
        }
        long ratio = 1000L * uploaded / downloaded;
        if (ratio > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)ratio;
    }

    @Override
    public void setShareRatio(int ratio) {
        if (ratio < 0) {
            ratio = 0;
        }
        if (ratio > 1000000) {
            ratio = 1000000;
        }
        DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfoSet().getFiles();
        long total_size = 0L;
        DiskManagerFileInfo[] diskManagerFileInfoArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
            if (!file.isSkipped()) {
                total_size += file.getLength();
            }
            ++n2;
        }
        if (total_size == 0L) {
            return;
        }
        this.saved_hashfails = 0L;
        this.saved_discarded = 0L;
        this.saved_data_bytes_downloaded = 0L;
        this.saved_data_bytes_uploaded = 0L;
        long downloaded = this.getTotalGoodDataBytesReceived();
        long uploaded = this.getTotalDataBytesSent();
        long target_downloaded = total_size;
        long target_uploaded = ((long)ratio * total_size + 999L) / 1000L;
        this.saved_data_bytes_downloaded = target_downloaded - downloaded;
        this.saved_data_bytes_uploaded = target_uploaded - uploaded;
        if (this.download_manager.getPeerManager() == null) {
            this.saveSessionTotals();
        }
    }

    @Override
    public long getSecondsDownloading() {
        long lTimeStartedDL = this.getTimeStarted(true);
        if (lTimeStartedDL >= 0L) {
            long lTimeEndedDL = this.getTimeStartedSeeding(true);
            if (lTimeEndedDL == -1L) {
                lTimeEndedDL = SystemTime.getMonotonousTime();
            }
            if (lTimeEndedDL > lTimeStartedDL) {
                return this.saved_SecondsDownloading + (lTimeEndedDL - lTimeStartedDL) / 1000L;
            }
        }
        return this.saved_SecondsDownloading;
    }

    @Override
    public long getSecondsOnlySeeding() {
        long lTimeStarted = this.getTimeStartedSeeding(true);
        if (lTimeStarted >= 0L) {
            return this.saved_SecondsOnlySeeding + (SystemTime.getMonotonousTime() - lTimeStarted) / 1000L;
        }
        return this.saved_SecondsOnlySeeding;
    }

    @Override
    public float getAvailability() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return -1.0f;
        }
        return pm.getMinAvailability();
    }

    @Override
    public long getBytesUnavailable() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return -1L;
        }
        return pm.getBytesUnavailable();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.max_upload_rate_bps;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.max_upload_rate_bps = max_rate_bps;
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.max_download_rate_bps;
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        if (Constants.IS_CVS_VERSION && this.max_download_rate_bps == -1 && max_rate_bps != -1) {
            Debug.out("Download changed from disabled to " + max_rate_bps + " for " + this.download_manager.getDisplayName());
        }
        this.max_download_rate_bps = max_rate_bps;
    }

    @Override
    public int getTimeSinceLastDataReceivedInSeconds(boolean this_session) {
        int res;
        PEPeerManager pm = this.download_manager.getPeerManager();
        int n = res = this_session ? this.session_SecondsSinceDownload : this.saved_SecondsSinceDownload;
        if (pm != null) {
            int current = pm.getStats().getTimeSinceLastDataReceivedInSeconds();
            if (current >= 0) {
                res = current;
            } else if (res >= 0) {
                long now = SystemTime.getCurrentTime();
                long elapsed = now - pm.getTimeStarted(false);
                if (elapsed < 0L) {
                    elapsed = 0L;
                }
                res = (int)((long)res + elapsed / 1000L);
            }
        }
        return res;
    }

    @Override
    public int getTimeSinceLastDataSentInSeconds(boolean this_session) {
        int res;
        PEPeerManager pm = this.download_manager.getPeerManager();
        int n = res = this_session ? this.session_SecondsSinceUpload : this.saved_SecondsSinceUpload;
        if (pm != null) {
            int current = pm.getStats().getTimeSinceLastDataSentInSeconds();
            if (current >= 0) {
                res = current;
            } else if (res >= 0) {
                long now = SystemTime.getCurrentTime();
                long elapsed = now - pm.getTimeStarted(false);
                if (elapsed < 0L) {
                    elapsed = 0L;
                }
                res = (int)((long)res + elapsed / 1000L);
            }
        }
        return res;
    }

    @Override
    public long getAvailWentBadTime() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            long bad_time = pm.getAvailWentBadTime();
            if (bad_time > 0L) {
                return bad_time;
            }
            if ((double)pm.getMinAvailability() >= 1.0) {
                return 0L;
            }
        }
        DownloadManagerState state = this.download_manager.getDownloadState();
        return state.getLongAttribute("badavail");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrackerStats() {
        DownloadManagerState state = this.download_manager.getDownloadState();
        Map<String, Map<Long, long[]>> map = this.tracker_session_stats;
        synchronized (map) {
            if (!this.tracker_session_stats.isEmpty()) {
                return;
            }
            Map stats2 = state.getMapAttribute("tss");
            if (stats2 == null) {
                return;
            }
            for (Map.Entry entry1 : stats2.entrySet()) {
                String key = (String)entry1.getKey();
                key = new String(Base32.decode(key), Constants.UTF_8);
                HashMap<Long, long[]> session_stats = new HashMap<Long, long[]>();
                this.tracker_session_stats.put(key, session_stats);
                for (Map.Entry entry : ((Map)entry1.getValue()).entrySet()) {
                    try {
                        long id = Long.parseLong((String)entry.getKey());
                        List nums = (List)entry.getValue();
                        long[] vals = new long[nums.size()];
                        int i = 0;
                        while (i < vals.length) {
                            vals[i] = ((Number)nums.get(i)).longValue();
                            ++i;
                        }
                        session_stats.put(id, vals);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTrackerStats() {
        DownloadManagerState state = this.download_manager.getDownloadState();
        Map<String, Map<Long, long[]>> map = this.tracker_session_stats;
        synchronized (map) {
            HashMap stats2 = new HashMap();
            for (Map.Entry<String, Map<Long, long[]>> entry1 : this.tracker_session_stats.entrySet()) {
                String key = entry1.getKey();
                key = Base32.encode(key.getBytes(Constants.UTF_8));
                HashMap ss = new HashMap();
                stats2.put(key, ss);
                Map<Long, long[]> session_stats = entry1.getValue();
                long[] consolidated = null;
                for (long[] lArray : session_stats.values()) {
                    if (consolidated == null) {
                        consolidated = (long[])lArray.clone();
                        continue;
                    }
                    int i = 1;
                    while (i < Math.min(lArray.length, consolidated.length)) {
                        consolidated[i] = consolidated[i] + lArray[i];
                        ++i;
                    }
                }
                if (consolidated == null) continue;
                consolidated[0] = SystemTime.getCurrentTime();
                ArrayList<Long> arrayList = new ArrayList<Long>();
                ss.put("0", arrayList);
                long[] lArray = consolidated;
                int n = consolidated.length;
                int n2 = 0;
                while (n2 < n) {
                    long l = lArray[n2];
                    arrayList.add(l);
                    ++n2;
                }
            }
            state.setMapAttribute("tss", stats2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTrackerSession(TRTrackerAnnouncerRequest request2) {
        long session = request2.getSessionID();
        URL url = request2.getURL();
        if (session != 0L && url != null) {
            String key = all_trackers.ingestURL(url);
            if (key == null) {
                return;
            }
            all_trackers.updateTracker(key, request2);
            long down = request2.getReportedDownload();
            long up = request2.getReportedUpload();
            if (down > 0L || up > 0L) {
                int group = this.download_manager.getTrackerURLGroup(key);
                Map<String, Map<Long, long[]>> map = this.tracker_session_stats;
                synchronized (map) {
                    while (true) {
                        Map<Long, long[]> session_stats;
                        if ((session_stats = this.tracker_session_stats.get(key)) == null) {
                            session_stats = new HashMap<Long, long[]>();
                            this.tracker_session_stats.put(key, session_stats);
                        }
                        session_stats.put(session, new long[]{SystemTime.getCurrentTime(), up, down});
                        while (session_stats.size() > 5) {
                            long oldest_time = Long.MAX_VALUE;
                            long oldest_session = 0L;
                            long[] consolidated = session_stats.remove(0L);
                            for (Map.Entry<Long, long[]> entry : session_stats.entrySet()) {
                                long[] vals = entry.getValue();
                                long time = vals[0];
                                if (time >= oldest_time) continue;
                                long sid = entry.getKey();
                                oldest_time = time;
                                oldest_session = sid;
                            }
                            long[] oldest = session_stats.remove(oldest_session);
                            if (consolidated == null) {
                                consolidated = oldest;
                            } else {
                                int i = 1;
                                while (i < Math.min(oldest.length, consolidated.length)) {
                                    consolidated[i] = consolidated[i] + oldest[i];
                                    ++i;
                                }
                            }
                            consolidated[0] = SystemTime.getCurrentTime();
                            session_stats.put(0L, consolidated);
                        }
                        if (group == -1) break;
                        key = String.valueOf(group);
                        group = -1;
                    }
                }
                if (this.download_manager.getPeerManager() == null) {
                    this.stats_saver.dispatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getTrackerReportedStats(URL url) {
        String key = all_trackers.ingestURL(url);
        int group = this.download_manager.getTrackerURLGroup(key);
        long group_up = 0L;
        long group_down = 0L;
        long url_up = 0L;
        long url_down = 0L;
        Map<String, Map<Long, long[]>> map = this.tracker_session_stats;
        synchronized (map) {
            Map<Long, long[]> stats2 = this.tracker_session_stats.get(key);
            if (stats2 != null) {
                for (long[] entry : stats2.values()) {
                    url_up += entry[1];
                    url_down += entry[2];
                }
            }
            if (group != -1 && (stats2 = this.tracker_session_stats.get(String.valueOf(group))) != null) {
                for (long[] entry : stats2.values()) {
                    group_up += entry[1];
                    group_down += entry[2];
                }
            }
        }
        return new long[]{group_up, group_down, url_up, url_down};
    }

    protected void saveSessionTotals() {
        this.checkShareRatioProgress();
        this.saved_data_bytes_downloaded = this.getTotalDataBytesReceived();
        this.saved_data_bytes_uploaded = this.getTotalDataBytesSent();
        this.saved_protocol_bytes_downloaded = this.getTotalProtocolBytesReceived();
        this.saved_protocol_bytes_uploaded = this.getTotalProtocolBytesSent();
        this.saved_discarded = this.getDiscarded();
        this.saved_hashfails = this.getHashFailBytes();
        this.saved_SecondsDownloading = this.getSecondsDownloading();
        this.saved_SecondsOnlySeeding = this.getSecondsOnlySeeding();
        this.saved_SecondsSinceDownload = this.getTimeSinceLastDataReceivedInSeconds();
        this.saved_SecondsSinceUpload = this.getTimeSinceLastDataSentInSeconds();
        this.session_SecondsSinceDownload = this.getTimeSinceLastDataReceivedInSeconds(true);
        this.session_SecondsSinceUpload = this.getTimeSinceLastDataSentInSeconds(true);
        this.saved_peak_receive_rate = this.getPeakDataReceiveRate();
        this.saved_peak_send_rate = this.getPeakDataSendRate();
        DownloadManagerState state = this.download_manager.getDownloadState();
        state.setIntAttribute("timesincedl", this.saved_SecondsSinceDownload);
        state.setIntAttribute("timesinceul", this.saved_SecondsSinceUpload);
        state.setLongAttribute("badavail", this.getAvailWentBadTime());
        state.setLongAttribute("pkdo", this.saved_peak_receive_rate);
        state.setLongAttribute("pkup", this.saved_peak_send_rate);
        this.saveTrackerStats();
    }

    protected void setSavedDownloadedUploaded(long d, long u) {
        this.saved_data_bytes_downloaded = d;
        this.saved_data_bytes_uploaded = u;
    }

    @Override
    public void restoreSessionTotals(long _saved_data_bytes_downloaded, long _saved_data_bytes_uploaded, long _saved_discarded, long _saved_hashfails, long _saved_SecondsDownloading, long _saved_SecondsOnlySeeding) {
        this.saved_data_bytes_downloaded = _saved_data_bytes_downloaded;
        this.saved_data_bytes_uploaded = _saved_data_bytes_uploaded;
        this.saved_discarded = _saved_discarded;
        this.saved_hashfails = _saved_hashfails;
        this.saved_SecondsDownloading = _saved_SecondsDownloading;
        this.saved_SecondsOnlySeeding = _saved_SecondsOnlySeeding;
        this.session_start_data_bytes_downloaded = this.saved_data_bytes_downloaded;
        this.session_start_data_bytes_uploaded = _saved_data_bytes_uploaded;
        DownloadManagerState state = this.download_manager.getDownloadState();
        this.saved_SecondsSinceDownload = state.getIntAttribute("timesincedl");
        this.saved_SecondsSinceUpload = state.getIntAttribute("timesinceul");
        this.saved_peak_receive_rate = state.getLongAttribute("pkdo");
        this.saved_peak_send_rate = state.getLongAttribute("pkup");
        if (this.saved_data_bytes_downloaded > 0L && this.saved_completed_download_bytes == 0L) {
            this.saved_completed_download_bytes = -1L;
        }
        this.loadTrackerStats();
    }

    public void setSkippedFileStats(long skipped_file_set_size, long skipped_but_downloaded) {
        this.saved_skipped_file_set_size = skipped_file_set_size;
        this.saved_skipped_but_downloaded = skipped_but_downloaded;
    }

    private long getSkippedFileSetSize() {
        if (this.saved_skipped_file_set_size < 0L) {
            DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfoSet().getFiles();
            long skipped_file_set_size = 0L;
            long skipped_but_downloaded = 0L;
            int i = 0;
            while (i < files.length) {
                DiskManagerFileInfo file = files[i];
                if (file.isSkipped()) {
                    skipped_file_set_size += file.getLength();
                    skipped_but_downloaded += file.getDownloaded();
                }
                ++i;
            }
            this.setSkippedFileStats(skipped_file_set_size, skipped_but_downloaded);
        }
        return this.saved_skipped_file_set_size;
    }

    protected void setFilePriorityStats(int[] stats2) {
        this.file_priority_stats = stats2;
    }

    @Override
    public int[] getFilePriorityStats() {
        return this.file_priority_stats;
    }

    @Override
    public long getRemainingExcludingDND() {
        int state;
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm != null && (state = dm.getState()) != 1 && state != 2) {
            return dm.getRemainingExcludingDND();
        }
        long remaining = this.getRemaining();
        long rem = remaining - (this.getSkippedFileSetSize() - this.saved_skipped_but_downloaded);
        if (rem < 0L) {
            rem = 0L;
        }
        return rem;
    }

    @Override
    public long getSizeExcludingDND() {
        int state;
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm != null && (state = dm.getState()) != 1 && state != 2) {
            return dm.getSizeExcludingDND();
        }
        long totalLength = this.download_manager.getSize();
        return totalLength - this.getSkippedFileSetSize();
    }

    @Override
    public int getPercentDoneExcludingDND() {
        long sizeExcludingDND = this.getSizeExcludingDND();
        if (sizeExcludingDND == 0L) {
            return 1000;
        }
        if (sizeExcludingDND < 0L) {
            return 0;
        }
        long rem = this.getRemainingExcludingDND();
        float pct = (float)(sizeExcludingDND - rem) / (float)sizeExcludingDND;
        int result = (int)(1000.0f * pct);
        if (result == 1000 && rem > 0L) {
            result = 999;
        } else if (result < 0) {
            result = 0;
        }
        return result;
    }

    protected void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManagerStats");
        try {
            writer.indent();
            writer.println("recv_d=" + this.getTotalDataBytesReceived() + ",recv_p=" + this.getTotalProtocolBytesReceived() + ",recv_g=" + this.getTotalGoodDataBytesReceived() + ",sent_d=" + this.getTotalDataBytesSent() + ",sent_p=" + this.getTotalProtocolBytesSent() + ",discard=" + this.getDiscarded() + ",hash_fails=" + this.getHashFailCount() + "/" + this.getHashFailBytes() + ",comp=" + this.getCompleted() + "[live:" + this.getDownloadCompleted(true) + "/" + this.getDownloadCompleted(false) + "]" + ",remaining=" + this.getRemaining());
            writer.println("down_lim=" + this.getDownloadRateLimitBytesPerSecond() + ",up_lim=" + this.getUploadRateLimitBytesPerSecond());
        }
        finally {
            writer.exdent();
        }
    }
}

