/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.global.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.global.impl.GlobalManagerImpl;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerListenerAdapter;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.components.UIButton;
import com.biglybt.pif.ui.components.UIPropertyChangeEvent;
import com.biglybt.pif.ui.components.UIPropertyChangeListener;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pifimpl.local.PluginInitializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalManagerFileMerger
implements AEDiagnosticsEvidenceGenerator {
    private static final int HASH_FAILS_BEFORE_QUIT = 3;
    private static final int TIMER_PERIOD = 5000;
    private static final int FORCE_PIECE_TIMER_PERIOD = 15000;
    private static final int FORCE_PIECE_TIMER_TICKS = 3;
    private static final int SYNC_TIMER_PERIOD = 60000;
    private static final int SYNC_TIMER_TICKS = 12;
    private static final String ORIGINATOR_PREFIX = "SwarmMerge-xfer";
    static final Object merged_data_lock = new Object();
    private final GlobalManagerImpl gm;
    private LoggerChannel log;
    private boolean logging_paused = true;
    boolean initialised;
    boolean enabled;
    boolean enabled_extended;
    int tolerance = 0;
    int min_pieces = 5;
    final Map<HashWrapper, DownloadManager> dm_map = new HashMap<HashWrapper, DownloadManager>();
    final List<SameSizeFiles> sames = new ArrayList<SameSizeFiles>();
    final Set<DownloadManager> sames_dms = new IdentityHashSet<DownloadManager>();
    final AsyncDispatcher read_write_dispatcher = new AsyncDispatcher("GMFM");
    final AsyncDispatcher sync_dispatcher = new AsyncDispatcher("GMFM:serial");
    private TimerEventPeriodic timer_event;

    protected GlobalManagerFileMerger(GlobalManagerImpl _gm) {
        this.gm = _gm;
        PluginInitializer.getDefaultInterface().addListener(new PluginAdapter(){

            @Override
            public void initializationComplete() {
                GlobalManagerFileMerger.this.initialise();
            }
        });
    }

    void initialise() {
        AEDiagnostics.addEvidenceGenerator(this);
        String VIEW_NAME = "TableColumn.header.mergeddata";
        PluginInterface plugin_interface = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
        this.log = plugin_interface.getLogger().getChannel("Swarm Merge");
        this.log.setDiagnostic();
        this.log.setForce(true);
        String pause_key = String.valueOf(VIEW_NAME) + ".LoggerView.pause";
        COConfigurationManager.setParameter(pause_key, true);
        COConfigurationManager.addParameterListener(pause_key, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                GlobalManagerFileMerger.this.setLoggingPaused(COConfigurationManager.getBooleanParameter(name));
            }
        });
        UIManager ui_manager = plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(VIEW_NAME);
        model.setProperty(1, true);
        model.getStatus().setText("Starting up...");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        UIButton reset = model.addButton();
        reset.setLabel("TableColumn.header.mergeddata");
        reset.setName("Button.reset");
        reset.addPropertyChangeListener(new UIPropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChanged(UIPropertyChangeEvent ev) {
                if (ev.getPropertyType() == "selected") {
                    GlobalManagerFileMerger.this.log("Resetting");
                    Map<HashWrapper, DownloadManager> map = GlobalManagerFileMerger.this.dm_map;
                    synchronized (map) {
                        for (SameSizeFiles s : GlobalManagerFileMerger.this.sames) {
                            s.destroy();
                        }
                        GlobalManagerFileMerger.this.sames.clear();
                        GlobalManagerFileMerger.this.sames_dms.clear();
                        GlobalManagerFileMerger.this.syncFileSets(true);
                    }
                }
            }
        });
        model.attachLoggerChannel(this.log);
        this.setLoggingPaused(true);
        new DelayedEvent("GMFM:delay", 30000L, new AERunnable(){

            @Override
            public void runSupport() {
                COConfigurationManager.addAndFireParameterListeners(new String[]{"Merge Same Size Files", "Merge Same Size Files Extended", "Merge Same Size Files Tolerance", "Merge Same Size Files Min Pieces"}, new ParameterListener(){

                    @Override
                    public void parameterChanged(String name) {
                        (this).GlobalManagerFileMerger.this.enabled = COConfigurationManager.getBooleanParameter("Merge Same Size Files");
                        (this).GlobalManagerFileMerger.this.enabled_extended = COConfigurationManager.getBooleanParameter("Merge Same Size Files Extended");
                        model.getStatus().setText((this).GlobalManagerFileMerger.this.enabled ? "Running" : "Disabled");
                        int old_tolerance = (this).GlobalManagerFileMerger.this.tolerance;
                        int old_min_pieces = (this).GlobalManagerFileMerger.this.min_pieces;
                        (this).GlobalManagerFileMerger.this.tolerance = COConfigurationManager.getIntParameter("Merge Same Size Files Tolerance");
                        (this).GlobalManagerFileMerger.this.min_pieces = COConfigurationManager.getIntParameter("Merge Same Size Files Min Pieces");
                        GlobalManagerFileMerger.this.logSupport("Complete files=" + (this).GlobalManagerFileMerger.this.enabled_extended + ", tolerance=" + (this).GlobalManagerFileMerger.this.tolerance + ", min pieces=" + (this).GlobalManagerFileMerger.this.min_pieces);
                        if ((this).GlobalManagerFileMerger.this.initialised) {
                            GlobalManagerFileMerger.this.syncFileSets(old_tolerance != (this).GlobalManagerFileMerger.this.tolerance || old_min_pieces != (this).GlobalManagerFileMerger.this.min_pieces);
                        }
                    }
                });
                GlobalManagerFileMerger.this.gm.addListener(new GlobalManagerAdapter(){

                    @Override
                    public void downloadManagerAdded(DownloadManager dm) {
                        GlobalManagerFileMerger.this.syncFileSets(false);
                    }

                    @Override
                    public void downloadManagerRemoved(DownloadManager dm) {
                        GlobalManagerFileMerger.this.syncFileSets(false);
                    }
                }, false);
                GlobalManagerFileMerger.this.syncFileSets(false);
                GlobalManagerFileMerger.this.initialised = true;
            }
        });
    }

    void setLoggingPaused(boolean b) {
        this.logging_paused = b;
        this.logSupport("Paused=" + b);
        if (!b) {
            this.logCurrentState(null);
        }
    }

    void log(String str) {
        this.log(null, str);
    }

    void log(IndentWriter writer, String str) {
        if (writer == null) {
            if (!this.logging_paused) {
                this.logSupport(str);
            }
        } else {
            writer.println(str);
        }
    }

    void logSupport(String str) {
        this.log.log(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSwarmMergingZ(DownloadManager dm) {
        Map<HashWrapper, DownloadManager> map = this.dm_map;
        synchronized (map) {
            return this.sames_dms.contains(dm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSwarmMergingInfo(DownloadManager dm) {
        Map<HashWrapper, DownloadManager> map = this.dm_map;
        synchronized (map) {
            if (this.sames.size() > 0) {
                StringBuffer result = null;
                for (SameSizeFiles s : this.sames) {
                    if (!s.hasDownloadManager(dm)) continue;
                    String info = s.getInfo();
                    if (result == null) {
                        result = new StringBuffer(1024);
                    } else {
                        result.append("\n");
                    }
                    result.append(info);
                }
                return result == null ? null : result.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncFileSets(boolean force) {
        List<DownloadManager> dms = this.gm.getDownloadManagers();
        Map<HashWrapper, DownloadManager> map = this.dm_map;
        synchronized (map) {
            boolean changed = false;
            HashSet<HashWrapper> existing_dm_hashes = new HashSet<HashWrapper>(this.dm_map.keySet());
            if (this.enabled) {
                this.log("Scanning files");
                for (DownloadManager dm : dms) {
                    TOTorrent torrent;
                    DownloadManagerState state = dm.getDownloadState();
                    if (state.getFlag(16L) || state.getFlag(512L) || !this.enabled_extended && dm.isDownloadComplete(false) || (torrent = dm.getTorrent()) == null) continue;
                    try {
                        HashWrapper hw = torrent.getHashWrapper();
                        if (this.dm_map.containsKey(hw)) {
                            existing_dm_hashes.remove(hw);
                            continue;
                        }
                        this.dm_map.put(hw, dm);
                        changed = true;
                    }
                    catch (Throwable hw) {
                        // empty catch block
                    }
                }
            }
            if (existing_dm_hashes.size() > 0) {
                changed = true;
                for (HashWrapper hw : existing_dm_hashes) {
                    this.dm_map.remove(hw);
                }
            }
            if (changed || force) {
                LinkedList interesting = new LinkedList();
                IdentityHashSet<DownloadManager> merging_downloads = new IdentityHashSet<DownloadManager>();
                int loop = 0;
                while (loop < 2) {
                    DiskManagerFileInfo file;
                    DiskManagerFileInfo[] diskManagerFileInfoArray;
                    boolean dm_is_merging;
                    TOTorrent torrent;
                    LinkedList<HashSet<DiskManagerFileInfo>> interesting_root_hashes = new LinkedList<HashSet<DiskManagerFileInfo>>();
                    ByteArrayHashMap<HashSet<DiskManagerFileInfo>> root_hash_map = new ByteArrayHashMap<HashSet<DiskManagerFileInfo>>();
                    for (DownloadManager dm : this.dm_map.values()) {
                        TOTorrent torrent2 = dm.getTorrent();
                        if (torrent2 == null || torrent2.getTorrentType() == 1) continue;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        boolean dm_is_merging2 = merging_downloads.contains(dm);
                        DiskManagerFileInfo[] diskManagerFileInfoArray2 = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte[] root_hash;
                            TOTorrentFile torrent_file;
                            DiskManagerFileInfo file2 = diskManagerFileInfoArray2[n2];
                            if (file2.getLength() != 0L && (file2.getNbPieces() >= this.min_pieces || dm_is_merging2) && !(torrent_file = file2.getTorrentFile()).isPadFile() && (root_hash = torrent_file.getRootHash()) != null) {
                                HashSet<DiskManagerFileInfo> set = (HashSet<DiskManagerFileInfo>)root_hash_map.get(root_hash);
                                if (set == null) {
                                    set = new HashSet<DiskManagerFileInfo>();
                                    root_hash_map.put(root_hash, set);
                                }
                                set.add(file2);
                                if (set.size() == 2) {
                                    interesting_root_hashes.add(set);
                                }
                            }
                            ++n2;
                        }
                    }
                    HashSet files_already_allocated = new HashSet();
                    if (!interesting_root_hashes.isEmpty()) {
                        interesting.addAll(interesting_root_hashes);
                        for (Set set : interesting_root_hashes) {
                            files_already_allocated.addAll(set);
                        }
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    HashMap size_map = new HashMap();
                    if (this.tolerance != 0) {
                        for (DownloadManager dm : this.dm_map.values()) {
                            torrent = dm.getTorrent();
                            if (torrent == null) continue;
                            DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                            dm_is_merging = merging_downloads.contains(dm);
                            diskManagerFileInfoArray = files;
                            int n = files.length;
                            int n3 = 0;
                            while (n3 < n) {
                                file = diskManagerFileInfoArray[n3];
                                if (!(files_already_allocated.contains(file) || file.getTorrentFile().isPadFile() || file.getLength() == 0L || file.getNbPieces() < this.min_pieces && !dm_is_merging)) {
                                    String name = file.getFile(true).getName();
                                    long len = file.getLength();
                                    Object existing = hashMap.get(name);
                                    if (existing == null) {
                                        hashMap.put(name, len);
                                    } else if (existing instanceof Long) {
                                        ArrayList<Long> list = new ArrayList<Long>(2);
                                        list.add((Long)existing);
                                        list.add(len);
                                        hashMap.put(name, list);
                                    } else {
                                        ((List)existing).add(len);
                                    }
                                }
                                ++n3;
                            }
                        }
                    }
                    for (DownloadManager dm : this.dm_map.values()) {
                        torrent = dm.getTorrent();
                        if (torrent == null) continue;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        dm_is_merging = merging_downloads.contains(dm);
                        diskManagerFileInfoArray = files;
                        int n = files.length;
                        int n4 = 0;
                        while (n4 < n) {
                            file = diskManagerFileInfoArray[n4];
                            if (!(files_already_allocated.contains(file) || file.getTorrentFile().isPadFile() || file.getLength() == 0L || file.getNbPieces() < this.min_pieces && !dm_is_merging)) {
                                HashSet<DiskManagerFileInfo> set;
                                String name;
                                Object o;
                                long len_to_use = file.getLength();
                                if (this.tolerance != 0 && !((o = hashMap.get(name = file.getFile(true).getName())) instanceof Long)) {
                                    Object[] lengths;
                                    if (o instanceof List) {
                                        List list = (List)o;
                                        lengths = list.toArray(new Long[0]);
                                        Arrays.sort(lengths);
                                        hashMap.put(name, lengths);
                                    } else {
                                        lengths = (Long[])o;
                                    }
                                    long current = lengths[0];
                                    if (len_to_use > current) {
                                        int i = 1;
                                        while (i < lengths.length) {
                                            long l = (Long)lengths[i];
                                            if (l - current > (long)this.tolerance) {
                                                current = l;
                                            }
                                            if (l == len_to_use) {
                                                len_to_use = current;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                }
                                if ((set = (HashSet<DiskManagerFileInfo>)size_map.get(len_to_use)) == null) {
                                    set = new HashSet<DiskManagerFileInfo>();
                                    size_map.put(len_to_use, set);
                                }
                                boolean same_dm = false;
                                for (DiskManagerFileInfo existing : set) {
                                    if (existing.getDownloadManager() != dm) continue;
                                    same_dm = true;
                                    break;
                                }
                                if (!same_dm) {
                                    set.add(file);
                                    if (set.size() == 2) {
                                        interesting.add(set);
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                    if (loop != 0 || this.min_pieces <= 0 || interesting.isEmpty()) break;
                    for (Set set : interesting) {
                        for (DiskManagerFileInfo file2 : set) {
                            merging_downloads.add(file2.getDownloadManager());
                        }
                    }
                    this.log("Rescanning after finding " + merging_downloads.size() + " interesting downloads with " + interesting.size() + " same-size files");
                    interesting.clear();
                    ++loop;
                }
                Iterator interesting_it = interesting.iterator();
                while (interesting_it.hasNext()) {
                    Set set = (Set)interesting_it.next();
                    boolean all_done = true;
                    for (DiskManagerFileInfo file : set) {
                        if (file.getDownloaded() == file.getLength()) continue;
                        all_done = false;
                        break;
                    }
                    if (!all_done) continue;
                    interesting_it.remove();
                }
                LinkedList<SameSizeFiles> sames_copy = new LinkedList<SameSizeFiles>(this.sames);
                for (Set set : interesting) {
                    boolean bl;
                    boolean bl2 = false;
                    Iterator sames_it = sames_copy.iterator();
                    while (sames_it.hasNext()) {
                        SameSizeFiles same = (SameSizeFiles)sames_it.next();
                        if (!same.sameAs(set)) continue;
                        bl = true;
                        sames_it.remove();
                        break;
                    }
                    if (bl) continue;
                    this.sames.add(new SameSizeFiles(set));
                }
                for (SameSizeFiles dead : sames_copy) {
                    dead.destroy();
                    this.sames.remove(dead);
                }
                if (this.enabled) {
                    this.log("Scan result: dm_map=" + this.dm_map.size() + ", sames=" + this.sames.size());
                }
                this.sames_dms.clear();
                if (this.sames.size() > 0) {
                    for (SameSizeFiles same : this.sames) {
                        this.sames_dms.addAll(same.getDownloadManagers());
                    }
                    if (this.timer_event == null) {
                        this.timer_event = SimpleTimer.addPeriodicEvent("GMFM:sync", 5000L, new TimerEventPerformer(){
                            private int tick_count = 0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform(TimerEvent event2) {
                                ++this.tick_count;
                                Map<HashWrapper, DownloadManager> map = GlobalManagerFileMerger.this.dm_map;
                                synchronized (map) {
                                    for (SameSizeFiles s : GlobalManagerFileMerger.this.sames) {
                                        s.sync(this.tick_count);
                                    }
                                }
                            }
                        });
                    }
                } else if (this.timer_event != null) {
                    this.timer_event.cancel();
                    this.timer_event = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentState(IndentWriter write) {
        Map<HashWrapper, DownloadManager> map = this.dm_map;
        synchronized (map) {
            this.log(write, "Same size file sets=" + this.sames.size() + ", dm_map=" + this.dm_map.size());
            for (SameSizeFiles same : this.sames) {
                same.logCurrentState(write);
            }
        }
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Swarm Merge");
        try {
            writer.indent();
            this.logCurrentState(writer);
        }
        finally {
            writer.exdent();
        }
    }

    private static interface DownloadManagerPeerListenerEx
    extends DownloadManagerPeerListener {
        public void sync();
    }

    private class SameSizeFiles {
        private final Set<DiskManagerFileInfo> files;
        private final List<SameSizeFileWrapper> file_wrappers;
        private final Set<DownloadManager> dm_set = new IdentityHashSet<DownloadManager>();
        private boolean completion_logged;
        private volatile boolean dl_has_restarted;
        private volatile boolean destroyed;
        private String abandon_reason;

        SameSizeFiles(Set<DiskManagerFileInfo> _files) {
            this.files = _files;
            this.file_wrappers = new ArrayList<SameSizeFileWrapper>(this.files.size());
            int num = 0;
            for (DiskManagerFileInfo file : this.files) {
                SameSizeFileWrapper file_wrapper = new SameSizeFileWrapper(num++, file);
                this.file_wrappers.add(file_wrapper);
                this.dm_set.add(file_wrapper.getDownloadManager());
            }
            for (final SameSizeFileWrapper file_wrapper : this.file_wrappers) {
                final DiskManagerFileInfo file = file_wrapper.getFile();
                final DownloadManager dm = file_wrapper.getDownloadManager();
                DownloadManagerPeerListenerEx dmpl = new DownloadManagerPeerListenerEx(){
                    final Object lock = this;
                    DiskManager current_disk_manager;
                    boolean pm_removed;
                    final DiskManagerFileInfoListener file_listener;
                    {
                        this.file_listener = new DiskManagerFileInfoListener(){

                            @Override
                            public void dataWritten(long offset, long length, Object originator) {
                                if (SameSizeFiles.this.destroyed) {
                                    diskManagerFileInfo.removeListener(this);
                                    return;
                                }
                                if (originator instanceof String && ((String)originator).startsWith(GlobalManagerFileMerger.ORIGINATOR_PREFIX)) {
                                    return;
                                }
                                sameSizeFileWrapper.dataWritten(offset, length, originator);
                            }

                            @Override
                            public void dataChecked(long offset, long length) {
                                if (SameSizeFiles.this.destroyed) {
                                    diskManagerFileInfo.removeListener(this);
                                    return;
                                }
                            }
                        };
                    }

                    @Override
                    public void sync() {
                        if (SameSizeFiles.this.destroyed) {
                            return;
                        }
                        ((SameSizeFiles)SameSizeFiles.this).GlobalManagerFileMerger.this.sync_dispatcher.dispatch(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                if (SameSizeFiles.this.destroyed) {
                                    return;
                                }
                                Object object = lock;
                                synchronized (object) {
                                    if (current_disk_manager == null) {
                                        return;
                                    }
                                    file.removeListener(file_listener);
                                }
                                file.addListener(file_listener);
                            }
                        });
                    }

                    @Override
                    public void peerManagerAdded(final PEPeerManager manager) {
                        if (SameSizeFiles.this.destroyed) {
                            return;
                        }
                        ((SameSizeFiles)SameSizeFiles.this).GlobalManagerFileMerger.this.sync_dispatcher.dispatch(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                if (SameSizeFiles.this.destroyed) {
                                    return;
                                }
                                if (pm_removed) {
                                    GlobalManagerFileMerger.this.log(String.valueOf(dm.getDisplayName()) + " restarted ");
                                    SameSizeFiles.this.dl_has_restarted = true;
                                }
                                manager.addListener(new PEPeerManagerListenerAdapter(){

                                    @Override
                                    public void pieceCorrupted(PEPeerManager manager, int piece_number) {
                                        if (SameSizeFiles.this.destroyed) {
                                            manager.removeListener(this);
                                            return;
                                        }
                                        file_wrapper.pieceCorrupt(piece_number);
                                    }
                                });
                                Object object = lock;
                                synchronized (object) {
                                    if (current_disk_manager != null) {
                                        file.removeListener(file_listener);
                                    }
                                    current_disk_manager = manager.getDiskManager();
                                    if (current_disk_manager == null) {
                                        return;
                                    }
                                }
                                file.addListener(file_listener);
                            }
                        });
                    }

                    @Override
                    public void peerManagerRemoved(PEPeerManager manager) {
                        ((SameSizeFiles)SameSizeFiles.this).GlobalManagerFileMerger.this.sync_dispatcher.dispatch(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Object object = lock;
                                synchronized (object) {
                                    pm_removed = true;
                                    if (current_disk_manager != null) {
                                        file.removeListener(file_listener);
                                        current_disk_manager = null;
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void peerAdded(PEPeer peer) {
                    }

                    @Override
                    public void peerRemoved(PEPeer peer) {
                    }

                    @Override
                    public void peerManagerWillBeAdded(PEPeerManager manager) {
                    }
                };
                dm.setUserData(this, dmpl);
                dm.addPeerListener(dmpl);
            }
            this.dl_has_restarted = true;
            if (!GlobalManagerFileMerger.this.logging_paused) {
                GlobalManagerFileMerger.this.log("Created");
                this.logCurrentState();
            }
        }

        boolean hasDownloadManager(DownloadManager dm) {
            return this.dm_set.contains(dm);
        }

        Set<DownloadManager> getDownloadManagers() {
            return this.dm_set;
        }

        void sync(int tick_count) {
            boolean do_force;
            if (GlobalManagerFileMerger.this.read_write_dispatcher.getQueueSize() > 0) {
                return;
            }
            boolean do_sync = tick_count % 12 == 0;
            boolean bl = do_force = tick_count % 3 == 0;
            if (this.dl_has_restarted) {
                this.dl_has_restarted = false;
                do_sync = true;
            }
            if (!do_sync && !do_force) {
                return;
            }
            HashSet<DiskManagerFileInfo> active = new HashSet<DiskManagerFileInfo>();
            int num_incomplete = 0;
            for (DiskManagerFileInfo file : this.files) {
                int dl_state;
                if (file.isSkipped() || (dl_state = file.getDownloadManager().getState()) != 50 && dl_state != 60) continue;
                active.add(file);
                if (file.getLength() == file.getDownloaded()) continue;
                ++num_incomplete;
            }
            if (num_incomplete > 0 && active.size() > 1) {
                boolean rta_active = false;
                for (DiskManagerFileInfo file : active) {
                    PEPeerManager pm;
                    DownloadManagerPeerListenerEx dmpl;
                    DownloadManager dm = file.getDownloadManager();
                    if (do_sync && (dmpl = (DownloadManagerPeerListenerEx)dm.getUserData(this)) != null) {
                        dmpl.sync();
                    }
                    if ((pm = dm.getPeerManager()) == null || pm.getPiecePicker().getRTAProviders().size() <= 0) continue;
                    rta_active = true;
                }
                if (rta_active) {
                    do_force = false;
                }
                if (do_force) {
                    try {
                        for (SameSizeFileWrapper ss_file : this.file_wrappers) {
                            DiskManagerFileInfo file = ss_file.getFile();
                            if (!active.contains(file)) continue;
                            DiskManager dm = ss_file.getDiskManager();
                            PEPeerManager pm = ss_file.getPeerManager();
                            if (dm == null || pm == null) continue;
                            DiskManagerPiece[] pieces = dm.getPieces();
                            int first_piece = file.getFirstPieceNumber();
                            int last_piece = file.getLastPieceNumber();
                            long file_length = file.getLength();
                            long piece_size = dm.getPieceLength();
                            long file_start_offset = ss_file.getFileByteOffset();
                            boolean force_done = false;
                            int[] availability = pm.getAvailability();
                            int i = first_piece;
                            while (i <= last_piece && !force_done) {
                                DiskManagerPiece piece = pieces[i];
                                if (piece.isInteresting() && availability[i] == 0) {
                                    long start_in_file = piece_size * (long)i - file_start_offset;
                                    long end_in_file_exclusive = start_in_file + (long)piece.getLength();
                                    if (start_in_file < 0L) {
                                        start_in_file = 0L;
                                    }
                                    if (end_in_file_exclusive > file_length) {
                                        end_in_file_exclusive = file_length;
                                    }
                                    for (SameSizeFileWrapper o_ss_file : this.file_wrappers) {
                                        if (ss_file == o_ss_file || !active.contains(o_ss_file.getFile()) || !o_ss_file.forceRange(i, start_in_file, end_in_file_exclusive)) continue;
                                        force_done = true;
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            if (!do_sync) {
                return;
            }
            if (!this.completion_logged) {
                boolean all_done = true;
                long total_merged = 0L;
                for (SameSizeFileWrapper ssf : this.file_wrappers) {
                    if (ssf.isSkipped()) continue;
                    total_merged += ssf.getMergedByteCount();
                    if (ssf.isComplete()) continue;
                    all_done = false;
                }
                if (all_done) {
                    this.completion_logged = true;
                    if (total_merged > 0L) {
                        String msg = "Successfully merged files:\n";
                        for (SameSizeFileWrapper file : this.file_wrappers) {
                            long merged = file.getMergedByteCount();
                            if (merged <= 0L) continue;
                            DownloadManager dm = file.getDownloadManager();
                            msg = String.valueOf(msg) + dm.getDisplayName();
                            if (!dm.getTorrent().isSimpleTorrent()) {
                                msg = String.valueOf(msg) + " - " + file.getFile().getTorrentFile().getRelativePath();
                            }
                            msg = String.valueOf(msg) + ": " + DisplayFormatters.formatByteCountToKiBEtc(merged) + "\n";
                        }
                        msg = String.valueOf(msg) + "\nTotal: " + DisplayFormatters.formatByteCountToKiBEtc(total_merged);
                        GlobalManagerFileMerger.this.log(msg);
                        Logger.log(new LogAlert(true, 0, msg));
                    }
                }
            }
        }

        boolean sameAs(Set<DiskManagerFileInfo> _others) {
            return this.files.equals(_others);
        }

        void abandon(SameSizeFileWrapper failed) {
            this.destroy();
            String msg = "Abandoned attempt to merge files:\n";
            for (SameSizeFileWrapper file : this.file_wrappers) {
                msg = String.valueOf(msg) + file.getDownloadManager().getDisplayName() + " - " + file.getFile().getTorrentFile().getRelativePath() + "\n";
            }
            this.abandon_reason = msg = String.valueOf(msg) + "\nToo many hash fails in " + failed.getDownloadManager().getDisplayName();
            Logger.log(new LogEvent(LogIDs.CORE, msg));
            GlobalManagerFileMerger.this.log(msg);
        }

        String getInfo() {
            StringBuilder msg = new StringBuilder(1024);
            long size_min = -1L;
            long size_max = -1L;
            for (SameSizeFileWrapper file : this.file_wrappers) {
                DiskManagerFileInfo f = file.getFile();
                if (size_min == -1L) {
                    size_min = size_max = f.getLength();
                } else if (GlobalManagerFileMerger.this.tolerance != 0) {
                    long l2 = f.getLength();
                    size_min = Math.min(size_min, l2);
                    size_max = Math.max(size_max, l2);
                }
                msg.append("  ");
                msg.append(file.getDownloadManager().getDisplayName());
                msg.append(": ");
                msg.append(f.getTorrentFile().getRelativePath());
                msg.append("\n");
                msg.append("    " + file.getInfo());
                msg.append("\n");
            }
            String size_str = DisplayFormatters.formatByteCountToKiBEtc(size_min);
            if (size_max > size_min) {
                size_str = String.valueOf(size_str) + " (+" + (size_max - size_min) + ")";
            }
            return "Size: " + size_str + "\n" + msg.toString();
        }

        void destroy() {
            this.destroyed = true;
            for (DiskManagerFileInfo file : this.files) {
                DownloadManager dm = file.getDownloadManager();
                DownloadManagerPeerListenerEx dmpl = (DownloadManagerPeerListenerEx)dm.getUserData(this);
                if (dmpl == null) continue;
                dm.setUserData(this, null);
                dm.removePeerListener(dmpl);
            }
        }

        private void logCurrentState() {
            this.logCurrentState(null);
        }

        private void logCurrentState(IndentWriter writer) {
            long size_min = -1L;
            long size_max = -1L;
            for (SameSizeFileWrapper file : this.file_wrappers) {
                DiskManagerFileInfo f = file.getFile();
                if (size_min == -1L) {
                    size_min = size_max = f.getLength();
                    continue;
                }
                if (GlobalManagerFileMerger.this.tolerance == 0) continue;
                long l2 = f.getLength();
                size_min = Math.min(size_min, l2);
                size_max = Math.max(size_max, l2);
            }
            String size_str = DisplayFormatters.formatByteCountToKiBEtc(size_min);
            if (size_max > size_min) {
                size_str = String.valueOf(size_str) + " (+" + (size_max - size_min) + ")";
            }
            GlobalManagerFileMerger.this.log(writer, "  " + size_str + ", files=" + this.file_wrappers.size());
            if (this.completion_logged) {
                GlobalManagerFileMerger.this.log(writer, "    Completed");
            } else if (this.abandon_reason != null) {
                GlobalManagerFileMerger.this.log(writer, "    Abandoned: " + this.abandon_reason);
            } else {
                for (SameSizeFileWrapper file : this.file_wrappers) {
                    file.logCurrentState(writer);
                }
            }
        }

        private String getString() {
            String str = "";
            long size = -1L;
            for (DiskManagerFileInfo file : this.files) {
                size = file.getLength();
                str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + file.getTorrentFile().getRelativePath();
            }
            str = String.valueOf(str) + " - length " + size;
            return str;
        }

        private class SameSizeFileWrapper {
            private final DownloadManager download_manager;
            private final int wrapper_num;
            private final DiskManagerFileInfo file;
            private final long piece_length;
            private final long file_length;
            private final long file_byte_offset;
            private final int first_piece_number;
            private final int last_piece_number;
            private final int first_piece_block_number;
            private final int last_piece_block_number;
            private final String id;
            private long merged_byte_counnt;
            private final boolean[] modified_pieces;
            private int pieces_completed;
            private int pieces_corrupted;
            private int hash_fails_allowed = 3;
            private int forced_start_piece = 0;
            private int forced_end_piece = -1;

            SameSizeFileWrapper(int _wrapper_num, DiskManagerFileInfo _file) {
                String _id;
                this.wrapper_num = _wrapper_num;
                this.file = _file;
                this.modified_pieces = new boolean[this.file.getNbPieces()];
                this.download_manager = this.file.getDownloadManager();
                this.file_length = this.file.getLength();
                int file_index = this.file.getIndex();
                long fbo = 0L;
                if (file_index > 0) {
                    DiskManagerFileInfo[] f = this.download_manager.getDiskManagerFileInfoSet().getFiles();
                    int i = 0;
                    while (i < file_index) {
                        fbo += f[i].getLength();
                        ++i;
                    }
                }
                TOTorrent torrent = this.download_manager.getTorrent();
                try {
                    _id = String.valueOf(Base32.encode(torrent.getHash())) + "/" + this.file.getIndex();
                }
                catch (Throwable e) {
                    _id = String.valueOf(this.download_manager.getDisplayName()) + "/" + this.file.getIndex();
                }
                this.id = _id;
                this.file_byte_offset = fbo;
                this.piece_length = torrent.getPieceLength();
                this.first_piece_number = this.file.getFirstPieceNumber();
                this.last_piece_number = this.file.getLastPieceNumber();
                this.first_piece_block_number = (int)(this.file_byte_offset % this.piece_length) / 16384;
                long file_end_offset = this.file_byte_offset + this.file_length;
                int end_rem = (int)(file_end_offset % this.piece_length);
                if (end_rem == 0) {
                    end_rem = (int)this.piece_length;
                }
                this.last_piece_block_number = (end_rem - 1) / 16384;
            }

            DiskManagerFileInfo getFile() {
                return this.file;
            }

            boolean isSkipped() {
                return this.file.isSkipped();
            }

            boolean isComplete() {
                return this.file.getLength() == this.file.getDownloaded();
            }

            DownloadManager getDownloadManager() {
                return this.download_manager;
            }

            DiskManager getDiskManager() {
                return this.file.getDiskManager();
            }

            PEPeerManager getPeerManager() {
                return this.download_manager.getPeerManager();
            }

            long getFileByteOffset() {
                return this.file_byte_offset;
            }

            private String getID() {
                return this.id;
            }

            void dataWritten(final long initial_file_write_offset, final long initial_file_write_length, Object originator) {
                boolean SS = true;
                final DiskManager disk_manager = this.getDiskManager();
                PEPeerManager peer_manager = this.getPeerManager();
                if (disk_manager == null || peer_manager == null) {
                    return;
                }
                final DiskManagerPiece[] origin_pieces = disk_manager.getPieces();
                final long origin_piece_length = this.piece_length;
                for (final SameSizeFileWrapper target_file : SameSizeFiles.this.file_wrappers) {
                    if (target_file == this || target_file.isSkipped() || target_file.isComplete()) continue;
                    final DiskManager target_disk_manager = target_file.getDiskManager();
                    PEPeerManager target_peer_manager = target_file.getPeerManager();
                    if (target_disk_manager == null || target_peer_manager == null) continue;
                    ((SameSizeFiles)SameSizeFiles.this).GlobalManagerFileMerger.this.read_write_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            int added_size;
                            if (target_file.isComplete()) {
                                return;
                            }
                            if (!GlobalManagerFileMerger.this.logging_paused) {
                                SameSizeFileWrapper.this.logFile("data write: " + SameSizeFileWrapper.this.getName() + "->" + target_file.getName() + ": offset=" + initial_file_write_offset + ", len=" + initial_file_write_length);
                            }
                            DiskManagerPiece[] target_pieces = target_disk_manager.getPieces();
                            long target_piece_length = target_file.piece_length;
                            long file_write_offset = initial_file_write_offset;
                            long file_write_length = initial_file_write_length;
                            if (file_write_offset + initial_file_write_length > SameSizeFileWrapper.this.file_length && (file_write_length = SameSizeFileWrapper.this.file_length - file_write_offset) <= 0L) {
                                return;
                            }
                            long origin_written_start = SameSizeFileWrapper.this.file_byte_offset + file_write_offset;
                            long origin_written_end_inclusive = origin_written_start + file_write_length - 1L;
                            int origin_first_piece_num = (int)(origin_written_start / origin_piece_length);
                            int origin_last_piece_num = (int)(origin_written_end_inclusive / origin_piece_length);
                            int origin_first_block = (int)(origin_written_start % origin_piece_length) / 16384;
                            int origin_last_block = (int)(origin_written_end_inclusive % origin_piece_length) / 16384;
                            int origin_block_offset = (int)(origin_written_start % 16384L);
                            if (origin_first_piece_num != SameSizeFileWrapper.this.first_piece_number || origin_first_block != SameSizeFileWrapper.this.first_piece_block_number) {
                                int prev_block_num = origin_first_block - 1;
                                int prev_piece_num = origin_first_piece_num;
                                DiskManagerPiece prev_piece = origin_pieces[origin_first_piece_num];
                                if (prev_block_num < 0) {
                                    prev_piece = origin_pieces[--prev_piece_num];
                                    prev_block_num = prev_piece.getNbBlocks() - 1;
                                }
                                if (prev_piece.isWritten(prev_block_num)) {
                                    added_size = prev_piece.getBlockSize(prev_block_num);
                                    file_write_offset -= (long)added_size;
                                    file_write_length += (long)added_size;
                                    origin_first_piece_num = prev_piece_num;
                                    origin_first_block = prev_block_num;
                                }
                            }
                            if (origin_last_piece_num != SameSizeFileWrapper.this.last_piece_number || origin_last_block != SameSizeFileWrapper.this.last_piece_block_number) {
                                int next_block_num = origin_last_block + 1;
                                int next_piece_num = origin_last_piece_num;
                                DiskManagerPiece next_piece = origin_pieces[origin_last_piece_num];
                                if (next_piece.getNbBlocks() <= next_block_num) {
                                    next_piece = origin_pieces[++next_piece_num];
                                    next_block_num = 0;
                                }
                                if (next_piece.isWritten(next_block_num)) {
                                    added_size = next_piece.getBlockSize(next_block_num);
                                    file_write_length += (long)added_size;
                                    origin_last_piece_num = next_piece_num;
                                    origin_last_block = next_block_num;
                                }
                            }
                            origin_written_start = SameSizeFileWrapper.this.file_byte_offset + file_write_offset;
                            origin_written_end_inclusive = origin_written_start + file_write_length - 1L;
                            long target_written_start = target_file.file_byte_offset + file_write_offset;
                            long target_written_end_inclusive = target_written_start + file_write_length - 1L;
                            int target_first_piece_num = (int)(target_written_start / target_piece_length);
                            int target_last_piece_num = (int)(target_written_end_inclusive / target_piece_length);
                            int target_first_block = (int)(target_written_start % target_piece_length) / 16384;
                            int target_last_block = (int)(target_written_end_inclusive % target_piece_length) / 16384;
                            int target_block_offset = (int)(target_written_start % 16384L);
                            int read_piece_num = origin_first_piece_num;
                            int read_block_num = origin_first_block;
                            int read_block_offset = origin_block_offset;
                            DiskManagerPiece read_piece = origin_pieces[read_piece_num];
                            int write_piece_num = target_first_piece_num;
                            int write_block_num = target_first_block;
                            int write_block_offset = target_block_offset;
                            DiskManagerPiece write_piece = target_pieces[write_piece_num];
                            boolean read_complete = false;
                            boolean write_complete = false;
                            DirectByteBuffer read_block = null;
                            DirectByteBuffer write_block = null;
                            try {
                                int consecutive_skips = 0;
                                while (!write_complete) {
                                    if (SameSizeFiles.this.destroyed) {
                                        break;
                                    }
                                    boolean check_written = true;
                                    boolean skip_block = write_piece.isDone();
                                    if (!skip_block) {
                                        if (write_piece_num == target_file.first_piece_number && write_block_num == target_file.first_piece_block_number || write_piece_num == target_file.last_piece_number && write_block_num == target_file.last_piece_block_number) {
                                            check_written = false;
                                        } else {
                                            boolean[] written = write_piece.getWritten();
                                            if (written != null && written[write_block_num]) {
                                                skip_block = true;
                                            }
                                        }
                                    }
                                    if (skip_block) {
                                        if (++consecutive_skips > 1) {
                                            ++read_block_num;
                                        } else {
                                            int relative_block_offset;
                                            int read_ahead = -1;
                                            if (read_block != null) {
                                                read_ahead = read_block.remaining((byte)1);
                                                read_block.returnToPool();
                                                read_block = null;
                                            }
                                            if ((relative_block_offset = origin_block_offset - target_block_offset) == 0) {
                                                read_block_offset = 0;
                                                ++read_block_num;
                                            } else if (read_ahead > 0) {
                                                read_block_offset = 16384 - read_ahead;
                                            } else if (relative_block_offset < 0) {
                                                read_block_offset = read_piece.getBlockSize(read_block_num) + relative_block_offset;
                                            } else {
                                                read_block_offset = relative_block_offset;
                                                ++read_block_num;
                                            }
                                        }
                                        if (read_piece_num == origin_last_piece_num && read_block_num > origin_last_block) {
                                            break;
                                        }
                                        if (read_block_num == read_piece.getNbBlocks()) {
                                            read_piece = origin_pieces[++read_piece_num];
                                            read_block_num = 0;
                                        }
                                        write_block_offset = 0;
                                        if (write_piece_num == target_last_piece_num && ++write_block_num > target_last_block) {
                                            break;
                                        }
                                        if (write_block_num != write_piece.getNbBlocks()) continue;
                                        write_piece = target_pieces[++write_piece_num];
                                        write_block_num = 0;
                                        continue;
                                    }
                                    consecutive_skips = 0;
                                    if (write_block != null) {
                                        Debug.out("eh?");
                                        write_block.returnToPool();
                                        write_block = null;
                                    }
                                    write_block = DirectByteBufferPool.getBuffer((byte)1, write_piece.getBlockSize(write_block_num));
                                    int block_offset = write_block_offset;
                                    if (block_offset > 0) {
                                        write_block.position((byte)1, write_block.position((byte)1) + block_offset);
                                        write_block_offset = 0;
                                    }
                                    while (write_block.hasRemaining((byte)1)) {
                                        if (SameSizeFiles.this.destroyed) break;
                                        if (read_block == null) {
                                            if (read_complete || (read_block = disk_manager.readBlock(read_piece_num, read_block_num * 16384, read_piece.getBlockSize(read_block_num))) == null) break;
                                            if (read_piece_num == origin_last_piece_num && read_block_num == origin_last_block) {
                                                read_complete = true;
                                            } else if (++read_block_num == read_piece.getNbBlocks()) {
                                                read_piece = origin_pieces[++read_piece_num];
                                                read_block_num = 0;
                                            }
                                            if (read_block_offset > 0) {
                                                read_block.position((byte)1, read_block.position((byte)1) + read_block_offset);
                                                read_block_offset = 0;
                                            }
                                            read_piece.setMergeRead();
                                        }
                                        int write_space = write_block.remaining((byte)1);
                                        int read_remaining = read_block.remaining((byte)1);
                                        int read_limit = read_block.limit((byte)1);
                                        if (write_space < read_remaining) {
                                            read_block.limit((byte)1, read_block.position((byte)1) + write_space);
                                        }
                                        write_block.put((byte)1, read_block);
                                        read_block.limit((byte)1, read_limit);
                                        if (read_block.hasRemaining((byte)1)) continue;
                                        read_block.returnToPool();
                                        read_block = null;
                                    }
                                    boolean skip_incomplete = false;
                                    if (!(block_offset <= 0 && !write_block.hasRemaining((byte)1) || write_piece_num == target_file.first_piece_number && write_block_num == target_file.first_piece_block_number || write_piece_num == target_file.last_piece_number && write_block_num == target_file.last_piece_block_number)) {
                                        skip_incomplete = true;
                                    }
                                    write_block.position((byte)1, 0);
                                    boolean[] written = write_piece.getWritten();
                                    if (skip_incomplete || write_piece.isDone() || check_written && written != null && written[write_block_num]) {
                                        write_block.returnToPool();
                                        write_block = null;
                                    } else {
                                        if (!GlobalManagerFileMerger.this.logging_paused) {
                                            SameSizeFileWrapper.this.logFile("Write from " + read_piece_num + "/" + read_block_num + " to " + write_piece_num + "/" + write_block_num);
                                        }
                                        if (!target_file.writeBlock(write_piece, write_piece_num, write_block_num, write_block, block_offset)) {
                                            write_block.returnToPool();
                                            write_block = null;
                                            break;
                                        }
                                        write_block = null;
                                        write_piece.setMergeWrite();
                                        if (write_piece.isWritten()) {
                                            SameSizeFileWrapper sameSizeFileWrapper = SameSizeFileWrapper.this;
                                            sameSizeFileWrapper.pieces_completed = sameSizeFileWrapper.pieces_completed + 1;
                                            if (SameSizeFileWrapper.this.pieces_completed < 5) {
                                                try {
                                                    Thread.sleep(500L);
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                        }
                                    }
                                    if (write_piece_num == target_last_piece_num && write_block_num == target_last_block) {
                                        write_complete = true;
                                        continue;
                                    }
                                    if (++write_block_num != write_piece.getNbBlocks()) continue;
                                    write_piece = target_pieces[++write_piece_num];
                                    write_block_num = 0;
                                }
                            }
                            finally {
                                if (read_block != null) {
                                    read_block.returnToPool();
                                }
                                if (write_block != null) {
                                    write_block.returnToPool();
                                }
                            }
                        }
                    });
                }
            }

            /*
             * Exception decompiling
             */
            boolean writeBlock(DiskManagerPiece piece, int piece_number, int block_number, DirectByteBuffer buffer, int block_offset) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            void pieceCorrupt(int piece_number) {
                int first_piece = this.file.getFirstPieceNumber();
                if (piece_number >= first_piece && piece_number <= this.file.getLastPieceNumber() && this.modified_pieces[piece_number - first_piece]) {
                    ++this.pieces_corrupted;
                    this.logFile("piece " + piece_number + " corrupt, bad=" + this.pieces_corrupted + ", good=" + this.pieces_completed);
                    if (this.pieces_corrupted >= this.hash_fails_allowed) {
                        SameSizeFiles.this.abandon(this);
                    }
                }
            }

            boolean forceRange(int for_piece, long start_in_file, long end_in_file_exclusive) {
                DiskManager dm = this.getDiskManager();
                PEPeerManager pm = this.getPeerManager();
                if (dm == null || pm == null) {
                    return false;
                }
                int[] availability = pm.getAvailability();
                long start_in_torrent = start_in_file + this.file_byte_offset;
                long end_in_torrent_inclusive = end_in_file_exclusive + this.file_byte_offset - 1L;
                int piece_size = dm.getPieceLength();
                int first_piece = (int)(start_in_torrent / (long)piece_size);
                int last_piece = (int)(end_in_torrent_inclusive / (long)piece_size);
                DiskManagerPiece[] pieces = dm.getPieces();
                boolean forceable = false;
                int i = first_piece;
                while (i <= last_piece) {
                    DiskManagerPiece piece = pieces[i];
                    if (!piece.isDone() && availability[piece.getPieceNumber()] > 0 && piece.isInteresting()) {
                        forceable = true;
                        break;
                    }
                    ++i;
                }
                if (forceable) {
                    if (this.forced_start_piece != first_piece || this.forced_end_piece != last_piece) {
                        DiskManagerPiece piece;
                        PiecePicker pp = pm.getPiecePicker();
                        if (this.forced_start_piece != first_piece || this.forced_end_piece != last_piece) {
                            int i2 = this.forced_start_piece;
                            while (i2 <= this.forced_end_piece) {
                                piece = pieces[i2];
                                pp.setForcePiece(piece.getPieceNumber(), false);
                                ++i2;
                            }
                        }
                        this.forced_start_piece = first_piece;
                        this.forced_end_piece = last_piece;
                        int i3 = first_piece;
                        while (i3 <= last_piece) {
                            piece = pieces[i3];
                            if (!piece.isDone()) {
                                pp.setForcePiece(i3, true);
                            }
                            ++i3;
                        }
                        if (!GlobalManagerFileMerger.this.logging_paused) {
                            this.logFile("Forced pieces for " + for_piece + ": " + this.forced_start_piece + " -> " + this.forced_end_piece + " in " + this.download_manager.getDisplayName() + "/" + this.file.getTorrentFile().getRelativePath());
                        }
                    }
                    return true;
                }
                return false;
            }

            long getMergedByteCount() {
                return this.merged_byte_counnt;
            }

            String getInfo() {
                return "merged=" + DisplayFormatters.formatByteCountToKiBEtc(this.merged_byte_counnt) + ", ok=" + this.pieces_completed + ", bad=" + this.pieces_corrupted + ", force=[" + (this.forced_end_piece == -1 ? "" : String.valueOf(this.forced_start_piece) + "-" + this.forced_end_piece) + "]";
            }

            private String getName() {
                return String.valueOf(this.file.getFile(true).getName()) + "[" + this.wrapper_num + "]";
            }

            private void logFile(String str) {
                GlobalManagerFileMerger.this.log(String.valueOf(this.getName()) + ": " + str);
            }

            private void logCurrentState(IndentWriter writer) {
                GlobalManagerFileMerger.this.log(writer, "      " + (writer == null ? this.getName() : Debug.secretFileName(this.getName())) + ": " + this.getInfo());
            }
        }
    }
}

