/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.html.impl;

import com.biglybt.core.html.HTMLException;
import com.biglybt.core.html.HTMLPage;
import com.biglybt.core.html.impl.HTMLChunkImpl;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class HTMLPageImpl
extends HTMLChunkImpl
implements HTMLPage {
    public HTMLPageImpl(InputStream is, String charset, boolean close_file) throws HTMLException {
        BufferedReader br = null;
        StringBuilder res = new StringBuilder(1024);
        try {
            try {
                String line;
                br = charset == null ? new BufferedReader(new InputStreamReader(is)) : new BufferedReader(new InputStreamReader(is, charset));
                while ((line = br.readLine()) != null) {
                    res.append(line);
                }
                this.setContent(res.toString());
            }
            catch (IOException e) {
                throw new HTMLException("Error reading HTML page", e);
            }
        }
        finally {
            if (br != null && close_file) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public URL getMetaRefreshURL() {
        return this.getMetaRefreshURL(null);
    }

    @Override
    public URL getMetaRefreshURL(URL base_url) {
        String[] tags = this.getTags("META");
        int i = 0;
        while (i < tags.length) {
            int e1;
            String tag = tags[i];
            String lc_tag = tag.toLowerCase(MessageText.LOCALE_ENGLISH);
            int pos = lc_tag.indexOf("http-equiv=\"refresh\"");
            int url_start = lc_tag.indexOf("url=");
            if (pos != -1 && url_start != -1 && (e1 = lc_tag.indexOf("\"", url_start += 4)) != -1) {
                try {
                    String mr_url = tag.substring(url_start, e1).trim();
                    String lc = mr_url.toLowerCase();
                    if (!lc.startsWith("http:") && !lc.startsWith("https:") && base_url != null) {
                        String s = base_url.toExternalForm();
                        int p = s.indexOf(63);
                        if (p != -1) {
                            s = s.substring(0, p);
                        }
                        if (s.endsWith("/") && mr_url.startsWith("/")) {
                            mr_url = mr_url.substring(1);
                        }
                        mr_url = String.valueOf(s) + mr_url;
                    }
                    return new URL(mr_url);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
        return null;
    }
}

