/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.instancemanager.impl;

import com.biglybt.core.instancemanager.ClientInstance;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;

public abstract class ClientInstanceImpl
implements ClientInstance {
    protected ClientInstanceImpl() {
    }

    protected void encode(Map<String, Object> map) {
        map.put("id", this.getID().getBytes());
        map.put("ai", this.getApplicationID().getBytes());
        map.put("iip", this.getInternalAddress().getHostAddress().getBytes());
        map.put("eip", this.getExternalAddress().getHostAddress().getBytes());
        map.put("tp", new Long(this.getTCPListenPort()));
        map.put("dp", new Long(this.getUDPListenPort()));
        map.put("dp2", new Long(this.getUDPNonDataListenPort()));
        Map<String, Object> props = this.getProperties();
        if (props != null) {
            map.put("pr", props);
        }
    }

    @Override
    public String getString() {
        String id = this.getID();
        if (id.length() > 8) {
            id = String.valueOf(id.substring(0, 8)) + "...";
        }
        List<InetAddress> internal_addresses = this.getInternalAddresses();
        String int_str = "";
        for (InetAddress ia : internal_addresses) {
            int_str = String.valueOf(int_str) + (int_str.isEmpty() ? "" : ";") + ia.getHostAddress();
        }
        return "id=" + id + ",ap=" + this.getApplicationID() + ",int=" + int_str + ",ext=" + this.getExternalAddress().getHostAddress() + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",udp2=" + this.getUDPNonDataListenPort() + ",props=" + this.getProperties();
    }
}

