/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.internat;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.IntegratedResourceBundle;
import com.biglybt.core.internat.StringSupplier;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageText {
    public static final Locale LOCALE_ENGLISH = Locale.ENGLISH;
    public static final Locale LOCALE_DEFAULT = Locale.ROOT;
    private static final boolean LOG_MISSING_MESSAGES = System.getProperty("log.missing.messages", "0").equals("1");
    private static Locale LOCALE_CURRENT = LOCALE_DEFAULT;
    static final String BUNDLE_NAME;
    public static final Map<String, String> CONSTANTS;
    public static final String DEFAULT_BUNDLE_NAME = "com.biglybt.internat.MessagesBundle";
    private static final Map pluginLocalizationPaths;
    private static final Collection pluginResourceBundles;
    static IntegratedResourceBundle RESOURCE_BUNDLE;
    private static Set platform_specific_keys;
    private static final Pattern PAT_PARAM_ALPHA;
    private static int bundle_fail_count;
    private static final List listeners;
    private static final String PLATFORM_SUFFIX;
    private static IntegratedResourceBundle DEFAULT_BUNDLE;
    private static final Map<String, Locale> substitutes;

    static {
        CONSTANTS = new HashMap<String, String>();
        BUNDLE_NAME = System.getProperty("az.factory.internat.bundle", DEFAULT_BUNDLE_NAME);
        MessageText.updateProductName();
        pluginLocalizationPaths = new HashMap();
        pluginResourceBundles = new ArrayList();
        platform_specific_keys = new HashSet();
        PAT_PARAM_ALPHA = Pattern.compile("(\\{([^0-9].+?)\\})");
        bundle_fail_count = 0;
        listeners = new ArrayList();
        PLATFORM_SUFFIX = Constants.isOSX ? "._mac" : (Constants.isLinux ? "._linux" : (Constants.isUnix ? "._unix" : (Constants.isFreeBSD ? "._freebsd" : (Constants.isSolaris ? "._solaris" : (Constants.isWindows ? "._windows" : "._unknown")))));
        if (System.getProperty("SKIP_SETRB", "0").equals("0")) {
            MessageText.setResourceBundle(new IntegratedResourceBundle(MessageText.getResourceBundle(BUNDLE_NAME, LOCALE_DEFAULT, MessageText.class.getClassLoader()), pluginLocalizationPaths, null, 4000, true));
        }
        DEFAULT_BUNDLE = RESOURCE_BUNDLE;
        substitutes = new HashMap<String, Locale>();
        if (new Locale("vls", "BE").getDisplayLanguage().equals("vls")) {
            substitutes.put("vls_BE", new Locale("nl", "BE"));
        }
    }

    public static void updateProductName() {
        CONSTANTS.put("base.product.name", Constants.APP_NAME);
        CONSTANTS.put("base.wiki.url", "https://wiki.biglybt.com/");
        CONSTANTS.put("base.client.url", "https://www.biglybt.com/");
        CONSTANTS.put("Alert.failed.update.url", "https://wiki.biglybt.com/w/Failed_Update");
        CONSTANTS.put("alltrackers.link.url", "https://wiki.biglybt.com/w/AllTrackersView");
        CONSTANTS.put("restart.error.url", "https://wiki.biglybt.com/w/Restarting_Issues");
        CONSTANTS.put("unix.script.new.manual.url", "https://wiki.biglybt.com/w/Unix_Startup_Script");
        CONSTANTS.put("wiki.fat32", "https://wiki.biglybt.com/w/FAT32_file_size_limit");
        CONSTANTS.put("url.wiki.app.disappears", "https://wiki.biglybt.com/w/Vuze_disappears");
        CONSTANTS.put("url.wiki.failed.update", "https://wiki.biglybt.com/w/Failed_Update");
        CONSTANTS.put("url.wiki.swt.cant.autoupdate", "https://wiki.biglybt.com/w/SWT_Cant_Auto_Update");
        CONSTANTS.put("faq.legal.url", "https://wiki.biglybt.com/w/FAQ_Legal");
    }

    public static void loadBundle() {
        MessageText.loadBundle(false);
    }

    public static void loadBundle(boolean forceReload) {
        Locale old_locale = MessageText.getCurrentLocale();
        String savedLocaleString = COConfigurationManager.getStringParameter("locale");
        Locale savedLocale = MessageText.parseFormattedLocaleString(savedLocaleString);
        if (!Locale.ROOT.equals(savedLocale)) {
            MessageText.changeLocale(savedLocale, forceReload);
        }
        COConfigurationManager.setParameter("locale.set.complete.count", COConfigurationManager.getIntParameter("locale.set.complete.count") + 1);
        Locale new_locale = MessageText.getCurrentLocale();
        if (!old_locale.equals(new_locale) || forceReload) {
            int i = 0;
            while (i < listeners.size()) {
                try {
                    ((MessageTextListener)listeners.get(i)).localeChanged(old_locale, new_locale);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    public static void addListener(MessageTextListener listener) {
        listeners.add(listener);
    }

    public static void addAndFireListener(MessageTextListener listener) {
        listeners.add(listener);
        listener.localeChanged(MessageText.getCurrentLocale(), MessageText.getCurrentLocale());
    }

    public static void removeListener(MessageTextListener listener) {
        listeners.remove(listener);
    }

    static ResourceBundle getResourceBundle(String name, Locale loc, ClassLoader cl) {
        try {
            return ResourceBundle.getBundle(name, loc, cl);
        }
        catch (Throwable e) {
            if (++bundle_fail_count == 1) {
                e.printStackTrace();
                Logger.log(new LogAlert(true, 3, "Failed to load resource bundle. One possible cause is that you have installed " + Constants.APP_NAME + " into a directory " + "with a '!' in it. If so, please remove the '!'."));
            }
            return new ResourceBundle(){

                @Override
                public Locale getLocale() {
                    return LOCALE_DEFAULT;
                }

                @Override
                protected Object handleGetObject(String key) {
                    return null;
                }

                public Enumeration getKeys() {
                    return new Vector().elements();
                }
            };
        }
    }

    private static void setResourceBundle(IntegratedResourceBundle bundle) {
        RESOURCE_BUNDLE = bundle;
        Iterator keys = RESOURCE_BUNDLE.getKeysLight();
        String ui_suffix = MessageText.getUISuffix();
        HashSet<String> platformKeys = new HashSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.endsWith(PLATFORM_SUFFIX)) {
                platformKeys.add(key);
                continue;
            }
            if (!key.endsWith(ui_suffix)) continue;
            RESOURCE_BUNDLE.addString(key.substring(0, key.length() - ui_suffix.length()), RESOURCE_BUNDLE.getString(key));
        }
        platform_specific_keys = platformKeys;
    }

    public static boolean keyExists(String key) {
        try {
            MessageText.getResourceBundleString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static boolean keyExistsForDefaultLocale(String key) {
        try {
            DEFAULT_BUNDLE.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getString(String key, String sDefault) {
        if (key == null || key.length() == 0) {
            return "";
        }
        if (key.startsWith("!") && key.endsWith("!")) {
            return MessageText.expandValue(key.substring(1, key.length() - 1));
        }
        String target_key = String.valueOf(key) + PLATFORM_SUFFIX;
        if (!platform_specific_keys.contains(target_key)) {
            target_key = key;
        }
        try {
            return MessageText.getResourceBundleString(target_key);
        }
        catch (MissingResourceException e) {
            return MessageText.getPlatformNeutralString(key, sDefault);
        }
    }

    public static String getString(String key) {
        if (key == null || key.length() == 0) {
            return "";
        }
        if (key.startsWith("!") && key.endsWith("!")) {
            return MessageText.expandValue(key.substring(1, key.length() - 1));
        }
        String target_key = String.valueOf(key) + PLATFORM_SUFFIX;
        if (!platform_specific_keys.contains(target_key)) {
            target_key = key;
        }
        try {
            return MessageText.getResourceBundleString(target_key);
        }
        catch (MissingResourceException e) {
            return MessageText.getPlatformNeutralString(key);
        }
    }

    public static String getPlatformNeutralString(String key) {
        try {
            return MessageText.getResourceBundleString(key);
        }
        catch (MissingResourceException e) {
            if (key.startsWith("!") && key.endsWith("!")) {
                return MessageText.expandValue(key.substring(1, key.length() - 1));
            }
            if (LOG_MISSING_MESSAGES) {
                System.err.println("Missing message key '" + key + "' via " + Debug.getCompressedStackTraceSkipFrames(2));
            }
            return String.valueOf('!') + key + '!';
        }
    }

    public static String getPlatformNeutralString(String key, String sDefault) {
        try {
            return MessageText.getResourceBundleString(key);
        }
        catch (MissingResourceException e) {
            if (key.startsWith("!") && key.endsWith("!")) {
                return MessageText.expandValue(key.substring(1, key.length() - 1));
            }
            return sDefault;
        }
    }

    private static String getResourceBundleString(String key) {
        if (key == null) {
            return "";
        }
        String defaultValue = CONSTANTS.get(key);
        String value = defaultValue != null ? String.valueOf(defaultValue) : RESOURCE_BUNDLE.getString(key);
        return MessageText.expandValue(value);
    }

    public static String expandValue(String value) {
        if (value != null && value.indexOf(125) > 0) {
            Matcher matcher = PAT_PARAM_ALPHA.matcher(value);
            while (matcher.find()) {
                String key = matcher.group(2);
                String expression = matcher.group(1);
                String text = null;
                try {
                    text = MessageText.getResourceBundleString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (text == null) continue;
                value = value.replace(expression, text);
            }
        }
        return value;
    }

    private static String getUISuffix() {
        return "az2".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui")) ? "._classic" : "._vuze";
    }

    public static String getString(String key, String[] params) {
        String res = MessageText.getString(key, null);
        if (res == null) {
            if (LOG_MISSING_MESSAGES) {
                System.err.println("Missing message key '" + key + "', params " + Arrays.toString(params));
            }
            if (params == null || params.length == 0) {
                return "!" + key + "!";
            }
            return "!" + key + "(" + Arrays.toString(params) + ")" + "!";
        }
        if (params == null || params.length == 0) {
            return res;
        }
        int i = 0;
        while (i < params.length) {
            String from_str = "%" + (i + 1);
            String to_str = params[i];
            if (to_str == null) {
                to_str = "<null>";
            }
            to_str = to_str.replace('%', '\ufde5');
            res = MessageText.replaceStrings(res, from_str, to_str);
            ++i;
        }
        return res.replace('\ufde5', '%');
    }

    protected static String replaceStrings(String str, String f_s, String t_s) {
        int pos = 0;
        String res = "";
        while (pos < str.length()) {
            int p1 = str.indexOf(f_s, pos);
            if (p1 == -1) {
                res = String.valueOf(res) + str.substring(pos);
                break;
            }
            res = String.valueOf(res) + str.substring(pos, p1) + t_s;
            pos = p1 + f_s.length();
        }
        return res;
    }

    public static String getDefaultLocaleString(String key) {
        try {
            return DEFAULT_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            if (key.startsWith("!") && key.endsWith("!")) {
                return key.substring(1, key.length() - 1);
            }
            return String.valueOf('!') + key + '!';
        }
    }

    public static Locale getCurrentLocale() {
        return LOCALE_DEFAULT.equals(LOCALE_CURRENT) ? LOCALE_ENGLISH : LOCALE_CURRENT;
    }

    public static boolean isCurrentLocale(Locale locale) {
        return LOCALE_ENGLISH.equals(locale) ? LOCALE_CURRENT.equals(LOCALE_DEFAULT) : LOCALE_CURRENT.equals(locale);
    }

    public static Locale[] getLocales(boolean sort) {
        File appDir;
        String[] appBundles;
        String bundleFolder = BUNDLE_NAME.replace('.', '/');
        final String prefix = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
        String extension = ".properties";
        String urlString = MessageText.class.getClassLoader().getResource(bundleFolder.concat(".properties")).toExternalForm();
        String[] bundles = null;
        if (urlString.startsWith("jar:file:")) {
            File jar = FileUtil.getJarFileFromURL(urlString);
            if (jar != null) {
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (JarFile jarFile = new JarFile(jar);){
                        Enumeration<JarEntry> entries = jarFile.entries();
                        ArrayList<String> list = new ArrayList<String>(250);
                        while (entries.hasMoreElements()) {
                            JarEntry jarEntry = entries.nextElement();
                            if (!jarEntry.getName().startsWith(bundleFolder) || !jarEntry.getName().endsWith(".properties")) continue;
                            list.add(jarEntry.getName().substring(bundleFolder.length() - prefix.length()));
                        }
                        bundles = list.toArray(new String[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            File bundleDirectory = FileUtil.newFile(URI.create(urlString)).getParentFile();
            bundles = bundleDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix) && name.endsWith(".properties");
                }
            });
        }
        HashSet bundleSet = new HashSet();
        File localDir = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
        String[] localBundles = localDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(".properties");
            }
        });
        if (localBundles != null) {
            Collections.addAll(bundleSet, localBundles);
        }
        if ((appBundles = (appDir = FileUtil.newFile(SystemProperties.getApplicationPath(), new String[0])).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(".properties");
            }
        })) != null) {
            Collections.addAll(bundleSet, appBundles);
        }
        Collections.addAll(bundleSet, bundles);
        ArrayList<Locale> foundLocalesList = new ArrayList<Locale>(bundleSet.size());
        foundLocalesList.add(LOCALE_ENGLISH);
        for (String sBundle : bundleSet) {
            String locale;
            Locale parsedLocale;
            if (prefix.length() + 1 >= sBundle.length() - ".properties".length() || Locale.ROOT.equals(parsedLocale = MessageText.parseFormattedLocaleString(locale = sBundle.substring(prefix.length() + 1, sBundle.length() - ".properties".length())))) continue;
            foundLocalesList.add(parsedLocale);
        }
        Locale[] foundLocales = foundLocalesList.toArray(new Locale[0]);
        if (sort) {
            try {
                Arrays.sort(foundLocales, new Comparator<Locale>(){

                    @Override
                    public final int compare(Locale a, Locale b) {
                        a = MessageText.getDisplaySubstitute(a);
                        b = MessageText.getDisplaySubstitute(b);
                        return a.getDisplayName(a).compareToIgnoreCase(b.getDisplayName(b));
                    }
                });
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return foundLocales;
    }

    public static boolean changeLocale(Locale newLocale) {
        return MessageText.changeLocale(newLocale, false);
    }

    private static boolean changeLocale(Locale newLocale, boolean force) {
        Locale.setDefault(newLocale);
        if (!MessageText.isCurrentLocale(newLocale) || force) {
            ResourceBundle newResourceBundle;
            block14: {
                URL u;
                File appBundleFile;
                File userBundleFile;
                String prefix;
                block13: {
                    Locale.setDefault(LOCALE_DEFAULT);
                    newResourceBundle = null;
                    String bundleFolder = BUNDLE_NAME.replace('.', '/');
                    prefix = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
                    String extension = ".properties";
                    if (newLocale.equals(LOCALE_ENGLISH)) {
                        newLocale = LOCALE_DEFAULT;
                    }
                    userBundleFile = FileUtil.newFile(SystemProperties.getUserPath(), new String[0]);
                    appBundleFile = FileUtil.newFile(SystemProperties.getApplicationPath(), new String[0]);
                    ClassLoader cl = MessageText.class.getClassLoader();
                    u = cl.getResource(String.valueOf(bundleFolder) + ".properties");
                    if (u != null) break block13;
                    return false;
                }
                try {
                    String sJar = u.toString();
                    sJar = sJar.substring(0, sJar.length() - prefix.length() - ".properties".length());
                    URL jarURL = new URL(sJar);
                    URL[] urls = new URL[]{userBundleFile.toURI().toURL(), appBundleFile.toURI().toURL(), jarURL};
                    newResourceBundle = MessageText.getResourceBundle("MessagesBundle", newLocale, new URLClassLoader(urls));
                    if (newResourceBundle.getLocale().getLanguage().equals(newLocale.getLanguage()) || newLocale.getCountry().equals("")) break block14;
                    Locale foundLocale = newResourceBundle.getLocale();
                    System.out.println("changeLocale: " + (foundLocale.toString().equals("") ? "*Default Language*" : foundLocale.getDisplayLanguage()) + " != " + newLocale.getDisplayName() + ". Searching without country..");
                    Locale localeJustLang = new Locale(newLocale.getLanguage());
                    newResourceBundle = MessageText.getResourceBundle("MessagesBundle", localeJustLang, new URLClassLoader(urls));
                    if (newResourceBundle != null && newResourceBundle.getLocale().getLanguage().equals(localeJustLang.getLanguage())) break block14;
                    System.out.println("changeLocale: Searching for language " + newLocale.getDisplayLanguage() + " in *any* country..");
                    Locale[] locales = MessageText.getLocales(false);
                    int i = 0;
                    while (i < locales.length) {
                        if (locales[i].getLanguage().equals(newLocale.getLanguage())) {
                            newResourceBundle = MessageText.getResourceBundle("MessagesBundle", locales[i], new URLClassLoader(urls));
                            break;
                        }
                        ++i;
                    }
                }
                catch (MissingResourceException e) {
                    System.out.println("changeLocale: no resource bundle for " + newLocale);
                    Debug.printStackTrace(e);
                    return false;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            if (newResourceBundle != null) {
                if (!newLocale.equals(LOCALE_DEFAULT) && !newResourceBundle.getLocale().equals(newLocale)) {
                    String sNewLanguage = newResourceBundle.getLocale().getDisplayName();
                    if (sNewLanguage == null || sNewLanguage.trim().equals("")) {
                        sNewLanguage = "English (default)";
                    }
                    System.out.println("changeLocale: no message properties for Locale '" + newLocale.getDisplayName() + "' (" + newLocale + "), using '" + sNewLanguage + "'");
                    if (newResourceBundle.getLocale().equals(RESOURCE_BUNDLE.getLocale())) {
                        return false;
                    }
                }
                Locale.setDefault((newLocale = newResourceBundle.getLocale()).equals(LOCALE_DEFAULT) ? LOCALE_ENGLISH : newLocale);
                LOCALE_CURRENT = newLocale;
                MessageText.setResourceBundle(new IntegratedResourceBundle(newResourceBundle, pluginLocalizationPaths, null, 4000, true));
                if (newLocale.equals(LOCALE_DEFAULT)) {
                    DEFAULT_BUNDLE = RESOURCE_BUNDLE;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integratePluginMessages(String localizationPath, ClassLoader classLoader) {
        boolean integratedSuccessfully = false;
        if (localizationPath != null && localizationPath.length() != 0) {
            Map map = pluginLocalizationPaths;
            synchronized (map) {
                pluginLocalizationPaths.put(localizationPath, classLoader);
            }
            RESOURCE_BUNDLE.addPluginBundle(localizationPath, classLoader);
            MessageText.setResourceBundle(RESOURCE_BUNDLE);
            integratedSuccessfully = true;
        }
        return integratedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integratePluginMessages(ResourceBundle bundle) {
        Collection collection = pluginResourceBundles;
        synchronized (collection) {
            pluginResourceBundles.add(bundle);
        }
        RESOURCE_BUNDLE.addResourceMessages(bundle, true);
        MessageText.setResourceBundle(RESOURCE_BUNDLE);
        return true;
    }

    public static Locale getDisplaySubstitute(Locale l) {
        if (substitutes.isEmpty()) {
            return l;
        }
        Locale res = substitutes.get(String.valueOf(l.getLanguage()) + "_" + l.getCountry());
        if (res != null) {
            return res;
        }
        return l;
    }

    static Locale parseFormattedLocaleString(String savedLocaleString) {
        boolean hasScript;
        Locale.Builder localeBuilder = new Locale.Builder();
        String[] savedLocaleStrings = savedLocaleString.split("_", 3);
        if (savedLocaleStrings.length < 1 || savedLocaleStrings.length > 3) {
            return Locale.ROOT;
        }
        localeBuilder.setLanguage(savedLocaleStrings[0]);
        if (savedLocaleStrings.length == 1) {
            return localeBuilder.build();
        }
        boolean bl = hasScript = savedLocaleStrings[1].length() == 4;
        if (hasScript) {
            localeBuilder.setScript(savedLocaleStrings[1]);
        } else {
            localeBuilder.setRegion(savedLocaleStrings[1]);
            if (savedLocaleStrings.length == 3) {
                try {
                    localeBuilder.setVariant(savedLocaleStrings[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return localeBuilder.build();
    }

    public static StringSupplier getStringProvider(final String key, final String ... params) {
        return new StringSupplier(){

            @Override
            public String get() {
                return MessageText.getString(key, params);
            }

            public String toString() {
                return "key=" + key;
            }
        };
    }

    public static interface MessageTextListener {
        public void localeChanged(Locale var1, Locale var2);
    }
}

