/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.ipfilter.BadIp;
import com.biglybt.core.ipfilter.BadIps;
import com.biglybt.core.ipfilter.impl.BadIpImpl;
import com.biglybt.core.util.AEMonitor;
import java.util.HashMap;
import java.util.Map;

public class BadIpsImpl
implements BadIps {
    private static BadIps instance;
    private static final AEMonitor class_mon;
    private final Map<String, BadIpImpl> bad_ip_map;
    private final AEMonitor bad_ip_map_mon = new AEMonitor("BadIps:Map");

    static {
        class_mon = new AEMonitor("BadIps:class");
    }

    public static BadIps getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new BadIpsImpl();
            }
            BadIps badIps = instance;
            return badIps;
        }
        finally {
            class_mon.exit();
        }
    }

    public BadIpsImpl() {
        this.bad_ip_map = new HashMap<String, BadIpImpl>();
    }

    @Override
    public int addWarningForIp(String ip) {
        try {
            this.bad_ip_map_mon.enter();
            BadIpImpl bad_ip = this.bad_ip_map.get(ip);
            if (bad_ip == null) {
                bad_ip = new BadIpImpl(ip);
                this.bad_ip_map.put(ip, bad_ip);
            }
            int n = bad_ip.incrementWarnings();
            return n;
        }
        finally {
            this.bad_ip_map_mon.exit();
        }
    }

    @Override
    public int getNbWarningForIp(String ip) {
        try {
            this.bad_ip_map_mon.enter();
            BadIpImpl bad_ip = this.bad_ip_map.get(ip);
            if (bad_ip == null) {
                return 0;
            }
            int n = bad_ip.getNumberOfWarnings();
            return n;
        }
        finally {
            this.bad_ip_map_mon.exit();
        }
    }

    @Override
    public BadIp[] getBadIps() {
        try {
            this.bad_ip_map_mon.enter();
            BadIp[] res = new BadIp[this.bad_ip_map.size()];
            this.bad_ip_map.values().toArray(res);
            BadIp[] badIpArray = res;
            return badIpArray;
        }
        finally {
            this.bad_ip_map_mon.exit();
        }
    }

    @Override
    public boolean removeBadIp(String ip) {
        try {
            this.bad_ip_map_mon.enter();
            boolean bl = this.bad_ip_map.remove(ip) != null;
            return bl;
        }
        finally {
            this.bad_ip_map_mon.exit();
        }
    }

    @Override
    public void clearBadIps() {
        try {
            this.bad_ip_map_mon.enter();
            this.bad_ip_map.clear();
        }
        finally {
            this.bad_ip_map_mon.exit();
        }
    }

    @Override
    public int getNbBadIps() {
        return this.bad_ip_map.size();
    }
}

