/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.ipfilter.impl.IpFilterImpl;
import com.biglybt.core.ipfilter.impl.IpRangeImpl;
import com.biglybt.core.ipfilter.impl.IpRangeV4Impl;
import com.biglybt.core.ipfilter.impl.IpRangeV6Impl;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class IpFilterAutoLoaderImpl {
    static final LogIDs LOGID = LogIDs.CORE;
    public static final String CFG_AUTOLOAD_LAST = "Ip Filter Autoload Last Date";
    static final AEMonitor class_mon = new AEMonitor("IpFilterAutoLoaderImpl:class");
    private Object timerEventFilterReload;
    final IpFilterImpl ipFilter;

    public IpFilterAutoLoaderImpl(IpFilterImpl ipFilter) {
        this.ipFilter = ipFilter;
        COConfigurationManager.addParameterListener("Ip Filter Autoload Days", parameterName -> this.setNextAutoDownload(false));
    }

    /*
     * Unable to fully structure code
     */
    private void loadDATFilters(InputStream fin) {
        block46: {
            try {
                block45: {
                    IpFilterAutoLoaderImpl.class_mon.enter();
                    new_ipRanges = new ArrayList<IpRangeV4Impl>(1024);
                    streamReader = null;
                    reader = null;
                    try {
                        try {
                            pattern = Pattern.compile("^(.*):([0-9\\.]+)[^0-9]+([0-9\\.]+).*");
                            parseMode = -1;
                            streamReader = new InputStreamReader(fin, "utf8");
                            reader = new BufferedReader(streamReader);
                            numConsecutiveUnknowns = 0;
                            while (numConsecutiveUnknowns < 1000) {
                                line = reader.readLine();
                                if (line == null) break block45;
                                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                                description = "";
                                startIp = null;
                                endIp = null;
                                level = 0;
                                if (parseMode <= 0 || parseMode == 1) {
                                    matcher = pattern.matcher(line);
                                    if (matcher.find()) {
                                        if (parseMode != 1) {
                                            parseMode = 1;
                                        }
                                        description = matcher.group(1);
                                        startIp = matcher.group(2);
                                        endIp = matcher.group(3);
                                    } else {
                                        Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, 1, "unrecognized line while reading ip filter: " + line));
                                    }
                                }
                                if (parseMode != 1) {
                                    if (parseMode != 2) {
                                        parseMode = 2;
                                    }
                                    if ((sections = line.split(" *[-,] *", 4)).length >= 2 && (sections[0].indexOf(46) < 0 || sections[1].indexOf(46) < 0 || sections[0].length() > 15 || sections[1].length() > 15 || sections[0].length() < 7 || sections[1].length() < 7)) {
                                        ++numConsecutiveUnknowns;
                                        continue;
                                    }
                                    if (sections.length >= 4) {
                                        startIp = sections[0];
                                        endIp = sections[1];
                                        description = sections[3];
                                        try {
                                            level = Integer.parseInt(sections[2]);
                                        }
                                        catch (NumberFormatException e) {
                                            description = String.valueOf(sections[2]) + " " + description;
                                        }
                                        i = 4;
                                        while (i < sections.length) {
                                            description = String.valueOf(description) + " " + sections[i];
                                            ++i;
                                        }
                                        numConsecutiveUnknowns = 0;
                                    } else if (sections.length == 3) {
                                        startIp = sections[0];
                                        endIp = sections[1];
                                        description = sections[2];
                                        numConsecutiveUnknowns = 0;
                                    } else if (sections.length == 2) {
                                        startIp = sections[0];
                                        endIp = sections[1];
                                        numConsecutiveUnknowns = 0;
                                    } else {
                                        ++numConsecutiveUnknowns;
                                        continue;
                                    }
                                    if (level >= 128) continue;
                                }
                                if (startIp == null || endIp == null) continue;
                                ipRange = new IpRangeV4Impl(description, startIp, endIp, true);
                                ipRange.setAddedToRangeList(true);
                                new_ipRanges.add(ipRange);
                            }
                            break block45;
                        }
                        catch (IOException e) {
                            Debug.out(e);
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable var16_17) {
                                    // empty catch block
                                }
                            }
                            if (streamReader != null) {
                                try {
                                    streamReader.close();
                                }
                                catch (Throwable var16_18) {
                                    // empty catch block
                                }
                            }
                            it = new_ipRanges.iterator();
                            ** while (it.hasNext())
                        }
                    }
                    catch (Throwable var15_26) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        if (streamReader != null) {
                            try {
                                streamReader.close();
                            }
                            catch (Throwable it) {
                                // empty catch block
                            }
                        }
                        it = new_ipRanges.iterator();
                        ** while (it.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((IpRange)it.next()).checkValid();
                        continue;
lbl92:
                        // 1 sources

                        break block46;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((IpRange)it.next()).checkValid();
                        continue;
                    }
lbl110:
                    // 1 sources

                    throw var15_26;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable it) {
                        // empty catch block
                    }
                }
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (Throwable it) {
                        // empty catch block
                    }
                }
                it = new_ipRanges.iterator();
                while (it.hasNext()) {
                    ((IpRange)it.next()).checkValid();
                }
            }
            finally {
                IpFilterAutoLoaderImpl.class_mon.exit();
            }
        }
        this.ipFilter.markAsUpToDate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getP2BFileVersion(InputStream is) {
        try {
            int i = 0;
            while (i < 4) {
                int byteRead = is.read();
                if (byteRead != 255) {
                    return -1;
                }
                ++i;
            }
            byte[] MAGIC = new byte[]{80, 50, 66};
            int i2 = 0;
            while (i2 < MAGIC.length) {
                byte b = MAGIC[i2];
                if (b != is.read()) {
                    return -1;
                }
                ++i2;
            }
            int p2bVersion = is.read();
            Logger.log(new LogEvent(LOGID, "Log Filter: loading p2b version " + p2bVersion));
            return p2bVersion;
        }
        catch (IOException e) {
            Debug.out(e);
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void loadOtherFilters(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading) {
        setFileReloadTimer = false;
        try {
            IpFilterAutoLoaderImpl.class_mon.enter();
            new_ipRanges = new ArrayList<IpRangeImpl>(1024);
            try {
                isURL = this.loadIPv4(allowAsyncDownloading, loadOldWhileAsyncDownloading, new_ipRanges);
                if (!isURL) {
                    setFileReloadTimer = true;
                }
                if (!(isURL = this.loadIPv6(allowAsyncDownloading, loadOldWhileAsyncDownloading, new_ipRanges))) {
                    setFileReloadTimer = true;
                }
            }
            finally {
                it = new_ipRanges.iterator();
                if (true) ** GOTO lbl20
            }
            {
            }
            do {
                ((IpRangeImpl)it.next()).checkValid();
lbl20:
                // 2 sources

            } while (it.hasNext());
            if (setFileReloadTimer) {
                this.setFileReloadTimer();
            }
        }
        finally {
            IpFilterAutoLoaderImpl.class_mon.exit();
        }
        this.ipFilter.markAsUpToDate();
    }

    /*
     * Exception decompiling
     */
    private boolean loadIPv4(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading, List<IpRangeImpl> new_ipRanges) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 82[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadIPv6(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading, List<IpRangeImpl> new_ipRanges) {
        fin = null;
        bin = null;
        isURL = false;
        try {
            block57: {
                file = COConfigurationManager.getStringParameter("Ip Filter V6 Autoload File");
                Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, "IPv6 Filter file: " + file));
                filtersFile = FileUtil.newFile(file, new String[0]);
                if (filtersFile.exists()) {
                    isURL = false;
                } else {
                    if (!UrlUtils.isURL(file)) {
                        var20_10 = isURL;
                        return var20_10;
                    }
                    isURL = true;
                    filtersFile = FileUtil.getUserFile("ipfilterv6.dl");
                    if (filtersFile.exists()) {
                        if (allowAsyncDownloading) {
                            Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, "Downloading " + file + "  async"));
                            this.downloadFiltersAsync(new URL(file), false);
                            if (!loadOldWhileAsyncDownloading) {
                                var20_11 = isURL;
                                return var20_11;
                            }
                        }
                    } else {
                        Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, "sync Downloading " + file));
                        try {
                            rd = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(file));
                            fin = rd.download();
                            FileUtil.copyFile(fin, filtersFile);
                            this.setNextAutoDownload(true);
                        }
                        catch (ResourceDownloaderException e) {
                            var20_12 = isURL;
                            if (bin != null) {
                                try {
                                    bin.close();
                                }
                                catch (Throwable var21_18) {
                                    // empty catch block
                                }
                            }
                            if (fin == null) return var20_12;
                            try {
                                fin.close();
                                return var20_12;
                            }
                            catch (Throwable var21_19) {
                                // empty catch block
                            }
                            return var20_12;
                        }
                    }
                }
                fin = FileUtil.newFileInputStream(filtersFile);
                bin = new BufferedInputStream(fin, 16384);
                headerBytes = new byte[2];
                bin.mark(3);
                bin.read(headerBytes, 0, 2);
                bin.reset();
                if (headerBytes[1] != -117 || headerBytes[0] != 31) break block57;
                gzip = new GZIPInputStream(bin);
                filtersFile = FileUtil.getUserFile("ipfilterv6.ext");
                FileUtil.copyFile((InputStream)gzip, filtersFile);
                fin = FileUtil.newFileInputStream(filtersFile);
                bin = new BufferedInputStream(fin, 16384);
                ** GOTO lbl95
            }
            if (headerBytes[0] != 80 || headerBytes[1] != 75) ** GOTO lbl95
            largestSize = 0L;
            largestPos = -1L;
            zip = new ZipInputStream(bin);
            zipEntry = zip.getNextEntry();
            zipPos = 0;
            while (zipEntry != null) {
                ++zipPos;
                size = zipEntry.getSize();
                if (size > largestSize) {
                    largestPos = zipPos;
                }
                zipEntry = zip.getNextEntry();
            }
            if (largestPos < 0L) {
                var20_13 = isURL;
                return var20_13;
            }
            bin.close();
            fin.close();
            fin = FileUtil.newFileInputStream(filtersFile);
            bin = new BufferedInputStream(fin, 16384);
            zip = new ZipInputStream(bin);
            i = 0;
            while (true) {
                if ((long)i >= largestPos) {
                    filtersFile = FileUtil.getUserFile("ipfilterv6.ext");
                    FileUtil.copyFile((InputStream)zip, filtersFile);
                    fin = FileUtil.newFileInputStream(filtersFile);
                    bin = new BufferedInputStream(fin, 16384);
                    break;
                }
                zip.getNextEntry();
                ++i;
            }
lbl95:
            // 3 sources

            lnr = new LineNumberReader(new InputStreamReader((InputStream)bin, Constants.UTF_8));
            while (true) {
                if ((line = lnr.readLine()) == null) {
                    return isURL;
                }
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                bits = line.split(",", 2);
                if (bits.length != 2) {
                    Logger.log(new LogEvent(IpFilterAutoLoaderImpl.LOGID, 1, "unrecognized line while reading ip filter: " + line));
                    continue;
                }
                address = bits[0].trim();
                desc = bits[1].trim();
                ipRange = new IpRangeV6Impl(desc, address, "", true);
                ipRange.setAddedToRangeList(true);
                new_ipRanges.add(ipRange);
            }
        }
        catch (IOException e) {
            Debug.out(e);
            return isURL;
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Throwable var21_14) {}
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Throwable var21_15) {}
            }
        }
    }

    private void setFileReloadTimer() {
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addPeriodicEvent("IP Filter download", 60000L, new TimerEventPerformer(){
            long lastFileModified;
            long lastFileV6Modified;

            @Override
            public void perform(TimerEvent event2) {
                long fileModified;
                event2.cancel();
                boolean doReload = false;
                String file = COConfigurationManager.getStringParameter("Ip Filter Autoload File");
                File filtersFile = FileUtil.newFile(file, new String[0]);
                if (filtersFile.exists()) {
                    fileModified = filtersFile.lastModified();
                    if (this.lastFileModified == 0L) {
                        this.lastFileModified = fileModified;
                    } else if (this.lastFileModified != fileModified) {
                        doReload = true;
                    }
                }
                if ((filtersFile = FileUtil.newFile(file = COConfigurationManager.getStringParameter("Ip Filter V6 Autoload File"), new String[0])).exists()) {
                    fileModified = filtersFile.lastModified();
                    if (this.lastFileV6Modified == 0L) {
                        this.lastFileV6Modified = fileModified;
                    } else if (this.lastFileV6Modified != fileModified) {
                        doReload = true;
                    }
                }
                if (doReload) {
                    try {
                        IpFilterAutoLoaderImpl.this.ipFilter.reload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void downloadFiltersAsync(URL url, final boolean v6) {
        ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(url);
        rd.addListener(new ResourceDownloaderAdapter(){

            @Override
            public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
            }

            @Override
            public boolean completed(ResourceDownloader downloader, InputStream data) {
                try {
                    IpFilterAutoLoaderImpl.this.setNextAutoDownload(true);
                    Logger.log(new LogEvent(LOGID, "downloaded..waiting"));
                    class_mon.enter();
                    Logger.log(new LogEvent(LOGID, "downloaded.. copying"));
                    try {
                        FileUtil.copyFile(data, FileUtil.getUserFile(v6 ? "ipfilterv6.dl" : "ipfilter.dl"));
                        AEThread thread = new AEThread("reload ipfilters", true){

                            @Override
                            public void runSupport() {
                                try {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.setStatusText("reloading.filters");
                                    }
                                    (this).IpFilterAutoLoaderImpl.this.ipFilter.reload(false);
                                    if (uif != null) {
                                        uif.setStatusText(null);
                                    }
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                }
                            }
                        };
                        thread.setPriority(4);
                        thread.start();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                finally {
                    class_mon.exit();
                }
                return true;
            }
        });
        rd.asyncDownload();
    }

    public void setNextAutoDownload(boolean updateLastDownloadedDate) {
        long lastDL;
        long now = SystemTime.getCurrentTime();
        if (updateLastDownloadedDate) {
            COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            lastDL = now;
        } else {
            lastDL = COConfigurationManager.getLongParameter(CFG_AUTOLOAD_LAST);
            if (lastDL > now) {
                lastDL = now;
                COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            }
        }
        int reloadPeriod = COConfigurationManager.getIntParameter("Ip Filter Autoload Days");
        if (reloadPeriod < 1) {
            reloadPeriod = 1;
        }
        long nextDL = lastDL + 86400000L * (long)reloadPeriod;
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addEvent("IP Filter download", nextDL, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                String file = COConfigurationManager.getStringParameter("Ip Filter Autoload File");
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(file), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                file = COConfigurationManager.getStringParameter("Ip Filter V6 Autoload File");
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(file), true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private String readString(BufferedInputStream bin, byte[] descBytes, String encoding) {
        int pos = 0;
        try {
            int byteRead;
            while ((byteRead = bin.read()) >= 0) {
                if (pos < descBytes.length) {
                    descBytes[pos] = (byte)byteRead;
                    ++pos;
                }
                if (byteRead != 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pos > 1) {
            try {
                return new String(descBytes, 0, pos - 1, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }
}

