/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.ipfilter.impl.IpRangeImpl;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HostNameToIPResolver;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;

public class IpRangeV6Impl
extends IpRangeImpl {
    private byte[] start_prefix;
    private byte[] end_prefix;
    private int start_mask;
    private int end_mask;

    protected IpRangeV6Impl(String desc, Inet6Address address, boolean session) {
        if (session) {
            this.flags = 1;
        }
        if (address == null) {
            throw new RuntimeException("Invalid start/end values - null not supported");
        }
        this.start_prefix = address.getAddress();
        this.start_mask = 128;
        if (desc.length() > 0) {
            this.setDescription(desc);
        }
        this.checkValid();
    }

    protected IpRangeV6Impl(String desc, String start, String end, boolean session) {
        if (session) {
            this.flags = 1;
        }
        if (start == null || end == null) {
            throw new RuntimeException("Invalid start/end values - null not supported");
        }
        this.setStartSupport(start);
        this.setEndSupport(end);
        if (desc.length() > 0) {
            this.setDescription(desc);
        }
        this.checkValid();
    }

    @Override
    protected boolean isV4() {
        return false;
    }

    @Override
    public boolean isValid() {
        if ((this.flags & 0x18) > 0) {
            return false;
        }
        if (this.start_prefix == null) {
            return false;
        }
        return this.end_prefix == null || Arrays.equals(this.start_prefix, this.end_prefix) && this.start_mask == this.end_mask;
    }

    private Inet6Address getLiteralAddress(String str) throws Exception {
        char[] chars;
        str = str.trim().toLowerCase(Locale.US);
        char[] cArray = chars = str.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(Character.isDigit(c) || c >= 'a' && c <= 'f' || c == ':' || c == '[' || c == ']')) {
                throw new Exception("Not literal: " + str);
            }
            ++n2;
        }
        return (Inet6Address)InetAddress.getByName(str);
    }

    private void setStartSupport(String str) {
        this.flags = (byte)(this.flags & 0xFFFFFFF7);
        try {
            str = str.trim();
            if (str.isEmpty()) {
                this.start_prefix = null;
                this.flags = (byte)(this.flags | 8);
            } else {
                int pos = str.indexOf(47);
                if (pos == -1) {
                    Inet6Address address = this.getLiteralAddress(str);
                    this.start_prefix = ((InetAddress)address).getAddress();
                    this.start_mask = 128;
                } else {
                    Inet6Address address = this.getLiteralAddress(str.substring(0, pos));
                    this.start_prefix = ((InetAddress)address).getAddress();
                    this.start_mask = Integer.parseInt(str.substring(pos + 1));
                    if (this.start_mask < 0) {
                        this.start_mask = 0;
                    } else if (this.start_mask > 128) {
                        this.start_mask = 128;
                    }
                    int whole_bytes = this.start_mask / 8;
                    int rem = this.start_mask % 8;
                    if (rem > 0) {
                        byte b = this.start_prefix[whole_bytes];
                        byte mask = (byte)(255 << 8 - rem);
                        byte masked = (byte)(b & mask);
                        if (masked != b) {
                            this.start_prefix[whole_bytes] = masked;
                            System.out.println("clearing extra bits in " + str);
                        }
                        ++whole_bytes;
                    }
                    int i = whole_bytes;
                    while (i < this.start_prefix.length) {
                        if (this.start_prefix[i] != 0) {
                            System.out.println("clearing extra byte " + i + " in " + str);
                            this.start_prefix[i] = 0;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.flags = (byte)(this.flags | 8);
        }
    }

    private void setEndSupport(String str) {
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        try {
            str = str.trim();
            if (str.isEmpty()) {
                this.end_prefix = null;
            } else {
                int pos = str.indexOf(47);
                if (pos == -1) {
                    Inet6Address address = this.getLiteralAddress(str);
                    this.end_prefix = ((InetAddress)address).getAddress();
                    this.end_mask = 128;
                } else {
                    Inet6Address address = this.getLiteralAddress(str.substring(0, pos));
                    this.end_prefix = ((InetAddress)address).getAddress();
                    this.end_mask = Integer.parseInt(str.substring(pos + 1));
                    if (this.end_mask < 0) {
                        this.end_mask = 0;
                    } else if (this.end_mask > 128) {
                        this.end_mask = 128;
                    }
                    int whole_bytes = this.end_mask / 8;
                    int rem = this.end_mask % 8;
                    if (rem > 0) {
                        byte b = this.end_prefix[whole_bytes];
                        byte mask = (byte)(255 << 8 - rem);
                        byte masked = (byte)(b & mask);
                        if (masked != b) {
                            this.end_prefix[whole_bytes] = masked;
                            System.out.println("clearing extra bits in " + str);
                        }
                        ++whole_bytes;
                    }
                    int i = whole_bytes;
                    while (i < this.end_prefix.length) {
                        if (this.end_prefix[i] != 0) {
                            System.out.println("clearing extra byte " + i + " in " + str);
                            this.end_prefix[i] = 0;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.flags = (byte)(this.flags | 0x10);
        }
    }

    @Override
    public String getStartIp() {
        if ((this.flags & 8) != 0) {
            return "";
        }
        try {
            return String.valueOf(InetAddress.getByAddress(this.start_prefix).getHostAddress()) + (this.start_mask == 128 ? "" : "/" + this.start_mask);
        }
        catch (Throwable e) {
            return "";
        }
    }

    private String getStartIpSlow() {
        if ((this.flags & 8) != 0) {
            return "";
        }
        try {
            return String.valueOf(AddressUtils.getShortForm((Inet6Address)InetAddress.getByAddress(this.start_prefix))) + (this.start_mask == 128 ? "" : "/" + this.start_mask);
        }
        catch (Throwable e) {
            return "";
        }
    }

    protected byte[] getStartPrefix() {
        return this.start_prefix;
    }

    protected int getStartMask() {
        return this.start_mask;
    }

    @Override
    public void setStartIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid start value - null not supported");
        }
        if (str.equals(this.getStartIp())) {
            return;
        }
        this.setStartSupport(str);
        if ((this.flags & 0x18) == 0) {
            this.checkValid();
        }
    }

    @Override
    public String getEndIp() {
        if ((this.flags & 0x10) != 0) {
            return "";
        }
        if (this.end_prefix == null) {
            return "";
        }
        try {
            return String.valueOf(InetAddress.getByAddress(this.end_prefix).getHostAddress()) + (this.end_mask == 128 ? "" : "/" + this.end_mask);
        }
        catch (Throwable e) {
            return "";
        }
    }

    private String getEndIpSlow() {
        if ((this.flags & 0x10) != 0) {
            return "";
        }
        if (this.end_prefix == null) {
            return "";
        }
        try {
            return String.valueOf(AddressUtils.getShortForm((Inet6Address)InetAddress.getByAddress(this.end_prefix))) + (this.end_mask == 128 ? "" : "/" + this.end_mask);
        }
        catch (Throwable e) {
            return "";
        }
    }

    @Override
    public void setEndIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid end value - null not supported");
        }
        if (str.equals(this.getEndIp())) {
            return;
        }
        if (str.isEmpty()) {
            this.end_prefix = null;
        } else {
            this.setEndSupport(str);
        }
        if ((this.flags & 0x18) == 0) {
            this.checkValid();
        }
    }

    @Override
    public boolean isInRange(String ipAddress) {
        byte[] bytes;
        if (!this.isValid()) {
            return false;
        }
        if (ipAddress.contains(".") && (bytes = HostNameToIPResolver.hostAddressToBytes(ipAddress)) != null && bytes.length == 4) {
            return false;
        }
        try {
            Inet6Address ia = this.getLiteralAddress(ipAddress);
            return this.isInRange(((InetAddress)ia).getAddress());
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    protected boolean isInRange(byte[] bytes) {
        if (!this.isValid()) {
            return false;
        }
        if (this.start_mask == 128) {
            return Arrays.equals(bytes, this.start_prefix);
        }
        int whole_bytes = this.start_mask / 8;
        int i = 0;
        while (i < whole_bytes) {
            if (bytes[i] != this.start_prefix[i]) {
                return false;
            }
            ++i;
        }
        int rem = this.start_mask % 8;
        if (rem > 0) {
            byte mask = (byte)(255 << 8 - rem);
            return (byte)(bytes[whole_bytes] & mask) == this.start_prefix[whole_bytes];
        }
        return true;
    }

    private int compare(byte[] s1, byte[] s2, int len) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        int i = 0;
        while (i < len) {
            int i1 = s1[i] & 0xFF;
            int i2 = s2[i] & 0xFF;
            int res = i1 - i2;
            if (res != 0) {
                return res;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int compareStartIpTo(IpRange other) {
        if (other instanceof IpRangeV6Impl) {
            IpRangeV6Impl o = (IpRangeV6Impl)other;
            byte[] s1 = this.start_prefix;
            byte[] s2 = o.start_prefix;
            int len = (Math.max(this.start_mask, o.start_mask) + 7) / 8;
            return this.compare(s1, s2, len);
        }
        return 1;
    }

    @Override
    public int compareEndIpTo(IpRange other) {
        if (other instanceof IpRangeV6Impl) {
            IpRangeV6Impl o = (IpRangeV6Impl)other;
            byte[] s1 = this.end_prefix;
            byte[] s2 = o.end_prefix;
            int len = (Math.max(this.end_mask, o.end_mask) + 7) / 8;
            return this.compare(s1, s2, len);
        }
        return 1;
    }

    @Override
    public String toString() {
        String start = this.getStartIp();
        String end = this.getEndIp();
        return String.valueOf(this.getDescription()) + " : " + start + (start.equals(end) || end.isEmpty() ? "" : " - " + end);
    }

    @Override
    public String getStringSlow() {
        String start = this.getStartIpSlow();
        String end = this.getEndIpSlow();
        return String.valueOf(this.getDescription()) + " : " + start + (start.equals(end) || end.isEmpty() ? "" : " - " + end);
    }
}

