/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.logging.impl;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.logging.ILogEventListener;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.logging.impl.FileLoggingAdapter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class FileLogging
implements ILogEventListener {
    public static final String LOG_FILE_NAME = "biglybt.log";
    public static final String BAK_FILE_NAME = "biglybt.log.bak";
    public static final LogIDs[] configurableLOGIDs = new LogIDs[]{LogIDs.STDOUT, LogIDs.ALERT, LogIDs.CORE, LogIDs.DISK, LogIDs.GUI, LogIDs.NET, LogIDs.NWMAN, LogIDs.PEER, LogIDs.PLUGIN, LogIDs.TRACKER, LogIDs.CACHE, LogIDs.PIECES};
    private static final String CFG_ENABLELOGTOFILE = "Logging Enable";
    private static boolean closing;
    private static volatile boolean closing_taking_too_long;
    private boolean bLogToFile = false;
    private boolean bLogToFileErrorPrinted = false;
    private String sLogDir = "";
    private int iLogFileMaxMB = 1;
    private final ArrayList[] ignoredComponents = new ArrayList[3];
    private final ArrayList listeners = new ArrayList();
    private SimpleDateFormat format;
    private FileOutputStream logFileOS;
    private PrintWriter logFilePrinter;
    private static final int DEFPADDING = 100;
    private int lastWidth = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setClosing() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            closing = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setClosingTakingTooLong() {
        this.logToFile("Closedown is taking too long, disabling file logging\n");
        closing_taking_too_long = true;
    }

    public void initialize() {
        ConfigurationManager config = ConfigurationManager.getInstance();
        boolean overrideLog = System.getProperty(SystemProperties.SYSPROP_OVERRIDELOG) != null;
        int i = 0;
        while (i < this.ignoredComponents.length) {
            this.ignoredComponents[i] = new ArrayList();
            ++i;
        }
        if (!overrideLog) {
            config.addListener(new COConfigurationListener(){

                @Override
                public void configurationSaved() {
                    FileLogging.this.checkLoggingConfig();
                }
            });
        }
        this.checkLoggingConfig();
        config.addParameterListener(CFG_ENABLELOGTOFILE, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                FileLogging.this.reloadLogToFileParam();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reloadLogToFileParam() {
        boolean bNewLogToFile;
        ConfigurationManager config = ConfigurationManager.getInstance();
        boolean bl = bNewLogToFile = System.getProperty(SystemProperties.SYSPROP_OVERRIDELOG) != null || config.getBooleanParameter(CFG_ENABLELOGTOFILE);
        if (bNewLogToFile == this.bLogToFile) return;
        this.bLogToFile = bNewLogToFile;
        if (this.bLogToFile) {
            Logger.addListener(this);
            return;
        }
        Logger.removeListener(this);
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            this.checkAndSwapLog();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkLoggingConfig() {
        try {
            int i;
            String timeStampFormat;
            boolean overrideLog;
            ConfigurationManager config = ConfigurationManager.getInstance();
            boolean bl = overrideLog = System.getProperty(SystemProperties.SYSPROP_OVERRIDELOG) != null;
            if (overrideLog) {
                this.sLogDir = System.getProperty(SystemProperties.SYSPROP_OVERRIDELOGDIR, ".");
                this.iLogFileMaxMB = 2;
                timeStampFormat = "HH:mm:ss.SSS ";
                i = 0;
                while (i < this.ignoredComponents.length) {
                    this.ignoredComponents[i].clear();
                    ++i;
                }
                this.reloadLogToFileParam();
            } else {
                this.reloadLogToFileParam();
                this.sLogDir = config.getStringParameter("Logging Dir", "");
                this.iLogFileMaxMB = config.getIntParameter("Logging Max Size");
                timeStampFormat = String.valueOf(config.getStringParameter("Logging Timestamp")) + " ";
                i = 0;
                while (i < this.ignoredComponents.length) {
                    this.ignoredComponents[i].clear();
                    int logType = this.indexToLogType(i);
                    int j = 0;
                    while (j < configurableLOGIDs.length) {
                        if (!config.getBooleanParameter("bLog." + logType + "." + configurableLOGIDs[j])) {
                            this.ignoredComponents[i].add(configurableLOGIDs[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            Class<Logger> clazz = Logger.class;
            synchronized (Logger.class) {
                this.format = new SimpleDateFormat(timeStampFormat);
                this.checkAndSwapLog();
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String str) {
        if (!this.bLogToFile || closing_taking_too_long) {
            return;
        }
        String dateStr = this.format.format(new Date());
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (this.logFilePrinter != null) {
                this.logFilePrinter.print(dateStr);
                this.logFilePrinter.print(str);
                this.logFilePrinter.flush();
                if (closing) {
                    try {
                        this.logFileOS.getFD().sync();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.checkAndSwapLog();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void checkAndSwapLog() {
        block10: {
            if (!this.bLogToFile) {
                if (this.logFilePrinter != null) {
                    this.logFilePrinter.close();
                    this.logFilePrinter = null;
                }
                return;
            }
            long lMaxBytes = (long)this.iLogFileMaxMB * 1024L * 1024L / 2L;
            File logFile = FileUtil.newFile(this.sLogDir, LOG_FILE_NAME);
            if (logFile.length() > lMaxBytes && this.logFilePrinter != null) {
                File back_name = FileUtil.newFile(this.sLogDir, BAK_FILE_NAME);
                this.logFilePrinter.close();
                this.logFilePrinter = null;
                if (!back_name.exists() || back_name.delete()) {
                    if (!logFile.renameTo(back_name)) {
                        logFile.delete();
                    }
                } else {
                    logFile.delete();
                }
            }
            if (this.logFilePrinter == null) {
                try {
                    this.logFileOS = FileUtil.newFileOutputStream(logFile, true);
                    if (logFile.length() == 0L) {
                        this.logFileOS.write(new byte[]{-17, -69, -65});
                    }
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.logFileOS, "UTF-8");
                    this.logFilePrinter = new PrintWriter(osw);
                }
                catch (IOException e) {
                    if (this.bLogToFileErrorPrinted) break block10;
                    this.bLogToFileErrorPrinted = true;
                    Debug.out("Unable to write to log file: " + logFile);
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private int logTypeToIndex(int entryType) {
        switch (entryType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private int indexToLogType(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void log(LogEvent event2) {
        if (this.ignoredComponents[this.logTypeToIndex(event2.entryType)].contains(event2.logID)) {
            return;
        }
        StringBuffer text = new StringBuffer(event2.text.length());
        text.append(event2.entryType).append(" ");
        this.padAndAppend(text, event2.logID.toString(), 8, 1);
        if (event2.relatedTo != null) {
            this.lastWidth = this.padAndAppend(text, event2.text, this.lastWidth, 1);
            if (this.lastWidth > 200) {
                this.lastWidth = 200;
            }
            int i = 0;
            while (i < event2.relatedTo.length) {
                Object obj = event2.relatedTo[i];
                if (obj != null) {
                    if (i > 0) {
                        text.append("; ");
                    }
                    if (obj instanceof LogRelation) {
                        text.append(((LogRelation)obj).getRelationText());
                    } else {
                        text.append("RelatedTo[").append(obj.toString()).append("]");
                    }
                }
                ++i;
            }
        } else {
            text.append(event2.text);
            this.lastWidth = 100;
        }
        if (!event2.text.endsWith("\n")) {
            text.append("\r\n");
        }
        boolean okToLog = true;
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext() && okToLog) {
            FileLoggingAdapter listener = (FileLoggingAdapter)iter.next();
            okToLog = listener.logToFile(event2, text);
        }
        this.logToFile(text.toString());
    }

    private int padAndAppend(StringBuffer appendTo, String s, int width, int growBy) {
        if (s == null) {
            s = "null";
        }
        appendTo.append(s);
        int sLen = s.length();
        int len = width - sLen;
        while (len <= 0) {
            len += growBy;
        }
        char[] padding = new char[len];
        if (len > 5) {
            int i = 0;
            while (i < len) {
                padding[i] = 32;
                i += 2;
            }
            i = 1;
            while (i < len) {
                padding[i] = 46;
                i += 2;
            }
        } else {
            int i = 0;
            while (i < len) {
                padding[i] = 32;
                ++i;
            }
        }
        appendTo.append(padding);
        return len + sLen;
    }

    public void addListener(FileLoggingAdapter listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(FileLoggingAdapter listener) {
        this.listeners.remove(listener);
    }

    public List getListeners() {
        return this.listeners;
    }
}

