/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.messenger;

import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.util.JSONUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class PlatformMessage {
    private final String messageID;
    private final String listenerID;
    private final String operationID;
    private final Map<?, ?> parameters;
    private final long fireBeforeDate;
    private final long messageCreatedOn;
    private long lSequenceNo = -1L;
    private boolean sendAZID = true;
    private boolean forceProxy;

    private PlatformMessage(String messageID, String listenerID, String operationID, JSONObject parameters, long maxDelayMS) {
        this.messageID = messageID;
        this.listenerID = listenerID;
        this.operationID = operationID;
        this.parameters = parameters;
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + maxDelayMS;
    }

    public PlatformMessage(String messageID, String listenerID, String operationID, Map<?, ?> parameters, long maxDelayMS) {
        this(messageID, listenerID, operationID, JSONUtils.encodeToJSONObject(parameters), maxDelayMS);
    }

    public PlatformMessage(String messageID, String listenerID, String operationID, Object[] parameters, long maxDelayMS) {
        this(messageID, listenerID, operationID, JSONUtils.encodeToJSONObject(PlatformMessage.parseParams(parameters)), maxDelayMS);
    }

    public static Map<String, Object> parseParams(Object[] parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < parameters.length - 1) {
            try {
                if (parameters[i] instanceof String) {
                    if (parameters[i + 1] instanceof String[]) {
                        List<String> list = Arrays.asList((String[])parameters[i + 1]);
                        result.put((String)parameters[i], list);
                    } else if (parameters[i + 1] instanceof Object[]) {
                        result.put((String)parameters[i], PlatformMessage.parseParams((Object[])parameters[i + 1]));
                    } else if (parameters[i + 1] instanceof Map) {
                        result.put((String)parameters[i], (Map)parameters[i + 1]);
                    } else {
                        result.put((String)parameters[i], parameters[i + 1]);
                    }
                }
            }
            catch (Exception e) {
                Debug.out("making JSONObject out of parsedParams", e);
            }
            i += 2;
        }
        return result;
    }

    public boolean isForceProxy() {
        return this.forceProxy;
    }

    public void setForceProxy(boolean fp) {
        this.forceProxy = fp;
    }

    public long getFireBefore() {
        return this.fireBeforeDate;
    }

    public long getMessageCreated() {
        return this.messageCreatedOn;
    }

    public Map<?, ?> getParameters() {
        return this.parameters;
    }

    public String getListenerID() {
        return this.listenerID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    protected long getSequenceNo() {
        return this.lSequenceNo;
    }

    protected void setSequenceNo(long sequenceNo) {
        this.lSequenceNo = sequenceNo;
    }

    public String toString() {
        String paramString = this.parameters.toString();
        return "PlaformMessage {" + this.lSequenceNo + ", " + this.messageID + ", " + this.listenerID + ", " + this.operationID + ", " + (paramString.length() > Short.MAX_VALUE ? paramString.substring(0, Short.MAX_VALUE) : paramString) + "}";
    }

    public String toShortString() {
        return String.valueOf(this.getMessageID()) + "." + this.getListenerID() + "." + this.getOperationID();
    }

    public boolean sendAZID() {
        return this.sendAZID;
    }

    public void setSendAZID(boolean send) {
        this.sendAZID = send;
    }
}

