/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.metasearch;

import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.FilterableResult;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.utils.MomentsAgoDateFormatter;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.Entities;
import org.json.simple.JSONObject;

public abstract class Result
implements FilterableResult {
    private static final String HTML_TAGS = "(\\<(/?[^\\>]+)\\>)";
    private static final String DUPLICATE_SPACES = "\\s{2,}";
    private final Engine engine;
    private final long time_created_secs = SystemTime.getCurrentTime() / 1000L;

    public abstract Date getPublishedDate();

    public abstract Date getAssetDate();

    @Override
    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getContentType();

    public abstract void setContentType(String var1);

    @Override
    public abstract String getName();

    @Override
    public abstract long getSize();

    @Override
    public abstract int getNbPeers();

    @Override
    public abstract int getNbSeeds();

    public abstract int getNbSuperSeeds();

    public abstract int getComments();

    public abstract int getVotes();

    public abstract int getVotesDown();

    public abstract boolean isPrivate();

    public abstract String getDRMKey();

    public abstract String getDownloadLink();

    public abstract String getTorrentLink();

    public abstract String getDownloadButtonLink();

    public abstract String getCDPLink();

    public abstract String getPlayLink();

    public abstract float getAccuracy();

    public abstract String getSearchQuery();

    public abstract String getUID();

    public abstract String getHash();

    protected Result(Engine _engine) {
        this.engine = _engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " : " + this.getNbSeeds() + " s, " + this.getNbPeers() + "p, ";
    }

    public float getRank() {
        float rank;
        int votesDown;
        int votes;
        int seeds = this.getNbSeeds();
        int peers = this.getNbPeers();
        if (seeds < 0) {
            seeds = 0;
        }
        if (peers < 0) {
            peers = 0;
        }
        int totalVirtualPeers = 3 * seeds + peers + 2;
        int superSeeds = this.getNbSuperSeeds();
        if (superSeeds > 0) {
            totalVirtualPeers += 50 * superSeeds;
        }
        if ((votes = this.getVotes()) > 0) {
            if (votes > 50) {
                votes = 50;
            }
            totalVirtualPeers += 5 * votes;
        }
        if ((votesDown = this.getVotesDown()) > 0) {
            totalVirtualPeers -= 200 * votesDown;
        }
        if (totalVirtualPeers < 2) {
            totalVirtualPeers = 2;
        }
        if ((rank = (float)(Math.log(totalVirtualPeers) / Math.log(10.0)) / 5.0f) > 2.0f) {
            rank = 2.0f;
        }
        if (this.isPrivate()) {
            rank /= 2.0f;
        }
        String queryString = this.getSearchQuery();
        String name = this.getName();
        if (queryString != null && name != null) {
            char[] chars;
            name = name.toLowerCase(Locale.ENGLISH);
            String token = "";
            ArrayList<String> tokens = new ArrayList<String>();
            char[] cArray = chars = queryString.toCharArray();
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Character.isLetterOrDigit(c)) {
                    token = String.valueOf(token) + String.valueOf(c).toLowerCase(Locale.ENGLISH);
                } else if (token.length() > 0) {
                    tokens.add(token);
                    token = "";
                }
                ++n2;
            }
            if (token.length() > 0) {
                tokens.add(token);
            }
            for (String s : tokens) {
                if (name.contains(s)) continue;
                rank /= 2.0f;
            }
        }
        rank = this.applyRankBias(rank);
        return rank;
    }

    protected float applyRankBias(float _rank) {
        float rank = this.engine.applyRankBias(_rank);
        return rank;
    }

    public Map toJSONMap() {
        String uid;
        String drmKey;
        long size;
        JSONObject object = new JSONObject();
        object.put("tf", "" + this.time_created_secs);
        Date pub_date = this.getPublishedDate();
        if (pub_date == null) {
            object.put("d", "unknown");
            object.put("ts", "0");
        } else {
            try {
                object.put("d", MomentsAgoDateFormatter.getMomentsAgoString(pub_date));
                object.put("ts", "" + pub_date.getTime());
            }
            catch (Exception e) {
                object.put("d", "unknown");
                object.put("ts", "0");
            }
        }
        Date ad = this.getAssetDate();
        if (ad != null) {
            object.put("ad", String.valueOf(ad.getTime()));
        }
        object.put("c", this.getCategory());
        String[] tags = this.getTags();
        if (tags != null && tags.length > 0) {
            object.put("tgs", Arrays.asList(tags));
        }
        object.put("n", this.getName());
        int super_seeds = this.getNbSuperSeeds();
        int seeds = this.getNbSeeds();
        int seed_total = -1;
        if (super_seeds > 0) {
            seed_total = 10 * super_seeds + new Random().nextInt(10);
        }
        if (seeds > 0) {
            if (seed_total == -1) {
                seed_total = 0;
            }
            seed_total += seeds;
        }
        object.put("s", "" + seed_total);
        if (this.getNbPeers() >= 0) {
            object.put("p", "" + this.getNbPeers());
        } else {
            object.put("p", "-1");
        }
        int comments = this.getComments();
        if (comments >= 0) {
            object.put("co", "" + comments);
        }
        if ((size = this.getSize()) >= 0L) {
            String size_str = DisplayFormatters.formatByteCountToKiBEtc(size);
            size_str = DisplayFormatters.trimDigits(size_str, 3);
            object.put("l", size_str);
            object.put("lb", "" + size);
        } else {
            object.put("l", "-1");
            object.put("lb", "0");
        }
        object.put("r", "" + this.getRank());
        object.put("ct", this.getContentType());
        float accuracy = this.getAccuracy();
        if (accuracy >= 0.0f) {
            if (accuracy > 1.0f) {
                accuracy = 1.0f;
            }
            object.put("ac", "" + accuracy);
        }
        if (this.getCDPLink().length() > 0) {
            object.put("cdp", this.getCDPLink());
        }
        if (this.getDownloadLink().length() > 0) {
            object.put("dl", this.getDownloadLink());
        } else {
            String tl = this.getTorrentLink();
            if (tl.length() > 0) {
                object.put("dl", tl);
            }
        }
        if (this.getDownloadButtonLink().length() > 0) {
            object.put("dbl", this.getDownloadButtonLink());
        }
        if (this.getPlayLink().length() > 0) {
            object.put("pl", this.getPlayLink());
        }
        if (this.getVotes() >= 0) {
            object.put("v", "" + this.getVotes());
        }
        if (this.getVotesDown() >= 0) {
            object.put("vd", "" + this.getVotesDown());
        }
        if ((drmKey = this.getDRMKey()) != null) {
            object.put("dk", drmKey);
        }
        if ((uid = this.getUID()) != null) {
            object.put("u", uid);
        }
        object.put("pr", this.isPrivate() ? "1" : "0");
        String hash = this.getHash();
        if (hash != null) {
            object.put("h", hash);
        }
        return object;
    }

    protected String guessContentTypeFromCategory(String category) {
        if (category == null || category.length() == 0) {
            return "";
        }
        if ((category = category.toLowerCase(Locale.US)).startsWith("video") || category.startsWith("movie") || category.startsWith("show") || category.startsWith("tv")) {
            return "video";
        }
        if (category.startsWith("audio") || category.startsWith("music")) {
            return "audio";
        }
        if (category.startsWith("game")) {
            return "game";
        }
        return "";
    }

    @Override
    public long getTime() {
        Date date = this.getPublishedDate();
        if (date != null) {
            return date.getTime();
        }
        return 0L;
    }

    public static String adjustLink(String link) {
        int pt;
        if (link == null || link.length() < 5) {
            return link;
        }
        char c = link.charAt(0);
        if ((c == 'h' || c == 'H' || c == 'f' || c == 'F') && (pt = MetaSearchManagerFactory.getSingleton().getProxyRequestsEnabled()) != 0) {
            try {
                String host = new URL(link).getHost();
                if (AENetworkClassifier.categoriseAddress(host) != "Public") {
                    return link;
                }
                InetAddress ia = HostNameToIPResolver.hostAddressToInetAddress(host);
                if (ia != null && (ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress())) {
                    return link;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (pt == 1) {
                return "tor:" + link;
            }
            return "i2p:" + link;
        }
        return link;
    }

    public static void adjustRelativeTerms(Map map) {
        long l_ts;
        String ts = (String)map.get("ts");
        if (ts != null && (l_ts = Long.parseLong(ts)) > 0L) {
            map.put("d", MomentsAgoDateFormatter.getMomentsAgoString(new Date(l_ts)));
        }
    }

    protected static String removeHTMLTags(String input) {
        if (input == null) {
            return null;
        }
        String result = input.replaceAll(HTML_TAGS, " ");
        return result.replaceAll(DUPLICATE_SPACES, " ").trim();
    }

    protected static String unescapeEntities(String input) {
        if (input == null) {
            return null;
        }
        return Entities.HTML40.unescape(input);
    }
}

