/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.metasearch.impl.web;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.metasearch.SearchException;
import com.biglybt.core.metasearch.SearchParameter;
import com.biglybt.core.metasearch.impl.DateParser;
import com.biglybt.core.metasearch.impl.DateParserRegex;
import com.biglybt.core.metasearch.impl.EngineImpl;
import com.biglybt.core.metasearch.impl.MetaSearchImpl;
import com.biglybt.core.metasearch.impl.web.CookieParser;
import com.biglybt.core.metasearch.impl.web.FieldMapping;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.util.MapUtils;
import com.biglybt.util.UrlFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class WebEngine
extends EngineImpl {
    public static final String AM_TRANSPARENT = "transparent";
    public static final String AM_PROXY = "proxy";
    private static final boolean NEEDS_AUTH_DEFAULT = false;
    private static final boolean AUTOMATIC_DATE_PARSER_DEFAULT = true;
    private static final Pattern baseTagPattern = Pattern.compile("(?i)<base.*?href=\"([^\"]+)\".*?>");
    private static final Pattern rootURLPattern = Pattern.compile("((?:tor:)?https?://[^/]+)");
    private static final Pattern baseURLPattern = Pattern.compile("((?:tor:)?https?://.*/)");
    private static int search_timeout_secs;
    private String searchURLFormat;
    private String timeZone;
    private boolean automaticDateParser;
    private String userDateFormat;
    private String downloadLinkCSS;
    private FieldMapping[] mappings;
    private String rootPage;
    private String basePage;
    private DateParser dateParser;
    private boolean needsAuth;
    private String authMethod;
    private String loginPageUrl;
    private String iconUrl;
    private String[] requiredCookies;
    private String fullCookies;
    private String local_cookies;

    static {
        COConfigurationManager.addAndFireParameterListener("search.rss.template.timeout", name -> {
            search_timeout_secs = COConfigurationManager.getIntParameter(name);
        });
    }

    public WebEngine(MetaSearchImpl meta_search, int type, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String timeZone, boolean automaticDateParser, String userDateFormat, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, type, id, last_updated, rank_bias, name);
        this.searchURLFormat = searchURLFormat;
        this.timeZone = timeZone;
        this.automaticDateParser = automaticDateParser;
        this.userDateFormat = userDateFormat;
        this.mappings = mappings;
        this.needsAuth = needs_auth;
        this.authMethod = auth_method;
        this.loginPageUrl = login_url;
        this.requiredCookies = required_cookies;
        this.init();
    }

    protected WebEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        this.searchURLFormat = MapUtils.getMapString(map, "web.search_url_format", null);
        this.timeZone = MapUtils.getMapString(map, "web.time_zone", null);
        this.userDateFormat = MapUtils.getMapString(map, "web.date_format", null);
        this.downloadLinkCSS = MapUtils.getMapString(map, "web.dl_link_css", null);
        this.needsAuth = MapUtils.getMapBoolean(map, "web.needs_auth", false);
        this.authMethod = MapUtils.getMapString(map, "web.auth_method", AM_TRANSPARENT);
        this.loginPageUrl = MapUtils.getMapString(map, "web.login_page", null);
        this.requiredCookies = MapUtils.importStringArray(map, "web.required_cookies");
        this.fullCookies = MapUtils.getMapString(map, "web.full_cookies", null);
        this.automaticDateParser = MapUtils.getMapBoolean(map, "web.auto_date", true);
        this.iconUrl = MapUtils.getMapString(map, "web.icon_url", null);
        List maps = (List)map.get("web.maps");
        this.mappings = new FieldMapping[maps.size()];
        int i = 0;
        while (i < this.mappings.length) {
            Map m = (Map)maps.get(i);
            this.mappings[i] = new FieldMapping(MapUtils.getMapString(m, "name", null), ((Long)m.get("field")).intValue(), MapUtils.getMapString(m, "post_filter", null));
            ++i;
        }
        this.init();
    }

    @Override
    protected void exportToBencodedMap(Map map, boolean generic) throws IOException {
        super.exportToBencodedMap(map, generic);
        if (generic) {
            if (this.searchURLFormat != null) {
                MapUtils.setMapString(map, "web.search_url_format", this.searchURLFormat);
            }
            if (this.timeZone != null) {
                MapUtils.setMapString(map, "web.time_zone", this.timeZone);
            }
            if (this.userDateFormat != null) {
                MapUtils.setMapString(map, "web.date_format", this.userDateFormat);
            }
            if (this.downloadLinkCSS != null) {
                MapUtils.setMapString(map, "web.dl_link_css", this.downloadLinkCSS);
            }
            if (this.needsAuth) {
                MapUtils.exportBooleanAsLong(map, "web.needs_auth", this.needsAuth);
            }
            if (this.authMethod != null && !this.authMethod.equals(AM_TRANSPARENT)) {
                MapUtils.setMapString(map, "web.auth_method", this.authMethod);
            }
            if (this.loginPageUrl != null) {
                MapUtils.setMapString(map, "web.login_page", this.loginPageUrl);
            }
            if (this.iconUrl != null) {
                MapUtils.setMapString(map, "web.icon_url", this.iconUrl);
            }
            if (this.requiredCookies != null && this.requiredCookies.length > 0) {
                MapUtils.exportStringArray(map, "web.required_cookies", this.requiredCookies);
            }
            if (!this.automaticDateParser) {
                MapUtils.exportBooleanAsLong(map, "web.auto_date", this.automaticDateParser);
            }
        } else {
            MapUtils.setMapString(map, "web.search_url_format", this.searchURLFormat);
            MapUtils.setMapString(map, "web.time_zone", this.timeZone);
            MapUtils.setMapString(map, "web.date_format", this.userDateFormat);
            MapUtils.setMapString(map, "web.dl_link_css", this.downloadLinkCSS);
            MapUtils.exportBooleanAsLong(map, "web.needs_auth", this.needsAuth);
            MapUtils.setMapString(map, "web.auth_method", this.authMethod);
            MapUtils.setMapString(map, "web.login_page", this.loginPageUrl);
            MapUtils.setMapString(map, "web.icon_url", this.iconUrl);
            MapUtils.exportStringArray(map, "web.required_cookies", this.requiredCookies);
            map.put("web.full_cookies", this.fullCookies);
            MapUtils.exportBooleanAsLong(map, "web.auto_date", this.automaticDateParser);
        }
        ArrayList maps = new ArrayList();
        map.put("web.maps", maps);
        int i = 0;
        while (i < this.mappings.length) {
            FieldMapping fm = this.mappings[i];
            HashMap<String, Long> m = new HashMap<String, Long>();
            MapUtils.setMapString(m, "name", fm.getName());
            m.put("field", new Long(fm.getField()));
            MapUtils.setMapString(m, "post_filter", fm.getPostFilter());
            maps.add(m);
            ++i;
        }
    }

    protected WebEngine(MetaSearchImpl meta_search, int type, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, type, id, last_updated, rank_bias, name, map);
        this.searchURLFormat = MapUtils.importURL(map, "searchURL");
        this.timeZone = MapUtils.getMapString(map, "timezone", null);
        this.userDateFormat = MapUtils.getMapString(map, "time_format", null);
        this.downloadLinkCSS = MapUtils.importURL(map, "download_link");
        this.needsAuth = MapUtils.getMapBoolean(map, "needs_auth", false);
        this.authMethod = MapUtils.getMapString(map, "auth_method", AM_TRANSPARENT);
        this.loginPageUrl = MapUtils.importURL(map, "login_page");
        this.iconUrl = MapUtils.importURL(map, "icon_url");
        this.requiredCookies = MapUtils.importStringArray(map, "required_cookies");
        this.fullCookies = MapUtils.getMapString(map, "full_cookies", null);
        this.automaticDateParser = this.userDateFormat == null || this.userDateFormat.trim().length() == 0;
        List maps = (List)map.get("column_map");
        ArrayList<FieldMapping> conv_maps = new ArrayList<FieldMapping>();
        int i = 0;
        while (i < maps.size()) {
            Map m = (Map)maps.get(i);
            if (m != null) {
                int field_id;
                Map test = (Map)m.get("mapping");
                if (test != null) {
                    m = test;
                }
                String vuze_field = MapUtils.getMapString(m, "vuze_field", null).toUpperCase();
                String field_name = MapUtils.getMapString(m, "group_nb", null);
                if (field_name == null) {
                    field_name = MapUtils.getMapString(m, "field_name", null);
                }
                if (vuze_field == null || field_name == null) {
                    this.log("Missing field mapping name/value in '" + m + "'");
                }
                if ((field_id = this.vuzeFieldToID(vuze_field)) == -1) {
                    this.log("Unrecognised field mapping '" + vuze_field + "'");
                } else {
                    conv_maps.add(new FieldMapping(field_name, field_id, MapUtils.getMapString(m, "post_filter", null)));
                }
            }
            ++i;
        }
        this.mappings = conv_maps.toArray(new FieldMapping[conv_maps.size()]);
        this.init();
    }

    @Override
    protected void exportToJSONObject(JSONObject res) throws IOException {
        super.exportToJSONObject(res);
        MapUtils.exportJSONURL(res, "searchURL", this.searchURLFormat);
        if (this.timeZone != null) {
            res.put("timezone", this.timeZone);
        }
        if (this.downloadLinkCSS != null) {
            MapUtils.exportJSONURL(res, "download_link", this.downloadLinkCSS);
        }
        res.put("needs_auth", (Object)this.needsAuth);
        if (this.authMethod != null) {
            res.put("auth_method", this.authMethod);
        }
        MapUtils.exportJSONURL(res, "login_page", this.loginPageUrl);
        MapUtils.exportJSONURL(res, "icon_url", this.iconUrl);
        MapUtils.exportJSONStringArray(res, "required_cookies", this.requiredCookies);
        if (this.fullCookies != null) {
            res.put("full_cookies", this.fullCookies);
        }
        if (!this.automaticDateParser && this.userDateFormat != null) {
            res.put("time_format", this.userDateFormat);
        }
        JSONArray maps = new JSONArray();
        res.put("column_map", maps);
        int i = 0;
        while (i < this.mappings.length) {
            FieldMapping fm = this.mappings[i];
            int field_id = fm.getField();
            String field_value = this.vuzeIDToField(field_id);
            if (field_value == null) {
                this.log("JSON export: unknown field id " + field_id);
            } else {
                JSONObject entry = new JSONObject();
                maps.add(entry);
                entry.put("vuze_field", field_value);
                if (this.getType() == 2) {
                    entry.put("field_name", fm.getName());
                } else {
                    entry.put("group_nb", fm.getName());
                }
                String filter2 = fm.getPostFilter();
                if (filter2 != null) {
                    entry.put("post_filter", filter2);
                }
            }
            ++i;
        }
    }

    protected void init() {
        Matcher m;
        try {
            m = rootURLPattern.matcher(this.searchURLFormat);
            if (m.find()) {
                this.rootPage = m.group(1);
            }
        }
        catch (Exception e) {
            this.rootPage = null;
        }
        try {
            m = baseURLPattern.matcher(this.searchURLFormat);
            if (m.find()) {
                this.basePage = m.group(1);
            }
        }
        catch (Exception e) {
            this.basePage = null;
        }
        this.dateParser = new DateParserRegex(this.timeZone, this.automaticDateParser, this.userDateFormat);
        this.local_cookies = this.getLocalString("cookies");
        this.authMethod = this.authMethod.intern();
        int cook_pos = this.searchURLFormat.indexOf(":COOKIE:");
        if (cook_pos != -1) {
            String explicit_cookie = this.searchURLFormat.substring(cook_pos + 8);
            this.setNeedsAuth(true);
            this.setCookies(explicit_cookie);
            this.setRequiredCookies(CookieParser.getCookiesNames(explicit_cookie));
            this.searchURLFormat = this.searchURLFormat.substring(0, cook_pos);
            this.setPublic(false);
            String name = this.getName();
            int n_pos = name.indexOf(":COOKIE:");
            if (n_pos != -1) {
                this.setName(name.substring(0, n_pos));
            }
        }
    }

    @Override
    public String getNameEx() {
        String name;
        String url = this.getRootPage();
        if (url == null || url.length() == 0) {
            url = this.searchURLFormat;
        }
        if (!(name = this.getName()).contains(url)) {
            return String.valueOf(name) + " (" + url + ")";
        }
        return name;
    }

    @Override
    public String getReferer() {
        return this.getRootPage();
    }

    @Override
    public boolean supportsContext(String context_key) {
        String host;
        block6: {
            block5: {
                URL url = new URL(this.searchURLFormat);
                host = url.getHost();
                if (!Constants.isAppDomain(host)) break block5;
                return true;
            }
            if (!UrlFilter.getInstance().isWhitelisted(this.searchURLFormat)) break block6;
            return true;
        }
        try {
            InetAddress iad = AddressUtils.getByName(host);
            if (iad.isLoopbackAddress() || iad.isLinkLocalAddress() || iad.isSiteLocalAddress()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isShareable() {
        try {
            return !UrlUtils.containsPasskey(new URL(this.searchURLFormat));
        }
        catch (Throwable e) {
            return true;
        }
    }

    @Override
    public boolean isAnonymous() {
        try {
            return AENetworkClassifier.categoriseAddress(new URL(this.searchURLFormat).getHost()) != "Public";
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected pageDetails getWebPageContent(SearchParameter[] searchParameters, Map<String, String> searchContext, String headers, boolean only_if_modified) throws SearchException {
        return this.getWebPageContent(searchParameters, searchContext, headers, only_if_modified, null);
    }

    protected pageDetails getWebPageContent(SearchParameter[] searchParameters, Map<String, String> searchContext, String headers, boolean only_if_modified, pageDetailsVerifier verifier) throws SearchException {
        String test;
        String test2;
        if (NetworkAdmin.getSingleton().hasMissingForcedBind()) {
            throw new SearchException("Forced bind address is missing");
        }
        String searchURL = this.searchURLFormat;
        String lc_url = searchURL.toLowerCase(Locale.US);
        boolean can_proxy = lc_url.startsWith("http") || lc_url.startsWith("ftp");
        boolean explicit_tor = lc_url.startsWith("tor:");
        boolean user_tor = false;
        if (!explicit_tor && (test2 = Result.adjustLink(searchURL)).startsWith("tor:")) {
            user_tor = true;
        }
        boolean explicit_i2p = lc_url.startsWith("i2p:");
        boolean user_i2p = false;
        if (!explicit_i2p && (test = Result.adjustLink(searchURL)).startsWith("i2p:")) {
            user_i2p = true;
        }
        if (can_proxy && (explicit_tor || user_tor || explicit_i2p || user_i2p)) {
            AEProxyFactory.PluginProxy plugin_proxy;
            URL location;
            searchContext = new HashMap<String, String>();
            String target_resource = explicit_tor || explicit_i2p ? searchURL.substring(4) : searchURL;
            try {
                location = new URL(target_resource);
            }
            catch (MalformedURLException e) {
                throw new SearchException(e);
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("peer_networks", new String[]{explicit_tor || user_tor ? "Tor" : "I2P"});
            if (explicit_i2p || user_i2p) {
                options.put("preferred_proxy_type", "HTTP");
                options.put("force_proxy", true);
            }
            if ((plugin_proxy = AEProxyFactory.getPluginProxy("Web engine download of '" + target_resource + "'", location, options, true)) == null) {
                throw new SearchException("No Tor plugin proxy available for '" + target_resource + "'");
            }
            URL url = plugin_proxy.getURL();
            Proxy proxy = plugin_proxy.getProxy();
            boolean ok = false;
            try {
                String proxy_host = String.valueOf(location.getHost()) + (location.getPort() == -1 ? "" : ":" + location.getPort());
                pageDetails details = this.getWebPageContentSupport(proxy, proxy_host, url.toExternalForm(), searchParameters, searchContext, headers, only_if_modified);
                if (verifier != null) {
                    verifier.verify(details);
                }
                ok = true;
                pageDetails pageDetails2 = details;
                return pageDetails2;
            }
            finally {
                plugin_proxy.setOK(ok);
            }
        }
        try {
            try {
                URL url = new URL(searchURL);
                if (AENetworkClassifier.categoriseAddress(url.getHost()) != "Public") {
                    searchContext = new HashMap<String, String>();
                }
            }
            catch (Throwable url) {
                // empty catch block
            }
            pageDetails details = this.getWebPageContentSupport(null, null, searchURL, searchParameters, searchContext, headers, only_if_modified);
            if (verifier != null) {
                verifier.verify(details);
            }
            return details;
        }
        catch (SearchException e) {
            boolean pp_connected = false;
            URL original_url = new URL(searchURL);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("preferred_proxy_type", "HTTP");
            AEProxyFactory.PluginProxy plugin_proxy = AEProxyFactory.getPluginProxy("getting search results ", original_url, options);
            if (plugin_proxy == null) {
                throw e;
            }
            URL url = plugin_proxy.getURL();
            Proxy proxy = plugin_proxy.getProxy();
            boolean ok = false;
            try {
                String proxy_host = String.valueOf(original_url.getHost()) + (original_url.getPort() == -1 ? "" : ":" + original_url.getPort());
                pageDetails details = this.getWebPageContentSupport(proxy, proxy_host, url.toExternalForm(), searchParameters, searchContext, headers, only_if_modified);
                if (verifier != null) {
                    verifier.verify(details);
                }
                ok = true;
                pageDetails pageDetails3 = details;
                if (!ok) {
                    Throwable error = plugin_proxy.getError();
                    if (error != null) {
                        e = new SearchException(error);
                    } else if (plugin_proxy.getConnected()) {
                        pp_connected = true;
                    }
                }
                plugin_proxy.setOK(ok);
                return pageDetails3;
            }
            catch (Throwable throwable) {
                try {
                    if (!ok) {
                        Throwable error = plugin_proxy.getError();
                        if (error != null) {
                            e = new SearchException(error);
                        } else if (plugin_proxy.getConnected()) {
                            pp_connected = true;
                        }
                    }
                    plugin_proxy.setOK(ok);
                    throw throwable;
                }
                catch (SearchException f) {
                    throw pp_connected ? f : e;
                }
                catch (Throwable f) {
                    throw e;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private pageDetails getWebPageContentSupport(Proxy proxy, String proxy_host, String searchURL, SearchParameter[] searchParameters, Map<String, String> searchContext, String headers, boolean only_if_modified) throws SearchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String extractProperty(Object o) {
        List l;
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof List && (l = (List)o).size() > 0) {
            Object x;
            if (l.size() > 1) {
                Debug.out("Property has multiple values!");
            }
            if ((x = l.get(0)) instanceof String) {
                return (String)x;
            }
            Debug.out("Property value isn't a String:" + x);
        }
        return null;
    }

    protected void setHeaders(ResourceDownloader rd, String encoded_headers) {
        UrlUtils.setBrowserHeaders(rd, encoded_headers, this.rootPage);
    }

    @Override
    public String getIcon() {
        if (this.iconUrl != null) {
            return this.iconUrl;
        }
        if (this.rootPage != null) {
            return String.valueOf(this.rootPage) + "/favicon.ico";
        }
        return null;
    }

    protected FieldMapping[] getMappings() {
        return this.mappings;
    }

    @Override
    public boolean supportsField(int field_id) {
        int i = 0;
        while (i < this.mappings.length) {
            if (this.mappings[i].getField() == field_id) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getRootPage() {
        return this.rootPage;
    }

    protected String getBasePage() {
        return this.basePage;
    }

    protected DateParser getDateParser() {
        return this.dateParser;
    }

    @Override
    public String getDownloadLinkCSS() {
        if (this.downloadLinkCSS == null) {
            return "";
        }
        return this.downloadLinkCSS;
    }

    public boolean requiresLogin() {
        return this.needsAuth && !CookieParser.cookiesContain(this.requiredCookies, this.local_cookies);
    }

    public void setCookies(String cookies) {
        this.local_cookies = cookies;
        this.setLocalString("cookies", cookies);
    }

    public String getSearchUrl(boolean raw) {
        if (raw) {
            return this.searchURLFormat;
        }
        return this.getSearchUrl();
    }

    public String getSearchUrl() {
        return this.searchURLFormat.replaceAll("%s", "");
    }

    public void setSearchUrl(String str) {
        this.searchURLFormat = str;
        this.init();
        this.getMetaSearch().configDirty();
    }

    public String getLoginPageUrl() {
        return this.searchURLFormat.replaceAll("%s", "");
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public String[] getRequiredCookies() {
        return this.requiredCookies;
    }

    public void setRequiredCookies(String[] requiredCookies) {
        this.requiredCookies = requiredCookies;
    }

    public boolean isNeedsAuth() {
        return this.needsAuth;
    }

    @Override
    public boolean isAuthenticated() {
        return this.isNeedsAuth();
    }

    protected void setNeedsAuth(boolean b) {
        this.needsAuth = b;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getCookies() {
        return this.local_cookies;
    }

    @Override
    public String getString() {
        return this.getString(false);
    }

    @Override
    public String getString(boolean full) {
        return String.valueOf(super.getString()) + (full ? ", url=" + this.searchURLFormat : "") + ", auth=" + this.isNeedsAuth() + (this.isNeedsAuth() ? " [cookies=" + this.local_cookies + "]" : "");
    }

    public static class pageDetails {
        private URL initial_url;
        private URL final_url;
        private String content;
        private Object verified_state;

        protected pageDetails(URL _initial_url, URL _final_url, String _content) {
            this.initial_url = _initial_url;
            this.final_url = _final_url;
            this.content = _content;
        }

        public URL getInitialURL() {
            return this.initial_url;
        }

        public URL getFinalURL() {
            return this.final_url;
        }

        public String getContent() {
            return this.content;
        }

        private void setContent(String _content) {
            this.content = _content;
        }

        public void setVerifiedState(Object state) {
            this.verified_state = state;
        }

        public Object getVerifiedState() {
            return this.verified_state;
        }
    }

    public static interface pageDetailsVerifier {
        public void verify(pageDetails var1) throws SearchException;
    }
}

