/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.metasearch.impl.web.json;

import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.metasearch.ResultListener;
import com.biglybt.core.metasearch.SearchException;
import com.biglybt.core.metasearch.SearchParameter;
import com.biglybt.core.metasearch.impl.EngineImpl;
import com.biglybt.core.metasearch.impl.MetaSearchImpl;
import com.biglybt.core.metasearch.impl.web.FieldMapping;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.metasearch.impl.web.WebResult;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.util.MapUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONEngine
extends WebEngine {
    private static final String variablePattern = "\\$\\{[^}]+\\}";
    private static final Pattern patternVariable = Pattern.compile("\\$\\{[^}]+\\}");
    private static final boolean DEBUG_MAPPINGS = false;
    private String resultsEntryPath;
    private String rankDivisorPath;
    private float rankDivisor = 1.0f;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new JSONEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new JSONEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String timeZone, boolean automaticDateFormat, String userDateFormat, String resultsEntryPath, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 2, id, last_updated, rank_bias, name, searchURLFormat, timeZone, automaticDateFormat, userDateFormat, mappings, needs_auth, auth_method, login_url, required_cookies);
        this.resultsEntryPath = resultsEntryPath;
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected JSONEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        this.resultsEntryPath = MapUtils.getMapString(map, "json.path", null);
        this.rankDivisorPath = MapUtils.getMapString(map, "rank.divisor.path", null);
    }

    protected JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 2, id, last_updated, rank_bias, name, map);
        this.resultsEntryPath = MapUtils.getMapString(map, "json_result_key", null);
        this.resultsEntryPath = UrlUtils.decode(this.resultsEntryPath);
        this.rankDivisorPath = MapUtils.getMapString(map, "rank_divisor_key", null);
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        MapUtils.setMapString(res, "json.path", this.resultsEntryPath);
        MapUtils.setMapString(res, "rank.divisor.path", this.rankDivisorPath);
        super.exportToBencodedMap(res, generic);
        return res;
    }

    @Override
    protected void exportToJSONObject(JSONObject res) throws IOException {
        res.put("json_result_key", this.resultsEntryPath);
        res.put("rank_divisor_key", this.rankDivisorPath);
        super.exportToJSONObject(res);
    }

    @Override
    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, false);
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        String searchQuery = null;
        int i = 0;
        while (i < searchParameters.length) {
            if (searchParameters[i].getMatchPattern().equals("s")) {
                searchQuery = searchParameters[i].getValue();
            }
            ++i;
        }
        FieldMapping[] mappings = this.getMappings();
        try {
            Object jsonObject;
            try {
                jsonObject = JSONValue.parse(page);
            }
            catch (Throwable e) {
                String temp_page = page.replaceAll("\\\\\",", "\",");
                try {
                    jsonObject = JSONValue.parse(temp_page);
                }
                catch (Throwable f) {
                    throw e;
                }
            }
            if (this.rankDivisorPath != null) {
                String[] split = this.rankDivisorPath.split("\\.");
                try {
                    if (split.length > 0) {
                        Object jsonRankDivisor = jsonObject;
                        int i2 = 0;
                        while (i2 < split.length - 1) {
                            String key = split[i2];
                            if (!(jsonRankDivisor instanceof JSONObject)) break;
                            jsonRankDivisor = ((JSONObject)jsonRankDivisor).get(key);
                            ++i2;
                        }
                        if (jsonRankDivisor instanceof Map) {
                            jsonRankDivisor = ((Map)jsonRankDivisor).get(split[split.length - 1]);
                        }
                        if (jsonRankDivisor instanceof Number) {
                            this.rankDivisor = ((Number)jsonRankDivisor).floatValue();
                        }
                    }
                }
                catch (Exception jsonRankDivisor) {
                    // empty catch block
                }
            }
            JSONArray resultArray = null;
            if (this.resultsEntryPath != null && this.resultsEntryPath.length() > 0) {
                JSONArray array;
                String[] split = this.resultsEntryPath.split("\\.");
                if (jsonObject instanceof JSONArray && split.length > 0 && !split[0].startsWith("[") && (array = (JSONArray)jsonObject).size() == 1) {
                    jsonObject = array.get(0);
                }
                String[] stringArray = split;
                int n = split.length;
                int key = 0;
                while (key < n) {
                    String pathEntry = stringArray[key];
                    if (jsonObject == null) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath);
                    }
                    try {
                        if (pathEntry.startsWith("[") && pathEntry.endsWith("]")) {
                            int idx = Integer.parseInt(pathEntry.substring(1, pathEntry.length() - 1));
                            jsonObject = ((JSONArray)jsonObject).get(idx);
                        } else {
                            jsonObject = ((JSONObject)jsonObject).get(pathEntry);
                        }
                    }
                    catch (Throwable t) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath, t);
                    }
                    ++key;
                }
            }
            try {
                resultArray = (JSONArray)jsonObject;
            }
            catch (Throwable t) {
                throw new SearchException("Object is not a result array. Check the JSON service and/or the entry path");
            }
            if (resultArray != null) {
                ArrayList<WebResult> results = new ArrayList<WebResult>();
                Throwable decode_failure = null;
                int i3 = 0;
                while (i3 < resultArray.size()) {
                    Object obj = resultArray.get(i3);
                    if (obj instanceof JSONObject) {
                        JSONObject jsonEntry = (JSONObject)obj;
                        if (absolute_max_matches >= 0 && --absolute_max_matches < 0) break;
                        if (listener != null) {
                            Iterator<Map.Entry<String, Object>> it = new TreeMap<String, Object>(jsonEntry).entrySet().iterator();
                            String[] groups = new String[jsonEntry.size()];
                            int pos = 0;
                            while (it.hasNext()) {
                                Map.Entry<String, Object> entry = it.next();
                                String key = entry.getKey();
                                Object value = entry.getValue();
                                groups[pos++] = key != null && value != null ? String.valueOf(key.toString()) + "=" + UrlUtils.encode(value.toString()) : "";
                            }
                            listener.matchFound(this, groups);
                        }
                        WebResult result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), searchQuery);
                        try {
                            String downloadLink;
                            String possibleMagnet;
                            byte[] hash;
                            boolean addResult = true;
                            HashSet<Integer> fields_mapped = new HashSet<Integer>();
                            int j = 0;
                            while (j < mappings.length) {
                                String fieldFrom = mappings[j].getName();
                                if (fieldFrom != null) {
                                    int fieldTo = mappings[j].getField();
                                    String fieldContent = null;
                                    Matcher matcher = patternVariable.matcher(fieldFrom);
                                    if (matcher.find()) {
                                        fieldContent = fieldFrom;
                                        do {
                                            String key = matcher.group();
                                            key = key.substring(2, key.length() - 1);
                                            String[] keys = key.split(",", -1);
                                            try {
                                                String replaceWith;
                                                Object replaceWithObject = jsonEntry.get(keys[0]);
                                                String string = replaceWith = replaceWithObject == null ? "" : replaceWithObject.toString();
                                                if (keys.length > 1) {
                                                    String[] commands = keys[1].split("\\+");
                                                    int keyPos = 2;
                                                    String[] stringArray = commands;
                                                    int n = commands.length;
                                                    int n2 = 0;
                                                    while (n2 < n) {
                                                        String command = stringArray[n2];
                                                        try {
                                                            if (command.equals("replace")) {
                                                                if (keyPos + 2 > keys.length) break;
                                                                String simpleReplace = keys[keyPos];
                                                                String simpleReplacement = keys[++keyPos];
                                                                ++keyPos;
                                                                replaceWith = replaceWith.replaceAll(simpleReplace, Matcher.quoteReplacement(simpleReplacement));
                                                            } else if (command.equals("ucase")) {
                                                                replaceWith = replaceWith.toUpperCase();
                                                            } else if (command.equals("lcase")) {
                                                                replaceWith = replaceWith.toLowerCase();
                                                            } else if (command.equals("urldecode")) {
                                                                replaceWith = UrlUtils.decode(replaceWith);
                                                            }
                                                        }
                                                        catch (Exception exception) {
                                                            // empty catch block
                                                        }
                                                        ++n2;
                                                    }
                                                }
                                                fieldContent = fieldContent.replaceFirst(variablePattern, replaceWith);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        } while (matcher.find());
                                    } else {
                                        Object fieldContentObj = jsonEntry.get(fieldFrom);
                                        String string = fieldContent = fieldContentObj == null ? "" : fieldContentObj.toString();
                                    }
                                    if (!(fieldContent == null || fieldContent.isEmpty() && fields_mapped.contains(fieldTo))) {
                                        Matcher postMatch;
                                        Pattern filter2 = mappings[j].getPostFilterPattern(searchQuery);
                                        if (filter2 != null && !(postMatch = filter2.matcher(fieldContent)).find()) {
                                            addResult = false;
                                        } else {
                                            if (!fieldContent.isEmpty()) {
                                                fields_mapped.add(fieldTo);
                                            }
                                            switch (fieldTo) {
                                                case 1: {
                                                    result.setNameFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 3: {
                                                    result.setSizeFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 4: {
                                                    result.setNbPeersFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 5: {
                                                    result.setNbSeedsFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 6: {
                                                    result.setCategoryFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 2: {
                                                    result.setPublishedDateFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 7: {
                                                    result.setCommentsFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 103: {
                                                    result.setCDPLink(fieldContent);
                                                    break;
                                                }
                                                case 102: {
                                                    result.setTorrentLink(fieldContent);
                                                    break;
                                                }
                                                case 104: {
                                                    result.setPlayLink(fieldContent);
                                                    break;
                                                }
                                                case 105: {
                                                    result.setDownloadButtonLink(fieldContent);
                                                    break;
                                                }
                                                case 10: {
                                                    result.setVotesFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 11: {
                                                    result.setNbSuperSeedsFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 12: {
                                                    result.setPrivateFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 13: {
                                                    result.setDrmKey(fieldContent);
                                                    break;
                                                }
                                                case 14: {
                                                    result.setVotesDownFromHTML(fieldContent);
                                                    break;
                                                }
                                                case 200: {
                                                    if (fieldContent.startsWith("magnet:")) {
                                                        byte[] hash2 = UrlUtils.getTruncatedHashFromMagnetURI(fieldContent);
                                                        fieldContent = hash2 != null ? ByteFormatter.encodeString(hash2) : null;
                                                    }
                                                    if (fieldContent == null) break;
                                                    result.setHash(fieldContent);
                                                    break;
                                                }
                                                case 201: {
                                                    result.setRankFromHTML(fieldContent, this.rankDivisor);
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                                ++j;
                            }
                            if (result.getHash() == null && (hash = UrlUtils.getTruncatedHashFromMagnetURI(possibleMagnet = UrlUtils.parseTextForMagnets(downloadLink = result.getDownloadLink()))) != null) {
                                result.setHash(ByteFormatter.nicePrint(hash, true));
                            }
                            if (addResult) {
                                results.add(result);
                            }
                        }
                        catch (Throwable e) {
                            decode_failure = e;
                        }
                    }
                    ++i3;
                }
                if (results.size() == 0 && decode_failure != null) {
                    throw decode_failure;
                }
                Result[] res = results.toArray(new Result[results.size()]);
                this.debugLog("success: found " + res.length + " results");
                return res;
            }
            this.debugLog("success: no result array found so no results");
            return new Result[0];
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            String content_str = page;
            if (content_str.length() > 256) {
                content_str = String.valueOf(content_str.substring(0, 256)) + "...";
            }
            throw new SearchException("JSON matching failed for " + this.getName() + ", content=" + content_str, e);
        }
    }
}

