/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager;

import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.impl.NetworkConnectionImpl;
import com.biglybt.core.peermanager.messaging.MessageStreamDecoder;
import com.biglybt.core.peermanager.messaging.MessageStreamEncoder;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;

public class NetworkConnectionFactory {
    private static final CopyOnWriteList<NetworkConnectionFactoryListener> listeners = new CopyOnWriteList();

    protected static NetworkConnection create(ConnectionEndpoint target, MessageStreamEncoder encoder, MessageStreamDecoder decoder, boolean connect_with_crypto, boolean allow_fallback, byte[][] shared_secrets) {
        NetworkConnectionImpl connection = new NetworkConnectionImpl(target, encoder, decoder, connect_with_crypto, allow_fallback, shared_secrets);
        for (NetworkConnectionFactoryListener listener : listeners) {
            try {
                listener.connectionCreated(connection);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return connection;
    }

    protected static NetworkConnection create(Transport transport, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        NetworkConnectionImpl connection = new NetworkConnectionImpl(transport, encoder, decoder);
        for (NetworkConnectionFactoryListener listener : listeners) {
            try {
                listener.connectionCreated(connection);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return connection;
    }

    public static void addListener(NetworkConnectionFactoryListener l) {
        listeners.add(l);
    }

    public static void removeListener(NetworkConnectionFactoryListener l) {
        listeners.remove(l);
    }

    public static interface NetworkConnectionFactoryListener {
        public void connectionCreated(NetworkConnection var1);
    }
}

