/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.networkmanager.admin.NetworkAdminNATDevice;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.plugin.upnp.UPnPPluginService;
import java.net.InetAddress;

public class NetworkAdminNATDeviceImpl
implements NetworkAdminNATDevice {
    private final UPnPPluginService service;
    private InetAddress external_address;
    private long address_time;

    protected NetworkAdminNATDeviceImpl(UPnPPluginService _service) {
        this.service = _service;
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.service.getAddress());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public int getPort() {
        return this.service.getPort();
    }

    @Override
    public InetAddress getExternalAddress() {
        long now = SystemTime.getCurrentTime();
        if (this.external_address != null && now > this.address_time && now - this.address_time < 60000L) {
            return this.external_address;
        }
        try {
            this.external_address = InetAddress.getByName(this.service.getExternalAddress());
            this.address_time = now;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return this.external_address;
    }

    protected boolean sameAs(NetworkAdminNATDeviceImpl other) {
        if (!this.getAddress().equals(other.getAddress()) || this.getPort() != other.getPort()) {
            return false;
        }
        InetAddress e1 = this.getExternalAddress();
        InetAddress e2 = other.getExternalAddress();
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    @Override
    public String getString() {
        String res = this.getName();
        res = String.valueOf(res) + ": address=" + this.service.getAddress() + ":" + this.service.getPort();
        InetAddress ext = this.getExternalAddress();
        res = ext == null ? String.valueOf(res) + ", no public address available" : String.valueOf(res) + ", public address=" + ext.getHostAddress();
        return res;
    }
}

