/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.Core;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.biglybt.core.networkmanager.admin.NetworkAdminProgressListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminProtocol;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminHTTPTester;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminTCPTester;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminUDPTester;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.upnp.UPnPMapping;
import com.biglybt.plugin.upnp.UPnPPlugin;
import java.net.InetAddress;

public class NetworkAdminProtocolImpl
implements NetworkAdminProtocol {
    private final Core core;
    private final int type;
    private final int port;

    protected NetworkAdminProtocolImpl(Core _core, int _type) {
        this.core = _core;
        this.type = _type;
        this.port = -1;
    }

    protected NetworkAdminProtocolImpl(Core _core, int _type, int _port) {
        this.core = _core;
        this.type = _type;
        this.port = _port;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address) throws NetworkAdminException {
        return this.test(address, null);
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address, NetworkAdminProgressListener listener) throws NetworkAdminException {
        return this.test(address, false, listener);
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address, boolean upnp_map, NetworkAdminProgressListener listener) throws NetworkAdminException {
        return this.test(address, false, upnp_map, listener);
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address, boolean ipv6, boolean upnp_map, NetworkAdminProgressListener listener) throws NetworkAdminException {
        InetAddress res;
        InetAddress bind_ip;
        InetAddress inetAddress = bind_ip = address == null ? null : address.getAddress();
        NetworkAdminProtocolTester tester = this.type == 1 ? new NetworkAdminHTTPTester(this.core, listener) : (this.type == 2 ? new NetworkAdminTCPTester(this.core, listener) : new NetworkAdminUDPTester(this.core, listener));
        if (this.port <= 0) {
            res = tester.testOutbound(bind_ip, 0, ipv6);
        } else {
            UPnPPlugin upnp;
            UPnPMapping mapping2;
            PluginInterface pi_upnp;
            UPnPMapping new_mapping = null;
            if (upnp_map && (pi_upnp = this.core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class)) != null && (mapping2 = (upnp = (UPnPPlugin)pi_upnp.getPlugin()).getMapping(this.type != 3, this.port)) == null) {
                new_mapping = mapping2 = upnp.addMapping("NAT Tester", this.type != 3, this.port, true);
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                res = tester.testInbound(bind_ip, this.port, ipv6);
            }
            finally {
                if (new_mapping != null) {
                    new_mapping.destroy();
                }
            }
        }
        return res;
    }

    @Override
    public String getTypeString() {
        String res = this.type == 1 ? "HTTP" : (this.type == 2 ? "TCP" : "UDP");
        return res;
    }

    @Override
    public String getName() {
        String res = this.getTypeString();
        if (this.port == -1) {
            return String.valueOf(res) + " outbound";
        }
        return String.valueOf(res) + " port " + this.port + " inbound";
    }
}

